/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RunConfiguration
extends RunProfile,
Cloneable {
    public static final DataKey<RunConfiguration> DATA_KEY = DataKey.create((String)"runtimeConfiguration");

    @NotNull
    default public ConfigurationType getType() {
        ConfigurationFactory factory = this.getFactory();
        ConfigurationType configurationType = factory == null ? UnknownConfigurationType.getInstance() : factory.getType();
        if (configurationType == null) {
            RunConfiguration.$$$reportNull$$$0(0);
        }
        return configurationType;
    }

    @Nullable
    public ConfigurationFactory getFactory();

    public void setName(@NlsSafe String var1);

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor();

    public Project getProject();

    @Nullable
    default public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
        return null;
    }

    @Nullable
    default public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
        return null;
    }

    public RunConfiguration clone();

    default public int getUniqueID() {
        return System.identityHashCode(this);
    }

    @Nullable
    @NonNls
    default public String getId() {
        return null;
    }

    @Transient
    @NotNull
    @NlsActions.ActionText
    default public String getPresentableType() {
        if (PlatformUtils.isPhpStorm()) {
            String string = " (" + StringUtil.first((String)this.getType().getDisplayName(), (int)10, (boolean)true) + ")";
            if (string == null) {
                RunConfiguration.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    default public boolean hideDisabledExecutorButtons() {
        return false;
    }

    default public void checkConfiguration() throws RuntimeConfigurationException {
    }

    default public void readExternal(@NotNull Element element) {
        if (element == null) {
            RunConfiguration.$$$reportNull$$$0(2);
        }
    }

    default public void writeExternal(@NotNull Element element) {
        if (element == null) {
            RunConfiguration.$$$reportNull$$$0(3);
        }
    }

    @NotNull
    default public List<BeforeRunTask<?>> getBeforeRunTasks() {
        List<BeforeRunTask<?>> list = Collections.emptyList();
        if (list == null) {
            RunConfiguration.$$$reportNull$$$0(4);
        }
        return list;
    }

    default public void setBeforeRunTasks(@NotNull List<BeforeRunTask<?>> value) {
        if (value == null) {
            RunConfiguration.$$$reportNull$$$0(5);
        }
    }

    default public boolean isAllowRunningInParallel() {
        return false;
    }

    default public void setAllowRunningInParallel(boolean value) {
    }

    default public RestartSingletonResult restartSingleton(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            RunConfiguration.$$$reportNull$$$0(6);
        }
        return RestartSingletonResult.ASK_AND_RESTART;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/RunConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableType";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/RunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeRunTasks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setBeforeRunTasks";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "restartSingleton";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    public static enum RestartSingletonResult {
        ASK_AND_RESTART,
        RESTART,
        NO_FURTHER_ACTION;

    }
}

