/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.executors;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.RunExecutorSettings;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u001f*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u001f B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u000f\u001a\u00070\n\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\nH&J\r\u0010\u0012\u001a\u00070\n\u00a2\u0006\u0002\b\u0010H&J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\u001a0\u0019H\u0004J\u0015\u0010\u001b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u000e\u0012\f0\fR\b\u0012\u0004\u0012\u00028\u00000\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/execution/executors/ExecutorGroup;", "Settings", "Lcom/intellij/execution/executors/RunExecutorSettings;", "Lcom/intellij/execution/Executor;", "<init>", "()V", "customSettingsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "executorId2customSettings", "", "", "customSettings2Executor", "Lcom/intellij/execution/executors/ExecutorGroup$ProxyExecutor;", "nextCustomExecutorId", "Ljava/util/concurrent/atomic/AtomicLong;", "getRunToolbarActionText", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "param", "getRunToolbarChooserText", "registerSettings", "", "settings", "(Lcom/intellij/execution/executors/RunExecutorSettings;)V", "unregisterSettings", "allRegisteredSettings", "", "Lkotlin/Pair;", "getRegisteredSettings", "proxyExecutorId", "(Ljava/lang/String;)Lcom/intellij/execution/executors/RunExecutorSettings;", "childExecutors", "Companion", "ProxyExecutor", "intellij.platform.execution"})
@SourceDebugExtension(value={"SMAP\nExecutorGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutorGroup.kt\ncom/intellij/execution/executors/ExecutorGroup\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,127:1\n129#2:128\n158#2,3:129\n*S KotlinDebug\n*F\n+ 1 ExecutorGroup.kt\ncom/intellij/execution/executors/ExecutorGroup\n*L\n49#1:128\n49#1:129,3\n*E\n"})
public abstract class ExecutorGroup<Settings extends RunExecutorSettings>
extends Executor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReentrantReadWriteLock customSettingsLock = new ReentrantReadWriteLock();
    @NotNull
    private final Map<String, Settings> executorId2customSettings = new LinkedHashMap();
    @NotNull
    private final Map<Settings, ProxyExecutor> customSettings2Executor = new LinkedHashMap();
    @NotNull
    private final AtomicLong nextCustomExecutorId = new AtomicLong();

    @NotNull
    public abstract String getRunToolbarActionText(@NotNull String var1);

    @NotNull
    public abstract String getRunToolbarChooserText();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void registerSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        ReentrantReadWriteLock reentrantReadWriteLock = this.customSettingsLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            String newId = this.getId() + "#" + this.nextCustomExecutorId.incrementAndGet();
            this.executorId2customSettings.put(newId, settings);
            this.customSettings2Executor.put(settings, new ProxyExecutor((RunExecutorSettings)settings, newId));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void unregisterSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        ReentrantReadWriteLock reentrantReadWriteLock = this.customSettingsLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            ProxyExecutor executor = this.customSettings2Executor.remove(settings);
            if (executor != null) {
                this.executorId2customSettings.remove(executor.getId());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected final List<Pair<String, Settings>> allRegisteredSettings() {
        List list;
        ReentrantReadWriteLock.ReadLock readLock = this.customSettingsLock.readLock();
        readLock.lock();
        try {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Map<String, Settings> $this$map$iv = this.executorId2customSettings;
            boolean $i$f$map = false;
            Map<String, Settings> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String id = (String)entry.getKey();
                RunExecutorSettings setting = (RunExecutorSettings)entry.getValue();
                collection.add(TuplesKt.to((Object)id, (Object)setting));
            }
            list = (List)destination$iv$iv;
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Settings getRegisteredSettings(@NotNull String proxyExecutorId) {
        RunExecutorSettings runExecutorSettings;
        Intrinsics.checkNotNullParameter((Object)proxyExecutorId, (String)"proxyExecutorId");
        ReentrantReadWriteLock.ReadLock readLock = this.customSettingsLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            runExecutorSettings = (RunExecutorSettings)this.executorId2customSettings.get(proxyExecutorId);
        }
        finally {
            readLock.unlock();
        }
        return (Settings)runExecutorSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Executor> childExecutors() {
        List list;
        ReentrantReadWriteLock.ReadLock readLock = this.customSettingsLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)this.customSettings2Executor.values());
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    @JvmStatic
    @Nullable
    public static final ExecutorGroup<?> getGroupIfProxy(@NotNull Executor executor) {
        return Companion.getGroupIfProxy(executor);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/executors/ExecutorGroup$Companion;", "", "<init>", "()V", "getGroupIfProxy", "Lcom/intellij/execution/executors/ExecutorGroup;", "executor", "Lcom/intellij/execution/Executor;", "intellij.platform.execution"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final ExecutorGroup<?> getGroupIfProxy(@NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            ProxyExecutor proxyExecutor = executor instanceof ProxyExecutor ? (ProxyExecutor)executor : null;
            return proxyExecutor != null ? proxyExecutor.group() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/executors/ExecutorGroup$ProxyExecutor;", "Lcom/intellij/execution/Executor;", "settings", "Lcom/intellij/execution/executors/RunExecutorSettings;", "executorId", "", "<init>", "(Lcom/intellij/execution/executors/ExecutorGroup;Lcom/intellij/execution/executors/RunExecutorSettings;Ljava/lang/String;)V", "getToolWindowId", "getToolWindowIcon", "Ljavax/swing/Icon;", "getIcon", "getDisabledIcon", "getDescription", "getActionName", "getId", "getStartActionText", "configurationName", "getContextActionId", "getHelpId", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "isSupportedOnTarget", "group", "Lcom/intellij/execution/executors/ExecutorGroup;", "intellij.platform.execution"})
    private final class ProxyExecutor
    extends Executor {
        @NotNull
        private final RunExecutorSettings settings;
        @NotNull
        private final String executorId;

        public ProxyExecutor(@NotNull RunExecutorSettings settings, String executorId) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
            this.settings = settings;
            this.executorId = executorId;
        }

        @Override
        @NotNull
        public String getToolWindowId() {
            String string = ExecutorGroup.this.getToolWindowId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToolWindowId(...)");
            return string;
        }

        @Override
        @NotNull
        public Icon getToolWindowIcon() {
            Icon icon = ExecutorGroup.this.getToolWindowIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getToolWindowIcon(...)");
            return icon;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return this.settings.getIcon();
        }

        @Override
        @Nullable
        public Icon getDisabledIcon() {
            return null;
        }

        @Override
        @NotNull
        public String getDescription() {
            String string = ExecutorGroup.this.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            return string;
        }

        @Override
        @NotNull
        public String getActionName() {
            return this.settings.getActionName();
        }

        @Override
        @NotNull
        public String getId() {
            return this.executorId;
        }

        @Override
        @NotNull
        public String getStartActionText() {
            return this.settings.getStartActionText();
        }

        @Override
        @NotNull
        public String getStartActionText(@NotNull String configurationName) {
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            return this.settings.getStartActionText(configurationName);
        }

        @Override
        @NotNull
        public String getContextActionId() {
            throw new UnsupportedOperationException("ProxyExecutor can't be used to create context action");
        }

        @Override
        @Nullable
        public String getHelpId() {
            return null;
        }

        @Override
        public boolean isApplicable(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.settings.isApplicable(project);
        }

        @Override
        public boolean isSupportedOnTarget() {
            return this.group().isSupportedOnTarget();
        }

        @NotNull
        public final ExecutorGroup<Settings> group() {
            return ExecutorGroup.this;
        }
    }
}

