// Copyright 2000-2024 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.execution.configurations;

import com.intellij.openapi.util.NlsActions;
import org.jetbrains.annotations.Nullable;

/**
 * Base interface that should be used for configurations that can be created from context (a location in a file) by implementations of
 * {@link com.intellij.execution.actions.RunConfigurationProducer}
 *
 * @author anna
 * @see LocatableConfigurationBase
 */
public interface LocatableConfiguration extends RunConfiguration {
  /**
   * Checks if the current name for the run configuration was automatically generated.
   *
   * @return true if the name was generated by {@link #suggestedName()}, false if it was manually entered or changed by the user.
   */
  boolean isGeneratedName();

  /**
   * Returns the default name for the run configuration based on its settings (such as the name of class or file to run).
   *
   * @return the suggested name for the configuration, or null if no name could be suggested based on the current settings (for example,
   * the name of the file to run isn't yet specified). NOTE: Please don't return hard-coded strings which are not based on the current
   * run configuration settings (such as "Unnamed").
   */
  default @Nullable @NlsActions.ActionText String suggestedName() {
    return null;
  }
}
