/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.settings;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemExecutionSettings
implements Serializable,
UserDataHolder {
    public static final String REMOTE_PROCESS_IDLE_TTL_IN_MS_KEY = "external.system.remote.process.idle.ttl.ms";
    private static final int DEFAULT_REMOTE_PROCESS_TTL_MS = -1;
    public static final Key<Boolean> DEBUG_SERVER_PROCESS_KEY = Key.create((String)"DEBUG_SERVER_PROCESS");
    private static final long serialVersionUID = 1L;
    private long myRemoteProcessIdleTtlInMs;
    private boolean myVerboseProcessing;
    @NotNull
    private final List<String> myJvmArguments;
    @NotNull
    private List<String> myTasks;
    @NotNull
    private final List<String> myArguments;
    @NotNull
    private final Map<String, String> myEnv;
    private boolean myPassParentEnvs;
    @Nullable
    private String myJvmParameters;
    @NotNull
    private final transient UserDataHolderBase myUserData;

    public ExternalSystemExecutionSettings() {
        this.myUserData = new UserDataHolderBase();
        this.myRemoteProcessIdleTtlInMs = SystemProperties.getIntProperty((String)REMOTE_PROCESS_IDLE_TTL_IN_MS_KEY, (int)-1);
        this.myVerboseProcessing = false;
        this.myJvmArguments = new ArrayList<String>();
        this.myTasks = new ArrayList<String>();
        this.myArguments = new ArrayList<String>();
        this.myEnv = new LinkedHashMap<String, String>();
        this.myPassParentEnvs = true;
        this.myJvmParameters = null;
    }

    public ExternalSystemExecutionSettings(@NotNull ExternalSystemExecutionSettings settings) {
        if (settings == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(0);
        }
        this.myUserData = new UserDataHolderBase();
        this.myRemoteProcessIdleTtlInMs = settings.myRemoteProcessIdleTtlInMs;
        this.myVerboseProcessing = settings.myVerboseProcessing;
        this.myJvmArguments = new ArrayList<String>(settings.myJvmArguments);
        this.myTasks = new ArrayList<String>(settings.myTasks);
        this.myArguments = new ArrayList<String>(settings.myArguments);
        this.myEnv = new LinkedHashMap<String, String>(settings.myEnv);
        this.myPassParentEnvs = settings.myPassParentEnvs;
        this.myJvmParameters = settings.myJvmParameters;
        settings.myUserData.copyUserDataTo(this.myUserData);
    }

    public long getRemoteProcessIdleTtlInMs() {
        return this.myRemoteProcessIdleTtlInMs;
    }

    public void setRemoteProcessIdleTtlInMs(long remoteProcessIdleTtlInMs) {
        this.myRemoteProcessIdleTtlInMs = remoteProcessIdleTtlInMs;
    }

    public boolean isVerboseProcessing() {
        return this.myVerboseProcessing;
    }

    public void setVerboseProcessing(boolean verboseProcessing) {
        this.myVerboseProcessing = verboseProcessing;
    }

    @NotNull
    public List<String> getJvmArguments() {
        List<String> list = Collections.unmodifiableList(this.myJvmArguments);
        if (list == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<String> getTasks() {
        List<String> list = Collections.unmodifiableList(this.myTasks);
        if (list == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setTasks(List<String> tasks) {
        this.myTasks = new ArrayList<String>(tasks);
    }

    @NotNull
    public List<String> getArguments() {
        List<String> list = Collections.unmodifiableList(this.myArguments);
        if (list == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public Map<String, String> getEnv() {
        Map<String, String> map = Collections.unmodifiableMap(this.myEnv);
        if (map == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(4);
        }
        return map;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public boolean isDebugServerProcess() {
        Boolean value = this.getUserData(DEBUG_SERVER_PROCESS_KEY);
        return (Boolean)ObjectUtils.chooseNotNull((Object)value, (Object)false);
    }

    public ExternalSystemExecutionSettings withVmOptions(Collection<String> vmOptions) {
        this.myJvmArguments.addAll(vmOptions);
        return this;
    }

    public ExternalSystemExecutionSettings withVmOptions(String ... vmOptions) {
        Collections.addAll(this.myJvmArguments, vmOptions);
        return this;
    }

    public ExternalSystemExecutionSettings withVmOption(String vmOption) {
        this.myJvmArguments.add(vmOption);
        return this;
    }

    public ExternalSystemExecutionSettings withArguments(Collection<String> arguments) {
        this.myArguments.addAll(arguments);
        return this;
    }

    public ExternalSystemExecutionSettings withArguments(String ... arguments) {
        Collections.addAll(this.myArguments, arguments);
        return this;
    }

    public ExternalSystemExecutionSettings withArgument(String argument) {
        this.myArguments.add(argument);
        return this;
    }

    public void prependArguments(String ... arguments) {
        this.myArguments.addAll(0, Arrays.asList(arguments));
    }

    public void addEnvironmentVariable(@NotNull String name, @NotNull String value) {
        if (name == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(5);
        }
        if (value == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(6);
        }
        this.myEnv.put(name, value);
    }

    public ExternalSystemExecutionSettings withEnvironmentVariables(Map<String, String> envs) {
        this.myEnv.putAll(envs);
        return this;
    }

    public ExternalSystemExecutionSettings passParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
        return this;
    }

    @ApiStatus.Internal
    @Nullable
    public String getJvmParameters() {
        return this.myJvmParameters;
    }

    @ApiStatus.Internal
    public void setJvmParameters(@Nullable String jvmParameters) {
        this.myJvmParameters = jvmParameters;
    }

    @Nullable
    public <U> U getUserData(@NotNull Key<U> key) {
        if (key == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(7);
        }
        return (U)this.myUserData.getUserData(key);
    }

    public <U> void putUserData(@NotNull Key<U> key, U value) {
        if (key == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(8);
        }
        this.myUserData.putUserData(key, value);
    }

    public int hashCode() {
        int result = Long.hashCode(this.myRemoteProcessIdleTtlInMs);
        result = 31 * result + (this.myVerboseProcessing ? 1 : 0);
        result = 31 * result + this.myJvmArguments.hashCode();
        result = 31 * result + this.myArguments.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemExecutionSettings that = (ExternalSystemExecutionSettings)o;
        if (this.myRemoteProcessIdleTtlInMs != that.myRemoteProcessIdleTtlInMs) {
            return false;
        }
        if (this.myVerboseProcessing != that.myVerboseProcessing) {
            return false;
        }
        if (!this.myJvmArguments.equals(that.myJvmArguments)) {
            return false;
        }
        return this.myArguments.equals(that.myArguments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmArguments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addEnvironmentVariable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

