/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.ElementSignatureProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractElementSignatureProvider
implements ElementSignatureProvider {
    private static final int CHILDREN_COUNT_LIMIT = 100;
    protected static final String ELEMENTS_SEPARATOR = ";";
    protected static final String ELEMENT_TOKENS_SEPARATOR = "#";
    private static final String ESCAPE_CHAR = "\\";
    private static final List<String> ESCAPE_FROM = Arrays.asList("\\", "#", ";");
    private static final List<String> ESCAPE_TO = Arrays.asList("\\\\", "\\s", "\\h");

    @Override
    @Nullable
    public PsiElement restoreBySignature(@NotNull PsiFile file, @NotNull String signature, @Nullable StringBuilder processingInfoStorage) {
        PsiFile parent;
        int semicolonIndex;
        if (file == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(0);
        }
        if (signature == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(1);
        }
        if ((semicolonIndex = signature.indexOf(ELEMENTS_SEPARATOR)) >= 0) {
            String parentSignature = signature.substring(semicolonIndex + 1);
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Provider '%s'. Restoring parent by signature '%s'...%n", this.getClass().getName(), parentSignature));
            }
            parent = this.restoreBySignature(file, parentSignature, processingInfoStorage);
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Restored parent by signature '%s': %s%n", parentSignature, parent));
            }
            if (parent == null) {
                return null;
            }
            signature = signature.substring(0, semicolonIndex);
        } else {
            parent = file;
        }
        StringTokenizer tokenizer = new StringTokenizer(signature, ELEMENT_TOKENS_SEPARATOR);
        String type = tokenizer.nextToken();
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Provider '%s'. Restoring target element by signature '%s'. Parent: %s, same as the given parent: %b%n", this.getClass().getName(), signature, parent, parent == file));
        }
        return this.restoreBySignatureTokens(file, (PsiElement)parent, type, tokenizer, processingInfoStorage);
    }

    @Nullable
    protected abstract PsiElement restoreBySignatureTokens(@NotNull PsiFile var1, @NotNull PsiElement var2, @NotNull String var3, @NotNull StringTokenizer var4, @Nullable StringBuilder var5);

    protected static <T extends PsiNamedElement> int getChildIndex(T element, @NotNull PsiElement parent, String name, Class<? extends T> hisClass) {
        PsiFile file;
        Set cache;
        if (parent == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(2);
        }
        Set set = cache = (file = parent.getContainingFile()) == null ? null : (Set)CachedValuesManager.getCachedValue((PsiElement)file, () -> new CachedValueProvider.Result((Object)ContainerUtil.createWeakSet(), new Object[]{file}));
        if (cache != null && cache.contains(parent)) {
            return -1;
        }
        PsiElement[] children = parent.getChildren();
        if (children.length > 100) {
            if (cache != null) {
                cache.add(parent);
            }
            return -1;
        }
        int index = 0;
        for (PsiElement child : children) {
            PsiNamedElement namedChild;
            String childName;
            if (!ReflectionUtil.isAssignable(hisClass, (Class)child.getClass()) || !Objects.equals(name, childName = (namedChild = (PsiNamedElement)hisClass.cast(child)).getName())) continue;
            if (namedChild.equals(element)) {
                return index;
            }
            ++index;
        }
        return index;
    }

    @Nullable
    protected static <T extends PsiNamedElement> T restoreElementInternal(@NotNull PsiElement parent, String name, int index, @NotNull Class<T> hisClass) {
        PsiElement[] children;
        if (parent == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(3);
        }
        if (hisClass == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(4);
        }
        for (PsiElement child : children = parent.getChildren()) {
            PsiNamedElement namedChild;
            String childName;
            if (!ReflectionUtil.isAssignable(hisClass, (Class)child.getClass()) || !Objects.equals(name, childName = (namedChild = (PsiNamedElement)hisClass.cast(child)).getName())) continue;
            if (index == 0) {
                return (T)namedChild;
            }
            --index;
        }
        return null;
    }

    protected static String escape(String name) {
        return StringUtil.replace((String)name, ESCAPE_FROM, ESCAPE_TO);
    }

    protected static String unescape(String name) {
        return StringUtil.replace((String)name, ESCAPE_TO, ESCAPE_FROM);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hisClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/AbstractElementSignatureProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreBySignature";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildIndex";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreElementInternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

