/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.DocumentFoldingInfo;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.WeakList;
import java.util.Collection;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CodeFoldingManagerImpl
extends CodeFoldingManager
implements Disposable {
    private static final Key<Boolean> FOLDINGS_INITIALIZED_KEY = Key.create((String)"FOLDINGS_INITIALIZED");
    private static final Key<Boolean> ASYNC_FOLDING_UPDATE_KEY = Key.create((String)"ASYNC_FOLDING_UPDATE");
    private static final Key<Map<TextRange, Boolean>> ASYNC_FOLDING_CACHE_KEY = Key.create((String)"ASYNC_FOLDING_CACHE");
    private static final Key<Boolean> AUTO_CREATED_KEY = Key.create((String)"AUTO_CREATED");
    private static final Key<Boolean> FRONTEND_CREATED_KEY = Key.create((String)"FRONTEND_CREATED");
    private static final Key<Boolean> TRANSIENT_KEY = Key.create((String)"TRANSIENT");
    private final Project myProject;
    private final Collection<Document> myDocumentsWithFoldingInfo = new WeakList();
    private final Key<DocumentFoldingInfo> MY_FOLDING_INFO_IN_DOCUMENT_KEY = Key.create((String)"FOLDING_INFO_IN_DOCUMENT_KEY");

    public CodeFoldingManagerImpl(final Project project) {
        this.myProject = project;
        LanguageFolding.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<KeyedLazyInstance<FoldingBuilder>>(){

            public void extensionAdded(@NotNull KeyedLazyInstance<FoldingBuilder> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    TextEditor te = (TextEditor)fileEditor;
                    CodeFoldingManagerImpl.this.scheduleAsyncFoldingUpdate(te.getEditor());
                }
            }

            public void extensionRemoved(@NotNull KeyedLazyInstance<FoldingBuilder> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    TextEditor te = (TextEditor)fileEditor;
                    CodeFoldingManagerImpl.this.updateFoldRegions(te.getEditor());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        Runnable listener = () -> {
            for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                TextEditor te = (TextEditor)fileEditor;
                FoldingUpdate.clearFoldingCache(te.getEditor());
            }
        };
        MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.addChangeListener((AreaInstance)project, listener, (Disposable)this);
        LanguageInjector.EXTENSION_POINT_NAME.addChangeListener(listener, (Disposable)this);
        CustomFoldingProvider.EP_NAME.addChangeListener(listener, (Disposable)this);
    }

    public void dispose() {
        for (Document document : this.myDocumentsWithFoldingInfo) {
            if (document == null) continue;
            document.putUserData(this.MY_FOLDING_INFO_IN_DOCUMENT_KEY, null);
        }
    }

    @Override
    @RequiresEdt
    public void releaseFoldings(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorFoldingInfo.disposeForEditor(editor);
    }

    @Override
    @Deprecated
    public void buildInitialFoldings(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(1);
        }
    }

    @Override
    @Deprecated
    @Nullable
    public CodeFoldingState buildInitialFoldings(@NotNull Document document) {
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return null;
    }

    @RequiresReadLock
    static PsiFile getPsiFileForFolding(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(3);
        }
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.softAssertReadAccess();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null || !psiFile.isValid() || !psiFile.getViewProvider().isPhysical() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (psiFile instanceof PsiCompiledFile) {
            PsiCompiledFile compiled = (PsiCompiledFile)psiFile;
            psiFile = compiled.getDecompiledPsiFile();
        }
        return psiFile;
    }

    @Override
    @Nullable
    public Boolean isCollapsedByDefault(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(5);
        }
        return CodeFoldingManagerImpl.getCollapsedByDefault(region);
    }

    @Override
    @Nullable
    public Boolean keepExpandedOnFirstCollapseAll(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(6);
        }
        return (Boolean)region.getUserData(UpdateFoldRegionsOperation.KEEP_EXPANDED_ON_FIRST_COLLAPSE_ALL);
    }

    public void markForUpdate(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(7);
        }
        UpdateFoldRegionsOperation.UPDATE_REGION.set((UserDataHolder)region, (Object)Boolean.TRUE);
    }

    public void markUpdated(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(8);
        }
        UpdateFoldRegionsOperation.UPDATE_REGION.set((UserDataHolder)region, null);
    }

    public static void markAsAutoCreated(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(9);
        }
        AUTO_CREATED_KEY.set((UserDataHolder)region, (Object)true);
    }

    static boolean isAutoCreated(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(10);
        }
        return AUTO_CREATED_KEY.isIn((UserDataHolder)region);
    }

    public static void markAsFrontendCreated(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(11);
        }
        FRONTEND_CREATED_KEY.set((UserDataHolder)region, (Object)true);
    }

    public static boolean isFrontendCreated(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(12);
        }
        return FRONTEND_CREATED_KEY.isIn((UserDataHolder)region);
    }

    public static void markAsCanBeRemovedWhenCollapsed(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(13);
        }
        UpdateFoldRegionsOperation.CAN_BE_REMOVED_WHEN_COLLAPSED.set((UserDataHolder)region, (Object)true);
    }

    public static boolean canBeRemovedWhenCollapsed(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(14);
        }
        return UpdateFoldRegionsOperation.CAN_BE_REMOVED_WHEN_COLLAPSED.get((UserDataHolder)region) == Boolean.TRUE;
    }

    public static Boolean getCollapsedByDefault(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(15);
        }
        return (Boolean)UpdateFoldRegionsOperation.COLLAPSED_BY_DEFAULT.get((UserDataHolder)region);
    }

    public static void setCollapsedByDefault(@NotNull FoldRegion region, boolean isCollapsed) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(16);
        }
        UpdateFoldRegionsOperation.COLLAPSED_BY_DEFAULT.set((UserDataHolder)region, (Object)isCollapsed);
    }

    public static void markTransient(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(17);
        }
        TRANSIENT_KEY.set((UserDataHolder)region, (Object)true);
    }

    @Deprecated
    public static void markAsNotPersistent(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(18);
        }
        CodeFoldingManagerImpl.markTransient(region);
    }

    static boolean isTransient(@Nullable FoldRegion region) {
        return TRANSIENT_KEY.isIn((UserDataHolder)region);
    }

    public static Map<TextRange, Boolean> getAsyncExpandStatusMap(@Nullable Editor editor) {
        return (Map)ASYNC_FOLDING_CACHE_KEY.get((UserDataHolder)editor);
    }

    public static void setAsyncExpandStatusMap(@Nullable Editor editor, @Nullable Map<TextRange, Boolean> regionExpansionStates) {
        ASYNC_FOLDING_CACHE_KEY.set((UserDataHolder)editor, regionExpansionStates);
    }

    public static void markAsAsyncFoldingUpdater(@Nullable Editor editor) {
        ASYNC_FOLDING_UPDATE_KEY.set((UserDataHolder)editor, (Object)true);
    }

    public static boolean isAsyncFoldingUpdater(@Nullable Editor editor) {
        return ASYNC_FOLDING_UPDATE_KEY.get((UserDataHolder)editor) == Boolean.TRUE;
    }

    @Override
    public void scheduleAsyncFoldingUpdate(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(19);
        }
        FoldingUpdate.clearFoldingCache(editor);
        DaemonCodeAnalyzerEx.getInstanceEx((Project)this.myProject).restart((Object)"CodeFoldingManagerImpl.scheduleAsyncFoldingUpdate");
    }

    @RequiresEdt
    private void initFolding(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(20);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Document document = editor.getDocument();
        ThreadingAssertions.assertEventDispatchThread();
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            ThreadingAssertions.assertEventDispatchThread();
            DocumentFoldingInfo documentFoldingInfo = this.getOrCreateDocumentFoldingInfo(document);
            EditorFactory.getInstance().editors(document, this.myProject).filter(otherEditor -> otherEditor != editor && CodeFoldingManagerImpl.isFoldingsInitializedInEditor(otherEditor)).findFirst().ifPresent(otherEditor -> documentFoldingInfo.loadFromEditor((Editor)otherEditor));
            documentFoldingInfo.setToEditor(editor);
            documentFoldingInfo.clear();
            CodeFoldingManagerImpl.setFoldingsInitializedInEditor(editor);
        });
    }

    @Override
    @Nullable
    public FoldRegion findFoldRegion(@NotNull Editor editor, int startOffset, int endOffset) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(21);
        }
        return FoldingUtil.findFoldRegion((Editor)editor, (int)startOffset, (int)endOffset);
    }

    @Override
    @NotNull
    public @NotNull FoldRegion @NotNull [] getFoldRegionsAtOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(22);
        }
        FoldRegion[] foldRegionArray = FoldingUtil.getFoldRegionsAtOffset((Editor)editor, (int)offset);
        if (foldRegionArray == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(23);
        }
        return foldRegionArray;
    }

    @Override
    @RequiresReadLock
    public void updateFoldRegions(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(24);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
        Runnable runnable = this.updateFoldRegions(editor, false);
        if (runnable != null) {
            runnable.run();
        }
    }

    @Override
    @RequiresBackgroundThread
    @RequiresReadLock
    @Nullable
    public Runnable updateFoldRegionsAsync(@NotNull Editor editor, boolean firstTime) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(25);
        }
        ThreadingAssertions.softAssertReadAccess();
        ThreadingAssertions.assertBackgroundThread();
        ThreadingAssertions.assertReadAccess();
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return null;
        }
        Runnable runnable = this.updateFoldRegions(editor, firstTime);
        return () -> {
            if (runnable != null) {
                runnable.run();
            }
            if (firstTime && !CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                this.initFolding(editor);
            }
        };
    }

    @Nullable
    private Runnable updateFoldRegions(@NotNull Editor editor, boolean firstTime) {
        PsiFile psiFile;
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(26);
        }
        return (psiFile = CodeFoldingManagerImpl.getPsiFileForFolding(this.myProject, editor.getDocument())) == null ? null : FoldingUpdate.updateFoldRegions(editor, psiFile, firstTime);
    }

    @Override
    @NotNull
    public CodeFoldingState saveFoldingState(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(27);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DocumentFoldingInfo info = this.getOrCreateDocumentFoldingInfo(editor.getDocument());
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            info.loadFromEditor(editor);
        }
        DocumentFoldingInfo documentFoldingInfo = info;
        if (documentFoldingInfo == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(28);
        }
        return documentFoldingInfo;
    }

    @Override
    public void restoreFoldingState(@NotNull Editor editor, @NotNull CodeFoldingState state) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(29);
        }
        if (state == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(30);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            state.setToEditor(editor);
        }
    }

    @Override
    public void writeFoldingState(@NotNull CodeFoldingState state, @NotNull Element element) {
        if (state == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(31);
        }
        if (element == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(32);
        }
        if (state instanceof DocumentFoldingInfo) {
            ((DocumentFoldingInfo)state).writeExternal(element);
        }
    }

    @Override
    @NotNull
    public CodeFoldingState readFoldingState(@NotNull Element element, @NotNull Document document) {
        if (element == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(33);
        }
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(34);
        }
        DocumentFoldingInfo info = this.getOrCreateDocumentFoldingInfo(document);
        info.readExternal(element);
        DocumentFoldingInfo documentFoldingInfo = info;
        if (documentFoldingInfo == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(35);
        }
        return documentFoldingInfo;
    }

    @NotNull
    private DocumentFoldingInfo getOrCreateDocumentFoldingInfo(@NotNull Document document) {
        DocumentFoldingInfo info;
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(36);
        }
        if ((info = (DocumentFoldingInfo)document.getUserData(this.MY_FOLDING_INFO_IN_DOCUMENT_KEY)) == null) {
            info = new DocumentFoldingInfo(this.myProject, document);
            DocumentFoldingInfo written = (DocumentFoldingInfo)((UserDataHolderEx)document).putUserDataIfAbsent(this.MY_FOLDING_INFO_IN_DOCUMENT_KEY, (Object)info);
            if (written == info) {
                this.myDocumentsWithFoldingInfo.add(document);
            } else {
                info = written;
            }
        }
        DocumentFoldingInfo documentFoldingInfo = info;
        if (documentFoldingInfo == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(37);
        }
        return documentFoldingInfo;
    }

    static boolean isFoldingsInitializedInEditor(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(38);
        }
        return Boolean.TRUE.equals(editor.getUserData(FOLDINGS_INITIALIZED_KEY));
    }

    private static void setFoldingsInitializedInEditor(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(39);
        }
        editor.putUserData(FOLDINGS_INITIALIZED_KEY, (Object)Boolean.TRUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 23, 28, 35, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 23: 
            case 28: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldRegionsAtOffset";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "saveFoldingState";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "readFoldingState";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDocumentFoldingInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "releaseFoldings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildInitialFoldings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileForFolding";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "keepExpandedOnFirstCollapseAll";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markForUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "markUpdated";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "markAsAutoCreated";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAutoCreated";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "markAsFrontendCreated";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isFrontendCreated";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "markAsCanBeRemovedWhenCollapsed";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canBeRemovedWhenCollapsed";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCollapsedByDefault";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setCollapsedByDefault";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "markTransient";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "markAsNotPersistent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAsyncFoldingUpdate";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "initFolding";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findFoldRegion";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFoldRegionsAtOffset";
                break;
            }
            case 23: 
            case 28: 
            case 35: 
            case 37: {
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateFoldRegions";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updateFoldRegionsAsync";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "saveFoldingState";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "restoreFoldingState";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "writeFoldingState";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "readFoldingState";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDocumentFoldingInfo";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isFoldingsInitializedInEditor";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setFoldingsInitializedInEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 23, 28, 35, 37 -> new IllegalStateException(string);
        };
    }
}

