/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SlowOperations;
import org.jetbrains.annotations.NotNull;

final class CodeFoldingPass
extends EditorBoundHighlightingPass
implements PossiblyDumbAware {
    private static final Key<Boolean> THE_FIRST_TIME_KEY = Key.create((String)"FirstFoldingPass");
    private volatile Runnable myRunnable;

    CodeFoldingPass(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            CodeFoldingPass.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            CodeFoldingPass.$$$reportNull$$$0(1);
        }
        super(editor, psiFile, false);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            CodeFoldingPass.$$$reportNull$$$0(2);
        }
        boolean firstTime = CodeFoldingPass.isFirstTime(this.myFile, this.myEditor, THE_FIRST_TIME_KEY);
        try (AccessToken ignored = CodeFoldingPass.runPass();){
            this.myRunnable = CodeFoldingManager.getInstance(this.myProject).updateFoldRegionsAsync(this.myEditor, firstTime);
        }
    }

    static boolean isFirstTime(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull Key<Boolean> key) {
        if (psiFile == null) {
            CodeFoldingPass.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            CodeFoldingPass.$$$reportNull$$$0(4);
        }
        if (key == null) {
            CodeFoldingPass.$$$reportNull$$$0(5);
        }
        return psiFile.getUserData(key) == null || editor.getUserData(key) == null;
    }

    static void clearFirstTimeFlag(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull Key<? super Boolean> key) {
        if (psiFile == null) {
            CodeFoldingPass.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            CodeFoldingPass.$$$reportNull$$$0(7);
        }
        if (key == null) {
            CodeFoldingPass.$$$reportNull$$$0(8);
        }
        psiFile.putUserData(key, (Object)Boolean.FALSE);
        editor.putUserData(key, (Object)Boolean.FALSE);
    }

    public void doApplyInformationToEditor() {
        Runnable runnable = this.myRunnable;
        if (runnable != null) {
            try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-333911, EA-840750");){
                runnable.run();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (InjectedLanguageManager.getInstance((Project)this.myFile.getProject()).getTopLevelFile((PsiElement)this.myFile) == this.myFile) {
            CodeFoldingPass.clearFirstTimeFlag(this.myFile, this.myEditor, THE_FIRST_TIME_KEY);
        }
    }

    public boolean isDumbAware() {
        return FoldingUpdate.supportsDumbModeFolding(this.myFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/CodeFoldingPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isFirstTime";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "clearFirstTimeFlag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

