/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.formatting.visualLayer.VisualFormattingLayerService;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.FoldingKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DocumentFoldingInfo
implements CodeFoldingState {
    private static final Logger LOG = Logger.getInstance(DocumentFoldingInfo.class);
    private static final Key<FoldingInfo> FOLDING_INFO_KEY = Key.create((String)"FOLDING_INFO");
    @NotNull
    private final Project myProject;
    private final VirtualFile myFile;
    @NotNull
    private final List<SignatureInfo> myInfos;
    @NotNull
    private final List<RangeMarker> myRangeMarkers;
    private static final String DEFAULT_PLACEHOLDER = "...";
    @NonNls
    private static final String ELEMENT_TAG = "element";
    @NonNls
    private static final String SIGNATURE_ATT = "signature";
    @NonNls
    private static final String EXPANDED_ATT = "expanded";
    @NonNls
    private static final String MARKER_TAG = "marker";
    @NonNls
    private static final String DATE_ATT = "date";
    @NonNls
    private static final String PLACEHOLDER_ATT = "ph";

    DocumentFoldingInfo(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(0);
        }
        if (document == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(1);
        }
        this.myInfos = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRangeMarkers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myFile = FileDocumentManager.getInstance().getFile(document);
    }

    void loadFromEditor(@NotNull Editor editor) {
        FoldRegion[] foldRegions;
        if (editor == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(2);
        }
        EditorThreading.Companion.assertInteractionAllowed();
        LOG.assertTrue(!editor.isDisposed());
        this.clear();
        int caretOffset = editor.getCaretModel().getOffset();
        for (FoldRegion region : foldRegions = editor.getFoldingModel().getAllFoldRegions()) {
            boolean collapseByDefault;
            if (!region.isValid() || region.shouldNeverExpand() || CodeFoldingManagerImpl.isTransient(region)) continue;
            boolean expanded = region.isExpanded();
            String signature = (String)region.getUserData(UpdateFoldRegionsOperation.SIGNATURE);
            if (Strings.areSameInstance((String)signature, (String)"no signature")) continue;
            Boolean storedCollapseByDefault = CodeFoldingManagerImpl.getCollapsedByDefault(region);
            boolean bl = collapseByDefault = storedCollapseByDefault != null && storedCollapseByDefault != false && !UpdateFoldRegionsOperation.caretInsideRange(caretOffset, region.getTextRange());
            if (collapseByDefault != expanded && !DocumentFoldingInfo.isManuallyCreated(region, signature)) continue;
            if (signature == null) {
                this.addRangeMarker(editor.getDocument(), region.getTextRange(), expanded, region.getPlaceholderText());
                continue;
            }
            this.myInfos.add(new SignatureInfo(signature, expanded));
        }
    }

    private void addRangeMarker(@NotNull Document document, @NotNull TextRange range, boolean expanded, @NotNull String placeholderText) {
        if (document == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(3);
        }
        if (range == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(4);
        }
        if (placeholderText == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(5);
        }
        RangeMarker marker = document.createRangeMarker(range);
        this.myRangeMarkers.add(marker);
        marker.putUserData(FOLDING_INFO_KEY, (Object)new FoldingInfo(placeholderText, expanded));
    }

    private static boolean isManuallyCreated(@NotNull FoldRegion region, @Nullable String signature) {
        if (region == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(6);
        }
        return signature == null && !CodeFoldingManagerImpl.isAutoCreated(region);
    }

    @RequiresEdt
    public void setToEditor(@NotNull Editor editor) {
        if (editor == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (psiManager.isDisposed()) {
            return;
        }
        if (!this.myFile.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(this.myFile);
        if (psiFile == null) {
            return;
        }
        Map<PsiElement, FoldingDescriptor> ranges = null;
        for (SignatureInfo info : this.myInfos) {
            TextRange range;
            FoldRegion region;
            FoldingDescriptor descriptor;
            PsiElement element = FoldingPolicy.restoreBySignature(psiFile, info.signature);
            if (element == null || !element.isValid()) continue;
            if (ranges == null) {
                ranges = DocumentFoldingInfo.buildRanges(psiFile, editor.getDocument());
            }
            if ((descriptor = (FoldingDescriptor)ranges.get(element)) == null || (region = FoldingUtil.findFoldRegion((Editor)editor, (int)(range = descriptor.getRange()).getStartOffset(), (int)range.getEndOffset())) == null) continue;
            DocumentFoldingInfo.expandRegionBlessForNewLife(editor, region, info.expanded);
        }
        for (RangeMarker marker : this.myRangeMarkers) {
            if (!marker.isValid() || marker.getStartOffset() == marker.getEndOffset()) continue;
            FoldRegion region = FoldingUtil.findFoldRegion((Editor)editor, (int)marker.getStartOffset(), (int)marker.getEndOffset());
            FoldingInfo info = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            if (region == null) {
                if (info != null) {
                    region = editor.getFoldingModel().addFoldRegion(marker.getStartOffset(), marker.getEndOffset(), info.placeHolder);
                }
                if (region == null) {
                    return;
                }
            }
            boolean expanded = info != null && info.expanded;
            DocumentFoldingInfo.expandRegionBlessForNewLife(editor, region, expanded);
        }
    }

    private static void expandRegionBlessForNewLife(@NotNull Editor editor, @NotNull FoldRegion region, boolean expanded) {
        int offset;
        if (editor == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(8);
        }
        if (region == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(9);
        }
        if (!CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor) && (offset = editor.getCaretModel().getOffset()) > region.getStartOffset() && offset < region.getEndOffset()) {
            expanded = true;
        }
        FoldingKeys.ZOMBIE_REGION_KEY.set((UserDataHolder)region, null);
        region.setExpanded(expanded);
    }

    @NotNull
    private static Map<PsiElement, FoldingDescriptor> buildRanges(@NotNull PsiFile psiFile, @NotNull Document document) {
        if (psiFile == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(10);
        }
        if (document == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(11);
        }
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(psiFile.getLanguage());
        FileASTNode node = psiFile.getNode();
        if (node == null) {
            Map<PsiElement, FoldingDescriptor> map = Collections.emptyMap();
            if (map == null) {
                DocumentFoldingInfo.$$$reportNull$$$0(12);
            }
            return map;
        }
        FoldingDescriptor[] descriptors = LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psiFile, (Document)document, (boolean)true);
        HashMap<PsiElement, FoldingDescriptor> ranges = HashMap.newHashMap(descriptors.length);
        for (FoldingDescriptor descriptor : descriptors) {
            ASTNode ast = descriptor.getElement();
            PsiElement psi = ast.getPsi();
            if (psi == null) continue;
            ranges.put(psi, descriptor);
        }
        HashMap<PsiElement, FoldingDescriptor> hashMap = ranges;
        if (hashMap == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    void clear() {
        this.myInfos.clear();
        for (RangeMarker marker : this.myRangeMarkers) {
            marker.dispose();
        }
        this.myRangeMarkers.clear();
    }

    void writeExternal(@NotNull Element element) {
        if (element == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(14);
        }
        if (this.myInfos.isEmpty() && this.myRangeMarkers.isEmpty()) {
            return;
        }
        for (SignatureInfo info : this.myInfos) {
            Element e = new Element(ELEMENT_TAG);
            e.setAttribute(SIGNATURE_ATT, info.signature);
            if (info.expanded) {
                e.setAttribute(EXPANDED_ATT, Boolean.toString(true));
            }
            element.addContent(e);
        }
        String date = null;
        for (RangeMarker marker : this.myRangeMarkers) {
            FoldingInfo fi = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            boolean state = fi != null && fi.expanded;
            Element e = new Element(MARKER_TAG);
            if (date == null) {
                date = this.getTimeStamp();
            }
            if (date.isEmpty()) continue;
            e.setAttribute(DATE_ATT, date);
            e.setAttribute(EXPANDED_ATT, Boolean.toString(state));
            String signature = marker.getStartOffset() + ":" + marker.getEndOffset();
            e.setAttribute(SIGNATURE_ATT, signature);
            String placeHolderText = fi == null ? DEFAULT_PLACEHOLDER : fi.placeHolder;
            e.setAttribute(PLACEHOLDER_ATT, XmlStringUtil.escapeIllegalXmlChars((String)placeHolderText));
            element.addContent(e);
        }
    }

    void readExternal(@NotNull Element element) {
        if (element == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            this.clear();
            if (!this.myFile.isValid()) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
            if (document == null) {
                return;
            }
            WhiteSpaceFormattingStrategy whiteSpaceFormattingStrategy = WhiteSpaceFormattingStrategyFactory.DEFAULT_STRATEGY;
            boolean removeVFmtZombieFoldings = VisualFormattingLayerService.shouldRemoveZombieFoldings();
            String date = null;
            for (Element e : element.getChildren()) {
                String signature = e.getAttributeValue(SIGNATURE_ATT);
                if (signature == null) continue;
                boolean expanded = Boolean.parseBoolean(e.getAttributeValue(EXPANDED_ATT));
                if (ELEMENT_TAG.equals(e.getName())) {
                    this.myInfos.add(new SignatureInfo(signature, expanded));
                    continue;
                }
                if (MARKER_TAG.equals(e.getName())) {
                    if (date == null) {
                        date = this.getTimeStamp();
                    }
                    if (date.isEmpty() || !date.equals(e.getAttributeValue(DATE_ATT)) || FileDocumentManager.getInstance().isDocumentUnsaved(document)) continue;
                    StringTokenizer tokenizer = new StringTokenizer(signature, ":");
                    try {
                        String placeHolderText;
                        int start = Integer.parseInt(tokenizer.nextToken());
                        int end = Integer.parseInt(tokenizer.nextToken());
                        if (start < 0 || end >= document.getTextLength() || start > end) continue;
                        String placeholderAttributeValue = e.getAttributeValue(PLACEHOLDER_ATT);
                        String string = placeHolderText = placeholderAttributeValue == null ? DEFAULT_PLACEHOLDER : XmlStringUtil.unescapeIllegalXmlChars((String)placeholderAttributeValue);
                        if (removeVFmtZombieFoldings && placeHolderText.isEmpty() && whiteSpaceFormattingStrategy.check((CharSequence)document.getText(), start, end) >= end) continue;
                        this.addRangeMarker(document, TextRange.create((int)start, (int)end), expanded, placeHolderText);
                    }
                    catch (NoSuchElementException exc) {
                        LOG.error((Throwable)exc);
                    }
                    continue;
                }
                throw new IllegalStateException("unknown tag: " + e.getName());
            }
        });
    }

    @NotNull
    private String getTimeStamp() {
        return this.myFile.isValid() ? Long.toString(this.myFile.getTimeStamp()) : "";
    }

    public int hashCode() {
        int result = this.myProject.hashCode();
        result = 31 * result + (this.myFile != null ? this.myFile.hashCode() : 0);
        result = 31 * result + this.myInfos.hashCode();
        result = 31 * result + this.myRangeMarkers.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFoldingInfo info = (DocumentFoldingInfo)o;
        if (!Objects.equals(this.myFile, info.myFile)) {
            return false;
        }
        if (!this.myProject.equals((Object)info.myProject) || !this.myInfos.equals(info.myInfos)) {
            return false;
        }
        if (this.myRangeMarkers.size() != info.myRangeMarkers.size()) {
            return false;
        }
        for (int i = 0; i < this.myRangeMarkers.size(); ++i) {
            FoldingInfo ofi;
            RangeMarker other;
            RangeMarker marker = this.myRangeMarkers.get(i);
            if (marker == (other = info.myRangeMarkers.get(i)) || !marker.isValid() || !other.isValid()) continue;
            if (!TextRange.areSegmentsEqual((Segment)marker, (Segment)other)) {
                return false;
            }
            FoldingInfo fi = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            if (Comparing.equal((Object)fi, (Object)(ofi = (FoldingInfo)other.getUserData(FOLDING_INFO_KEY)))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholderText";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_TAG;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadFromEditor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRangeMarker";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isManuallyCreated";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setToEditor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "expandRegionBlessForNewLife";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildRanges";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13 -> new IllegalStateException(string);
        };
    }

    private record SignatureInfo(@NotNull String signature, boolean expanded) {
        @NotNull
        private final String signature;

        private SignatureInfo(@NotNull String signature, boolean expanded) {
            if (signature == null) {
                SignatureInfo.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String signature() {
            String string = this.signature;
            if (string == null) {
                SignatureInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = DocumentFoldingInfo.SIGNATURE_ATT;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$SignatureInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$SignatureInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = DocumentFoldingInfo.SIGNATURE_ATT;
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private record FoldingInfo(@NotNull String placeHolder, boolean expanded) {
        @NotNull
        private final String placeHolder;

        private FoldingInfo(@NotNull String placeHolder, boolean expanded) {
            if (placeHolder == null) {
                FoldingInfo.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String placeHolder() {
            String string = this.placeHolder;
            if (string == null) {
                FoldingInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "placeHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$FoldingInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$FoldingInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "placeHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

