/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfoWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFoldingInfo {
    private static final Key<EditorFoldingInfo> KEY = Key.create((String)"EditorFoldingInfo.KEY");
    private static final Object ourLock = ObjectUtils.sentinel((String)"lock");
    private final Map<FoldRegion, SmartPsiElementPointer<?>> myFoldRegionToSmartPointerMap = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static EditorFoldingInfo get(@NotNull Editor editor) {
        if (editor == null) {
            EditorFoldingInfo.$$$reportNull$$$0(0);
        }
        if (editor instanceof EditorWindow) {
            return new EditorFoldingInfoWindow(EditorFoldingInfo.get(((EditorWindow)editor).getDelegate()));
        }
        Object object = ourLock;
        // MONITORENTER : object
        EditorFoldingInfo info = (EditorFoldingInfo)editor.getUserData(KEY);
        if (info == null) {
            info = new EditorFoldingInfo();
            editor.putUserData(KEY, (Object)info);
        }
        EditorFoldingInfo editorFoldingInfo = info;
        // MONITOREXIT : object
        if (editorFoldingInfo != null) return editorFoldingInfo;
        EditorFoldingInfo.$$$reportNull$$$0(1);
        return editorFoldingInfo;
    }

    @Nullable
    public PsiElement getPsiElement(@NotNull FoldRegion region) {
        SmartPsiElementPointer<?> pointer;
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(2);
        }
        if ((pointer = this.myFoldRegionToSmartPointerMap.get(region)) == null) {
            return null;
        }
        PsiElement element = pointer.getElement();
        return element != null && element.isValid() ? element : null;
    }

    @Nullable
    TextRange getPsiElementRange(@NotNull FoldRegion region) {
        PsiElement element;
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(3);
        }
        if ((element = this.getPsiElement(region)) == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        boolean isInjected = injectedManager.isInjectedFragment(containingFile);
        TextRange range = element.getTextRange();
        if (isInjected) {
            range = injectedManager.injectedToHost(element, range);
        }
        return range;
    }

    void addRegion(@NotNull FoldRegion region, @NotNull SmartPsiElementPointer<?> pointer) {
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(4);
        }
        if (pointer == null) {
            EditorFoldingInfo.$$$reportNull$$$0(5);
        }
        this.myFoldRegionToSmartPointerMap.put(region, pointer);
    }

    public void removeRegion(@NotNull FoldRegion region) {
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(6);
        }
        this.myFoldRegionToSmartPointerMap.remove(region);
    }

    void dispose() {
        this.myFoldRegionToSmartPointerMap.clear();
    }

    static void disposeForEditor(@NotNull Editor editor) {
        EditorFoldingInfo info;
        if (editor == null) {
            EditorFoldingInfo.$$$reportNull$$$0(7);
        }
        if ((info = (EditorFoldingInfo)editor.getUserData(KEY)) != null) {
            info.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/EditorFoldingInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/EditorFoldingInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementRange";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRegion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeRegion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "disposeForEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

