/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.actions.BaseFoldingHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExpandRegionAction
extends EditorAction
implements ActionRemoteBehaviorSpecification.Frontend {
    ExpandRegionAction() {
        super((EditorActionHandler)new BaseFoldingHandler(){

            public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExpandRegionAction.expandRegionAtCaret(editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/actions/ExpandRegionAction$1", "doExecute"));
            }
        });
    }

    private static void expandRegionAtCaret(@Nullable Editor editor) {
        if (editor == null) {
            return;
        }
        int[] offsets = editor.getCaretModel().getAllCarets().stream().mapToInt(Caret::getOffset).toArray();
        ExpandRegionAction.expandRegionAtOffsets(editor, offsets);
    }

    public static void expandRegionAtOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            ExpandRegionAction.$$$reportNull$$$0(0);
        }
        ExpandRegionAction.expandRegionAtOffsets(editor, new int[]{offset});
    }

    public static void expandRegionAtOffsets(@NotNull Editor editor, int[] offsets) {
        if (editor == null) {
            ExpandRegionAction.$$$reportNull$$$0(1);
        }
        Runnable processor = () -> {
            block0: for (int offset : offsets) {
                int line = editor.getDocument().getLineNumber(offset);
                FoldRegion region = FoldingUtil.findFoldRegionStartingAtLine((Editor)editor, (int)line);
                if (region != null && !region.isExpanded()) {
                    region.setExpanded(true);
                    continue;
                }
                FoldRegion[] regions = FoldingUtil.getFoldRegionsAtOffset((Editor)editor, (int)offset);
                for (int i = regions.length - 1; i >= 0; --i) {
                    region = regions[i];
                    if (region.isExpanded()) continue;
                    region.setExpanded(true);
                    continue block0;
                }
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/actions/ExpandRegionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "expandRegionAtOffset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "expandRegionAtOffsets";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

