/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.ElementSignatureProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractElementSignatureProvider
implements ElementSignatureProvider {
    private static final int CHILDREN_COUNT_LIMIT = 100;
    protected static final String ELEMENTS_SEPARATOR = ";";
    protected static final String ELEMENT_TOKENS_SEPARATOR = "#";
    private static final String ESCAPE_CHAR = "\\";
    private static final List<String> ESCAPE_FROM = Arrays.asList("\\", "#", ";");
    private static final List<String> ESCAPE_TO = Arrays.asList("\\\\", "\\s", "\\h");

    @Override
    @Nullable
    public PsiElement restoreBySignature(@NotNull PsiFile file, @NotNull String signature, @Nullable StringBuilder processingInfoStorage) {
        PsiFile parent;
        int semicolonIndex;
        if (file == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(0);
        }
        if (signature == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(1);
        }
        if ((semicolonIndex = signature.indexOf(ELEMENTS_SEPARATOR)) >= 0) {
            String parentSignature = signature.substring(semicolonIndex + 1);
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Provider '%s'. Restoring parent by signature '%s'...%n", this.getClass().getName(), parentSignature));
            }
            parent = this.restoreBySignature(file, parentSignature, processingInfoStorage);
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Restored parent by signature '%s': %s%n", parentSignature, parent));
            }
            if (parent == null) {
                return null;
            }
            signature = signature.substring(0, semicolonIndex);
        } else {
            parent = file;
        }
        StringTokenizer tokenizer = new StringTokenizer(signature, ELEMENT_TOKENS_SEPARATOR);
        String type = tokenizer.nextToken();
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Provider '%s'. Restoring target element by signature '%s'. Parent: %s, same as the given parent: %b%n", this.getClass().getName(), signature, parent, parent == file));
        }
        return this.restoreBySignatureTokens(file, (PsiElement)parent, type, tokenizer, processingInfoStorage);
    }

    @Nullable
    protected abstract PsiElement restoreBySignatureTokens(@NotNull PsiFile var1, @NotNull PsiElement var2, @NotNull String var3, @NotNull StringTokenizer var4, @Nullable StringBuilder var5);

    protected static <T extends PsiNamedElement> int getChildIndex(@Nullable T element, @NotNull PsiElement parent, @NotNull String name, @NotNull Class<? extends T> hisClass) {
        PsiFile file;
        Set cache;
        if (parent == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(2);
        }
        if (name == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(3);
        }
        if (hisClass == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(4);
        }
        Set set = cache = (file = parent.getContainingFile()) == null ? null : (Set)CachedValuesManager.getCachedValue((PsiElement)file, () -> new CachedValueProvider.Result((Object)ContainerUtil.createWeakSet(), new Object[]{file}));
        if (cache != null && cache.contains(parent)) {
            return -1;
        }
        PsiElement[] children = parent.getChildren();
        if (children.length > 100) {
            if (cache != null) {
                cache.add(parent);
            }
            return -1;
        }
        int index = 0;
        for (PsiElement child : children) {
            PsiNamedElement namedChild;
            String childName;
            if (!ReflectionUtil.isAssignable(hisClass, (Class)child.getClass()) || !name.equals(childName = (namedChild = (PsiNamedElement)hisClass.cast(child)).getName())) continue;
            if (namedChild.equals(element)) {
                return index;
            }
            ++index;
        }
        return index;
    }

    @Nullable
    protected static <T extends PsiNamedElement> T restoreElementInternal(@NotNull PsiElement parent, @NotNull String name, int index, @NotNull Class<T> hisClass) {
        PsiElement[] children;
        if (parent == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(5);
        }
        if (name == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(6);
        }
        if (hisClass == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(7);
        }
        for (PsiElement child : children = parent.getChildren()) {
            PsiNamedElement namedChild;
            String childName;
            if (!ReflectionUtil.isAssignable(hisClass, (Class)child.getClass()) || !name.equals(childName = (namedChild = (PsiNamedElement)hisClass.cast(child)).getName())) continue;
            if (index == 0) {
                return (T)namedChild;
            }
            --index;
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    protected static String escape(@NotNull String name) {
        if (name == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(8);
        }
        String string = StringUtil.replace((String)name, ESCAPE_FROM, ESCAPE_TO);
        if (string == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    protected static String unescape(@NotNull String name) {
        if (name == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(10);
        }
        String string = StringUtil.replace((String)name, ESCAPE_TO, ESCAPE_FROM);
        if (string == null) {
            AbstractElementSignatureProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hisClass";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/AbstractElementSignatureProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/AbstractElementSignatureProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "unescape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "restoreBySignature";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndex";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restoreElementInternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11 -> new IllegalStateException(string);
        };
    }
}

