/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.FoldingRegionWindow;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class FoldingUpdate {
    private static final Logger LOG = Logger.getInstance(FoldingUpdate.class);
    private static final Key<CachedValue<Runnable>> CODE_FOLDING_KEY = Key.create((String)"code folding");
    public static final Key<Boolean> INJECTED_CODE_FOLDING_ENABLED = Key.create((String)"injected code folding is enabled");
    private static final Key<Long> LAST_UPDATE_INJECTED_STAMP_KEY = Key.create((String)"LAST_UPDATE_INJECTED_STAMP_KEY");

    private FoldingUpdate() {
    }

    @RequiresReadLock
    @Nullable
    static Runnable updateFoldRegions(@NotNull Editor editor, @NotNull PsiFile psiFile, boolean firstTime) {
        Getter cached;
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            FoldingUpdate.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.softAssertReadAccess();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = psiFile.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(PsiDocumentManager.getInstance((Project)project).isCommitted(document));
        if (document.getTextLength() != psiFile.getTextLength()) {
            LOG.error(DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)psiFile, (Document)document));
            return null;
        }
        CachedValue value = (CachedValue)editor.getUserData(CODE_FOLDING_KEY);
        if (value != null && !firstTime && (cached = value.getUpToDateOrNull()) != null) {
            return (Runnable)cached.get();
        }
        if (firstTime) {
            return (Runnable)FoldingUpdate.getUpdateResult(psiFile, document, project, editor, true).getFirst();
        }
        return (Runnable)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)editor, CODE_FOLDING_KEY, () -> {
            PsiFile psiFile1 = CodeFoldingManagerImpl.getPsiFileForFolding(project, document);
            Pair<@NotNull Runnable, @NotNull Object @NotNull []> result = FoldingUpdate.getUpdateResult(psiFile1, document, project, editor, false);
            Runnable runnable = (Runnable)result.getFirst();
            Object[] dependencies = (Object[])result.getSecond();
            return CachedValueProvider.Result.create((Object)runnable, (Object[])dependencies);
        }, false);
    }

    @NotNull
    private static @NotNull Pair<@NotNull Runnable, @NotNull Object @NotNull []> getUpdateResult(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull Project project, @NotNull Editor editor, boolean applyDefaultState) {
        if (psiFile == null) {
            FoldingUpdate.$$$reportNull$$$0(2);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(3);
        }
        if (project == null) {
            FoldingUpdate.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(5);
        }
        PsiUtilCore.ensureValid((PsiElement)psiFile);
        List<RegionInfo> elementsToFold = FoldingUpdate.getFoldingsFor(psiFile, false);
        UpdateFoldRegionsOperation operation = new UpdateFoldRegionsOperation(project, editor, psiFile, elementsToFold, FoldingUpdate.applyDefaultStateMode(applyDefaultState), !applyDefaultState, false);
        int documentLength = document.getTextLength();
        AtomicBoolean alreadyExecuted = new AtomicBoolean();
        Runnable runnable = () -> {
            if (alreadyExecuted.compareAndSet(false, true)) {
                if (documentLength != document.getTextLength() || !PsiDocumentManager.getInstance((Project)project).isCommitted(document)) {
                    FoldingUpdate.reportUnexpectedDocumentChange(psiFile, document, documentLength);
                }
                editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret((Runnable)operation);
            }
        };
        HashSet<Object> dependencies = new HashSet<Object>();
        dependencies.add(psiFile);
        dependencies.add(editor.getFoldingModel());
        for (RegionInfo info : elementsToFold) {
            dependencies.addAll(info.descriptor.getDependencies());
        }
        Pair pair = Pair.create((Object)runnable, (Object)ArrayUtil.toObjectArray(dependencies));
        if (pair == null) {
            FoldingUpdate.$$$reportNull$$$0(6);
        }
        return pair;
    }

    private static void reportUnexpectedDocumentChange(@NotNull PsiFile psiFile, @NotNull Document document, int prevLength) {
        if (psiFile == null) {
            FoldingUpdate.$$$reportNull$$$0(7);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(8);
        }
        Document fileDoc = psiFile.getViewProvider().getDocument();
        VirtualFile vFile = psiFile.getViewProvider().getVirtualFile();
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)psiFile.getProject());
        PsiFile docFile = pdm.getCachedPsiFile(document);
        LOG.error("Document has changed since fold regions were calculated:\n  lengths: " + prevLength + " vs " + document.getTextLength() + "\n  document=" + String.valueOf(document) + "\n  file.document=" + String.valueOf(fileDoc == document ? "same" : fileDoc) + "\n  document.file=" + String.valueOf(docFile == psiFile ? "same" : docFile) + "\n  committed=" + pdm.isCommitted(document) + "\n  psiFile=" + String.valueOf(psiFile) + "\n  vFile.length=" + (vFile.isValid() ? vFile.getLength() : -1L));
    }

    @NotNull
    private static UpdateFoldRegionsOperation.ApplyDefaultStateMode applyDefaultStateMode(boolean applyDefaultState) {
        UpdateFoldRegionsOperation.ApplyDefaultStateMode applyDefaultStateMode = applyDefaultState ? UpdateFoldRegionsOperation.ApplyDefaultStateMode.EXCEPT_CARET_REGION : UpdateFoldRegionsOperation.ApplyDefaultStateMode.NO;
        if (applyDefaultStateMode == null) {
            FoldingUpdate.$$$reportNull$$$0(9);
        }
        return applyDefaultStateMode;
    }

    @Nullable
    static Runnable updateInjectedFoldRegions(@NotNull Editor hostEditor, @NotNull PsiFile hostPsiFile, boolean applyDefaultState) {
        if (hostEditor == null) {
            FoldingUpdate.$$$reportNull$$$0(10);
        }
        if (hostPsiFile == null) {
            FoldingUpdate.$$$reportNull$$$0(11);
        }
        if (hostPsiFile instanceof PsiCompiledElement) {
            return null;
        }
        boolean codeFoldingForInjectedEnabled = hostEditor.getUserData(INJECTED_CODE_FOLDING_ENABLED) != Boolean.FALSE;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = hostPsiFile.getProject();
        Document document = hostEditor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).isUncommited(document));
        FoldingModel foldingModel = hostEditor.getFoldingModel();
        long timeStamp = document.getModificationStamp();
        Long lastTimeStamp = (Long)hostEditor.getUserData(LAST_UPDATE_INJECTED_STAMP_KEY);
        if (lastTimeStamp != null && lastTimeStamp == timeStamp) {
            return null;
        }
        List injectedDocuments = InjectedLanguageManager.getInstance((Project)project).getCachedInjectedDocumentsInRange(hostPsiFile, hostPsiFile.getTextRange());
        if (injectedDocuments.isEmpty()) {
            return null;
        }
        ArrayList injectedEditors = new ArrayList(injectedDocuments.size());
        ArrayList injectedFiles = new ArrayList(injectedDocuments.size());
        ArrayList lists = new ArrayList(injectedDocuments.size());
        for (DocumentWindow injectedDocument : injectedDocuments) {
            if (!injectedDocument.isValid()) continue;
            InjectedLanguageUtil.enumerate((DocumentWindow)injectedDocument, (PsiFile)hostPsiFile, (injectedFile, places) -> {
                Editor injectedEditor;
                Editor editor = injectedEditor = injectedFile.isValid() ? InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)hostEditor, (PsiFile)injectedFile) : null;
                if (injectedEditor instanceof EditorWindow) {
                    EditorWindow window = (EditorWindow)injectedEditor;
                    injectedEditors.add(window);
                    injectedFiles.add(injectedFile);
                    lists.add(codeFoldingForInjectedEnabled ? FoldingUpdate.getFoldingsFor(injectedFile, false) : List.of());
                }
            });
        }
        return () -> {
            ArrayList<UpdateFoldRegionsOperation> updateOperations = new ArrayList<UpdateFoldRegionsOperation>(injectedEditors.size());
            for (int i = 0; i < injectedEditors.size(); ++i) {
                EditorWindow injectedEditor = (EditorWindow)injectedEditors.get(i);
                PsiFile injectedFile = (PsiFile)injectedFiles.get(i);
                if (!injectedEditor.getDocument().isValid()) continue;
                List list = (List)lists.get(i);
                updateOperations.add(new UpdateFoldRegionsOperation(project, (Editor)injectedEditor, injectedFile, list, FoldingUpdate.applyDefaultStateMode(applyDefaultState), !applyDefaultState, true));
            }
            foldingModel.runBatchFoldingOperation(() -> {
                for (Runnable operation : updateOperations) {
                    operation.run();
                }
            });
            EditorFoldingInfo info = EditorFoldingInfo.get(hostEditor);
            for (FoldRegion region : hostEditor.getFoldingModel().getAllFoldRegions()) {
                FoldingRegionWindow injectedRegion = FoldingRegionWindow.getInjectedRegion(region);
                if (injectedRegion == null || injectedRegion.isValid()) continue;
                info.removeRegion(region);
            }
            hostEditor.putUserData(LAST_UPDATE_INJECTED_STAMP_KEY, (Object)timeStamp);
        };
    }

    static boolean supportsDumbModeFolding(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            FoldingUpdate.$$$reportNull$$$0(12);
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (foldingBuilder == null || DumbService.isDumbAware((Object)foldingBuilder)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    @NotNull
    public static @Unmodifiable List<RegionInfo> getFoldingsFor(@NotNull PsiFile psiFile, boolean quick) {
        DocumentImpl documentImpl;
        FileViewProvider viewProvider;
        Document document;
        if (psiFile == null) {
            FoldingUpdate.$$$reportNull$$$0(13);
        }
        if ((document = (viewProvider = psiFile.getViewProvider()).getDocument()) == null) {
            LOG.error("No document for " + String.valueOf(viewProvider));
            List<RegionInfo> list = List.of();
            if (list == null) {
                FoldingUpdate.$$$reportNull$$$0(14);
            }
            return list;
        }
        LOG.assertTrue(PsiDocumentManager.getInstance((Project)psiFile.getProject()).isCommitted(document));
        int textLength = document.getTextLength();
        ArrayList hardRefToRangeMarkers = new ArrayList();
        Comparator<PsiFile> preferBaseLanguage = Comparator.comparing(f -> f.getLanguage() != viewProvider.getBaseLanguage()).thenComparing(f -> f.getLanguage().getID());
        List allFiles = ContainerUtil.sorted((Collection)viewProvider.getAllFiles(), preferBaseLanguage);
        if (allFiles.size() > 1) {
            DocumentImpl docImpl;
            boolean bl = document instanceof DocumentImpl && (docImpl = (DocumentImpl)document).acceptsSlashR();
            documentImpl = new DocumentImpl(document.getImmutableCharSequence(), bl, true);
        } else {
            documentImpl = null;
        }
        DocumentImpl copyDoc = documentImpl;
        ArrayList<RegionInfo> elementsToFold = null;
        for (PsiFile psiRoot : allFiles) {
            Language language = psiRoot.getLanguage();
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (foldingBuilder == null) continue;
            if (psiRoot.getTextLength() != textLength) {
                LOG.error(DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)psiRoot, (Document)document));
                List<RegionInfo> list = List.of();
                if (list == null) {
                    FoldingUpdate.$$$reportNull$$$0(15);
                }
                return list;
            }
            PsiFile containingFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)psiFile);
            FoldingDescriptor[] descriptors = LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psiRoot, (Document)document, (boolean)quick);
            if (elementsToFold == null) {
                elementsToFold = new ArrayList<RegionInfo>(descriptors.length);
            }
            for (FoldingDescriptor descriptor : descriptors) {
                TextRange range;
                PsiElement psiElement = descriptor.getElement().getPsi();
                if (psiElement == null) {
                    LOG.error("No PSI for folding descriptor " + String.valueOf(descriptor));
                    continue;
                }
                if (!(foldingBuilder instanceof CompositeFoldingBuilder)) {
                    CompositeFoldingBuilder.assertSameFile((PsiFile)containingFile, (FoldingDescriptor)descriptor, (PsiElement)psiElement, (FoldingBuilder)foldingBuilder);
                }
                if ((range = descriptor.getRange()).getEndOffset() > textLength) {
                    FoldingUpdate.diagnoseIncorrectRange(psiRoot, document, language, foldingBuilder, descriptor, psiElement);
                    continue;
                }
                if (copyDoc != null && !FoldingUpdate.addNonConflictingRegion((DocumentEx)copyDoc, range, hardRefToRangeMarkers)) continue;
                RegionInfo regionInfo = new RegionInfo(descriptor, psiElement, foldingBuilder);
                elementsToFold.add(regionInfo);
            }
        }
        List list = ContainerUtil.notNullize(elementsToFold);
        if (list == null) {
            FoldingUpdate.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static boolean addNonConflictingRegion(@NotNull DocumentEx document, @NotNull TextRange range, @NotNull List<? super RangeMarker> hardRefToRangeMarkers) {
        int end;
        int start;
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(17);
        }
        if (range == null) {
            FoldingUpdate.$$$reportNull$$$0(18);
        }
        if (hardRefToRangeMarkers == null) {
            FoldingUpdate.$$$reportNull$$$0(19);
        }
        if (!document.processRangeMarkersOverlappingWith(start = range.getStartOffset(), end = range.getEndOffset(), rm -> !FoldingUpdate.areConflicting(range, rm.getTextRange()))) {
            return false;
        }
        RangeMarker marker = document.createRangeMarker(start, end);
        hardRefToRangeMarkers.add((RangeMarker)marker);
        return true;
    }

    private static boolean areConflicting(@NotNull TextRange range1, @NotNull TextRange range2) {
        if (range1 == null) {
            FoldingUpdate.$$$reportNull$$$0(20);
        }
        if (range2 == null) {
            FoldingUpdate.$$$reportNull$$$0(21);
        }
        return range1.equals((Object)range2) || !range1.contains(range2) && !range2.contains(range1) && range1.intersectsStrict(range2);
    }

    private static void diagnoseIncorrectRange(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull Language language, @NotNull FoldingBuilder foldingBuilder, @NotNull FoldingDescriptor descriptor, @NotNull PsiElement psiElement) {
        Attachment[] attachmentArray;
        if (psiFile == null) {
            FoldingUpdate.$$$reportNull$$$0(22);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(23);
        }
        if (language == null) {
            FoldingUpdate.$$$reportNull$$$0(24);
        }
        if (foldingBuilder == null) {
            FoldingUpdate.$$$reportNull$$$0(25);
        }
        if (descriptor == null) {
            FoldingUpdate.$$$reportNull$$$0(26);
        }
        if (psiElement == null) {
            FoldingUpdate.$$$reportNull$$$0(27);
        }
        String message = "Folding descriptor " + String.valueOf(descriptor) + " made by " + String.valueOf(foldingBuilder) + " for " + String.valueOf(language) + " is outside document range, PSI element: " + String.valueOf(psiElement) + ", PSI element range: " + String.valueOf(psiElement.getTextRange()) + "; " + DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)psiElement, (Document)document);
        if (ApplicationManager.getApplication().isInternal()) {
            Attachment[] attachmentArray2 = new Attachment[2];
            attachmentArray2[0] = CoreAttachmentFactory.createAttachment((Document)document);
            attachmentArray = attachmentArray2;
            attachmentArray2[1] = new Attachment("psiTree.txt", DebugUtil.psiToString((PsiElement)psiFile, (boolean)true, (boolean)true));
        } else {
            attachmentArray = Attachment.EMPTY_ARRAY;
        }
        LOG.error(message, attachmentArray);
    }

    static void clearFoldingCache(@NotNull Editor editor) {
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(28);
        }
        editor.putUserData(CODE_FOLDING_KEY, null);
        editor.putUserData(LAST_UPDATE_INJECTED_STAMP_KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 12: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 8: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/FoldingUpdate";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hardRefToRangeMarkers";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range1";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range2";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingBuilder";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateResult";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "applyDefaultStateMode";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingsFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateFoldRegions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateResult";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reportUnexpectedDocumentChange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateInjectedFoldRegions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "supportsDumbModeFolding";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingsFor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addNonConflictingRegion";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "areConflicting";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "diagnoseIncorrectRange";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "clearFoldingCache";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 14, 15, 16 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class RegionInfo
    extends Record {
        @NotNull
        private final FoldingDescriptor descriptor;
        @NotNull
        private final PsiElement psiElement;
        @Nullable
        private final String signature;
        private final boolean collapsedByDefault;
        private final boolean keepExpandedOnFirstCollapseAll;

        private RegionInfo(@NotNull FoldingDescriptor descriptor, @NotNull PsiElement psiElement, @NotNull FoldingBuilder foldingBuilder) {
            if (descriptor == null) {
                RegionInfo.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                RegionInfo.$$$reportNull$$$0(1);
            }
            if (foldingBuilder == null) {
                RegionInfo.$$$reportNull$$$0(2);
            }
            this(descriptor, psiElement, RegionInfo.createSignature(psiElement), RegionInfo.isCollapsedByDefault(descriptor, foldingBuilder), FoldingPolicy.keepExpandedOnFirstCollapseAll(descriptor, foldingBuilder));
        }

        public RegionInfo(@NotNull FoldingDescriptor descriptor, @NotNull PsiElement psiElement, @Nullable String signature, boolean collapsedByDefault, boolean keepExpandedOnFirstCollapseAll) {
            if (descriptor == null) {
                RegionInfo.$$$reportNull$$$0(3);
            }
            if (psiElement == null) {
                RegionInfo.$$$reportNull$$$0(4);
            }
            this.descriptor = descriptor;
            this.psiElement = psiElement;
            this.signature = signature;
            this.collapsedByDefault = collapsedByDefault;
            this.keepExpandedOnFirstCollapseAll = keepExpandedOnFirstCollapseAll;
        }

        private static boolean isCollapsedByDefault(@NotNull FoldingDescriptor descriptor, @NotNull FoldingBuilder foldingBuilder) {
            Boolean hardCoded;
            if (descriptor == null) {
                RegionInfo.$$$reportNull$$$0(5);
            }
            if (foldingBuilder == null) {
                RegionInfo.$$$reportNull$$$0(6);
            }
            return (hardCoded = descriptor.isCollapsedByDefault()) == null ? FoldingPolicy.isCollapsedByDefault(descriptor, foldingBuilder) : hardCoded;
        }

        private static String createSignature(@NotNull PsiElement element) {
            PsiFile containingFile;
            PsiElement restoredElement;
            String signature;
            if (element == null) {
                RegionInfo.$$$reportNull$$$0(7);
            }
            if ((signature = FoldingPolicy.getSignature(element)) != null && Registry.is((String)"folding.signature.validation") && !element.equals((Object)(restoredElement = FoldingPolicy.restoreBySignature(containingFile = element.getContainingFile(), signature)))) {
                StringBuilder trace = new StringBuilder();
                PsiElement restoredAgain = FoldingPolicy.restoreBySignature(containingFile, signature, trace);
                LOG.error("element: " + String.valueOf(element) + "(" + element.getText() + "); restoredElement: " + String.valueOf(restoredElement) + "; signature: '" + signature + "'; file: " + String.valueOf(containingFile) + "; injected: " + InjectedLanguageManager.getInstance((Project)element.getProject()).isInjectedFragment(containingFile) + "; languages: " + String.valueOf(containingFile.getViewProvider().getLanguages()) + "; restored again: " + String.valueOf(restoredAgain) + "; restore produces same results: " + (restoredAgain == restoredElement) + "; trace:\n" + String.valueOf(trace));
            }
            return signature;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegionInfo.class, "descriptor;psiElement;signature;collapsedByDefault;keepExpandedOnFirstCollapseAll", "descriptor", "psiElement", "signature", "collapsedByDefault", "keepExpandedOnFirstCollapseAll"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegionInfo.class, "descriptor;psiElement;signature;collapsedByDefault;keepExpandedOnFirstCollapseAll", "descriptor", "psiElement", "signature", "collapsedByDefault", "keepExpandedOnFirstCollapseAll"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegionInfo.class, "descriptor;psiElement;signature;collapsedByDefault;keepExpandedOnFirstCollapseAll", "descriptor", "psiElement", "signature", "collapsedByDefault", "keepExpandedOnFirstCollapseAll"}, this, o);
        }

        @NotNull
        public FoldingDescriptor descriptor() {
            FoldingDescriptor foldingDescriptor = this.descriptor;
            if (foldingDescriptor == null) {
                RegionInfo.$$$reportNull$$$0(8);
            }
            return foldingDescriptor;
        }

        @NotNull
        public PsiElement psiElement() {
            PsiElement psiElement = this.psiElement;
            if (psiElement == null) {
                RegionInfo.$$$reportNull$$$0(9);
            }
            return psiElement;
        }

        @Nullable
        public String signature() {
            return this.signature;
        }

        public boolean collapsedByDefault() {
            return this.collapsedByDefault;
        }

        public boolean keepExpandedOnFirstCollapseAll() {
            return this.keepExpandedOnFirstCollapseAll;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foldingBuilder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/folding/impl/FoldingUpdate$RegionInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingUpdate$RegionInfo";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "descriptor";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "psiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isCollapsedByDefault";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createSignature";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9 -> new IllegalStateException(string);
            };
        }
    }
}

