/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.FoldingKeys;
import com.intellij.openapi.editor.impl.zombie.CodeFoldingZombieUtils;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class UpdateFoldRegionsOperation
implements Runnable {
    private static final Logger LOG = Logger.getInstance(UpdateFoldRegionsOperation.class);
    static final Key<Boolean> CAN_BE_REMOVED_WHEN_COLLAPSED = Key.create((String)"canBeRemovedWhenCollapsed");
    static final Key<Boolean> COLLAPSED_BY_DEFAULT = Key.create((String)"collapsedByDefault");
    static final Key<Boolean> KEEP_EXPANDED_ON_FIRST_COLLAPSE_ALL = Key.create((String)"keepExpandedOnFirstCollapseAll");
    static final Key<String> SIGNATURE = Key.create((String)"signature");
    static final Key<Boolean> UPDATE_REGION = Key.create((String)"update");
    static final String NO_SIGNATURE = "no signature";
    private static final Comparator<PsiElement> COMPARE_BY_OFFSET_REVERSED = (element, element1) -> {
        int startOffsetDiff = element1.getTextRange().getStartOffset() - element.getTextRange().getStartOffset();
        return startOffsetDiff == 0 ? element1.getTextRange().getEndOffset() - element.getTextRange().getEndOffset() : startOffsetDiff;
    };
    private final Project myProject;
    private final Editor myEditor;
    private final PsiFile myFile;
    @NotNull
    private final ApplyDefaultStateMode myApplyDefaultState;
    private final MultiMap<PsiElement, FoldingUpdate.RegionInfo> myElementsToFoldMap;
    private final Set<FoldingUpdate.RegionInfo> myRegionInfos;
    private final MultiMap<FoldingGroup, FoldingUpdate.RegionInfo> myGroupedRegionInfos;
    private final boolean myKeepCollapsedRegions;
    private final boolean myForInjected;

    UpdateFoldRegionsOperation(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull List<? extends FoldingUpdate.RegionInfo> elementsToFold, @NotNull ApplyDefaultStateMode applyDefaultState, boolean keepCollapsedRegions, boolean forInjected) {
        if (project == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(1);
        }
        if (file == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(2);
        }
        if (elementsToFold == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(3);
        }
        if (applyDefaultState == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(4);
        }
        this.myElementsToFoldMap = new MultiMap<PsiElement, FoldingUpdate.RegionInfo>(new TreeMap(COMPARE_BY_OFFSET_REVERSED)){

            @NotNull
            protected Collection<FoldingUpdate.RegionInfo> createCollection() {
                return new ArrayList<FoldingUpdate.RegionInfo>();
            }
        };
        this.myRegionInfos = new LinkedHashSet<FoldingUpdate.RegionInfo>();
        this.myGroupedRegionInfos = new MultiMap();
        this.myProject = project;
        this.myEditor = editor;
        this.myFile = file;
        this.myApplyDefaultState = applyDefaultState;
        this.myKeepCollapsedRegions = keepCollapsedRegions;
        this.myForInjected = forInjected;
        for (FoldingUpdate.RegionInfo regionInfo : elementsToFold) {
            this.myElementsToFoldMap.putValue((Object)regionInfo.psiElement(), (Object)regionInfo);
            this.myRegionInfos.add(regionInfo);
            FoldingGroup group = regionInfo.descriptor().getGroup();
            if (group == null) continue;
            this.myGroupedRegionInfos.putValue((Object)group, (Object)regionInfo);
        }
    }

    @Override
    public void run() {
        EditorFoldingInfo info = EditorFoldingInfo.get(this.myEditor);
        FoldingModelEx foldingModel = (FoldingModelEx)this.myEditor.getFoldingModel();
        Map<TextRange, Boolean> rangeToExpandStatusMap = this.removeInvalidRegions(foldingModel, info);
        HashSet shouldExpand = new HashSet();
        HashSet groupExpand = new HashSet();
        List<FoldRegion> newRegions = this.addNewRegions(foldingModel, info, rangeToExpandStatusMap, shouldExpand, groupExpand);
        if (CodeFoldingManagerImpl.isAsyncFoldingUpdater(this.myEditor)) {
            Map<TextRange, Boolean> postponedExpansionMap = CodeFoldingManagerImpl.getAsyncExpandStatusMap(this.myEditor);
            if (postponedExpansionMap != null) {
                postponedExpansionMap.putAll(rangeToExpandStatusMap);
            } else {
                CodeFoldingManagerImpl.setAsyncExpandStatusMap(this.myEditor, rangeToExpandStatusMap);
            }
        }
        UpdateFoldRegionsOperation.applyExpandStatus(newRegions, shouldExpand, groupExpand);
        foldingModel.clearDocumentRangesModificationStatus();
        CodeFoldingZombieUtils.INSTANCE.postponeAndScheduleCleanupZombieRegions(this.myEditor);
    }

    private static void applyExpandStatus(@NotNull List<? extends FoldRegion> newRegions, @NotNull Set<? extends FoldRegion> shouldExpand, @NotNull Set<? extends FoldingGroup> groupExpand) {
        if (newRegions == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(5);
        }
        if (shouldExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(6);
        }
        if (groupExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(7);
        }
        for (FoldRegion foldRegion : newRegions) {
            FoldingGroup group = foldRegion.getGroup();
            boolean expanded = group == null ? shouldExpand.contains(foldRegion) : groupExpand.contains(group);
            foldRegion.setExpanded(expanded);
        }
    }

    @RequiresEdt
    @NotNull
    private List<FoldRegion> addNewRegions(@NotNull FoldingModelEx foldingModel, @NotNull EditorFoldingInfo editorFoldingInfo, @NotNull @Unmodifiable Map<TextRange, Boolean> rangeToExpandStatusMap, @NotNull Set<? super FoldRegion> shouldExpand, @NotNull Set<? super FoldingGroup> groupExpand) {
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(8);
        }
        if (editorFoldingInfo == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(9);
        }
        if (rangeToExpandStatusMap == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(10);
        }
        if (shouldExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(11);
        }
        if (groupExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(12);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ArrayList<FoldRegion> newRegions = new ArrayList<FoldRegion>(this.myRegionInfos.size());
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        TextRange rangeToUnfoldOnNavigation = OpenFileDescriptor.getRangeToUnfoldOnNavigation((Editor)this.myEditor);
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        for (FoldingUpdate.RegionInfo regionInfo : this.myRegionInfos) {
            PsiElement psi;
            ProgressManager.checkCanceled();
            FoldingDescriptor descriptor = regionInfo.descriptor();
            FoldingGroup group = descriptor.getGroup();
            TextRange range = descriptor.getRange();
            String placeholder = null;
            try {
                placeholder = descriptor.getPlaceholderText();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (range.getEndOffset() > this.myEditor.getDocument().getTextLength()) {
                LOG.error(String.format("Invalid folding descriptor detected (%s). It ends beyond the document range (%d)", descriptor, this.myEditor.getDocument().getTextLength()));
                continue;
            }
            FoldRegion region = UpdateFoldRegionsOperation.createOrMergeWithZombie(foldingModel, range, placeholder == null ? "..." : placeholder, group, descriptor.isNonExpandable());
            if (region == null) continue;
            AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-326651, EA-831712");
            try {
                psi = descriptor.getElement().getPsi();
                if (psi == null || !psi.isValid() || !this.myFile.isValid()) {
                    region.dispose();
                    continue;
                }
            }
            finally {
                if (ignore == null) continue;
                ignore.close();
                continue;
            }
            region.setGutterMarkEnabledForSingleLine(descriptor.isGutterMarkEnabledForSingleLine());
            if (descriptor.canBeRemovedWhenCollapsed()) {
                region.putUserData(CAN_BE_REMOVED_WHEN_COLLAPSED, (Object)Boolean.TRUE);
            }
            CodeFoldingManagerImpl.markAsFrontendCreated(region);
            CodeFoldingManagerImpl.setCollapsedByDefault(region, regionInfo.collapsedByDefault());
            region.putUserData(KEEP_EXPANDED_ON_FIRST_COLLAPSE_ALL, (Object)regionInfo.keepExpandedOnFirstCollapseAll());
            region.putUserData(SIGNATURE, (Object)((String)ObjectUtils.chooseNotNull((Object)regionInfo.signature(), (Object)NO_SIGNATURE)));
            editorFoldingInfo.addRegion(region, smartPointerManager.createSmartPsiElementPointer(psi));
            newRegions.add(region);
            if (descriptor.isNonExpandable()) {
                region.putUserData(FoldingKeys.SELECT_REGION_ON_CARET_NEARBY, (Object)Boolean.TRUE);
                continue;
            }
            boolean expandStatus = this.shouldExpandNewRegion(range, rangeToExpandStatusMap, regionInfo.collapsedByDefault(), rangeToUnfoldOnNavigation, caretOffset);
            if (!expandStatus) continue;
            if (group == null) {
                shouldExpand.add((FoldRegion)region);
                continue;
            }
            groupExpand.add((FoldingGroup)group);
        }
        ArrayList<FoldRegion> arrayList = newRegions;
        if (arrayList == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @RequiresEdt
    @Nullable
    private static FoldRegion createOrMergeWithZombie(@NotNull FoldingModelEx foldingModel, @NotNull TextRange range, @NotNull String placeholder, @Nullable FoldingGroup group, boolean shouldNeverExpand) {
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(14);
        }
        if (range == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(15);
        }
        if (placeholder == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.assertEventDispatchThread();
        FoldRegion region = null;
        FoldRegion zombieFoldRegion = foldingModel.getFoldRegion(range.getStartOffset(), range.getEndOffset());
        if (zombieFoldRegion != null && FoldingKeys.ZOMBIE_REGION_KEY.isIn((UserDataHolder)zombieFoldRegion)) {
            if (placeholder.equals(zombieFoldRegion.getPlaceholderText()) && group == zombieFoldRegion.getGroup() && shouldNeverExpand == zombieFoldRegion.shouldNeverExpand()) {
                region = zombieFoldRegion;
                FoldingKeys.ZOMBIE_REGION_KEY.set((UserDataHolder)region, null);
            } else {
                foldingModel.removeFoldRegion(zombieFoldRegion);
            }
        }
        if (region == null) {
            region = foldingModel.createFoldRegion(range.getStartOffset(), range.getEndOffset(), placeholder, group, shouldNeverExpand);
        }
        return region;
    }

    static boolean caretInsideRange(int caretOffset, @NotNull TextRange range) {
        if (range == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(17);
        }
        return range.contains(caretOffset) && range.getStartOffset() != caretOffset;
    }

    private boolean shouldExpandNewRegion(@NotNull TextRange range, @NotNull @Unmodifiable Map<TextRange, Boolean> rangeToExpandStatusMap, boolean collapsedByDefault, @NotNull TextRange rangeToUnfoldOnNavigation, int caretOffset) {
        if (range == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(18);
        }
        if (rangeToExpandStatusMap == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(19);
        }
        if (rangeToUnfoldOnNavigation == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(20);
        }
        if (this.myApplyDefaultState != ApplyDefaultStateMode.NO) {
            if (this.myApplyDefaultState == ApplyDefaultStateMode.EXCEPT_CARET_REGION && rangeToUnfoldOnNavigation.intersects(range)) {
                return true;
            }
            return !collapsedByDefault;
        }
        Boolean oldStatus = rangeToExpandStatusMap.get(range);
        return oldStatus == null || oldStatus != false || UpdateFoldRegionsOperation.caretInsideRange(caretOffset, range);
    }

    @NotNull
    private Map<TextRange, Boolean> removeInvalidRegions(@NotNull FoldingModelEx foldingModel, @NotNull EditorFoldingInfo info) {
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(21);
        }
        if (info == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(22);
        }
        FoldRegion[] allFoldRegions = foldingModel.getAllFoldRegions();
        HashMap<TextRange, Boolean> rangeToExpandStatusMap = HashMap.newHashMap(allFoldRegions.length);
        ArrayList toRemove = new ArrayList();
        Ref infoRef = Ref.create();
        HashSet<FoldingGroup> processedGroups = new HashSet<FoldingGroup>();
        ArrayList<FoldingUpdate.RegionInfo> matchedInfos = new ArrayList<FoldingUpdate.RegionInfo>();
        for (FoldRegion region : allFoldRegions) {
            FoldingGroup group = region.getGroup();
            if (group != null && !processedGroups.add(group)) continue;
            List regionsToProcess = group == null ? Collections.singletonList(region) : foldingModel.getGroupedRegions(group);
            matchedInfos.clear();
            boolean shouldRemove = false;
            boolean isLight = true;
            for (Object regionToProcess : regionsToProcess) {
                if (!regionToProcess.isValid() || this.shouldRemoveRegion(foldingModel, (FoldRegion)regionToProcess, info, rangeToExpandStatusMap, (Ref<? super FoldingUpdate.RegionInfo>)infoRef)) {
                    shouldRemove = true;
                }
                isLight &= regionToProcess.getUserData(SIGNATURE) == null;
                FoldingUpdate.RegionInfo regionInfo = (FoldingUpdate.RegionInfo)infoRef.get();
                matchedInfos.add(regionInfo);
            }
            if (!shouldRemove && group != null && !isLight) {
                Object regionToProcess;
                FoldingGroup requestedGroup = null;
                regionToProcess = matchedInfos.iterator();
                while (regionToProcess.hasNext()) {
                    FoldingUpdate.RegionInfo matchedInfo = (FoldingUpdate.RegionInfo)regionToProcess.next();
                    if (matchedInfo == null) {
                        shouldRemove = true;
                        break;
                    }
                    FoldingGroup g = matchedInfo.descriptor().getGroup();
                    if (g == null) {
                        shouldRemove = true;
                        break;
                    }
                    if (requestedGroup == null) {
                        requestedGroup = g;
                        continue;
                    }
                    if (requestedGroup.equals((Object)g)) continue;
                    shouldRemove = true;
                    break;
                }
                if (this.myGroupedRegionInfos.get(requestedGroup).size() != matchedInfos.size()) {
                    shouldRemove = true;
                }
            }
            if (shouldRemove) {
                for (FoldRegion r : regionsToProcess) {
                    rangeToExpandStatusMap.putIfAbsent(r.getTextRange(), r.isExpanded());
                }
                toRemove.addAll(regionsToProcess);
                continue;
            }
            for (FoldingUpdate.RegionInfo matchedInfo : matchedInfos) {
                if (matchedInfo == null) continue;
                this.myElementsToFoldMap.remove((Object)matchedInfo.psiElement(), (Object)matchedInfo);
                this.myRegionInfos.remove(matchedInfo);
            }
        }
        for (FoldRegion region : toRemove) {
            foldingModel.removeFoldRegion(region);
            info.removeRegion(region);
        }
        HashMap<TextRange, Boolean> hashMap = rangeToExpandStatusMap;
        if (hashMap == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(23);
        }
        return hashMap;
    }

    private boolean shouldRemoveRegion(@NotNull FoldingModelEx foldingModel, @NotNull FoldRegion region, @NotNull EditorFoldingInfo info, @NotNull Map<? super TextRange, ? super Boolean> rangeToExpandStatusMap, @NotNull Ref<? super FoldingUpdate.RegionInfo> matchingInfo) {
        Collection regionInfos;
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(24);
        }
        if (region == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(25);
        }
        if (info == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(26);
        }
        if (rangeToExpandStatusMap == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(27);
        }
        if (matchingInfo == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(28);
        }
        matchingInfo.set(null);
        if (UPDATE_REGION.get((UserDataHolder)region) == Boolean.TRUE) {
            rangeToExpandStatusMap.put((TextRange)region.getTextRange(), (Boolean)region.isExpanded());
            return true;
        }
        PsiElement element = info.getPsiElement(region);
        if (element != null) {
            PsiFile containingFile = element.getContainingFile();
            boolean isInjected = InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(containingFile);
            if (isInjected != this.myForInjected) {
                return false;
            }
        }
        boolean forceKeepRegion = this.myKeepCollapsedRegions && !region.isExpanded() && !this.regionOrGroupCanBeRemovedWhenCollapsed(foldingModel, region);
        Boolean storedCollapsedByDefault = CodeFoldingManagerImpl.getCollapsedByDefault(region);
        if (element != null && !(regionInfos = this.myElementsToFoldMap.get((Object)element)).isEmpty()) {
            FoldingUpdate.RegionInfo[] array = regionInfos.toArray(new FoldingUpdate.RegionInfo[0]);
            for (FoldingUpdate.RegionInfo regionInfo : array) {
                FoldingDescriptor descriptor = regionInfo.descriptor();
                TextRange range = descriptor.getRange();
                if (!TextRange.areSegmentsEqual((Segment)region, (Segment)range)) continue;
                if (storedCollapsedByDefault != null && storedCollapsedByDefault.booleanValue() != regionInfo.collapsedByDefault()) {
                    rangeToExpandStatusMap.put((TextRange)range, (Boolean)(!regionInfo.collapsedByDefault() ? 1 : 0));
                    return true;
                }
                if (!region.getPlaceholderText().equals(descriptor.getPlaceholderText()) || range.getLength() < 2) {
                    return true;
                }
                matchingInfo.set((Object)regionInfo);
                return false;
            }
            if (!forceKeepRegion) {
                for (FoldingUpdate.RegionInfo regionInfo : regionInfos) {
                    rangeToExpandStatusMap.put((TextRange)regionInfo.descriptor().getRange(), (Boolean)region.isExpanded());
                }
                return true;
            }
            return false;
        }
        if (CodeFoldingManagerImpl.isAutoCreated(region)) {
            return !forceKeepRegion && Boolean.TRUE.equals(region.getUserData(CAN_BE_REMOVED_WHEN_COLLAPSED));
        }
        return !forceKeepRegion && region.getUserData(SIGNATURE) != null;
    }

    private boolean regionOrGroupCanBeRemovedWhenCollapsed(@NotNull FoldingModelEx foldingModel, @NotNull FoldRegion region) {
        FoldingGroup group;
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(29);
        }
        if (region == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(30);
        }
        List affectedRegions = (group = region.getGroup()) != null ? foldingModel.getGroupedRegions(group) : Collections.singletonList(region);
        for (FoldRegion affectedRegion : affectedRegions) {
            if (!this.regionCanBeRemovedWhenCollapsed(foldingModel, affectedRegion)) continue;
            return true;
        }
        return false;
    }

    private boolean regionCanBeRemovedWhenCollapsed(@NotNull FoldingModelEx foldingModel, @NotNull FoldRegion region) {
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(31);
        }
        if (region == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(32);
        }
        return Boolean.TRUE.equals(region.getUserData(CAN_BE_REMOVED_WHEN_COLLAPSED)) || foldingModel.hasDocumentRegionChangedFor(region) || !region.isValid() || this.isRegionInCaretLine(region);
    }

    private boolean isRegionInCaretLine(@NotNull FoldRegion region) {
        if (region == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(33);
        }
        int regionStartLine = this.myEditor.getDocument().getLineNumber(region.getStartOffset());
        int regionEndLine = this.myEditor.getDocument().getLineNumber(region.getEndOffset());
        int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
        return caretLine >= regionStartLine && caretLine <= regionEndLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToFold";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyDefaultState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRegions";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldExpand";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupExpand";
                break;
            }
            case 8: 
            case 14: 
            case 21: 
            case 24: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorFoldingInfo";
                break;
            }
            case 10: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToExpandStatusMap";
                break;
            }
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToUnfoldOnNavigation";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 25: 
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addNewRegions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "removeInvalidRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyExpandStatus";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addNewRegions";
                break;
            }
            case 13: 
            case 23: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createOrMergeWithZombie";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "caretInsideRange";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldExpandNewRegion";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeInvalidRegions";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shouldRemoveRegion";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "regionOrGroupCanBeRemovedWhenCollapsed";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "regionCanBeRemovedWhenCollapsed";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isRegionInCaretLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 23 -> new IllegalStateException(string);
        };
    }

    static enum ApplyDefaultStateMode {
        YES,
        EXCEPT_CARET_REGION,
        NO;

    }
}

