/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.bootstrap;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.CliResult;
import com.intellij.idea.LoggerFactory;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.DelegatingLogger;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.IdeaLogRecordFormatter;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.User32Ex;
import com.intellij.util.Suppressions;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.system.OS;
import com.sun.jna.platform.win32.WinDef;
import com.sun.tools.attach.VirtualMachine;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.LogRecord;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class DirectoryLock {
    private static final CollectingLogger LOG = new CollectingLogger(DirectoryLock.class);
    private static final int UDS_PATH_LENGTH_LIMIT = 100;
    private static final int BUFFER_LENGTH = 16384;
    private static final int MARKER = 16435934;
    private static final int HEADER_LENGTH = 6;
    private static final String SERVER_THREAD_NAME = "External Command Listener";
    private static final AtomicInteger COUNT = new AtomicInteger();
    private static final long TIMEOUT_MS = Integer.getInteger("ij.dir.lock.timeout", 5000).intValue();
    private static final List<String> ACK_PACKET = List.of("<<ACK>>");
    private final long myPid;
    private final Path myPortFile;
    private final Path myLockFile;
    private final boolean myFallbackMode;
    @Nullable
    private final Path myRedirectedPortFile;
    private final Function<List<String>, CliResult> myProcessor;
    @Nullable
    private volatile ServerSocketChannel myServerChannel;

    public DirectoryLock(@NotNull Path configPath, @NotNull Path systemPath, @NotNull Function<List<String>, CliResult> processor) {
        if (configPath == null) {
            DirectoryLock.$$$reportNull$$$0(0);
        }
        if (systemPath == null) {
            DirectoryLock.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            DirectoryLock.$$$reportNull$$$0(2);
        }
        this.myPid = ProcessHandle.current().pid();
        this.myServerChannel = null;
        this.myPortFile = systemPath.resolve(".port");
        this.myLockFile = configPath.resolve(".lock");
        this.myFallbackMode = !DirectoryLock.areUdsSupported(this.myPortFile);
        LOG.debug("portFile=" + String.valueOf(this.myPortFile) + " lockFile=" + String.valueOf(this.myLockFile) + " fallback=" + this.myFallbackMode + " PID=" + this.myPid);
        if (!this.myFallbackMode && this.myPortFile.toString().length() > 100) {
            Path baseDir = OS.CURRENT == OS.Windows ? Path.of(System.getenv("SystemRoot"), "Temp") : Path.of("/tmp", new String[0]);
            this.myRedirectedPortFile = baseDir.resolve(".ij_redirected_port_" + this.myPid + "_" + COUNT.incrementAndGet());
            LOG.debug("redirectedPortFile=" + String.valueOf(this.myRedirectedPortFile));
        } else {
            this.myRedirectedPortFile = null;
        }
        this.myProcessor = processor;
    }

    private static boolean areUdsSupported(Path file) {
        FileSystem fs = file.getFileSystem();
        if (fs.getClass().getModule() != Object.class.getModule()) {
            if (!System.getProperty("java.vm.vendor", "").contains("JetBrains")) {
                return false;
            }
            try {
                fs.provider().getClass().getMethod("getSunPathForSocketFile", Path.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                return false;
            }
        }
        if (OS.CURRENT == OS.Windows) {
            try {
                SocketChannel.open(StandardProtocolFamily.UNIX).close();
            }
            catch (UnsupportedOperationException e) {
                return false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public CliResult lockOrActivate(@NotNull Path currentDirectory, @NotNull List<String> args) throws CannotActivateException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void cannotActivate(String command, long pid, List<Exception> suppressed) throws CannotActivateException {
        String threadDump = DirectoryLock.remoteThreadDump(pid);
        CannotActivateException cae = new CannotActivateException(BootstrapBundle.message((String)"bootstrap.error.still.running", (Object[])new Object[]{command, pid}), threadDump);
        suppressed.forEach(cae::addSuppressed);
        throw cae;
    }

    @VisibleForTesting
    public void dispose() {
        this.dispose(true);
    }

    private void dispose(boolean deleteLockFile) {
        ServerSocketChannel serverChannel = this.myServerChannel;
        this.myServerChannel = null;
        if (serverChannel != null) {
            LOG.debug("cleaning up");
            ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[4];
            throwableRunnableArray[0] = serverChannel::close;
            throwableRunnableArray[1] = () -> {
                if (this.myRedirectedPortFile != null) {
                    Files.deleteIfExists(this.myRedirectedPortFile);
                }
            };
            throwableRunnableArray[2] = () -> Files.deleteIfExists(this.myPortFile);
            throwableRunnableArray[3] = () -> {
                if (deleteLockFile) {
                    Files.deleteIfExists(this.myLockFile);
                }
            };
            Suppressions.runSuppressing((ThrowableRunnable[])throwableRunnableArray);
        }
    }

    @Nullable
    private CliResult tryListen() throws IOException {
        SocketAddress address;
        ServerSocketChannel serverChannel = ServerSocketChannel.open(this.myFallbackMode ? StandardProtocolFamily.INET : StandardProtocolFamily.UNIX);
        if (this.myFallbackMode) {
            Files.writeString(this.myPortFile, (CharSequence)"0", StandardOpenOption.CREATE_NEW);
            address = new InetSocketAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), 0);
        } else if (this.myRedirectedPortFile != null) {
            Files.writeString(this.myPortFile, (CharSequence)this.myRedirectedPortFile.toString(), StandardOpenOption.CREATE_NEW);
            address = UnixDomainSocketAddress.of(this.myRedirectedPortFile);
        } else {
            address = UnixDomainSocketAddress.of(this.myPortFile);
        }
        LOG.debug("binding to " + String.valueOf(address));
        serverChannel.bind(address);
        this.myServerChannel = serverChannel;
        try {
            if (this.myFallbackMode) {
                int port = ((InetSocketAddress)serverChannel.getLocalAddress()).getPort();
                Files.writeString(this.myPortFile, (CharSequence)String.valueOf(port), StandardOpenOption.TRUNCATE_EXISTING);
            }
            Files.writeString(this.myLockFile, (CharSequence)Long.toString(this.myPid), StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            LOG.debug(e);
            this.dispose(false);
            throw new IOException("Cannot lock config directory " + String.valueOf(this.myLockFile.getParent()), e);
        }
        new Thread(this::acceptConnections, SERVER_THREAD_NAME).start();
        return null;
    }

    /*
     * Exception decompiling
     */
    private CliResult tryConnect(List<String> args, Path currentDirectory) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void allowActivation() {
        if (OS.CURRENT == OS.Windows && JnaLoader.isLoaded()) {
            try {
                User32Ex.INSTANCE.AllowSetForegroundWindow(new WinDef.DWORD(this.remotePID()));
            }
            catch (Throwable t) {
                LOG.debug(t);
            }
        }
    }

    private void acceptConnections() {
        ServerSocketChannel channel = null;
        while ((channel = this.myServerChannel) != null) {
            try {
                LOG.debug("accepting connections at " + String.valueOf(channel.getLocalAddress()));
                SocketChannel socketChannel = channel.accept();
                LOG.debug("accepted connection " + String.valueOf(socketChannel));
                ProcessIOExecutorService.INSTANCE.execute(() -> this.handleConnection(socketChannel));
            }
            catch (ClosedChannelException e) {
                LOG.debug(e);
                break;
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }

    private void handleConnection(SocketChannel socketChannel) {
        try (SocketChannel socketChannel2 = socketChannel;){
            CliResult result;
            List<String> request = DirectoryLock.receiveLines(socketChannel);
            DirectoryLock.sendLines(socketChannel, ACK_PACKET);
            try {
                result = this.myProcessor.apply(request);
            }
            catch (Throwable t) {
                LOG.error(t);
                String error = Objects.requireNonNullElse(t.getMessage(), "Unknown error");
                String message = BootstrapBundle.message((String)"bootstrap.error.request.failed", (Object[])new Object[]{this.myPid, t.getClass(), error, LoggerFactory.getLogFilePath()});
                result = new CliResult(15, message);
            }
            DirectoryLock.sendLines(socketChannel, List.of(String.valueOf(result.exitCode()), Objects.requireNonNullElse(result.message(), "")));
        }
        catch (IOException e) {
            LOG.warn(e);
        }
    }

    @VisibleForTesting
    @Nullable
    public Path getRedirectedPortFile() {
        return this.myRedirectedPortFile;
    }

    private long remotePID() throws IOException {
        return Long.parseLong(Files.readString(this.myLockFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String remoteThreadDump(long pid) {
        String string;
        VirtualMachine vm = VirtualMachine.attach(String.valueOf(pid));
        try {
            Object[] args = new Object[]{new Object[]{""}};
            InputStream is = (InputStream)vm.getClass().getMethod("remoteDataDump", Object[].class).invoke((Object)vm, args);
            StringBuilder out = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line = "";
                while ((line = reader.readLine()) != null) {
                    out.append(line).append("\n");
                }
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            try {
                vm.detach();
                throw throwable;
            }
            catch (Exception e) {
                return "Cannot collect thread dump: " + e.getClass().getName() + ": " + e.getMessage();
            }
        }
        vm.detach();
        return string;
    }

    private static void sendLines(SocketChannel socketChannel, List<String> lines) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16384);
        buffer.putInt(16435934).putShort((short)0);
        for (String line : lines) {
            byte[] bytes = line.getBytes(StandardCharsets.UTF_8);
            buffer.putShort((short)bytes.length);
            buffer.put(bytes);
        }
        buffer.putShort(4, (short)buffer.position());
        LOG.debug("sending: " + String.valueOf(lines) + ", bytes:" + buffer.position());
        buffer.flip();
        while (buffer.hasRemaining()) {
            socketChannel.write(buffer);
        }
    }

    private static List<String> receiveLines(SocketChannel socketChannel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16384);
        buffer.limit(6);
        while (buffer.position() < 6) {
            if (socketChannel.read(buffer) >= 0) continue;
            throw new EOFException("Expected 6 bytes, got " + buffer.position());
        }
        int marker = buffer.getInt(0);
        if (marker != 16435934) {
            throw new StreamCorruptedException("Invalid marker: 0x" + Integer.toHexString(marker));
        }
        short length = buffer.getShort(4);
        LOG.debug("receiving: " + length + " bytes");
        buffer.limit(length);
        while (buffer.position() < length) {
            if (socketChannel.read(buffer) >= 0) continue;
            throw new EOFException("Expected " + length + " bytes, got " + buffer.position());
        }
        buffer.position(6);
        ArrayList<String> lines = new ArrayList<String>();
        while (buffer.hasRemaining()) {
            short lineLength = buffer.getShort();
            if (lineLength > 0) {
                byte[] bytes = new byte[lineLength];
                buffer.get(bytes);
                lines.add(new String(bytes, StandardCharsets.UTF_8));
                continue;
            }
            lines.add("");
        }
        return lines;
    }

    private static /* synthetic */ String lambda$lockOrActivate$1(ProcessHandle ph) {
        return "  PID=" + ph.pid() + " (" + String.valueOf(ph.info().user()) + ") " + String.valueOf(ph.info().command());
    }

    private /* synthetic */ boolean lambda$lockOrActivate$0(String command, String user, ProcessHandle ph) {
        return command.equals(ph.info().command().orElse("")) && user.equals(ph.info().user().orElse("")) && ph.pid() != this.myPid;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/ide/bootstrap/DirectoryLock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lockOrActivate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CollectingLogger
    extends DelegatingLogger<Logger> {
        private volatile List<String> messages = new ArrayList<String>();
        private final IdeaLogRecordFormatter formatter = new IdeaLogRecordFormatter(true);
        private final String loggerName;

        private CollectingLogger(Class<?> klass) {
            super(CollectingLogger.getInstance(klass));
            if (Boolean.getBoolean("ij.dir.lock.debug")) {
                this.setLevel(LogLevel.DEBUG);
            }
            this.loggerName = "#" + klass.getName();
        }

        private String messages() {
            List<String> messages = this.messages;
            return messages != null ? String.join((CharSequence)"\n", messages) : "-";
        }

        private void reset() {
            List<String> messages = this.messages;
            if (messages != null) {
                messages.clear();
            }
            this.messages = null;
        }

        public void debug(String message, @Nullable Throwable t) {
            super.debug(message, t);
            this.log(LogLevel.DEBUG, message, t);
        }

        public void info(String message, @Nullable Throwable t) {
            super.info(message, t);
            this.log(LogLevel.INFO, message, t);
        }

        public void warn(String message, @Nullable Throwable t) {
            super.warn(message, t);
            this.log(LogLevel.WARNING, message, t);
        }

        public void error(String message, @Nullable Throwable t, String ... details) {
            if (details == null) {
                CollectingLogger.$$$reportNull$$$0(0);
            }
            super.error(message, t, details);
            this.log(LogLevel.ERROR, message, t);
        }

        private void log(LogLevel level, String message, @Nullable Throwable t) {
            List<String> messages = this.messages;
            if (messages != null) {
                LogRecord record = new LogRecord(level.getLevel(), message);
                record.setThrown(t);
                record.setLoggerName(this.loggerName);
                messages.add(this.formatter.format(record));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/platform/ide/bootstrap/DirectoryLock$CollectingLogger", "error"));
        }
    }

    @ApiStatus.Internal
    public static final class CannotActivateException
    extends Exception
    implements ExceptionWithAttachments {
        @Nls
        private final String myMessage;
        private final Attachment[] myAttachments;

        private CannotActivateException(@Nls String message, String threadDump) {
            this.myMessage = message;
            this.myAttachments = new Attachment[]{new Attachment("debug.txt", LOG.messages()), new Attachment("threadDump.txt", threadDump)};
        }

        @Override
        @Nls
        public String getMessage() {
            return this.myMessage;
        }

        @NotNull
        public @NotNull Attachment @NotNull [] getAttachments() {
            if (this.myAttachments == null) {
                CannotActivateException.$$$reportNull$$$0(0);
            }
            return this.myAttachments;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/ide/bootstrap/DirectoryLock$CannotActivateException", "getAttachments"));
        }
    }
}

