/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.bootstrap;

import com.intellij.jna.JnaLoader;
import com.intellij.util.system.OS;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.platform.win32.Kernel32;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.SwingUtilities;

final class UiThreadPriority {
    UiThreadPriority() {
    }

    static void adjust() {
        OS os = OS.CURRENT;
        SwingUtilities.invokeLater(() -> {
            try {
                switch (os) {
                    case Windows: {
                        UiThreadPriority.setWindowsThreadPriority();
                        break;
                    }
                    case macOS: {
                        UiThreadPriority.setUserInteractiveQosClassForCurrentThread();
                    }
                }
            }
            catch (Throwable t) {
                StringWriter buf = new StringWriter();
                t.printStackTrace(new PrintWriter(buf));
                UiThreadPriority.logError(buf.toString());
            }
        });
    }

    private static void setWindowsThreadPriority() {
        boolean debug = Boolean.getBoolean("ide.set.qos.for.edt.debug");
        Thread currentThread = Thread.currentThread();
        int jvmPriorityBefore = currentThread.getPriority();
        int nativePriorityBefore = debug && JnaLoader.isLoaded() ? Kernel32.INSTANCE.GetThreadPriority(Kernel32.INSTANCE.GetCurrentThread()) : -1;
        currentThread.setPriority(10);
        if (debug) {
            int nativeThreadId = JnaLoader.isLoaded() ? Kernel32.INSTANCE.GetCurrentThreadId() : -1;
            int nativePriorityAfter = JnaLoader.isLoaded() ? Kernel32.INSTANCE.GetThreadPriority(Kernel32.INSTANCE.GetCurrentThread()) : -1;
            int jvmPriorityAfter = currentThread.getPriority();
            UiThreadPriority.logDebug("EDT JVM ID = " + currentThread.getId() + ", Native ID = " + nativeThreadId + ", Name = " + currentThread.getName() + "\n  Before: JVM Priority = " + jvmPriorityBefore + ", Native Priority = " + nativePriorityBefore + "\n  After: JVM Priority = " + jvmPriorityAfter + ", Native Priority = " + nativePriorityAfter);
        }
    }

    private static void setUserInteractiveQosClassForCurrentThread() {
        if (!JnaLoader.isLoaded()) {
            return;
        }
        NativeLibrary libc = NativeLibrary.getInstance(null);
        Native.register(DarwinPThread.class, (NativeLibrary)libc);
        int ret = DarwinPThread.pthread_set_qos_class_self_np(33, 0);
        if (ret != 0) {
            Thread currentThread = Thread.currentThread();
            UiThreadPriority.logError("Unable to set QoS class for thread #" + currentThread.getId() + " (" + currentThread.getName() + "): " + ret);
        }
    }

    private static void logDebug(String message) {
        System.out.println(UiThreadPriority.class.getSimpleName() + ": " + message);
    }

    private static void logError(String message) {
        System.err.println(UiThreadPriority.class.getSimpleName() + ": " + message);
    }

    private static final class DarwinPThread {
        static final int QOS_CLASS_USER_INTERACTIVE = 33;

        private DarwinPThread() {
        }

        static native int pthread_set_qos_class_self_np(int var0, int var1);
    }
}

