/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.bootstrap;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.application.InitialConfigImportState;
import com.intellij.platform.ide.bootstrap.IdeStartupExperiment;
import com.intellij.platform.ide.bootstrap.IdeStartupWizardKt;
import com.intellij.platform.ide.bootstrap.StartupWizardStage;
import java.time.Duration;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\nJ\r\u0010\u0012\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0013J\u0016\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/ide/bootstrap/IdeStartupWizardCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGroup", "initialStartSucceeded", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "logInitialStartSuccess", "", "initialStartTimeoutTriggered", "logInitialStartTimeout", "experimentState", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "Lcom/intellij/platform/ide/bootstrap/IdeStartupExperiment$GroupKind;", "", "", "logWizardExperimentState", "logWizardExperimentState$intellij_platform_ide_bootstrap", "wizardStageEnded", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "Lcom/intellij/platform/ide/bootstrap/StartupWizardStage;", "", "logStartupStageTime", "stage", "duration", "Ljava/time/Duration;", "intellij.platform.ide.bootstrap"})
@SourceDebugExtension(value={"SMAP\nIdeStartupWizard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeStartupWizard.kt\ncom/intellij/platform/ide/bootstrap/IdeStartupWizardCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,173:1\n261#2,3:174\n261#2,3:177\n*S KotlinDebug\n*F\n+ 1 IdeStartupWizard.kt\ncom/intellij/platform/ide/bootstrap/IdeStartupWizardCollector\n*L\n147#1:174,3\n165#1:177,3\n*E\n"})
public final class IdeStartupWizardCollector
extends CounterUsagesCollector {
    @NotNull
    public static final IdeStartupWizardCollector INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final EventId initialStartSucceeded;
    @NotNull
    private static final EventId initialStartTimeoutTriggered;
    @NotNull
    private static final EventId3<IdeStartupExperiment.GroupKind, Integer, Boolean> experimentState;
    @NotNull
    private static final EventId2<StartupWizardStage, Long> wizardStageEnded;

    private IdeStartupWizardCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void logInitialStartSuccess() {
        initialStartSucceeded.log();
    }

    public final void logInitialStartTimeout() {
        initialStartTimeoutTriggered.log();
    }

    public final void logWizardExperimentState$intellij_platform_ide_bootstrap() {
        boolean bl = InitialConfigImportState.isFirstSession();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean isEnabled = IdeStartupExperiment.INSTANCE.isWizardExperimentEnabled$intellij_platform_ide_bootstrap();
        IdeStartupWizardKt.access$getLOG().info("IDE startup isEnabled = " + isEnabled + ", IDEStartupKind = " + IdeStartupExperiment.INSTANCE.getExperimentGroupKind() + ", IDEStartup = " + IdeStartupExperiment.INSTANCE.getExperimentGroup());
        experimentState.log((Object)IdeStartupExperiment.INSTANCE.getExperimentGroupKind(), (Object)IdeStartupExperiment.INSTANCE.getExperimentGroup(), (Object)isEnabled);
    }

    public final void logStartupStageTime(@NotNull StartupWizardStage stage, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        wizardStageEnded.log((Object)stage, (Object)duration.toMillis());
    }

    static {
        EventFields $this$iv;
        INSTANCE = new IdeStartupWizardCollector();
        GROUP = new EventLogGroup("wizard.startup", 7, null, 4, null);
        initialStartSucceeded = GROUP.registerEvent("initial_start_succeeded");
        initialStartTimeoutTriggered = GROUP.registerEvent("initial_start_timeout_triggered");
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "kind";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        experimentState = GROUP.registerEvent("initial_start_experiment_state", (EventField)new EnumEventField(name$iv, IdeStartupExperiment.GroupKind.class, null, transform$iv), (EventField)EventFields.Int((String)"group"), (EventField)EventFields.Boolean((String)"enabled"));
        $this$iv = EventFields.INSTANCE;
        name$iv = "stage";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        wizardStageEnded = GROUP.registerEvent("wizard_stage_ended", (EventField)new EnumEventField(name$iv, StartupWizardStage.class, null, transform$iv), (EventField)EventFields.DurationMs);
    }
}

