/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.bootstrap;

import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.platform.ide.bootstrap.IdeStartupWizard;
import com.intellij.util.MathUtil;
import com.intellij.util.PlatformUtils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0007H\u0002J\r\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u0006\u0010\u001c\u001a\u00020\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u001b\u0010\u0010\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0015\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0014\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/ide/bootstrap/IdeStartupExperiment;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "numberOfGroups", "", "getNumberOfGroups$annotations", "getGroupKind", "Lcom/intellij/platform/ide/bootstrap/IdeStartupExperiment$GroupKind;", "group", "asBucket", "s", "", "getBucket", "experimentGroup", "getExperimentGroup", "()I", "experimentGroup$delegate", "Lkotlin/Lazy;", "experimentGroupKind", "getExperimentGroupKind", "()Lcom/intellij/platform/ide/bootstrap/IdeStartupExperiment$GroupKind;", "experimentGroupKind$delegate", "isWizardExperimentEnabled", "", "isWizardExperimentEnabled$intellij_platform_ide_bootstrap", "isFeedbackSurveyExperimentEnabled", "GroupKind", "intellij.platform.ide.bootstrap"})
@SourceDebugExtension(value={"SMAP\nIdeStartupExperiment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeStartupExperiment.kt\ncom/intellij/platform/ide/bootstrap/IdeStartupExperiment\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,88:1\n82#2,3:89\n13#2:92\n*S KotlinDebug\n*F\n+ 1 IdeStartupExperiment.kt\ncom/intellij/platform/ide/bootstrap/IdeStartupExperiment\n*L\n51#1:89,3\n13#1:92\n*E\n"})
public final class IdeStartupExperiment {
    @NotNull
    public static final IdeStartupExperiment INSTANCE = new IdeStartupExperiment();
    @NotNull
    private static final Logger LOG;
    private static final int numberOfGroups;
    @NotNull
    private static final Lazy experimentGroup$delegate;
    @NotNull
    private static final Lazy experimentGroupKind$delegate;

    private IdeStartupExperiment() {
    }

    private static /* synthetic */ void getNumberOfGroups$annotations() {
    }

    private final GroupKind getGroupKind(int group) {
        GroupKind groupKind;
        if (PlatformUtils.isIdeaUltimate()) {
            int n = group;
            groupKind = (0 <= n ? n < 6 : false) ? GroupKind.ExperimentalWizard : (n == 6 || n == 7 ? GroupKind.ExperimentalFeedbackSurvey : (n == 8 || n == 9 ? GroupKind.Control : GroupKind.Undefined));
        } else if (PlatformUtils.isPyCharmPro()) {
            int n = group;
            groupKind = (0 <= n ? n < 8 : false) ? GroupKind.ExperimentalWizard : (n == 8 || n == 9 ? GroupKind.Control : GroupKind.Undefined);
        } else {
            switch (group) {
                case 0: 
                case 1: {
                    groupKind = GroupKind.ExperimentalWizard;
                    break;
                }
                case 2: {
                    groupKind = GroupKind.Control;
                    break;
                }
                default: {
                    groupKind = GroupKind.Undefined;
                }
            }
        }
        return groupKind;
    }

    private final int asBucket(String s) {
        return MathUtil.nonNegativeAbs((int)s.hashCode()) % 256;
    }

    private final int getBucket() {
        Object object;
        Logger $this$runAndLogException$iv = LOG;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            object = Result.constructor-impl((Object)DeviceIdManager.getOrGenerateId((DeviceIdManager.DeviceIdToken)new DeviceIdManager.DeviceIdToken(){}, (String)"FUS"));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        String string = (String)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        if (string == null) {
            return 0;
        }
        String deviceId2 = string;
        return this.asBucket(deviceId2);
    }

    public final int getExperimentGroup() {
        Lazy lazy = experimentGroup$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final GroupKind getExperimentGroupKind() {
        Lazy lazy = experimentGroupKind$delegate;
        return (GroupKind)((Object)lazy.getValue());
    }

    public final boolean isWizardExperimentEnabled$intellij_platform_ide_bootstrap() {
        if (PlatformUtils.isCLion()) {
            return false;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getExperimentGroupKind().ordinal()]) {
            case 1, 2 -> true;
            case 3, 4 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean isFeedbackSurveyExperimentEnabled() {
        if (PlatformUtils.isCLion()) {
            return false;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getExperimentGroupKind().ordinal()]) {
            case 1, 4 -> false;
            case 2, 3 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final int experimentGroup_delegate$lambda$0() {
        String string = System.getProperty("ide.transfer.wizard.experiment.group", "-1");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Integer n = StringsKt.toIntOrNull((String)string);
        int registryExperimentGroup = RangesKt.coerceIn((int)(n != null ? n : -1), (int)-1, (int)(numberOfGroups - 1));
        if (registryExperimentGroup >= 0) {
            return registryExperimentGroup;
        }
        int bucket = INSTANCE.getBucket();
        int experimentGroup = bucket % numberOfGroups;
        return experimentGroup;
    }

    private static final GroupKind experimentGroupKind_delegate$lambda$0() {
        return INSTANCE.getGroupKind(INSTANCE.getExperimentGroup());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IdeStartupWizard.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        numberOfGroups = PlatformUtils.isIdeaUltimate() || PlatformUtils.isPyCharmPro() ? 10 : 3;
        experimentGroup$delegate = LazyKt.lazy(IdeStartupExperiment::experimentGroup_delegate$lambda$0);
        experimentGroupKind$delegate = LazyKt.lazy(IdeStartupExperiment::experimentGroupKind_delegate$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/ide/bootstrap/IdeStartupExperiment$GroupKind;", "", "<init>", "(Ljava/lang/String;I)V", "ExperimentalWizard", "ExperimentalFeedbackSurvey", "Control", "Undefined", "intellij.platform.ide.bootstrap"})
    public static final class GroupKind
    extends Enum<GroupKind> {
        public static final /* enum */ GroupKind ExperimentalWizard = new GroupKind();
        public static final /* enum */ GroupKind ExperimentalFeedbackSurvey = new GroupKind();
        public static final /* enum */ GroupKind Control = new GroupKind();
        public static final /* enum */ GroupKind Undefined = new GroupKind();
        private static final /* synthetic */ GroupKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static GroupKind[] values() {
            return (GroupKind[])$VALUES.clone();
        }

        public static GroupKind valueOf(String value) {
            return Enum.valueOf(GroupKind.class, value);
        }

        @NotNull
        public static EnumEntries<GroupKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = groupKindArray = new GroupKind[]{GroupKind.ExperimentalWizard, GroupKind.ExperimentalFeedbackSurvey, GroupKind.Control, GroupKind.Undefined};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GroupKind.values().length];
            try {
                nArray[GroupKind.ExperimentalWizard.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GroupKind.Undefined.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GroupKind.ExperimentalFeedbackSurvey.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GroupKind.Control.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

