/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.bootstrap;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.ide.ui.localization.statistics.EventSource;
import com.intellij.ide.ui.localization.statistics.LocalizationActionsStatistics;
import com.intellij.l10n.LocalizationStateService;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.platform.ide.bootstrap.ButtonPanel;
import com.intellij.platform.ide.bootstrap.ButtonPanelKt;
import com.intellij.platform.ide.bootstrap.LanguageAndRegionDialog;
import com.intellij.platform.ide.bootstrap.LanguageAndRegionDialogKt;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.util.text.DateTimeFormatManager;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u0018\u001a\u00020\f2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0003H\u0003J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0005H\u0003J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0005H\u0003J\b\u0010#\u001a\u00020\u0014H\u0014J\b\u0010$\u001a\u00020\u0014H\u0002J\b\u0010%\u001a\u00020\u0014H\u0016J\r\u0010&\u001a\u00070'\u00a2\u0006\u0002\b(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/platform/ide/bootstrap/LanguageAndRegionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "selectedLanguage", "Ljava/util/Locale;", "selectedRegion", "Lcom/intellij/ide/Region;", "osLocale", "<init>", "(Ljava/util/Locale;Lcom/intellij/ide/Region;Ljava/util/Locale;)V", "source", "Lcom/intellij/ide/ui/localization/statistics/EventSource;", "createCenterPanel", "Ljavax/swing/JComponent;", "getLanguageButton", "Lcom/intellij/platform/ide/bootstrap/ButtonPanel;", "getRegionButton", "getNextButton", "createContentPaneBorder", "Ljavax/swing/border/Border;", "createRegionPopup", "", "button", "Ljavax/swing/JButton;", "createLanguagePopup", "createRendererComponent", "value", "", "list", "selected", "", "getLocaleName", "locale", "getRegionName", "region", "getRegionLabel", "doOKAction", "clearCache", "doCancelAction", "getMessageBundle", "Ljava/util/ResourceBundle;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.bootstrap"})
@SourceDebugExtension(value={"SMAP\nLanguageAndRegionDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageAndRegionDialog.kt\ncom/intellij/platform/ide/bootstrap/LanguageAndRegionDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n1056#2:276\n*S KotlinDebug\n*F\n+ 1 LanguageAndRegionDialog.kt\ncom/intellij/platform/ide/bootstrap/LanguageAndRegionDialog\n*L\n129#1:276\n*E\n"})
final class LanguageAndRegionDialog
extends DialogWrapper {
    @NotNull
    private Locale selectedLanguage;
    @NotNull
    private Region selectedRegion;
    @NotNull
    private final EventSource source;

    public LanguageAndRegionDialog(@NotNull Locale selectedLanguage, @NotNull Region selectedRegion, @NotNull Locale osLocale) {
        Intrinsics.checkNotNullParameter((Object)selectedLanguage, (String)"selectedLanguage");
        Intrinsics.checkNotNullParameter((Object)selectedRegion, (String)"selectedRegion");
        Intrinsics.checkNotNullParameter((Object)osLocale, (String)"osLocale");
        super(null, null, true, DialogWrapper.IdeModalityType.IDE, false);
        this.selectedLanguage = selectedLanguage;
        this.selectedRegion = selectedRegion;
        this.source = EventSource.PRE_EUA_DIALOG;
        this.setResizable(false);
        LocalizationActionsStatistics.INSTANCE.dialogInitializationStarted(osLocale, this.selectedLanguage, this.selectedRegion, this.source);
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Object object = new VerticalLayout(JBUI.scale((int)10), 0);
        Object $this$createCenterPanel_u24lambda_u240 = object = new JPanel((VerticalLayout)object){

            protected Graphics getComponentGraphics(Graphics g) {
                Graphics2D graphics2D = JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(g));
                Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"runGlobalCGTransform(...)");
                return graphics2D;
            }
        };
        boolean bl = false;
        ((JComponent)$this$createCenterPanel_u24lambda_u240).setOpaque(false);
        ((JComponent)$this$createCenterPanel_u24lambda_u240).setBorder((Border)JBUI.Borders.empty());
        Object centerPanel2 = object;
        ((JComponent)centerPanel2).setPreferredSize((Dimension)new JBDimension(640, 470));
        Object $this$createCenterPanel_u24lambda_u241 = $this$createCenterPanel_u24lambda_u240 = new JLabel(this.getMessageBundle().getString("title.language.and.region"));
        boolean bl2 = false;
        ((JComponent)$this$createCenterPanel_u24lambda_u241).setFont((Font)JBFont.h1());
        ((JComponent)$this$createCenterPanel_u24lambda_u241).setAlignmentX(0.5f);
        Object header = $this$createCenterPanel_u24lambda_u240;
        Object $this$createCenterPanel_u24lambda_u242 = $this$createCenterPanel_u24lambda_u241 = new JEditorPane(){

            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new JTextComponent.AccessibleJTextComponent(this){

                        public AccessibleRole getAccessibleRole() {
                            return AccessibleRole.LABEL;
                        }
                    };
                }
                return this.accessibleContext;
            }
        };
        boolean bl3 = false;
        ((JTextComponent)$this$createCenterPanel_u24lambda_u242).setEditable(false);
        ((JComponent)$this$createCenterPanel_u24lambda_u242).setOpaque(false);
        ((Component)$this$createCenterPanel_u24lambda_u242).setFocusable(false);
        ((JEditorPane)$this$createCenterPanel_u24lambda_u242).setEditorKit(HTMLEditorKitBuilder.Companion.simple());
        ((JEditorPane)$this$createCenterPanel_u24lambda_u242).setText(this.getMessageBundle().getString("description.language.and.region"));
        Object text2 = $this$createCenterPanel_u24lambda_u241;
        ((JEditorPane)text2).addHyperlinkListener(LanguageAndRegionDialog::createCenterPanel$lambda$3);
        ((Container)centerPanel2).add((Component)BuilderKt.panel(arg_0 -> LanguageAndRegionDialog.createCenterPanel$lambda$4((JLabel)header, text2, arg_0)).withPreferredWidth(350), "CENTER");
        JPanel buttonsPanel = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)3), 0));
        buttonsPanel.add(this.getLanguageButton());
        buttonsPanel.add(this.getRegionButton());
        buttonsPanel.add(this.getNextButton());
        ((Container)centerPanel2).add((Component)buttonsPanel, "CENTER");
        return (JComponent)centerPanel2;
    }

    private final ButtonPanel getLanguageButton() {
        return new ButtonPanel(ButtonPanelKt.createButton(false, this.getLocaleName(this.selectedLanguage), AllIcons.General.ChevronDown, (Function1<? super JButton, Unit>)((Function1)arg_0 -> LanguageAndRegionDialog.getLanguageButton$lambda$0(this, arg_0))));
    }

    private final ButtonPanel getRegionButton() {
        return new ButtonPanel(ButtonPanelKt.createButton(false, this.getRegionLabel(this.selectedRegion), AllIcons.General.ChevronDown, (Function1<? super JButton, Unit>)((Function1)arg_0 -> LanguageAndRegionDialog.getRegionButton$lambda$0(this, arg_0))));
    }

    private final ButtonPanel getNextButton() {
        String string = this.getMessageBundle().getString("button.next");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return new ButtonPanel(ButtonPanelKt.createButton(true, string, null, (Function1<? super JButton, Unit>)((Function1)arg_0 -> LanguageAndRegionDialog.getNextButton$lambda$0(this, arg_0))));
    }

    @NotNull
    protected Border createContentPaneBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        return (Border)jBEmptyBorder;
    }

    private final void createRegionPopup(JButton button) {
        Iterable $this$sortedBy$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$sortedBy = false;
        List regions = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Region it = (Region)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getDisplayOrdinal());
                it = (Region)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getDisplayOrdinal()));
            }
        });
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(regions).setRequestFocus(true).setRenderer((arg_0, arg_1, arg_2, arg_3, arg_4) -> LanguageAndRegionDialog.createRegionPopup$lambda$2((arg_0, arg_1, arg_2, arg_3, arg_4) -> LanguageAndRegionDialog.createRegionPopup$lambda$1(this, arg_0, arg_1, arg_2, arg_3, arg_4), arg_0, arg_1, arg_2, arg_3, arg_4)).setSelectedValue((Object)this.selectedRegion, true).setMinSize(new Dimension(280, 100)).setResizable(false).setCancelOnClickOutside(true).setItemChosenCallback(arg_0 -> LanguageAndRegionDialog.createRegionPopup$lambda$4(arg_0 -> LanguageAndRegionDialog.createRegionPopup$lambda$3(this, button, arg_0), arg_0)).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        popup.show(RelativePoint.getSouthWestOf((JComponent)button));
        LocalizationActionsStatistics.INSTANCE.regionExpanded(this.source);
    }

    private final void createLanguagePopup(JButton button) {
        Object[] objectArray = new Locale[]{Locale.ENGLISH};
        List locales = CollectionsKt.plus((Collection)CollectionsKt.mutableListOf((Object[])objectArray), (Iterable)LanguageAndRegionDialogKt.access$getLanguageMapping$p().keySet());
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(locales).setRequestFocus(true).setRenderer((arg_0, arg_1, arg_2, arg_3, arg_4) -> LanguageAndRegionDialog.createLanguagePopup$lambda$1((arg_0, arg_1, arg_2, arg_3, arg_4) -> LanguageAndRegionDialog.createLanguagePopup$lambda$0(this, arg_0, arg_1, arg_2, arg_3, arg_4), arg_0, arg_1, arg_2, arg_3, arg_4)).setSelectedValue((Object)this.selectedLanguage, true).setMinSize(new Dimension(280, 100)).setResizable(false).setCancelOnClickOutside(true).setItemChosenCallback(arg_0 -> LanguageAndRegionDialog.createLanguagePopup$lambda$3(arg_0 -> LanguageAndRegionDialog.createLanguagePopup$lambda$2(this, arg_0), arg_0)).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        popup.show(RelativePoint.getSouthWestOf((JComponent)button));
        LocalizationActionsStatistics.INSTANCE.languageExpanded(this.source);
    }

    private final JComponent createRendererComponent(@Nls String value, JComponent list, boolean selected) {
        JBLabel label = new JBLabel(value, null, 2);
        SelectablePanel panel = SelectablePanel.Companion.wrap((Component)label, list.getBackground());
        if (selected) {
            panel.setSelectionColor(UIUtil.getListSelectionBackground((boolean)true));
        }
        PopupUtil.configListRendererFixedHeight((SelectablePanel)panel);
        return (JComponent)panel;
    }

    @Nls
    private final String getLocaleName(Locale locale) {
        ResourceBundle resourceBundle = this.getMessageBundle();
        String string = locale.toLanguageTag();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLanguageTag(...)");
        String string2 = resourceBundle.getString("language." + StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return string2;
    }

    @Nls
    private final String getRegionName(Region region) {
        String string = this.getMessageBundle().getString(region.getDisplayKey());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @Nls
    private final String getRegionLabel(Region region) {
        String string = this.getMessageBundle().getString(region == Region.NOT_SET ? "title.region.not.set.label" : region.getDisplayKey());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    protected void doOKAction() {
        LocalizationActionsStatistics.INSTANCE.nextButtonPressed(this.selectedLanguage, this.selectedRegion, this.source);
        LocalizationStateService localizationStateService = LocalizationStateService.getInstance();
        if (localizationStateService != null) {
            localizationStateService.setSelectedLocale(this.selectedLanguage.toLanguageTag(), Boolean.valueOf(true));
        }
        RegionSettings.setRegion((Region)this.selectedRegion);
        this.clearCache();
        super.doOKAction();
    }

    private final void clearCache() {
        DynamicBundle.clearCache();
        DateTimeFormatManager.getInstance().resetFormats();
    }

    public void doCancelAction() {
        LocalizationActionsStatistics.INSTANCE.dialogClosedWithoutConfirmation(this.selectedLanguage, this.selectedRegion, this.source);
        super.doCancelAction();
    }

    private final ResourceBundle getMessageBundle() {
        ResourceBundle resourceBundle = DynamicBundle.getResourceBundleLocalized((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"messages.LanguageAndRegionBundle", (Locale)this.selectedLanguage);
        Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"getResourceBundleLocalized(...)");
        return resourceBundle;
    }

    private static final void createCenterPanel$lambda$3(HyperlinkEvent e) {
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            BrowserUtil.browse((URL)e.getURL());
        }
    }

    private static final Unit createCenterPanel$lambda$4(JLabel $header, createCenterPanel.text.1 $text, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LanguageAndRegionDialog.createCenterPanel$lambda$4$0($header, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LanguageAndRegionDialog.createCenterPanel$lambda$4$1($text, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$4$0(JLabel $header, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$header).align(Align.CENTER);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$4$1(createCenterPanel.text.1 $text, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$text);
        return Unit.INSTANCE;
    }

    private static final Unit getLanguageButton$lambda$0(LanguageAndRegionDialog this$0, JButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.createLanguagePopup(it);
        return Unit.INSTANCE;
    }

    private static final Unit getRegionButton$lambda$0(LanguageAndRegionDialog this$0, JButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.createRegionPopup(it);
        return Unit.INSTANCE;
    }

    private static final Unit getNextButton$lambda$0(LanguageAndRegionDialog this$0, JButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.doOKAction();
        return Unit.INSTANCE;
    }

    private static final Component createRegionPopup$lambda$1(LanguageAndRegionDialog this$0, JList list, Region value, int n, boolean selected, boolean bl) {
        Intrinsics.checkNotNull((Object)value);
        String string = this$0.getRegionName(value);
        Intrinsics.checkNotNull((Object)list);
        return this$0.createRendererComponent(string, list, selected);
    }

    private static final Component createRegionPopup$lambda$2(Function5 $tmp0, JList p0, Object p1, int p2, boolean p3, boolean p4) {
        return (Component)$tmp0.invoke((Object)p0, p1, (Object)p2, (Object)p3, (Object)p4);
    }

    private static final Unit createRegionPopup$lambda$3(LanguageAndRegionDialog this$0, JButton $button, Region it) {
        Intrinsics.checkNotNull((Object)it);
        LocalizationActionsStatistics.INSTANCE.regionSelected(it, this$0.selectedRegion, this$0.source);
        this$0.selectedRegion = it;
        $button.setText(this$0.getRegionLabel(it));
        return Unit.INSTANCE;
    }

    private static final void createRegionPopup$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Component createLanguagePopup$lambda$0(LanguageAndRegionDialog this$0, JList list, Locale value, int n, boolean selected, boolean bl) {
        Intrinsics.checkNotNull((Object)value);
        String string = this$0.getLocaleName(value);
        Intrinsics.checkNotNull((Object)list);
        return this$0.createRendererComponent(string, list, selected);
    }

    private static final Component createLanguagePopup$lambda$1(Function5 $tmp0, JList p0, Object p1, int p2, boolean p3, boolean p4) {
        return (Component)$tmp0.invoke((Object)p0, p1, (Object)p2, (Object)p3, (Object)p4);
    }

    private static final Unit createLanguagePopup$lambda$2(LanguageAndRegionDialog this$0, Locale it) {
        Intrinsics.checkNotNull((Object)it);
        LocalizationActionsStatistics.INSTANCE.languageSelected(it, this$0.selectedLanguage, this$0.source);
        this$0.selectedLanguage = it;
        this$0.getContentPanel().removeAll();
        JComponent panel = this$0.createCenterPanel();
        this$0.getContentPanel().add((Component)panel, "Center");
        this$0.getContentPanel().doLayout();
        this$0.getContentPanel().revalidate();
        this$0.getContentPanel().repaint();
        return Unit.INSTANCE;
    }

    private static final void createLanguagePopup$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Region> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Region.values()));
        }
    }
}

