/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.listeners.typing;

import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.codeInsight.inline.completion.listeners.typing.InlineCompletionTypingSessionTracker;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionUsageTracker;
import com.intellij.codeInsight.inline.completion.utils.InlineCompletionHandlerUtils;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/inline/completion/listeners/typing/InlineCompletionDocumentListener;", "Lcom/intellij/openapi/editor/event/BulkAwareDocumentListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "documentChangedNonBulk", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.platform.ide.codeinsight.inline"})
public final class InlineCompletionDocumentListener
implements BulkAwareDocumentListener {
    @NotNull
    private final Editor editor;

    public InlineCompletionDocumentListener(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    public void documentChangedNonBulk(@NotNull DocumentEvent event) {
        block2: {
            InlineCompletionTypingSessionTracker typingSessionTracker2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ClientId clientId = ClientEditorManager.Companion.getClientId(this.editor);
            if (clientId == null) {
                clientId = ClientId.Companion.getLocalId();
            }
            if (!Intrinsics.areEqual((Object)clientId, (Object)ClientId.Companion.getCurrent())) {
                InlineCompletionHandlerUtils.INSTANCE.hideInlineCompletion(this.editor, InlineCompletionUsageTracker.ShownEvents.FinishType.DOCUMENT_CHANGED);
                return;
            }
            InlineCompletionHandler inlineCompletionHandler = InlineCompletion.INSTANCE.getHandlerOrNull(this.editor);
            InlineCompletionTypingSessionTracker inlineCompletionTypingSessionTracker = typingSessionTracker2 = inlineCompletionHandler != null ? inlineCompletionHandler.getTypingSessionTracker() : null;
            if (inlineCompletionTypingSessionTracker == null) break block2;
            inlineCompletionTypingSessionTracker.collectTypedCharOrInvalidateSession(event, this.editor);
        }
    }
}

