/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion;

import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionUsageTracker;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionSession;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J$\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/codeInsight/inline/completion/BackspaceDeleteInlineCompletionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "originalHandler", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "invokeOriginalHandler", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isEnabledForCaret", "", "doExecute", "intellij.platform.ide.codeinsight.inline"})
@ApiStatus.Internal
public final class BackspaceDeleteInlineCompletionHandler
extends EditorActionHandler {
    @NotNull
    private final EditorActionHandler originalHandler;

    public BackspaceDeleteInlineCompletionHandler(@NotNull EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        this.originalHandler = originalHandler;
    }

    private final void invokeOriginalHandler(Editor editor, Caret caret, DataContext dataContext) {
        if (this.originalHandler.isEnabled(editor, caret, dataContext)) {
            this.originalHandler.execute(editor, caret, dataContext);
        }
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.originalHandler.isEnabled(editor, caret, dataContext);
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        InlineCompletionHandler handler = InlineCompletion.INSTANCE.getHandlerOrNull(editor);
        if (handler == null) {
            this.invokeOriginalHandler(editor, caret, dataContext);
            return;
        }
        InlineCompletionSession inlineCompletionSession = InlineCompletionSession.Companion.getOrNull(editor);
        if (inlineCompletionSession != null) {
            InlineCompletionSession session = inlineCompletionSession;
            boolean bl = false;
            handler.hide(session.getContext(), InlineCompletionUsageTracker.ShownEvents.FinishType.BACKSPACE_PRESSED);
        }
        if (editor.getCaretModel().getCaretCount() != 1) {
            this.invokeOriginalHandler(editor, caret, dataContext);
            return;
        }
        long initialModificationStamp = editor.getDocument().getModificationStamp();
        this.invokeOriginalHandler(editor, caret, dataContext);
        if (editor.getDocument().getModificationStamp() == initialModificationStamp) {
            return;
        }
        handler.invokeEvent(new InlineCompletionEvent.Backspace(editor));
    }
}

