/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J'\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/codeInsight/inline/completion/InlineCompletionFontUtils;", "", "<init>", "()V", "font", "Ljava/awt/Font;", "editor", "Lcom/intellij/openapi/editor/Editor;", "color", "Ljava/awt/Color;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getFont", "text", "", "fontType", "", "getFont$intellij_platform_ide_codeinsight_inline", "intellij.platform.ide.codeinsight.inline"})
public final class InlineCompletionFontUtils {
    @NotNull
    public static final InlineCompletionFontUtils INSTANCE = new InlineCompletionFontUtils();

    private InlineCompletionFontUtils() {
    }

    @NotNull
    public final Font font(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Font font = editor.getColorsScheme().getFont(EditorFontType.ITALIC);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        return font;
    }

    @NotNull
    public final Color color(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Color color = this.attributes(editor).getForegroundColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForegroundColor(...)");
        return color;
    }

    @ApiStatus.Experimental
    @NotNull
    public final TextAttributes attributes(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextAttributes textAttributes = editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_SUGGESTION);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"getAttributes(...)");
        return textAttributes;
    }

    @NotNull
    public final Font getFont$intellij_platform_ide_codeinsight_inline(@NotNull Editor editor, @NotNull String text, @JdkConstants.FontStyle int fontType) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Font font = editor.getColorsScheme().getFont(EditorFontType.forJavaStyle((int)fontType));
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font original = font;
        Font font2 = UIUtil.getFontWithFallbackIfNeeded((Font)original, (String)text);
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"getFontWithFallbackIfNeeded(...)");
        return font2;
    }
}

