/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.listeners;

import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.codeInsight.inline.completion.TypingEvent;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/inline/completion/listeners/InlineCompletionEnterHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "originalHandler", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isEnabledForCaret", "", "intellij.platform.ide.codeinsight.inline"})
public final class InlineCompletionEnterHandler
extends EditorActionHandler {
    @NotNull
    private final EditorActionHandler originalHandler;

    public InlineCompletionEnterHandler(@NotNull EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        this.originalHandler = originalHandler;
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Caret caret2 = caret;
        if (caret2 == null) {
            Caret caret3 = editor.getCaretModel().getCurrentCaret();
            caret2 = caret3;
            Intrinsics.checkNotNullExpressionValue((Object)caret3, (String)"getCurrentCaret(...)");
        }
        Caret currentCaret = caret2;
        int initialOffset = currentCaret.getOffset();
        this.originalHandler.execute(editor, caret, dataContext);
        int finalOffset = currentCaret.getOffset();
        if (initialOffset >= finalOffset) {
            return;
        }
        Editor actualEditor = editor;
        InlineCompletionHandler handler = InlineCompletion.INSTANCE.getHandlerOrNull(editor);
        TextRange typedRange = new TextRange(initialOffset, finalOffset);
        while (handler == null && actualEditor instanceof EditorWindow) {
            Intrinsics.checkNotNullExpressionValue((Object)((EditorWindow)actualEditor).getDocument().injectedToHost(typedRange), (String)"injectedToHost(...)");
            Intrinsics.checkNotNullExpressionValue((Object)((EditorWindow)actualEditor).getDelegate(), (String)"getDelegate(...)");
            handler = InlineCompletion.INSTANCE.getHandlerOrNull(actualEditor);
        }
        if (handler == null) {
            return;
        }
        String string = actualEditor.getDocument().getText(typedRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String typed = string;
        TypingEvent.NewLine typingEvent = new TypingEvent.NewLine(typed, typedRange);
        InlineCompletionEvent.DocumentChange icEvent = new InlineCompletionEvent.DocumentChange(typingEvent, actualEditor);
        handler.invokeEvent(icEvent);
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.originalHandler.isEnabled(editor, caret, dataContext);
    }
}

