/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.utils;

import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElementManipulator;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionSkipTextElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0007J>\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u0014\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J2\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u00052\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0002J8\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00052\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002JP\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u00052\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u0005H\u0002J4\u0010\u001e\u001a\u00020\b*\u00020\u000e2\b\b\u0002\u0010\u001f\u001a\u00020\b2\b\b\u0002\u0010 \u001a\u00020\b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00130\"H\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/codeInsight/inline/completion/utils/InlineCompletionSkipElementUtils;", "", "<init>", "()V", "insertSkipElementsAt", "", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement;", "offsets", "", "insertOffsetsAndAdditionalLines", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "completion", "", "labelSkipOffsets", "", "elements", "computeExistenceOfLines", "", "numberOfLines", "mapOffsetsToLineNumber", "computeLinesToInsertForOffsets", "Lcom/intellij/codeInsight/inline/completion/utils/InlineCompletionSkipElementUtils$LineToInsert;", "lineNumberToOffsets", "doInsertOffsetsAndAdditionalLines", "", "originalEditor", "startOffset", "linesToInsert", "countWhilePredicate", "start", "end", "predicate", "Lkotlin/Function1;", "", "LineToInsert", "intellij.platform.ide.codeinsight.inline"})
@ApiStatus.Internal
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nInlineCompletionSkipElementUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionSkipElementUtils.kt\ncom/intellij/codeInsight/inline/completion/utils/InlineCompletionSkipElementUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n777#2:277\n873#2,2:278\n1391#2:283\n1480#2,5:284\n777#2:293\n873#2,2:294\n777#2:296\n873#2,2:297\n1123#3,3:280\n1123#3,3:290\n1#4:289\n*S KotlinDebug\n*F\n+ 1 InlineCompletionSkipElementUtils.kt\ncom/intellij/codeInsight/inline/completion/utils/InlineCompletionSkipElementUtils\n*L\n90#1:277\n90#1:278,2\n102#1:283\n102#1:284,5\n183#1:293\n183#1:294,2\n184#1:296\n184#1:297,2\n97#1:280,3\n130#1:290,3\n*E\n"})
public final class InlineCompletionSkipElementUtils {
    @NotNull
    public static final InlineCompletionSkipElementUtils INSTANCE = new InlineCompletionSkipElementUtils();

    private InlineCompletionSkipElementUtils() {
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public final List<InlineCompletionElement> insertSkipElementsAt(@NotNull List<? extends InlineCompletionElement> $this$insertSkipElementsAt, @NotNull List<Integer> offsets) {
        List list;
        block6: {
            Intrinsics.checkNotNullParameter($this$insertSkipElementsAt, (String)"<this>");
            Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
            List $this$insertSkipElementsAt_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            List elements = CollectionsKt.toMutableList((Collection)$this$insertSkipElementsAt);
            int offset = 0;
            int elementIndex = 0;
            Iterator iterator = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)offsets)).iterator();
            while (iterator.hasNext()) {
                int skipOffset = ((Number)iterator.next()).intValue();
                while (elementIndex < elements.size() && offset + ((InlineCompletionElement)elements.get(elementIndex)).getText().length() <= skipOffset) {
                    $this$insertSkipElementsAt_u24lambda_u240.add(elements.get(elementIndex));
                    offset += ((InlineCompletionElement)elements.get(elementIndex)).getText().length();
                    ++elementIndex;
                }
                if (elementIndex < elements.size()) {
                    InlineCompletionElementManipulator manipulator;
                    InlineCompletionElement element = (InlineCompletionElement)elements.get(elementIndex);
                    if (element instanceof InlineCompletionSkipTextElement) continue;
                    int splitOffset = skipOffset - offset;
                    Intrinsics.checkNotNull((Object)InlineCompletionElementManipulator.Companion.getApplicable(element));
                    UtilKt.addIfNotNull((List)$this$insertSkipElementsAt_u24lambda_u240, (Object)manipulator.substring(element, 0, splitOffset));
                    String string = element.getText().substring(splitOffset, splitOffset + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    $this$insertSkipElementsAt_u24lambda_u240.add(new InlineCompletionSkipTextElement(string));
                    InlineCompletionElement leftPart = manipulator.substring(element, splitOffset + 1, element.getText().length());
                    if (leftPart != null) {
                        elements.set(elementIndex, leftPart);
                    } else {
                        ++elementIndex;
                    }
                    offset = skipOffset + 1;
                    continue;
                }
                break block6;
            }
            while (elementIndex < elements.size()) {
                $this$insertSkipElementsAt_u24lambda_u240.add(elements.get(elementIndex));
                ++elementIndex;
            }
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public final List<InlineCompletionElement> insertOffsetsAndAdditionalLines(@NotNull List<? extends InlineCompletionElement> $this$insertOffsetsAndAdditionalLines, @NotNull List<Integer> offsets, @NotNull Editor editor, int offset, @NotNull String completion) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter($this$insertOffsetsAndAdditionalLines, (String)"<this>");
        Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)completion, (String)"completion");
        Iterable iterable = offsets;
        boolean $i$f$filter = false;
        void var9_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        int $i$f$filterTo22 = 0;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(it < completion.length() && it >= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List initialOffsets = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        if (initialOffsets.isEmpty()) {
            return $this$insertOffsetsAndAdditionalLines;
        }
        CharSequence $this$count$iv = completion;
        boolean $i$f$count = false;
        int count$iv = 0;
        for ($i$f$filterTo22 = 0; $i$f$filterTo22 < $this$count$iv.length(); ++$i$f$filterTo22) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt($i$f$filterTo22);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int numberOfLines = count$iv + 1;
        List<List<Integer>> lineNumberToOffsets = this.mapOffsetsToLineNumber(numberOfLines, completion, initialOffsets);
        List<LineToInsert> linesToInsert = this.computeLinesToInsertForOffsets(lineNumberToOffsets, $this$insertOffsetsAndAdditionalLines, completion);
        this.doInsertOffsetsAndAdditionalLines(editor, offset, completion, $this$insertOffsetsAndAdditionalLines, linesToInsert, lineNumberToOffsets);
        Iterable $i$f$filterTo22 = linesToInsert;
        Collection collection = initialOffsets;
        boolean $i$f$flatMap = false;
        void it = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LineToInsert it2 = (LineToInsert)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)RangesKt.until((int)it2.getWhitespaceStart(), (int)it2.getWhitespaceEnd());
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List newOffsets = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2)));
        return this.insertSkipElementsAt($this$insertOffsetsAndAdditionalLines, newOffsets);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean[] labelSkipOffsets(List<? extends InlineCompletionElement> elements) {
        int n = 0;
        Iterable object = elements;
        int n2 = 0;
        for (Object t : object) {
            void it;
            InlineCompletionElement inlineCompletionElement = (InlineCompletionElement)t;
            int n3 = n2;
            boolean bl = false;
            int n4 = it.getText().length();
            n2 = n3 + n4;
        }
        int n5 = n2;
        boolean[] blArray = new boolean[n5];
        while (n < n5) {
            n2 = n++;
            blArray[n2] = false;
        }
        boolean[] labels = blArray;
        int offset = 0;
        for (InlineCompletionElement inlineCompletionElement : elements) {
            n2 = inlineCompletionElement.getText().length();
            int n6 = 0;
            while (n6 < n2) {
                int it = n6++;
                boolean bl = false;
                labels[offset] = inlineCompletionElement instanceof InlineCompletionSkipTextElement;
                ++offset;
            }
        }
        return labels;
    }

    private final List<Boolean> computeExistenceOfLines(int numberOfLines, List<? extends InlineCompletionElement> elements) {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(numberOfLines);
        int n = 0;
        while (n < numberOfLines) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<Boolean> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(false);
        }
        List lineToExists = arrayList;
        lineToExists.set(0, true);
        int lineNumber = 0;
        for (InlineCompletionElement inlineCompletionElement : elements) {
            int n4;
            int i;
            CharSequence $this$count$iv = inlineCompletionElement.getText();
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int j = 0; j < $this$count$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(j);
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            int newLinesNumber = count$iv;
            if (inlineCompletionElement instanceof InlineCompletionSkipTextElement && (i = lineNumber + 1) <= (n4 = lineNumber + newLinesNumber)) {
                while (true) {
                    lineToExists.set(i, true);
                    if (i == n4) break;
                    ++i;
                }
            }
            lineNumber += newLinesNumber;
        }
        return lineToExists;
    }

    private final List<List<Integer>> mapOffsetsToLineNumber(int numberOfLines, String completion, List<Integer> offsets) {
        ArrayList<List> arrayList = new ArrayList<List>(numberOfLines);
        int n = 0;
        while (n < numberOfLines) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<List> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new ArrayList());
        }
        List lineNumberToOffsets = arrayList;
        int lineNumber = 0;
        int currentOffset = 0;
        Iterator<Integer> iterator = offsets.iterator();
        while (iterator.hasNext()) {
            int offset = ((Number)iterator.next()).intValue();
            while (currentOffset < offset) {
                if (completion.charAt(currentOffset) == '\n') {
                    ++lineNumber;
                }
                ++currentOffset;
            }
            Collection collection = (Collection)lineNumberToOffsets.get(lineNumber);
            collection.add(offset);
        }
        return lineNumberToOffsets;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LineToInsert> computeLinesToInsertForOffsets(List<? extends List<Integer>> lineNumberToOffsets, List<? extends InlineCompletionElement> elements, String completion) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        List newLinesDescriptors = new ArrayList();
        List<Boolean> lineToExists = this.computeExistenceOfLines(lineNumberToOffsets.size(), elements);
        Iterable $this$filter$iv = (Iterable)StringsKt.getIndices((CharSequence)completion);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(completion.charAt(it) == '\n')) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lineBreaksOffsets = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = (Iterable)CollectionsKt.getIndices((Collection)lineNumberToOffsets);
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            boolean bl2 = !((Collection)lineNumberToOffsets.get(it)).isEmpty();
            if (!bl2) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterator iterator = ((List)destination$iv$iv2).iterator();
        while (iterator.hasNext()) {
            int lineNum = ((Number)iterator.next()).intValue();
            if (lineToExists.get(lineNum).booleanValue()) {
                Integer n = (Integer)CollectionsKt.getOrNull((List)lineBreaksOffsets, (int)(lineNum - 1));
                int lineStart = n != null ? n + 1 : 0;
                ((Collection)newLinesDescriptors).add(new LineToInsert(lineNum, lineStart, lineStart));
                continue;
            }
            if (!(lineNum > 0)) {
                throw new IllegalStateException("Check failed.");
            }
            int breakStart = ((Number)lineBreaksOffsets.get(lineNum - 1)).intValue();
            int rangeEnd = breakStart + InlineCompletionSkipElementUtils.countWhilePredicate$default(this, completion, breakStart, 0, InlineCompletionSkipElementUtils::computeLinesToInsertForOffsets$lambda$2, 2, null);
            ((Collection)newLinesDescriptors).add(new LineToInsert(lineNum, breakStart, rangeEnd));
        }
        return newLinesDescriptors;
    }

    private final void doInsertOffsetsAndAdditionalLines(Editor originalEditor, int startOffset, String completion, List<? extends InlineCompletionElement> elements, List<LineToInsert> linesToInsert, List<? extends List<Integer>> lineNumberToOffsets) {
        int currentOffset = 0;
        int insertionOffset = startOffset;
        boolean[] labeledSkipOffsets = this.labelSkipOffsets(elements);
        for (LineToInsert lineToInsert : linesToInsert) {
            int lineNum = lineToInsert.component1();
            int newSkipOffsetStart = lineToInsert.component2();
            int newSkipOffsetEnd = lineToInsert.component3();
            while (currentOffset < newSkipOffsetStart) {
                if (labeledSkipOffsets[currentOffset]) {
                    ++insertionOffset;
                }
                ++currentOffset;
            }
            for (int i = newSkipOffsetStart; i < newSkipOffsetEnd; ++i) {
                if (labeledSkipOffsets[i]) {
                    ++insertionOffset;
                    continue;
                }
                originalEditor.getDocument().insertString(insertionOffset, (CharSequence)String.valueOf(completion.charAt(i)));
                ++insertionOffset;
            }
            int focusOffset = newSkipOffsetEnd;
            Iterator iterator = CollectionsKt.sorted((Iterable)lineNumberToOffsets.get(lineNum)).iterator();
            while (iterator.hasNext()) {
                int currentSkipOffset = ((Number)iterator.next()).intValue();
                if (focusOffset > currentSkipOffset) continue;
                while (focusOffset < currentSkipOffset) {
                    if (labeledSkipOffsets[focusOffset]) {
                        ++insertionOffset;
                    }
                    ++focusOffset;
                }
                if (labeledSkipOffsets[currentSkipOffset]) continue;
                originalEditor.getDocument().insertString(insertionOffset, (CharSequence)String.valueOf(completion.charAt(currentSkipOffset)));
                ++insertionOffset;
            }
        }
    }

    private final int countWhilePredicate(String $this$countWhilePredicate, int start, int end, Function1<? super Character, Boolean> predicate) {
        for (int i = start; i < end; ++i) {
            if (((Boolean)predicate.invoke((Object)Character.valueOf($this$countWhilePredicate.charAt(i)))).booleanValue()) continue;
            return i - start;
        }
        return end - start;
    }

    static /* synthetic */ int countWhilePredicate$default(InlineCompletionSkipElementUtils inlineCompletionSkipElementUtils, String string, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return inlineCompletionSkipElementUtils.countWhilePredicate(string, n, n2, (Function1<? super Character, Boolean>)function1);
    }

    private static final boolean computeLinesToInsertForOffsets$lambda$2(char it) {
        return CharsKt.isWhitespace((char)it);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInsight/inline/completion/utils/InlineCompletionSkipElementUtils$LineToInsert;", "", "lineNumberInCompletion", "", "whitespaceStart", "whitespaceEnd", "<init>", "(III)V", "getLineNumberInCompletion", "()I", "getWhitespaceStart", "getWhitespaceEnd", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide.codeinsight.inline"})
    private static final class LineToInsert {
        private final int lineNumberInCompletion;
        private final int whitespaceStart;
        private final int whitespaceEnd;

        public LineToInsert(int lineNumberInCompletion, int whitespaceStart, int whitespaceEnd) {
            this.lineNumberInCompletion = lineNumberInCompletion;
            this.whitespaceStart = whitespaceStart;
            this.whitespaceEnd = whitespaceEnd;
        }

        public final int getLineNumberInCompletion() {
            return this.lineNumberInCompletion;
        }

        public final int getWhitespaceStart() {
            return this.whitespaceStart;
        }

        public final int getWhitespaceEnd() {
            return this.whitespaceEnd;
        }

        public final int component1() {
            return this.lineNumberInCompletion;
        }

        public final int component2() {
            return this.whitespaceStart;
        }

        public final int component3() {
            return this.whitespaceEnd;
        }

        @NotNull
        public final LineToInsert copy(int lineNumberInCompletion, int whitespaceStart, int whitespaceEnd) {
            return new LineToInsert(lineNumberInCompletion, whitespaceStart, whitespaceEnd);
        }

        public static /* synthetic */ LineToInsert copy$default(LineToInsert lineToInsert, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = lineToInsert.lineNumberInCompletion;
            }
            if ((n4 & 2) != 0) {
                n2 = lineToInsert.whitespaceStart;
            }
            if ((n4 & 4) != 0) {
                n3 = lineToInsert.whitespaceEnd;
            }
            return lineToInsert.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "LineToInsert(lineNumberInCompletion=" + this.lineNumberInCompletion + ", whitespaceStart=" + this.whitespaceStart + ", whitespaceEnd=" + this.whitespaceEnd + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.lineNumberInCompletion);
            result2 = result2 * 31 + Integer.hashCode(this.whitespaceStart);
            result2 = result2 * 31 + Integer.hashCode(this.whitespaceEnd);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineToInsert)) {
                return false;
            }
            LineToInsert lineToInsert = (LineToInsert)other;
            if (this.lineNumberInCompletion != lineToInsert.lineNumberInCompletion) {
                return false;
            }
            if (this.whitespaceStart != lineToInsert.whitespaceStart) {
                return false;
            }
            return this.whitespaceEnd == lineToInsert.whitespaceEnd;
        }
    }
}

