/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.action;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.codeInsight.inline.edit.NoInlineEditShownNotifier;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0005\u0006B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/inline/completion/action/CallInlineCompletionAction;", "Lcom/intellij/openapi/editor/actionSystem/EditorAction;", "Lcom/intellij/codeInsight/hint/HintManagerImpl$ActionToIgnore;", "<init>", "()V", "CallInlineCompletionHandler", "ShowNoSuggestionsHintIfNeededHandler", "intellij.platform.ide.codeinsight.inline"})
@ApiStatus.Internal
public final class CallInlineCompletionAction
extends EditorAction
implements HintManagerImpl.ActionToIgnore {
    public CallInlineCompletionAction() {
        super((EditorActionHandler)new CallInlineCompletionHandler());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/inline/completion/action/CallInlineCompletionAction$CallInlineCompletionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "<init>", "()V", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isEnabledForCaret", "", "intellij.platform.ide.codeinsight.inline"})
    public static final class CallInlineCompletionHandler
    extends EditorWriteActionHandler {
        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Caret caret2 = caret;
            if (caret2 == null) {
                Caret caret3 = editor.getCaretModel().getCurrentCaret();
                caret2 = caret3;
                Intrinsics.checkNotNullExpressionValue((Object)caret3, (String)"getCurrentCaret(...)");
            }
            Caret curCaret = caret2;
            InlineCompletionHandler inlineCompletionHandler = InlineCompletion.INSTANCE.getHandlerOrNull(editor);
            if (inlineCompletionHandler == null) {
                return;
            }
            InlineCompletionHandler handler = inlineCompletionHandler;
            handler.invokeEvent(new InlineCompletionEvent.DirectCall(editor, curCaret, dataContext));
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            return InlineCompletion.INSTANCE.getHandlerOrNull(editor) != null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/codeInsight/inline/completion/action/CallInlineCompletionAction$ShowNoSuggestionsHintIfNeededHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isEnabledForCaret", "", "intellij.platform.ide.codeinsight.inline"})
    public static final class ShowNoSuggestionsHintIfNeededHandler
    extends EditorWriteActionHandler {
        @NotNull
        private final EditorActionHandler originalHandler;

        public ShowNoSuggestionsHintIfNeededHandler(@NotNull EditorActionHandler originalHandler) {
            Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
            this.originalHandler = originalHandler;
        }

        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
            block3: {
                DataContext project;
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                if (this.originalHandler.isEnabled(editor, caret, dataContext)) {
                    this.originalHandler.execute(editor, caret, dataContext);
                }
                if (InlineCompletion.INSTANCE.getHandlerOrNull(editor) == null) break block3;
                DataContext dataContext2 = dataContext;
                if (dataContext2 == null || (dataContext2 = (Project)dataContext2.getData(CommonDataKeys.PROJECT)) == null) {
                    dataContext2 = editor.getProject();
                }
                DataContext dataContext3 = project = dataContext2;
                if (dataContext3 != null) {
                    DataContext project2 = dataContext3;
                    boolean bl = false;
                    NoInlineEditShownNotifier.Companion.getInstance((Project)project2).notifyNoSuggestionIfNothingIsShown(editor);
                }
            }
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            return InlineCompletion.INSTANCE.getHandlerOrNull(editor) != null || this.originalHandler.isEnabled(editor, caret, dataContext);
        }
    }
}

