/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.logs;

import com.intellij.codeInsight.inline.completion.InlineCompletionProvider;
import com.intellij.codeInsight.inline.completion.InlineCompletionRequest;
import com.intellij.codeInsight.inline.completion.editor.InlineCompletionEditorType;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionUsageTracker;
import com.intellij.codeInsight.inline.completion.logs.InsertedStateTracker;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionContext;
import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u00016BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"J\u001e\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'J\u0016\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u0015J\u0006\u0010+\u001a\u00020\u001fJ\u0006\u0010,\u001a\u00020\u001fJ\u000e\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/H\u0002J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002J\u0010\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u00067"}, d2={"Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionShowTracker;", "", "request", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;", "requestId", "", "editorType", "Lcom/intellij/codeInsight/inline/completion/editor/InlineCompletionEditorType;", "provider", "Ljava/lang/Class;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionProvider;", "invocationTime", "language", "Lcom/intellij/lang/Language;", "fileLanguage", "<init>", "(Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;JLcom/intellij/codeInsight/inline/completion/editor/InlineCompletionEditorType;Ljava/lang/Class;JLcom/intellij/lang/Language;Lcom/intellij/lang/Language;)V", "data", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "showLogSent", "", "showStartTime", "variantStates", "Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionShowTracker$VariantState;", "lastOffset", "", "switchingVariantsTimes", "potentiallySelectedIndex", "Ljava/lang/Integer;", "firstComputed", "", "variantIndex", "element", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement;", "nextComputed", "suggestionChanged", "change", "newText", "", "variantSwitched", "toIndex", "explicit", "selected", "inserted", "canceled", "finishType", "Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionUsageTracker$ShownEvents$FinishType;", "finish", "getDurations", "", "Ljava/time/Duration;", "extendVariantsNumber", "atLeast", "VariantState", "intellij.platform.ide.codeinsight.inline"})
@SourceDebugExtension(value={"SMAP\nInlineCompletionShowTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionShowTracker.kt\ncom/intellij/codeInsight/inline/completion/logs/InlineCompletionShowTracker\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n42#2,3:168\n1586#3:171\n1661#3,3:172\n1586#3:175\n1661#3,3:176\n1#4:179\n*S KotlinDebug\n*F\n+ 1 InlineCompletionShowTracker.kt\ncom/intellij/codeInsight/inline/completion/logs/InlineCompletionShowTracker\n*L\n98#1:168,3\n120#1:171\n120#1:172,3\n121#1:175\n121#1:176,3\n*E\n"})
public final class InlineCompletionShowTracker {
    @NotNull
    private final InlineCompletionRequest request;
    private final long requestId;
    @NotNull
    private final InlineCompletionEditorType editorType;
    @NotNull
    private final Class<? extends InlineCompletionProvider> provider;
    private final long invocationTime;
    @Nullable
    private final Language language;
    @Nullable
    private final Language fileLanguage;
    @NotNull
    private final List<EventPair<?>> data;
    private boolean showLogSent;
    private long showStartTime;
    @NotNull
    private final List<VariantState> variantStates;
    private int lastOffset;
    private int switchingVariantsTimes;
    @Nullable
    private Integer potentiallySelectedIndex;

    public InlineCompletionShowTracker(@NotNull InlineCompletionRequest request2, long requestId, @NotNull InlineCompletionEditorType editorType, @NotNull Class<? extends InlineCompletionProvider> provider, long invocationTime, @Nullable Language language, @Nullable Language fileLanguage) {
        Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
        Intrinsics.checkNotNullParameter((Object)((Object)editorType), (String)"editorType");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        this.request = request2;
        this.requestId = requestId;
        this.editorType = editorType;
        this.provider = provider;
        this.invocationTime = invocationTime;
        this.language = language;
        this.fileLanguage = fileLanguage;
        this.data = new ArrayList();
        this.variantStates = new ArrayList();
        this.lastOffset = this.request.getEndOffset();
    }

    public final void firstComputed(int variantIndex, @NotNull InlineCompletionElement element) {
        boolean bl;
        VariantState state;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.extendVariantsNumber(variantIndex + 1);
        if (this.potentiallySelectedIndex == null) {
            this.potentiallySelectedIndex = variantIndex;
        }
        if ((state = this.variantStates.get(variantIndex)).getFirstComputed()) {
            throw new IllegalStateException(("First element for " + variantIndex + " index was already computed.").toString());
        }
        state.setFirstComputed(true);
        this.showStartTime = System.currentTimeMillis();
        this.data.add(InlineCompletionUsageTracker.ShownEvents.INSTANCE.getREQUEST_ID().with((Object)this.requestId));
        this.data.add(InlineCompletionUsageTracker.ShownEvents.INSTANCE.getEDITOR_TYPE().with((Object)this.editorType));
        this.data.add(EventFields.Language.with((Object)this.language));
        this.data.add(EventFields.CurrentFile.with((Object)this.fileLanguage));
        this.data.add(InlineCompletionUsageTracker.ShownEvents.INSTANCE.getTIME_TO_SHOW().with((Object)(System.currentTimeMillis() - this.invocationTime)));
        this.data.add(InlineCompletionUsageTracker.ShownEvents.INSTANCE.getPROVIDER().with(this.provider));
        this.nextComputed(variantIndex, element);
        boolean bl2 = bl = !this.showLogSent;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void nextComputed(int variantIndex, @NotNull InlineCompletionElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VariantState state = this.variantStates.get(variantIndex);
        int n = state.getFirstComputed();
        if (_Assertions.ENABLED && n == 0) {
            boolean bl = false;
            String string = "Call firstComputed firstly";
            throw new AssertionError((Object)string);
        }
        state.setLines(state.getLines() + RangesKt.coerceAtLeast((int)(StringsKt.lines((CharSequence)element.getText()).size() - 1), (int)0));
        if (((CharSequence)state.getInitialSuggestion()).length() == 0 && ((CharSequence)element.getText()).length() > 0) {
            n = state.getLines();
            state.setLines(n + 1);
        }
        state.append(element.getText());
        int n2 = n = !this.showLogSent ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void suggestionChanged(int variantIndex, int change, @NotNull String newText) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        VariantState state = this.variantStates.get(variantIndex);
        state.setLengthChange(state.getLengthChange() + change);
        state.setFinalSuggestion(newText);
        InlineCompletionContext inlineCompletionContext = InlineCompletionContext.Companion.getOrNull(this.request.getEditor());
        Intrinsics.checkNotNull((Object)((Object)inlineCompletionContext));
        this.lastOffset = inlineCompletionContext.getExpectedStartOffset$intellij_platform_ide_codeinsight_inline();
        boolean bl2 = bl = !this.showLogSent;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void variantSwitched(int toIndex, boolean explicit) {
        this.potentiallySelectedIndex = toIndex;
        if (explicit) {
            int n = this.switchingVariantsTimes;
            this.switchingVariantsTimes = n + 1;
        }
    }

    public final void selected() {
        this.finish(InlineCompletionUsageTracker.ShownEvents.FinishType.SELECTED);
    }

    public final void inserted() {
        block1: {
            Integer n = this.potentiallySelectedIndex;
            if (n == null) break block1;
            int it = ((Number)n).intValue();
            boolean bl = false;
            boolean $i$f$service = false;
            Class<InsertedStateTracker> serviceClass$iv = InsertedStateTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((InsertedStateTracker)object).track(this.requestId, this.language, this.fileLanguage, this.request.getEditor(), this.request.getEndOffset(), this.lastOffset, this.variantStates.get(it).getFinalSuggestion(), this.getDurations());
        }
    }

    public final void canceled(@NotNull InlineCompletionUsageTracker.ShownEvents.FinishType finishType) {
        Intrinsics.checkNotNullParameter((Object)((Object)finishType), (String)"finishType");
        this.finish(finishType);
    }

    private final void finish(InlineCompletionUsageTracker.ShownEvents.FinishType finishType) {
        VariantState it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (this.showLogSent) {
            return;
        }
        this.showLogSent = true;
        Iterable iterable = this.variantStates;
        Object object2 = InlineCompletionUsageTracker.ShownEvents.INSTANCE.getLINES();
        List<EventPair<?>> list = this.data;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            VariantState variantState = (VariantState)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getLines());
        }
        object = (List)destination$iv$iv;
        list.add(object2.with(object));
        $this$map$iv = this.variantStates;
        object2 = InlineCompletionUsageTracker.ShownEvents.INSTANCE.getLENGTH();
        list = this.data;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (VariantState)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getInitialSuggestion().length());
        }
        object = (List)destination$iv$iv;
        list.add(object2.with(object));
        iterable = this.variantStates;
        object2 = InlineCompletionUsageTracker.ShownEvents.INSTANCE.getLENGTH_CHANGE_DURING_SHOW();
        list = this.data;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Object it2 = (VariantState)iterator.next();
        boolean bl = false;
        it2 = ((VariantState)it2).getLengthChange();
        while (iterator.hasNext()) {
            Object it3 = (VariantState)iterator.next();
            $i$a$-maxOf-InlineCompletionShowTracker$finish$3 = false;
            if (it2.compareTo(it3 = (Comparable)Integer.valueOf(((VariantState)it3).getLengthChange())) >= 0) continue;
            it2 = it3;
        }
        object = it2;
        list.add(object2.with(object));
        this.data.add(InlineCompletionUsageTracker.ShownEvents.INSTANCE.getSHOWING_TIME().with((Object)(System.currentTimeMillis() - this.showStartTime)));
        this.data.add(InlineCompletionUsageTracker.ShownEvents.INSTANCE.getFINISH_TYPE().with((Object)finishType));
        this.data.add(InlineCompletionUsageTracker.ShownEvents.INSTANCE.getEXPLICIT_SWITCHING_VARIANTS_TIMES().with((Object)this.switchingVariantsTimes));
        if (finishType == InlineCompletionUsageTracker.ShownEvents.FinishType.SELECTED || finishType == InlineCompletionUsageTracker.ShownEvents.FinishType.TYPED) {
            Integer n = this.potentiallySelectedIndex;
            if (n != null) {
                int it4 = ((Number)n).intValue();
                boolean bl2 = false;
                this.data.add(InlineCompletionUsageTracker.ShownEvents.INSTANCE.getSELECTED_INDEX().with((Object)it4));
            }
        }
        InlineCompletionUsageTracker.INSTANCE.getSHOWN_EVENT$intellij_platform_ide_codeinsight_inline().log(this.request.getEditor().getProject(), this.data);
    }

    private final List<Duration> getDurations() {
        List list;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            list = CollectionsKt.listOf((Object)Duration.ofMillis(100L));
        } else {
            Object[] objectArray = new Duration[]{Duration.ofSeconds(10L), Duration.ofSeconds(30L), Duration.ofMinutes(1L), Duration.ofMinutes(5L)};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return list;
    }

    private final void extendVariantsNumber(int atLeast) {
        while (this.variantStates.size() < atLeast) {
            ((Collection)this.variantStates).add(new VariantState("", "", 0, 0, false));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\f\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J;\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0014\u0010%\u001a\u00020\t2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010'\u001a\u00020\u0006H\u00d6\u0081\u0004J\n\u0010(\u001a\u00020\u0003H\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionShowTracker$VariantState;", "", "initialSuggestion", "", "finalSuggestion", "lines", "", "lengthChange", "firstComputed", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;IIZ)V", "getInitialSuggestion", "()Ljava/lang/String;", "setInitialSuggestion", "(Ljava/lang/String;)V", "getFinalSuggestion", "setFinalSuggestion", "getLines", "()I", "setLines", "(I)V", "getLengthChange", "setLengthChange", "getFirstComputed", "()Z", "setFirstComputed", "(Z)V", "append", "", "text", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "intellij.platform.ide.codeinsight.inline"})
    private static final class VariantState {
        @NotNull
        private String initialSuggestion;
        @NotNull
        private String finalSuggestion;
        private int lines;
        private int lengthChange;
        private boolean firstComputed;

        public VariantState(@NotNull String initialSuggestion, @NotNull String finalSuggestion, int lines, int lengthChange, boolean firstComputed) {
            Intrinsics.checkNotNullParameter((Object)initialSuggestion, (String)"initialSuggestion");
            Intrinsics.checkNotNullParameter((Object)finalSuggestion, (String)"finalSuggestion");
            this.initialSuggestion = initialSuggestion;
            this.finalSuggestion = finalSuggestion;
            this.lines = lines;
            this.lengthChange = lengthChange;
            this.firstComputed = firstComputed;
        }

        @NotNull
        public final String getInitialSuggestion() {
            return this.initialSuggestion;
        }

        public final void setInitialSuggestion(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.initialSuggestion = string;
        }

        @NotNull
        public final String getFinalSuggestion() {
            return this.finalSuggestion;
        }

        public final void setFinalSuggestion(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.finalSuggestion = string;
        }

        public final int getLines() {
            return this.lines;
        }

        public final void setLines(int n) {
            this.lines = n;
        }

        public final int getLengthChange() {
            return this.lengthChange;
        }

        public final void setLengthChange(int n) {
            this.lengthChange = n;
        }

        public final boolean getFirstComputed() {
            return this.firstComputed;
        }

        public final void setFirstComputed(boolean bl) {
            this.firstComputed = bl;
        }

        public final void append(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.initialSuggestion = this.initialSuggestion + text;
            this.finalSuggestion = this.finalSuggestion + text;
        }

        @NotNull
        public final String component1() {
            return this.initialSuggestion;
        }

        @NotNull
        public final String component2() {
            return this.finalSuggestion;
        }

        public final int component3() {
            return this.lines;
        }

        public final int component4() {
            return this.lengthChange;
        }

        public final boolean component5() {
            return this.firstComputed;
        }

        @NotNull
        public final VariantState copy(@NotNull String initialSuggestion, @NotNull String finalSuggestion, int lines, int lengthChange, boolean firstComputed) {
            Intrinsics.checkNotNullParameter((Object)initialSuggestion, (String)"initialSuggestion");
            Intrinsics.checkNotNullParameter((Object)finalSuggestion, (String)"finalSuggestion");
            return new VariantState(initialSuggestion, finalSuggestion, lines, lengthChange, firstComputed);
        }

        public static /* synthetic */ VariantState copy$default(VariantState variantState, String string, String string2, int n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = variantState.initialSuggestion;
            }
            if ((n3 & 2) != 0) {
                string2 = variantState.finalSuggestion;
            }
            if ((n3 & 4) != 0) {
                n = variantState.lines;
            }
            if ((n3 & 8) != 0) {
                n2 = variantState.lengthChange;
            }
            if ((n3 & 0x10) != 0) {
                bl = variantState.firstComputed;
            }
            return variantState.copy(string, string2, n, n2, bl);
        }

        @NotNull
        public String toString() {
            return "VariantState(initialSuggestion=" + this.initialSuggestion + ", finalSuggestion=" + this.finalSuggestion + ", lines=" + this.lines + ", lengthChange=" + this.lengthChange + ", firstComputed=" + this.firstComputed + ")";
        }

        public int hashCode() {
            int result2 = this.initialSuggestion.hashCode();
            result2 = result2 * 31 + this.finalSuggestion.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.lines);
            result2 = result2 * 31 + Integer.hashCode(this.lengthChange);
            result2 = result2 * 31 + Boolean.hashCode(this.firstComputed);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VariantState)) {
                return false;
            }
            VariantState variantState = (VariantState)other;
            if (!Intrinsics.areEqual((Object)this.initialSuggestion, (Object)variantState.initialSuggestion)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.finalSuggestion, (Object)variantState.finalSuggestion)) {
                return false;
            }
            if (this.lines != variantState.lines) {
                return false;
            }
            if (this.lengthChange != variantState.lengthChange) {
                return false;
            }
            return this.firstComputed == variantState.firstComputed;
        }
    }
}

