/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.render;

import com.intellij.codeInsight.inline.completion.render.InlineCompletionComponentFactory;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionRenderTextBlock;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionVolumetricTextBlockFactory;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionVolumetricTextBlockFactoryKt;
import com.intellij.codeInsight.inline.completion.render.VolumetricInlineCompletionTextBlock;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 62\u00020\u0001:\u000256B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ*\u0010\u000f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0018\u00010\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J>\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u00072\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J^\u0010\u001d\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0018\u00010\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J^\u0010#\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0018\u00010\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002Jf\u0010$\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0018\u00010\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010&2\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0017H\u0002J\u0016\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0002J\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u000204H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u00067"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionSoftWrapManager;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "arrows", "Lkotlin/Pair;", "", "getArrows", "()Lkotlin/Pair;", "arrows$delegate", "Lkotlin/Lazy;", "getSoftWrapModelIfEnabled", "Lcom/intellij/openapi/editor/impl/SoftWrapModelImpl;", "softWrap", "", "Lcom/intellij/codeInsight/inline/completion/render/VolumetricInlineCompletionTextBlock;", "lines", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionSoftWrapManager$RenderedLine;", "volumetricFactory", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionVolumetricTextBlockFactory;", "isEditorWideEnough", "", "editorWidth", "", "splitByAvailableWidth", "blocks", "availableWidth", "trySplitByWhitespace", "blocksPrefix", "blocksSuffix", "currentBlock", "prefixWidth", "", "trySplitByAnyCharacter", "trySplit", "toLeft", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionRenderTextBlock;", "toRight", "getSoftWrapArrow", "type", "Lcom/intellij/openapi/editor/impl/softwrap/SoftWrapDrawingType;", "areArrowsOnly", "dispose", "", "isSoftWrappingEnabled", "chooseArrows", "canDisplay", "char", "", "getArrowAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "RenderedLine", "Companion", "intellij.platform.ide.codeinsight.inline"})
@SourceDebugExtension(value={"SMAP\nInlineCompletionSoftWrapManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionSoftWrapManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionSoftWrapManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,363:1\n1#2:364\n161#3,6:365\n1786#4,3:371\n*S KotlinDebug\n*F\n+ 1 InlineCompletionSoftWrapManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionSoftWrapManager\n*L\n245#1:365,6\n317#1:371,3\n*E\n"})
public final class InlineCompletionSoftWrapManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Lazy arrows$delegate;
    @NotNull
    private static final List<Pair<Character, Character>> ARROW_CANDIDATES;
    @NotNull
    private static final Key<InlineCompletionSoftWrapManager> KEY;

    private InlineCompletionSoftWrapManager(Editor editor) {
        this.editor = editor;
        this.arrows$delegate = LazyKt.lazy(() -> InlineCompletionSoftWrapManager.arrows_delegate$lambda$0(this));
    }

    private final Pair<String, String> getArrows() {
        Lazy lazy = this.arrows$delegate;
        return (Pair)lazy.getValue();
    }

    @Nullable
    public final SoftWrapModelImpl getSoftWrapModelIfEnabled() {
        if (!this.isSoftWrappingEnabled()) {
            return null;
        }
        SoftWrapModel softWrapModel = this.editor.getSoftWrapModel();
        return softWrapModel instanceof SoftWrapModelImpl ? (SoftWrapModelImpl)softWrapModel : null;
    }

    @Nullable
    public final List<List<VolumetricInlineCompletionTextBlock>> softWrap(@NotNull List<RenderedLine> lines, @NotNull InlineCompletionVolumetricTextBlockFactory volumetricFactory) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)volumetricFactory, (String)"volumetricFactory");
        SoftWrapModelImpl softWrapModelImpl = this.getSoftWrapModelIfEnabled();
        if (softWrapModelImpl == null) {
            return null;
        }
        SoftWrapModelImpl softWrapModel = softWrapModelImpl;
        int visibleAreaWidth = softWrapModel.getApplianceManager().getWidthProvider().getVisibleAreaWidth();
        if (!this.isEditorWideEnough(visibleAreaWidth, volumetricFactory)) {
            return null;
        }
        LinkedList<RenderedLine> linesToFix = new LinkedList<RenderedLine>((Collection)lines);
        List resultLines = new ArrayList();
        while (!((Collection)linesToFix).isEmpty()) {
            RenderedLine line = (RenderedLine)CollectionsKt.first((List)linesToFix);
            List<VolumetricInlineCompletionTextBlock> blocks = line.getBlocks();
            if (blocks.isEmpty()) {
                resultLines.add(blocks);
                linesToFix.removeFirst();
                continue;
            }
            int startX = line.getStartX();
            int editorAvailableLineWidth = visibleAreaWidth - startX;
            Pair<List<VolumetricInlineCompletionTextBlock>, List<VolumetricInlineCompletionTextBlock>> pair = this.splitByAvailableWidth(blocks, editorAvailableLineWidth, volumetricFactory);
            List leftSplitPart = (List)pair.component1();
            List rightSplitPart = (List)pair.component2();
            if (rightSplitPart.isEmpty()) {
                ((Collection)resultLines).add(leftSplitPart);
                linesToFix.removeFirst();
                continue;
            }
            if (leftSplitPart.isEmpty()) {
                if (startX > 0) {
                    resultLines.add(CollectionsKt.emptyList());
                    linesToFix.removeFirst();
                    linesToFix.addFirst(new RenderedLine(blocks, 0));
                    continue;
                }
                resultLines.add(blocks);
                linesToFix.removeFirst();
                continue;
            }
            if (this.areArrowsOnly(leftSplitPart)) {
                resultLines.add(blocks);
                linesToFix.removeFirst();
                continue;
            }
            resultLines.add(leftSplitPart);
            linesToFix.removeFirst();
            linesToFix.addFirst(new RenderedLine(rightSplitPart, 0));
        }
        return resultLines;
    }

    private final boolean isEditorWideEnough(int editorWidth, InlineCompletionVolumetricTextBlockFactory volumetricFactory) {
        InlineCompletionRenderTextBlock block = new InlineCompletionRenderTextBlock("abc", new TextAttributes());
        VolumetricInlineCompletionTextBlock volumetricBlock = volumetricFactory.getVolumetric(block);
        return volumetricBlock.getWidthInPixels() <= (double)editorWidth;
    }

    private final Pair<List<VolumetricInlineCompletionTextBlock>, List<VolumetricInlineCompletionTextBlock>> splitByAvailableWidth(List<VolumetricInlineCompletionTextBlock> blocks, int availableWidth, InlineCompletionVolumetricTextBlockFactory volumetricFactory) {
        double width;
        if (blocks.isEmpty()) {
            return TuplesKt.to(blocks, (Object)CollectionsKt.emptyList());
        }
        int currentIndex = 0;
        double currentWidth = 0.0;
        Iterator<VolumetricInlineCompletionTextBlock> iterator = blocks.iterator();
        while (iterator.hasNext() && InlineCompletionVolumetricTextBlockFactory.Companion.accumulatedWidthToInt$intellij_platform_ide_codeinsight_inline(currentWidth += (width = iterator.next().component2())) <= availableWidth) {
            ++currentIndex;
        }
        if (InlineCompletionVolumetricTextBlockFactory.Companion.accumulatedWidthToInt$intellij_platform_ide_codeinsight_inline(currentWidth) <= availableWidth) {
            return TuplesKt.to(blocks, (Object)CollectionsKt.emptyList());
        }
        if (!(currentIndex < blocks.size())) {
            throw new IllegalStateException("Check failed.");
        }
        Pair<List<VolumetricInlineCompletionTextBlock>, List<VolumetricInlineCompletionTextBlock>> potentialResultIfNoWhitespace = null;
        while (currentIndex >= 0) {
            VolumetricInlineCompletionTextBlock currentBlock;
            List<VolumetricInlineCompletionTextBlock> blocksSuffix;
            List<VolumetricInlineCompletionTextBlock> blocksPrefix = blocks.subList(0, currentIndex);
            Pair<List<VolumetricInlineCompletionTextBlock>, List<VolumetricInlineCompletionTextBlock>> pair = this.trySplitByWhitespace(blocksPrefix, blocksSuffix = blocks.subList(currentIndex + 1, blocks.size()), currentBlock = blocks.get(currentIndex), currentWidth -= blocks.get(currentIndex).getWidthInPixels(), availableWidth, volumetricFactory);
            if (pair != null) {
                Pair<List<VolumetricInlineCompletionTextBlock>, List<VolumetricInlineCompletionTextBlock>> it = pair;
                boolean bl = false;
                return it;
            }
            if (potentialResultIfNoWhitespace == null) {
                potentialResultIfNoWhitespace = this.trySplitByAnyCharacter(blocksPrefix, blocksSuffix, currentBlock, currentWidth, availableWidth, volumetricFactory);
            }
            --currentIndex;
        }
        if (potentialResultIfNoWhitespace != null) {
            return potentialResultIfNoWhitespace;
        }
        return TuplesKt.to((Object)CollectionsKt.emptyList(), blocks);
    }

    private final Pair<List<VolumetricInlineCompletionTextBlock>, List<VolumetricInlineCompletionTextBlock>> trySplitByWhitespace(List<VolumetricInlineCompletionTextBlock> blocksPrefix, List<VolumetricInlineCompletionTextBlock> blocksSuffix, VolumetricInlineCompletionTextBlock currentBlock, double prefixWidth, int availableWidth, InlineCompletionVolumetricTextBlockFactory volumetricFactory) {
        String text = currentBlock.getBlock().getText();
        int currentCharIndex = text.length() - 1;
        while (currentCharIndex >= 0) {
            int splitStart;
            if (!CharsKt.isWhitespace((char)text.charAt(currentCharIndex))) {
                --currentCharIndex;
                continue;
            }
            for (splitStart = currentCharIndex; splitStart >= 0 && CharsKt.isWhitespace((char)text.charAt(splitStart)); --splitStart) {
            }
            String string = text.substring(0, splitStart + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            InlineCompletionRenderTextBlock left = new InlineCompletionRenderTextBlock(string, currentBlock.getBlock().getAttributes());
            String string2 = text.substring(currentCharIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            InlineCompletionRenderTextBlock right = new InlineCompletionRenderTextBlock(string2, currentBlock.getBlock().getAttributes());
            Pair<List<VolumetricInlineCompletionTextBlock>, List<VolumetricInlineCompletionTextBlock>> pair = this.trySplit(blocksPrefix, blocksSuffix, left, right, prefixWidth, availableWidth, volumetricFactory);
            if (pair != null) {
                Pair<List<VolumetricInlineCompletionTextBlock>, List<VolumetricInlineCompletionTextBlock>> it = pair;
                boolean bl = false;
                return it;
            }
            currentCharIndex = splitStart;
        }
        return null;
    }

    private final Pair<List<VolumetricInlineCompletionTextBlock>, List<VolumetricInlineCompletionTextBlock>> trySplitByAnyCharacter(List<VolumetricInlineCompletionTextBlock> blocksPrefix, List<VolumetricInlineCompletionTextBlock> blocksSuffix, VolumetricInlineCompletionTextBlock currentBlock, double prefixWidth, int availableWidth, InlineCompletionVolumetricTextBlockFactory volumetricFactory) {
        int searchLimit;
        int n;
        Object $this$indexOfFirst$iv;
        String text;
        block2: {
            text = currentBlock.getBlock().getText();
            $this$indexOfFirst$iv = text;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!CharsKt.isWhitespace((char)it)) continue;
                n = index$iv;
                break block2;
            }
            n = -1;
        }
        $this$indexOfFirst$iv = n;
        int it = ((Number)$this$indexOfFirst$iv).intValue();
        boolean bl = false;
        Object object = it >= 0 ? $this$indexOfFirst$iv : null;
        for (int currentCharIndex = searchLimit = (v37741) != null ? ((Integer)(v37741)).intValue() : text.length(); 0 < currentCharIndex; --currentCharIndex) {
            String string = text.substring(0, currentCharIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            InlineCompletionRenderTextBlock left = new InlineCompletionRenderTextBlock(string, currentBlock.getBlock().getAttributes());
            String string2 = text.substring(currentCharIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            InlineCompletionRenderTextBlock right = new InlineCompletionRenderTextBlock(string2, currentBlock.getBlock().getAttributes());
            Pair<List<VolumetricInlineCompletionTextBlock>, List<VolumetricInlineCompletionTextBlock>> pair = this.trySplit(blocksPrefix, blocksSuffix, left, right, prefixWidth, availableWidth, volumetricFactory);
            if (pair == null) continue;
            Pair<List<VolumetricInlineCompletionTextBlock>, List<VolumetricInlineCompletionTextBlock>> it2 = pair;
            boolean bl2 = false;
            return it2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<VolumetricInlineCompletionTextBlock>, List<VolumetricInlineCompletionTextBlock>> trySplit(List<VolumetricInlineCompletionTextBlock> blocksPrefix, List<VolumetricInlineCompletionTextBlock> blocksSuffix, InlineCompletionRenderTextBlock toLeft, InlineCompletionRenderTextBlock toRight, double prefixWidth, int availableWidth, InlineCompletionVolumetricTextBlockFactory volumetricFactory) {
        double d;
        Object[] objectArray = new InlineCompletionRenderTextBlock[]{((CharSequence)toLeft.getText()).length() > 0 ? new InlineCompletionRenderTextBlock(toLeft.getText(), toLeft.getAttributes()) : null, this.getSoftWrapArrow(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED)};
        List<VolumetricInlineCompletionTextBlock> leftBlocks = InlineCompletionVolumetricTextBlockFactoryKt.toVolumetric(CollectionsKt.listOfNotNull((Object[])objectArray), volumetricFactory);
        Iterable iterable = leftBlocks;
        InlineCompletionVolumetricTextBlockFactory.Companion companion = InlineCompletionVolumetricTextBlockFactory.Companion;
        double d2 = 0.0;
        for (Object t : iterable) {
            void it;
            VolumetricInlineCompletionTextBlock volumetricInlineCompletionTextBlock = (VolumetricInlineCompletionTextBlock)t;
            d = d2;
            boolean bl = false;
            double d3 = it.getWidthInPixels();
            d2 = d + d3;
        }
        d = d2;
        int leftWidth = companion.accumulatedWidthToInt$intellij_platform_ide_codeinsight_inline(d);
        if (InlineCompletionVolumetricTextBlockFactory.Companion.accumulatedWidthToInt$intellij_platform_ide_codeinsight_inline(prefixWidth + (double)leftWidth) <= availableWidth) {
            Object[] objectArray2 = new InlineCompletionRenderTextBlock[]{this.getSoftWrapArrow(SoftWrapDrawingType.AFTER_SOFT_WRAP), ((CharSequence)toRight.getText()).length() > 0 ? new InlineCompletionRenderTextBlock(toRight.getText(), toRight.getAttributes()) : null};
            List<VolumetricInlineCompletionTextBlock> rightBlocks = InlineCompletionVolumetricTextBlockFactoryKt.toVolumetric(CollectionsKt.listOfNotNull((Object[])objectArray2), volumetricFactory);
            List finalLeft = CollectionsKt.plus((Collection)blocksPrefix, (Iterable)leftBlocks);
            List finalRight = CollectionsKt.plus((Collection)rightBlocks, (Iterable)blocksSuffix);
            return TuplesKt.to((Object)finalLeft, (Object)finalRight);
        }
        return null;
    }

    private final InlineCompletionRenderTextBlock getSoftWrapArrow(SoftWrapDrawingType type) {
        Pair<String, String> pair = this.getArrows();
        if (pair == null) {
            return null;
        }
        Pair<String, String> arrows = pair;
        String text = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> (String)arrows.getFirst();
            case 2 -> (String)arrows.getSecond();
            default -> throw new NoWhenBranchMatchedException();
        };
        return new InlineCompletionRenderTextBlock(text, this.getArrowAttributes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean areArrowsOnly(List<VolumetricInlineCompletionTextBlock> $this$areArrowsOnly) {
        boolean bl;
        Iterable $this$all$iv = $this$areArrowsOnly;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            VolumetricInlineCompletionTextBlock it = (VolumetricInlineCompletionTextBlock)element$iv;
            boolean bl2 = false;
            Pair<String, String> pair = this.getArrows();
            if (!Intrinsics.areEqual((Object)it.getBlock().getText(), (Object)(pair != null ? (String)pair.getFirst() : null))) {
                Pair<String, String> pair2 = this.getArrows();
                if (!Intrinsics.areEqual((Object)it.getBlock().getText(), (Object)(pair2 != null ? (String)pair2.getSecond() : null))) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    public void dispose() {
    }

    private final boolean isSoftWrappingEnabled() {
        return this.editor.getSoftWrapModel().isSoftWrappingEnabled() && this.editor.getSoftWrapModel() instanceof SoftWrapModelImpl;
    }

    private final Pair<String, String> chooseArrows() {
        Pair pair;
        Object v0;
        block3: {
            Iterable iterable = ARROW_CANDIDATES;
            for (Object t : iterable) {
                Pair it = (Pair)t;
                boolean bl = false;
                if (!(this.canDisplay(((Character)it.getFirst()).charValue()) && this.canDisplay(((Character)it.getSecond()).charValue()))) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Pair pair2 = v0;
        if (pair2 != null) {
            Pair it = pair2;
            boolean bl = false;
            pair = TuplesKt.to((Object)String.valueOf(((Character)it.getFirst()).charValue()), (Object)String.valueOf(((Character)it.getSecond()).charValue()));
        } else {
            pair = null;
        }
        return pair;
    }

    private final boolean canDisplay(char c) {
        FontInfo fontInfo = EditorUtil.fontForChar((char)c, (int)0, (Editor)this.editor);
        Intrinsics.checkNotNullExpressionValue((Object)fontInfo, (String)"fontForChar(...)");
        FontInfo fontInfo2 = fontInfo;
        return fontInfo2.canDisplay((int)c);
    }

    private final TextAttributes getArrowAttributes() {
        TextAttributes textAttributes = this.editor.getColorsScheme().getAttributes(HighlighterColors.TEXT);
        if (textAttributes == null || (textAttributes = textAttributes.clone()) == null) {
            textAttributes = new TextAttributes();
        }
        TextAttributes base = textAttributes;
        Color color = base.getForegroundColor();
        if (color == null) {
            return base;
        }
        Color color2 = color;
        base.setForegroundColor(ColorUtil.withAlpha((Color)color2, (double)((double)color2.getAlpha() / 255.0 * 0.8)));
        return base;
    }

    private static final Pair arrows_delegate$lambda$0(InlineCompletionSoftWrapManager this$0) {
        return this$0.chooseArrows();
    }

    public /* synthetic */ InlineCompletionSoftWrapManager(Editor editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\u2926'), (Object)Character.valueOf('\u2925')), TuplesKt.to((Object)Character.valueOf('\u21b2'), (Object)Character.valueOf('\u21b3')), TuplesKt.to((Object)Character.valueOf('\u2936'), (Object)Character.valueOf('\u2937')), TuplesKt.to((Object)Character.valueOf('\u21a9'), (Object)Character.valueOf('\u21aa')), TuplesKt.to((Object)Character.valueOf('\ue48b'), (Object)Character.valueOf('\ue48c'))};
        ARROW_CANDIDATES = CollectionsKt.listOf((Object[])objectArray);
        KEY = new Key("inline.completion.soft.wrap.manager");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionSoftWrapManager$Companion;", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionComponentFactory;", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionSoftWrapManager;", "<init>", "()V", "ARROW_CANDIDATES", "", "Lkotlin/Pair;", "", "KEY", "Lcom/intellij/openapi/util/Key;", "key", "getKey", "()Lcom/intellij/openapi/util/Key;", "create", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.ide.codeinsight.inline"})
    public static final class Companion
    extends InlineCompletionComponentFactory<InlineCompletionSoftWrapManager> {
        private Companion() {
        }

        @Override
        @NotNull
        protected Key<InlineCompletionSoftWrapManager> getKey() {
            return KEY;
        }

        @Override
        @NotNull
        protected InlineCompletionSoftWrapManager create(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return new InlineCompletionSoftWrapManager(editor, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionSoftWrapManager$RenderedLine;", "", "blocks", "", "Lcom/intellij/codeInsight/inline/completion/render/VolumetricInlineCompletionTextBlock;", "startX", "", "<init>", "(Ljava/util/List;I)V", "getBlocks", "()Ljava/util/List;", "getStartX", "()I", "intellij.platform.ide.codeinsight.inline"})
    public static final class RenderedLine {
        @NotNull
        private final List<VolumetricInlineCompletionTextBlock> blocks;
        private final int startX;

        public RenderedLine(@NotNull List<VolumetricInlineCompletionTextBlock> blocks, int startX) {
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            this.blocks = blocks;
            this.startX = startX;
        }

        @NotNull
        public final List<VolumetricInlineCompletionTextBlock> getBlocks() {
            return this.blocks;
        }

        public final int getStartX() {
            return this.startX;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SoftWrapDrawingType.values().length];
            try {
                nArray[SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoftWrapDrawingType.AFTER_SOFT_WRAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

