/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.render;

import com.intellij.codeInsight.inline.completion.render.InlineCompletionEditorTextUtils;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionFoldingManager;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionInlayRenderer;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionLineRenderer;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionRenderTextBlock;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionSoftWrapManager;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionVolumetricTextBlockFactory;
import com.intellij.codeInsight.inline.completion.render.RenderedInlineCompletionElementDescriptor;
import com.intellij.codeInsight.inline.completion.render.VolumetricInlineCompletionTextBlock;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHint;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHintKt;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0004\u001f !\"B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u001d\u001a\u00020\bH\u0002J\b\u0010\u001e\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "renderOffset", "", "onDispose", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;ILkotlin/jvm/functions/Function0;)V", "renderer", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Renderer;", "elementsCounter", "isActive", "", "requests", "", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Request;", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "append", "Lcom/intellij/codeInsight/inline/completion/render/RenderedInlineCompletionElementDescriptor;", "text", "", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "initialOffset", "cleanUp", "rerender", "Request", "UpdateOnResizeListener", "Renderer", "Companion", "intellij.platform.ide.codeinsight.inline"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInlineCompletionTextRenderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionTextRenderManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,542:1\n1#2:543\n23#3:544\n*S KotlinDebug\n*F\n+ 1 InlineCompletionTextRenderManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager\n*L\n478#1:544\n*E\n"})
public final class InlineCompletionTextRenderManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    private final int renderOffset;
    @NotNull
    private final Function0<Unit> onDispose;
    @NotNull
    private Renderer renderer;
    private int elementsCounter;
    private boolean isActive;
    @NotNull
    private final List<Request> requests;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private static final Key<Companion.Storage<Integer, InlineCompletionTextRenderManager>> STORAGE_KEY;
    @NotNull
    private static final Key<Unit> FOLDED_BLOCK_KEY;
    @NotNull
    private static final Logger LOG;

    private InlineCompletionTextRenderManager(Editor editor, int renderOffset, Function0<Unit> onDispose) {
        this.editor = editor;
        this.renderOffset = renderOffset;
        this.onDispose = onDispose;
        this.renderer = new Renderer(this.editor, this.renderOffset);
        this.isActive = true;
        this.requests = new ArrayList();
        Disposable disposable = Disposer.newDisposable((String)"[Inline Completion] text renderer manager");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)new UpdateOnResizeListener(), this.disposable);
    }

    private final RenderedInlineCompletionElementDescriptor append(String text, TextAttributes attributes, int initialOffset, Disposable disposable) {
        if (!this.isActive) {
            boolean bl = false;
            String string = "Cannot render an element since the renderer is already disposed.";
            throw new IllegalStateException(string.toString());
        }
        int n = this.elementsCounter;
        this.elementsCounter = n + 1;
        Request renderRequest = new Request(text, attributes, initialOffset, true);
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> InlineCompletionTextRenderManager.append$lambda$1(renderRequest, this));
        ((Collection)this.requests).add(renderRequest);
        return this.renderer.append(text, attributes, initialOffset);
    }

    private final void cleanUp() {
        this.isActive = false;
        Disposer.dispose((Disposable)this.renderer);
        Disposer.dispose((Disposable)this.disposable);
        this.requests.clear();
        this.onDispose.invoke();
    }

    private final void rerender() {
        Disposer.dispose((Disposable)this.renderer);
        this.renderer = new Renderer(this.editor, this.renderOffset);
        for (Request request2 : this.requests) {
            if (!request2.isActive()) continue;
            this.renderer.append(request2.getText(), request2.getAttributes(), request2.getInitialOffset());
        }
    }

    private static final Unit append$lambda$1(Request $renderRequest, InlineCompletionTextRenderManager this$0) {
        $renderRequest.setActive(false);
        ThreadingAssertions.assertEventDispatchThread();
        int n = this$0.elementsCounter;
        this$0.elementsCounter = n + -1;
        if (this$0.elementsCounter == 0) {
            this$0.cleanUp();
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ InlineCompletionTextRenderManager(Editor editor, int renderOffset, Function0 onDispose, DefaultConstructorMarker $constructor_marker) {
        this(editor, renderOffset, (Function0<Unit>)onDispose);
    }

    static {
        Key key = Key.create((String)"inline.completion.text.render");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        STORAGE_KEY = key;
        Key key2 = Key.create((String)"inline.completion.folded.block.marker");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        FOLDED_BLOCK_KEY = key2;
        Companion $this$thisLogger$iv = Companion;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R9\u0010\u0004\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b \t*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f0\u0005\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Companion;", "", "<init>", "()V", "STORAGE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Companion$Storage;", "", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "FOLDED_BLOCK_KEY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "render", "Lcom/intellij/codeInsight/inline/completion/render/RenderedInlineCompletionElementDescriptor;", "editor", "Lcom/intellij/openapi/editor/Editor;", "text", "", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "offset", "disposable", "Lcom/intellij/openapi/Disposable;", "render$intellij_platform_ide_codeinsight_inline", "requestRerendering", "Storage", "intellij.platform.ide.codeinsight.inline"})
    @SourceDebugExtension(value={"SMAP\nInlineCompletionTextRenderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionTextRenderManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,542:1\n1068#2:543\n1915#2,2:544\n*S KotlinDebug\n*F\n+ 1 InlineCompletionTextRenderManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Companion\n*L\n512#1:543\n512#1:544,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @ApiStatus.Experimental
        @RequiresEdt
        @NotNull
        public final RenderedInlineCompletionElementDescriptor render$intellij_platform_ide_codeinsight_inline(@NotNull Editor editor, @NotNull String text, @NotNull TextAttributes attributes, int offset, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            ThreadingAssertions.assertEventDispatchThread();
            int actualOffset = ((InlineCompletionFoldingManager)InlineCompletionFoldingManager.Companion.get(editor)).offsetOfFoldStart(offset);
            Storage storage = (Storage)editor.getUserData(STORAGE_KEY);
            if (storage == null) {
                storage = new Storage();
            }
            Storage storage2 = storage;
            editor.putUserData(STORAGE_KEY, (Object)storage2);
            InlineCompletionTextRenderManager renderer = (InlineCompletionTextRenderManager)storage2.getOrInitialize(actualOffset, () -> Companion.render$lambda$0(editor, actualOffset, storage2));
            return renderer.append(text, attributes, offset, disposable);
        }

        @ApiStatus.Internal
        @RequiresEdt
        public final void requestRerendering(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            ThreadingAssertions.assertEventDispatchThread();
            Storage storage = (Storage)editor.getUserData(STORAGE_KEY);
            if (storage == null) {
                return;
            }
            Storage storage2 = storage;
            Iterable $this$sortedBy$iv = storage2.allEntries();
            boolean $i$f$sortedBy = false;
            Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getFirst();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                InlineCompletionTextRenderManager renderer = (InlineCompletionTextRenderManager)pair.component2();
                renderer.rerender();
            }
        }

        private static final Unit render$lambda$0$0(Storage $storage, int $actualOffset, Editor $editor) {
            $storage.remove($actualOffset);
            if ($storage.isEmpty()) {
                RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)$editor), (Key)STORAGE_KEY);
            }
            return Unit.INSTANCE;
        }

        private static final InlineCompletionTextRenderManager render$lambda$0(Editor $editor, int $actualOffset, Storage $storage) {
            return new InlineCompletionTextRenderManager($editor, $actualOffset, () -> Companion.render$lambda$0$0($storage, $actualOffset, $editor), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00140\u0013R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Companion$Storage;", "K", "", "V", "<init>", "()V", "map", "", "getOrInitialize", "key", "init", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "remove", "", "(Ljava/lang/Object;)V", "isEmpty", "", "allEntries", "", "Lkotlin/Pair;", "intellij.platform.ide.codeinsight.inline"})
        @SourceDebugExtension(value={"SMAP\nInlineCompletionTextRenderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionTextRenderManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Companion$Storage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,542:1\n1586#2:543\n1661#2,3:544\n*S KotlinDebug\n*F\n+ 1 InlineCompletionTextRenderManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Companion$Storage\n*L\n528#1:543\n528#1:544,3\n*E\n"})
        private static final class Storage<K, V> {
            @NotNull
            private final Map<K, V> map = new LinkedHashMap();

            @NotNull
            public final V getOrInitialize(@NotNull K key, @NotNull Function0<? extends V> init) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Intrinsics.checkNotNullParameter(init, (String)"init");
                Object object = this.map.computeIfAbsent(key, arg_0 -> Storage.getOrInitialize$lambda$1(arg_0 -> Storage.getOrInitialize$lambda$0(init, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
                return (V)object;
            }

            public final void remove(@NotNull K key) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                if (this.map.remove(key) == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
            }

            public final boolean isEmpty() {
                return this.map.isEmpty();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Pair<K, V>> allEntries() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.map.entrySet();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to(it.getKey(), it.getValue()));
                }
                return (List)destination$iv$iv;
            }

            private static final Object getOrInitialize$lambda$0(Function0 $init, Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return $init.invoke();
            }

            private static final Object getOrInitialize$lambda$1(Function1 $tmp0, Object p0) {
                return $tmp0.invoke(p0);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0002DEB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020%H\u0016J\u001e\u0010&\u001a\u00020%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00102\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0016\u0010)\u001a\u00020%2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020(0\u0010H\u0002J\u001c\u0010+\u001a\u00020%2\u0012\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u00100\u0010H\u0002J0\u0010-\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00052\f\u0010/\u001a\b\u0012\u0004\u0012\u00020(0\u0010H\u0002J0\u00100\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00052\f\u0010/\u001a\b\u0012\u0004\u0012\u00020(0\u0010H\u0002J\u0010\u00101\u001a\u00020%2\u0006\u0010!\u001a\u00020\u0005H\u0002J\b\u00102\u001a\u00020%H\u0002J\u0018\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u00020#H\u0002J\f\u00106\u001a\u00020%*\u00020\u0003H\u0002J\b\u00107\u001a\u00020%H\u0002J\b\u00108\u001a\u00020%H\u0002J\u0014\u00109\u001a\u00020%*\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0002J\b\u0010:\u001a\u00020%H\u0002J\u0014\u0010;\u001a\u00020%*\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0002J\u001a\u0010<\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\u0006\u0010=\u001a\u00020\u0005H\u0002J\u0010\u0010>\u001a\u00020%2\u0006\u0010?\u001a\u00020\u0005H\u0002J)\u0010@\u001a\u00020%*\u0006\u0012\u0002\b\u00030\t2\u0012\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0B\"\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010CR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Renderer;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "renderOffset", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;I)V", "inlineInlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionLineRenderer;", "blockLineInlays", "", "state", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Renderer$RenderState;", "inlayRenderers", "", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionInlayRenderer;", "foldedRange", "Lcom/intellij/openapi/util/TextRange;", "foldingManager", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionFoldingManager;", "softWrapManager", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionSoftWrapManager;", "initialStartPoint", "Ljava/awt/Point;", "Lorg/jetbrains/annotations/NotNull;", "append", "Lcom/intellij/codeInsight/inline/completion/render/RenderedInlineCompletionElementDescriptor;", "text", "", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "initialOffset", "isSoftWrappingEnabled", "", "dispose", "", "render", "newLines", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionRenderTextBlock;", "renderInline", "newBlocks", "renderMultiline", "lines", "renderBlockInlay", "offset", "blocks", "renderInlineInlay", "trimFoldedRangeIfNeeded", "renderFoldedRange", "renderRealTextBlocks", "rangeInEditor", "areFolded", "forceLeanLeft", "foldLineEndIfNotFolded", "updateDirtyInlays", "updateIfNeeded", "removeFoldedBlocksEverywhere", "removeFoldedBlocks", "getInlayForLine", "line", "applySoftWrapping", "startingFromLine", "addActionAvailabilityHints", "actionIds", "", "(Lcom/intellij/openapi/editor/Inlay;[Ljava/lang/String;)V", "Descriptor", "RenderState", "intellij.platform.ide.codeinsight.inline"})
    @SourceDebugExtension(value={"SMAP\nInlineCompletionTextRenderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionTextRenderManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Renderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,542:1\n1586#2:543\n1661#2,3:544\n1586#2:547\n1661#2,3:548\n1586#2:551\n1661#2,3:552\n1915#2,2:556\n1915#2,2:558\n1915#2,2:560\n777#2:562\n873#2,2:563\n1651#2:565\n1915#2:566\n1586#2:567\n1661#2,3:568\n1916#2:572\n1652#2:573\n1586#2:574\n1661#2,2:575\n1586#2:577\n1661#2,3:578\n1#3:555\n1#3:571\n*S KotlinDebug\n*F\n+ 1 InlineCompletionTextRenderManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Renderer\n*L\n168#1:543\n168#1:544,3\n203#1:547\n203#1:548,3\n207#1:551\n207#1:552,3\n305#1:556,2\n352#1:558,2\n361#1:560,2\n365#1:562\n365#1:563,2\n389#1:565\n389#1:566\n391#1:567\n391#1:568,3\n389#1:572\n389#1:573\n422#1:574\n422#1:575,2\n422#1:577\n422#1:578,3\n389#1:571\n*E\n"})
    private static final class Renderer
    implements Disposable {
        @NotNull
        private final Editor editor;
        private final int renderOffset;
        @Nullable
        private Inlay<? extends InlineCompletionLineRenderer> inlineInlay;
        @NotNull
        private final List<Inlay<? extends InlineCompletionLineRenderer>> blockLineInlays;
        @NotNull
        private RenderState state;
        @NotNull
        private final List<InlineCompletionInlayRenderer> inlayRenderers;
        @Nullable
        private TextRange foldedRange;
        @NotNull
        private final InlineCompletionFoldingManager foldingManager;
        @NotNull
        private final InlineCompletionSoftWrapManager softWrapManager;
        @NotNull
        private final Point initialStartPoint;

        public Renderer(@NotNull Editor editor, int renderOffset) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.renderOffset = renderOffset;
            this.blockLineInlays = new ArrayList();
            this.state = RenderState.RENDERING_INLINE;
            this.inlayRenderers = InlineCompletionInlayRenderer.Companion.all$intellij_platform_ide_codeinsight_inline();
            this.foldingManager = (InlineCompletionFoldingManager)InlineCompletionFoldingManager.Companion.get(this.editor);
            this.softWrapManager = (InlineCompletionSoftWrapManager)InlineCompletionSoftWrapManager.Companion.get(this.editor);
            Point point = this.editor.offsetToXY(this.renderOffset);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
            this.initialStartPoint = point;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final RenderedInlineCompletionElementDescriptor append(@NotNull String text, @NotNull TextAttributes attributes, int initialOffset) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            Iterable $this$map$iv = StringsKt.lines((CharSequence)text);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new InlineCompletionRenderTextBlock((String)it, attributes));
            }
            List newLines = (List)destination$iv$iv;
            if (!(!((Collection)newLines).isEmpty())) {
                throw new IllegalStateException("Check failed.");
            }
            this.render(newLines, initialOffset);
            return new Descriptor(initialOffset);
        }

        public final boolean isSoftWrappingEnabled() {
            return this.softWrapManager.getSoftWrapModelIfEnabled() != null;
        }

        public void dispose() {
            this.editor.getInlayModel().execute(true, () -> Renderer.dispose$lambda$0(this));
            this.inlineInlay = null;
            this.blockLineInlays.clear();
            this.foldedRange = null;
        }

        /*
         * WARNING - void declaration
         */
        private final void render(List<InlineCompletionRenderTextBlock> newLines, int initialOffset) {
            int firstTouchedLine = this.blockLineInlays.size();
            this.forceLeanLeft(this.editor);
            this.removeFoldedBlocksEverywhere();
            this.trimFoldedRangeIfNeeded(initialOffset);
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    this.renderInline(CollectionsKt.listOf((Object)newLines.get(0)));
                    if (newLines.size() <= 1) break;
                    this.state = RenderState.RENDERING_BLOCK;
                    Iterable iterable = newLines.subList(1, newLines.size());
                    Renderer renderer = this;
                    boolean $i$f$map = false;
                    void var7_10 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        InlineCompletionRenderTextBlock inlineCompletionRenderTextBlock = (InlineCompletionRenderTextBlock)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(CollectionsKt.listOf((Object)it));
                    }
                    renderer.renderMultiline((List)destination$iv$iv);
                    break;
                }
                case 2: {
                    Iterable $this$map$iv = newLines;
                    Renderer renderer = this;
                    boolean $i$f$map = false;
                    Iterable $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        InlineCompletionRenderTextBlock it = (InlineCompletionRenderTextBlock)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(CollectionsKt.listOf((Object)it));
                    }
                    renderer.renderMultiline((List)destination$iv$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.renderFoldedRange();
            this.updateDirtyInlays();
            boolean foldingIsApplied = this.foldedRange != null;
            this.applySoftWrapping(firstTouchedLine);
            if (!foldingIsApplied && this.foldedRange != null) {
                this.renderFoldedRange();
                this.updateDirtyInlays();
            }
        }

        private final void renderInline(List<InlineCompletionRenderTextBlock> newBlocks) {
            int offset = this.foldingManager.firstNotFoldedOffset(this.renderOffset);
            Inlay<? extends InlineCompletionLineRenderer> inlineInlay = this.inlineInlay;
            if (inlineInlay != null) {
                ((InlineCompletionLineRenderer)inlineInlay.getRenderer()).setBlocks$intellij_platform_ide_codeinsight_inline(CollectionsKt.plus((Collection)((InlineCompletionLineRenderer)inlineInlay.getRenderer()).getBlocks(), (Iterable)newBlocks));
            } else {
                this.editor.getInlayModel().execute(true, () -> Renderer.renderInline$lambda$0(this, offset, newBlocks));
            }
        }

        private final void renderMultiline(List<? extends List<InlineCompletionRenderTextBlock>> lines) {
            if (lines.isEmpty()) {
                return;
            }
            this.foldLineEndIfNotFolded();
            int offset = this.foldingManager.firstNotFoldedOffset(this.renderOffset);
            List<? extends List<InlineCompletionRenderTextBlock>> linesToRender = lines;
            Inlay lastInlay = (Inlay)CollectionsKt.lastOrNull(this.blockLineInlays);
            if (lastInlay != null) {
                ((InlineCompletionLineRenderer)lastInlay.getRenderer()).setBlocks$intellij_platform_ide_codeinsight_inline(CollectionsKt.plus((Collection)((InlineCompletionLineRenderer)lastInlay.getRenderer()).getBlocks(), (Iterable)linesToRender.get(0)));
                linesToRender = linesToRender.subList(1, linesToRender.size());
            }
            for (List<InlineCompletionRenderTextBlock> list : linesToRender) {
                Collection collection = this.blockLineInlays;
                Inlay<? extends InlineCompletionLineRenderer> inlay = this.renderBlockInlay(this.editor, offset, list);
                if (inlay == null) break;
                collection.add(inlay);
            }
        }

        private final Inlay<? extends InlineCompletionLineRenderer> renderBlockInlay(Editor editor, int offset, List<InlineCompletionRenderTextBlock> blocks) {
            Inlay<? extends InlineCompletionLineRenderer> inlay;
            block1: {
                for (InlineCompletionInlayRenderer it : (Iterable)this.inlayRenderers) {
                    boolean bl = false;
                    Inlay<? extends InlineCompletionLineRenderer> inlay2 = it.renderBlockInlay(editor, offset, blocks);
                    if (inlay2 == null) continue;
                    inlay = inlay2;
                    break block1;
                }
                inlay = null;
            }
            return inlay;
        }

        private final Inlay<? extends InlineCompletionLineRenderer> renderInlineInlay(Editor editor, int offset, List<InlineCompletionRenderTextBlock> blocks) {
            Inlay<? extends InlineCompletionLineRenderer> inlay;
            block1: {
                for (InlineCompletionInlayRenderer it : (Iterable)this.inlayRenderers) {
                    boolean bl = false;
                    Inlay<? extends InlineCompletionLineRenderer> inlay2 = it.renderInlineInlay(editor, offset, blocks);
                    if (inlay2 == null) continue;
                    inlay = inlay2;
                    break block1;
                }
                inlay = null;
            }
            return inlay;
        }

        private final void trimFoldedRangeIfNeeded(int initialOffset) {
            TextRange textRange = this.foldedRange;
            if (textRange == null) {
                return;
            }
            TextRange foldedRange = textRange;
            if (initialOffset < foldedRange.getStartOffset()) {
                LOG.error("Incorrect state of inline completion rendering. It is called in the wrong order.");
                return;
            }
            TextRange trimRange = new TextRange(foldedRange.getStartOffset(), initialOffset);
            this.foldedRange = new TextRange(initialOffset, foldedRange.getEndOffset());
            this.renderRealTextBlocks(trimRange, false);
        }

        private final void renderFoldedRange() {
            TextRange textRange = this.foldedRange;
            if (textRange == null) {
                return;
            }
            TextRange foldedRange = textRange;
            this.renderRealTextBlocks(foldedRange, true);
        }

        private final void renderRealTextBlocks(TextRange rangeInEditor, boolean areFolded) {
            if (rangeInEditor.isEmpty()) {
                return;
            }
            List<InlineCompletionRenderTextBlock> blocks = InlineCompletionEditorTextUtils.INSTANCE.getBlocksForRealText(this.editor, rangeInEditor, this.state == RenderState.RENDERING_INLINE);
            if (areFolded) {
                Iterable $this$forEach$iv = blocks;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    InlineCompletionRenderTextBlock block = (InlineCompletionRenderTextBlock)element$iv;
                    boolean bl = false;
                    block.getData().putUserData(FOLDED_BLOCK_KEY, (Object)Unit.INSTANCE);
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    this.renderInline(blocks);
                    break;
                }
                case 2: {
                    Inlay lastBlock = (Inlay)CollectionsKt.last(this.blockLineInlays);
                    ((InlineCompletionLineRenderer)lastBlock.getRenderer()).setBlocks$intellij_platform_ide_codeinsight_inline(CollectionsKt.plus((Collection)((InlineCompletionLineRenderer)lastBlock.getRenderer()).getBlocks(), (Iterable)blocks));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final void forceLeanLeft(Editor $this$forceLeanLeft) {
            if ($this$forceLeanLeft.getCaretModel().getCurrentCaret().isAtRtlLocation()) {
                return;
            }
            VisualPosition visualPosition = $this$forceLeanLeft.getCaretModel().getVisualPosition();
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
            VisualPosition visualPosition2 = visualPosition;
            if (visualPosition2.leansRight) {
                VisualPosition leftLeaningPosition = new VisualPosition(visualPosition2.line, visualPosition2.column, false);
                $this$forceLeanLeft.getCaretModel().moveToVisualPosition(leftLeaningPosition);
            }
        }

        private final void foldLineEndIfNotFolded() {
            Inlay<? extends InlineCompletionLineRenderer> inlineInlay;
            TextRange range;
            if (this.foldedRange != null) {
                return;
            }
            TextRange textRange = this.foldingManager.foldLineEnd(this.renderOffset, this);
            if (textRange == null) {
                return;
            }
            this.foldedRange = range = textRange;
            String string = this.editor.getDocument().getText(range);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.contains$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null)) {
                LOG.error("Incorrect state of inline completion rendering. Folding mustn't contain a new line break.");
            }
            if ((inlineInlay = this.inlineInlay) != null) {
                List<InlineCompletionRenderTextBlock> inlineBlocks = ((InlineCompletionLineRenderer)inlineInlay.getRenderer()).getBlocks();
                Disposer.dispose((Disposable)((Disposable)inlineInlay));
                this.inlineInlay = null;
                this.renderInline(inlineBlocks);
            }
        }

        private final void updateDirtyInlays() {
            Inlay<? extends InlineCompletionLineRenderer> inlay = this.inlineInlay;
            if (inlay != null) {
                this.updateIfNeeded(inlay);
            }
            Iterable $this$forEach$iv = this.blockLineInlays;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Inlay it = (Inlay)element$iv;
                boolean bl = false;
                this.updateIfNeeded((Inlay<? extends InlineCompletionLineRenderer>)it);
            }
        }

        private final void updateIfNeeded(Inlay<? extends InlineCompletionLineRenderer> $this$updateIfNeeded) {
            ((InlineCompletionLineRenderer)$this$updateIfNeeded.getRenderer()).updateIfNeeded($this$updateIfNeeded);
        }

        private final void removeFoldedBlocksEverywhere() {
            Inlay<? extends InlineCompletionLineRenderer> inlay = this.inlineInlay;
            if (inlay != null) {
                this.removeFoldedBlocks(inlay);
            }
            Iterable $this$forEach$iv = this.blockLineInlays;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Inlay it = (Inlay)element$iv;
                boolean bl = false;
                this.removeFoldedBlocks((Inlay<? extends InlineCompletionLineRenderer>)it);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void removeFoldedBlocks(Inlay<? extends InlineCompletionLineRenderer> $this$removeFoldedBlocks) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ((InlineCompletionLineRenderer)$this$removeFoldedBlocks.getRenderer()).getBlocks();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                InlineCompletionRenderTextBlock it = (InlineCompletionRenderTextBlock)element$iv$iv;
                boolean bl = false;
                if (!(it.getData().getUserData(FOLDED_BLOCK_KEY) == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List blocks = (List)destination$iv$iv;
            if (blocks.size() != ((InlineCompletionLineRenderer)$this$removeFoldedBlocks.getRenderer()).getBlocks().size()) {
                ((InlineCompletionLineRenderer)$this$removeFoldedBlocks.getRenderer()).setBlocks$intellij_platform_ide_codeinsight_inline(blocks);
            }
        }

        private final Inlay<? extends InlineCompletionLineRenderer> getInlayForLine(int line) {
            if (line < 0 || line > this.blockLineInlays.size()) {
                LOG.error("Inline Completion: incorrect line number: " + line + ". Expected range: [0, " + this.blockLineInlays.size() + "].");
            }
            return line == 0 ? this.inlineInlay : (Inlay)CollectionsKt.getOrNull(this.blockLineInlays, (int)(line - 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void applySoftWrapping(int startingFromLine) {
            if (this.softWrapManager.getSoftWrapModelIfEnabled() == null) {
                return;
            }
            AutoCloseable autoCloseable = new InlineCompletionVolumetricTextBlockFactory(this.editor);
            Throwable throwable = null;
            try {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                int skipResultLinesCount;
                List<List<VolumetricInlineCompletionTextBlock>> list;
                Object object;
                Iterable destination$iv$iv;
                Object inlayForLine;
                void $this$mapNotNullTo$iv;
                InlineCompletionVolumetricTextBlockFactory volumetricFactory = (InlineCompletionVolumetricTextBlockFactory)autoCloseable;
                boolean bl = false;
                IntRange initialApplyRange = RangesKt.until((int)startingFromLine, (int)(this.blockLineInlays.size() + 1));
                Iterable iterable = (Iterable)initialApplyRange;
                Collection destination$iv = new LinkedList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach22 = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    List list2;
                    int element$iv$iv;
                    int element$iv = element$iv$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    int line = element$iv;
                    boolean bl3 = false;
                    inlayForLine = this.getInlayForLine(line);
                    Object object2 = inlayForLine;
                    if (object2 != null && (object2 = (InlineCompletionLineRenderer)object2.getRenderer()) != null && (object2 = ((InlineCompletionLineRenderer)object2).getBlocks()) != null) {
                        void $this$mapTo$iv$iv2;
                        Iterable $this$map$iv2 = (Iterable)object2;
                        boolean $i$f$map = false;
                        Iterable iterable2 = $this$map$iv2;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void block;
                            InlineCompletionRenderTextBlock inlineCompletionRenderTextBlock = (InlineCompletionRenderTextBlock)item$iv$iv;
                            object = destination$iv$iv;
                            boolean bl4 = false;
                            object.add(volumetricFactory.getVolumetric((InlineCompletionRenderTextBlock)block));
                        }
                        list2 = (List)destination$iv$iv;
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                    List blocks = list2;
                    int startX = line == 0 ? this.initialStartPoint.x : 0;
                    InlineCompletionSoftWrapManager.RenderedLine it$iv = new InlineCompletionSoftWrapManager.RenderedLine(blocks, startX);
                    boolean bl5 = false;
                    destination$iv.add(it$iv);
                }
                LinkedList linesToFix = (LinkedList)destination$iv;
                if (this.softWrapManager.softWrap(linesToFix, volumetricFactory) == null) {
                    return;
                }
                List<List<VolumetricInlineCompletionTextBlock>> softWrappedLines = list;
                for (skipResultLinesCount = 0; skipResultLinesCount < softWrappedLines.size() && skipResultLinesCount < linesToFix.size() && softWrappedLines.get(skipResultLinesCount) == ((InlineCompletionSoftWrapManager.RenderedLine)linesToFix.get(skipResultLinesCount)).getBlocks(); ++skipResultLinesCount) {
                }
                int actualStartingFromLine = startingFromLine + skipResultLinesCount;
                while (!((Collection)this.blockLineInlays).isEmpty() && this.blockLineInlays.size() >= actualStartingFromLine) {
                    Disposer.dispose((Disposable)((Disposable)this.blockLineInlays.removeLast()));
                }
                if (actualStartingFromLine == 0) {
                    Inlay<? extends InlineCompletionLineRenderer> inlay = this.inlineInlay;
                    if (inlay != null) {
                        Inlay<? extends InlineCompletionLineRenderer> it = inlay;
                        boolean bl6 = false;
                        Disposer.dispose((Disposable)((Disposable)it));
                    }
                    this.inlineInlay = null;
                }
                Iterable $i$f$forEach22 = CollectionsKt.drop((Iterable)softWrappedLines, (int)skipResultLinesCount);
                boolean $i$f$map = false;
                void bl6 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapTo$iv$iv3;
                    void blocks;
                    inlayForLine = (List)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl7 = false;
                    Iterable $this$map$iv3 = (Iterable)blocks;
                    boolean $i$f$map2 = false;
                    destination$iv$iv = $this$map$iv3;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                        void it;
                        object = (VolumetricInlineCompletionTextBlock)item$iv$iv2;
                        Collection collection2 = destination$iv$iv3;
                        boolean bl8 = false;
                        collection2.add(it.getBlock());
                    }
                    collection.add((List)destination$iv$iv3);
                }
                List newLines = (List)destination$iv$iv2;
                if (newLines.isEmpty()) {
                    return;
                }
                switch (actualStartingFromLine) {
                    case 0: {
                        this.renderInline((List)CollectionsKt.first((List)newLines));
                        if (newLines.size() <= 1) break;
                        this.state = RenderState.RENDERING_BLOCK;
                        this.renderMultiline(CollectionsKt.drop((Iterable)newLines, (int)1));
                        break;
                    }
                    case 1: {
                        this.renderMultiline(newLines);
                        break;
                    }
                    default: {
                        this.renderMultiline(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)CollectionsKt.emptyList()), (Iterable)newLines));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final void addActionAvailabilityHints(Inlay<?> $this$addActionAvailabilityHints, String ... actionIds) {
            for (String actionId : actionIds) {
                EditorActionAvailabilityHint hint2 = new EditorActionAvailabilityHint(actionId, EditorActionAvailabilityHint.AvailabilityCondition.CaretOnStart, null, 4, null);
                EditorActionAvailabilityHint[] editorActionAvailabilityHintArray = new EditorActionAvailabilityHint[]{hint2};
                EditorActionAvailabilityHintKt.addActionAvailabilityHint($this$addActionAvailabilityHints, (EditorActionAvailabilityHint[])editorActionAvailabilityHintArray);
            }
        }

        private static final void dispose$lambda$0(Renderer this$0) {
            Inlay<? extends InlineCompletionLineRenderer> inlay = this$0.inlineInlay;
            if (inlay != null) {
                Inlay<? extends InlineCompletionLineRenderer> it = inlay;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)it));
            }
            for (Inlay<? extends InlineCompletionLineRenderer> blockInlay : this$0.blockLineInlays) {
                Disposer.dispose((Disposable)((Disposable)blockInlay));
            }
        }

        private static final void renderInline$lambda$0(Renderer this$0, int $offset, List $newBlocks) {
            Inlay<? extends InlineCompletionLineRenderer> element;
            Inlay<? extends InlineCompletionLineRenderer> inlay = element = this$0.renderInlineInlay(this$0.editor, $offset, $newBlocks);
            if (inlay != null) {
                String[] stringArray = new String[]{"InsertInlineCompletionAction", "InsertInlineCompletionWordAction", "InsertInlineCompletionLineAction", "NextInlineCompletionSuggestionAction", "PrevInlineCompletionSuggestionAction"};
                this$0.addActionAvailabilityHints(inlay, stringArray);
            }
            this$0.inlineInlay = element;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0007J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Renderer$Descriptor;", "Lcom/intellij/codeInsight/inline/completion/render/RenderedInlineCompletionElementDescriptor;", "offset", "", "<init>", "(Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Renderer;I)V", "getStartOffset", "()Ljava/lang/Integer;", "getEndOffset", "getRectangle", "Ljava/awt/Rectangle;", "intellij.platform.ide.codeinsight.inline"})
        @SourceDebugExtension(value={"SMAP\nInlineCompletionTextRenderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionTextRenderManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Renderer$Descriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,542:1\n1849#2,3:543\n*S KotlinDebug\n*F\n+ 1 InlineCompletionTextRenderManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Renderer$Descriptor\n*L\n461#1:543,3\n*E\n"})
        private final class Descriptor
        implements RenderedInlineCompletionElementDescriptor {
            private final int offset;

            public Descriptor(int offset) {
                this.offset = offset;
            }

            @Override
            @Nullable
            public Integer getStartOffset() {
                return this.offset;
            }

            @Override
            @Nullable
            public Integer getEndOffset() {
                return this.offset;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @Nullable
            public Rectangle getRectangle() {
                void $this$fold$iv;
                Iterable iterable = Renderer.this.blockLineInlays;
                Inlay inlay = Renderer.this.inlineInlay;
                Rectangle initial$iv = inlay != null ? inlay.getBounds() : null;
                boolean $i$f$fold = false;
                Rectangle accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    Rectangle rectangle;
                    void inlay2;
                    Inlay inlay3 = (Inlay)element$iv;
                    Rectangle result2 = accumulator$iv;
                    boolean bl = false;
                    if (inlay2.getBounds() == null) {
                        rectangle = result2;
                    } else {
                        Rectangle newBounds;
                        Rectangle rectangle2 = result2;
                        rectangle = rectangle2 == null ? newBounds : rectangle2.union(newBounds);
                    }
                    accumulator$iv = rectangle;
                }
                return accumulator$iv;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Renderer$RenderState;", "", "<init>", "(Ljava/lang/String;I)V", "RENDERING_INLINE", "RENDERING_BLOCK", "intellij.platform.ide.codeinsight.inline"})
        private static final class RenderState
        extends Enum<RenderState> {
            public static final /* enum */ RenderState RENDERING_INLINE = new RenderState();
            public static final /* enum */ RenderState RENDERING_BLOCK = new RenderState();
            private static final /* synthetic */ RenderState[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static RenderState[] values() {
                return (RenderState[])$VALUES.clone();
            }

            public static RenderState valueOf(String value) {
                return Enum.valueOf(RenderState.class, value);
            }

            @NotNull
            public static EnumEntries<RenderState> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = renderStateArray = new RenderState[]{RenderState.RENDERING_INLINE, RenderState.RENDERING_BLOCK};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RenderState.values().length];
                try {
                    nArray[RenderState.RENDERING_INLINE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RenderState.RENDERING_BLOCK.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$Request;", "", "text", "", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "initialOffset", "", "isActive", "", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/editor/markup/TextAttributes;IZ)V", "getText", "()Ljava/lang/String;", "getAttributes", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "getInitialOffset", "()I", "()Z", "setActive", "(Z)V", "intellij.platform.ide.codeinsight.inline"})
    private static final class Request {
        @NotNull
        private final String text;
        @NotNull
        private final TextAttributes attributes;
        private final int initialOffset;
        private boolean isActive;

        public Request(@NotNull String text, @NotNull TextAttributes attributes, int initialOffset, boolean isActive) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            this.text = text;
            this.attributes = attributes;
            this.initialOffset = initialOffset;
            this.isActive = isActive;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final TextAttributes getAttributes() {
            return this.attributes;
        }

        public final int getInitialOffset() {
            return this.initialOffset;
        }

        public final boolean isActive() {
            return this.isActive;
        }

        public final void setActive(boolean bl) {
            this.isActive = bl;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager$UpdateOnResizeListener;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "<init>", "(Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionTextRenderManager;)V", "visibleAreaChanged", "", "e", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "intellij.platform.ide.codeinsight.inline"})
    private final class UpdateOnResizeListener
    implements VisibleAreaListener {
        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Rectangle rectangle = e.getOldRectangle();
            if (!(rectangle != null ? rectangle.width == e.getNewRectangle().width : false) && InlineCompletionTextRenderManager.this.renderer.isSoftWrappingEnabled()) {
                InlineCompletionTextRenderManager.this.rerender();
            }
        }
    }
}

