/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorLineStripeHint;

import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.codeInsight.editorLineStripeHint.EditorLineStripeButtonRenderer;
import com.intellij.codeInsight.editorLineStripeHint.EditorLineStripeInlayRenderer;
import com.intellij.codeInsight.editorLineStripeHint.EditorListener;
import com.intellij.codeInsight.editorLineStripeHint.RepositionableJPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.ui.components.JBPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BoxLayout;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u00012\u00020\u0002:\u00012B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\bH\u0016J\b\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\fH\u0016J\b\u0010#\u001a\u00020\fH\u0016J\b\u0010$\u001a\u00020\fH\u0016J\"\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\f2\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0\u0007H\u0016J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u001dJ\b\u0010,\u001a\u00020\u001dH\u0002J\u0006\u0010-\u001a\u00020\u001dJ\u0012\u0010.\u001a\u00020\u001d2\b\u0010/\u001a\u0004\u0018\u000100H\u0014J\b\u00101\u001a\u00020\u001dH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\n\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0012R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/codeInsight/editorLineStripeHint/EditorLineStripeHintComponent;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "panelRenderer", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "stripeColor", "Ljava/awt/Color;", "lifetime", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;Ljava/awt/Color;I)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getStripeColor", "()Ljava/awt/Color;", "gradientStartColor", "getGradientStartColor$annotations", "()V", "getGradientStartColor", "isInstalled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Ljava/util/concurrent/atomic/AtomicInteger;", "batches", "Ljava/awt/Component;", "reposition", "", "createPhantomInlayComponent", "Lcom/intellij/codeInsight/editorLineStripeHint/RepositionableJPanel;", "renderer", "getStripeVisibleWidth", "getLineStripeY", "getLineEndOffset", "getInlaysStartOffset", "getMeaningfulTextEnd", "lineEndOffset", "inlays", "Lcom/intellij/openapi/editor/Inlay;", "isShown", "", "redraw", "install", "uninstall", "paintComponent", "g", "Ljava/awt/Graphics;", "dispose", "PhantomInlayComponent", "intellij.platform.ide.codeinsight.inline"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEditorLineStripeHintComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorLineStripeHintComponent.kt\ncom/intellij/codeInsight/editorLineStripeHint/EditorLineStripeHintComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1586#2:198\n1661#2,2:199\n1642#2,10:201\n1915#2:211\n1916#2:213\n1652#2:214\n1663#2:215\n1915#2,2:216\n1915#2,2:219\n1915#2,2:221\n1#3:212\n1#3:218\n*S KotlinDebug\n*F\n+ 1 EditorLineStripeHintComponent.kt\ncom/intellij/codeInsight/editorLineStripeHint/EditorLineStripeHintComponent\n*L\n45#1:198\n45#1:199,2\n46#1:201,10\n46#1:211\n46#1:213\n46#1:214\n45#1:215\n50#1:216,2\n91#1:219,2\n95#1:221,2\n46#1:212\n*E\n"})
public class EditorLineStripeHintComponent
extends JBPanel<JBPanel<?>>
implements Disposable {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Color stripeColor;
    @NotNull
    private final Color gradientStartColor;
    @NotNull
    private final AtomicBoolean isInstalled;
    @NotNull
    private final AtomicInteger lifetime;
    @NotNull
    private final List<List<Component>> batches;

    /*
     * WARNING - void declaration
     */
    public EditorLineStripeHintComponent(@NotNull Editor editor, @NotNull Function0<? extends List<? extends List<? extends EditorCustomElementRenderer>>> panelRenderer, @NotNull Color stripeColor, int lifetime) {
        void $this$mapTo$iv$iv;
        Iterator<List<Component>> $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(panelRenderer, (String)"panelRenderer");
        Intrinsics.checkNotNullParameter((Object)stripeColor, (String)"stripeColor");
        this.editor = editor;
        this.stripeColor = stripeColor;
        EditorLineStripeHintComponent editorLineStripeHintComponent = this;
        EditorLineStripeHintComponent editorLineStripeHintComponent2 = this;
        boolean $i$a$-run-EditorLineStripeHintComponent$gradientStartColor$22 = false;
        editorLineStripeHintComponent2.gradientStartColor = new Color(0, 0, 0, 0);
        this.isInstalled = new AtomicBoolean(false);
        this.lifetime = new AtomicInteger(lifetime);
        this.setOpaque(false);
        this.setLayout(new BoxLayout((Container)((Object)this), 0));
        Iterable iterable = (Iterable)panelRenderer.invoke();
        editorLineStripeHintComponent2 = this;
        boolean $i$f$map = false;
        void $i$a$-run-EditorLineStripeHintComponent$gradientStartColor$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void renderers;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = (Iterable)renderers;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                RepositionableJPanel it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                EditorCustomElementRenderer renderer = (EditorCustomElementRenderer)element$iv$iv;
                boolean bl3 = false;
                if (this.createPhantomInlayComponent(renderer) == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            collection.add((List)destination$iv$iv2);
        }
        editorLineStripeHintComponent2.batches = (List)destination$iv$iv;
        for (List<Component> batch : this.batches) {
            Iterable $this$forEach$iv = batch;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RepositionableJPanel it = (RepositionableJPanel)element$iv;
                boolean bl = false;
                this.add(it);
            }
        }
        EditorListener editorListener = new EditorListener(this);
        this.editor.getContentComponent().addComponentListener(editorListener);
        this.editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)editorListener);
        DisposerUtilKt.whenDisposed((Disposable)this, () -> EditorLineStripeHintComponent._init_$lambda$2(this, editorListener));
    }

    public /* synthetic */ EditorLineStripeHintComponent(Editor editor, Function0 function0, Color color, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 4;
        }
        this(editor, (Function0<? extends List<? extends List<? extends EditorCustomElementRenderer>>>)function0, color, n);
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final Color getStripeColor() {
        return this.stripeColor;
    }

    @NotNull
    public final Color getGradientStartColor() {
        return this.gradientStartColor;
    }

    public static /* synthetic */ void getGradientStartColor$annotations() {
    }

    public final void reposition() {
        int width = this.editor.getScrollingModel().getVisibleArea().width;
        this.setSize(width / 2, this.editor.getLineHeight());
        ApplicationManager.getApplication().runReadAction(() -> EditorLineStripeHintComponent.reposition$lambda$0(this, width));
    }

    @Nullable
    public RepositionableJPanel createPhantomInlayComponent(@NotNull EditorCustomElementRenderer renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        return renderer instanceof EditorLineStripeInlayRenderer ? (RepositionableJPanel)new PhantomInlayComponent(this.editor, (EditorLineStripeInlayRenderer)renderer) : null;
    }

    public int getStripeVisibleWidth() {
        return this.editor.getScrollingModel().getVisibleArea().width / 2;
    }

    public int getLineStripeY() {
        return this.editor.visualPositionToXY((VisualPosition)this.editor.getCaretModel().getVisualPosition()).y;
    }

    public int getLineEndOffset() {
        return this.editor.getDocument().getLineEndOffset(this.editor.getCaretModel().getLogicalPosition().line);
    }

    public int getInlaysStartOffset() {
        return this.editor.getCaretModel().getOffset();
    }

    /*
     * WARNING - void declaration
     */
    public int getMeaningfulTextEnd(int lineEndOffset, @NotNull List<? extends Inlay<?>> inlays) {
        int n;
        Intrinsics.checkNotNullParameter(inlays, (String)"inlays");
        Iterable iterable = inlays;
        int n2 = this.editor.offsetToXY((int)lineEndOffset).x;
        int n3 = 0;
        for (Object t : iterable) {
            void it;
            Inlay inlay = (Inlay)t;
            n = n3;
            boolean bl = false;
            int n4 = it.getWidthInPixels();
            n3 = n + n4;
        }
        n = n3;
        return n2 + n;
    }

    public final boolean isShown() {
        return this.isInstalled.get();
    }

    public final void redraw() {
        this.uninstall();
        int currentLifetime = this.lifetime.getAndDecrement();
        if (currentLifetime <= 0) {
            this.lifetime.set(0);
            return;
        }
        this.reposition();
        this.install();
    }

    private final void install() {
        if (this.isInstalled.compareAndSet(false, true)) {
            this.editor.getContentComponent().add((Component)((Object)this));
        }
    }

    public final void uninstall() {
        if (this.isInstalled.compareAndSet(true, false)) {
            this.editor.getContentComponent().remove((Component)((Object)this));
        }
    }

    protected void paintComponent(@Nullable Graphics g) {
        super.paintComponent(g);
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        GradientPaint gradient = new GradientPaint((float)width / (float)3 * (float)2, (float)height / 2.0f, this.gradientStartColor, width, (float)height / 2.0f, this.stripeColor);
        g2d.setPaint(gradient);
        g2d.fillRect(0, 0, width, height);
    }

    public void dispose() {
    }

    private static final Unit _init_$lambda$2(EditorLineStripeHintComponent this$0, EditorListener $editorListener) {
        this$0.editor.getContentComponent().removeComponentListener($editorListener);
        this$0.editor.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)$editorListener);
        return Unit.INSTANCE;
    }

    private static final void reposition$lambda$0(EditorLineStripeHintComponent this$0, int $width) {
        int lineStripeY = this$0.getLineStripeY();
        int startPositionOfEolStripe = $width / 3 * 2;
        int stripeVisibleWidth = this$0.getStripeVisibleWidth();
        int widthLeft = this$0.editor.getScrollingModel().getVisibleArea().width - stripeVisibleWidth;
        this$0.setBounds(this$0.editor.getContentComponent().getVisibleRect().x + widthLeft, lineStripeY, stripeVisibleWidth, this$0.editor.getLineHeight());
        Component[] componentArray = this$0.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component comp : componentArray) {
            if (!(comp instanceof PhantomInlayComponent)) continue;
            ((PhantomInlayComponent)comp).reposition();
        }
        int lineEndOffset = this$0.getLineEndOffset();
        int caretOffset = this$0.getInlaysStartOffset();
        List list = this$0.editor.getInlayModel().getAfterLineEndElementsInRange(caretOffset, lineEndOffset);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAfterLineEndElementsInRange(...)");
        List inlays = list;
        int meaningfulTextEnd = this$0.getMeaningfulTextEnd(lineEndOffset, inlays);
        int remainingSpace = meaningfulTextEnd > startPositionOfEolStripe ? -1 : this$0.editor.getComponent().getSize().width - meaningfulTextEnd;
        for (List<Component> batch : this$0.batches) {
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Component it;
            Iterable iterable = batch;
            int n = 0;
            for (Object t : iterable) {
                Component component = (Component)t;
                int n2 = n;
                boolean bl = false;
                int n3 = it.getMaximumSize().width;
                n = n2 + n3;
            }
            int compoundSize = n;
            if (compoundSize < remainingSpace) {
                $this$forEach$iv = batch;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Component)element$iv;
                    boolean bl = false;
                    it.setVisible(true);
                }
                remainingSpace -= compoundSize;
                continue;
            }
            $this$forEach$iv = batch;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Component)element$iv;
                boolean bl = false;
                it.setVisible(false);
            }
            remainingSpace -= compoundSize;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/codeInsight/editorLineStripeHint/EditorLineStripeHintComponent$PhantomInlayComponent;", "Lcom/intellij/codeInsight/editorLineStripeHint/RepositionableJPanel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "renderer", "Lcom/intellij/codeInsight/editorLineStripeHint/EditorLineStripeInlayRenderer;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/editorLineStripeHint/EditorLineStripeInlayRenderer;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getRenderer", "()Lcom/intellij/codeInsight/editorLineStripeHint/EditorLineStripeInlayRenderer;", "pixelWidth", "", "getPixelWidth", "()I", "setPixelWidth", "(I)V", "reposition", "", "paint", "g", "Ljava/awt/Graphics;", "intellij.platform.ide.codeinsight.inline"})
    public static final class PhantomInlayComponent
    extends RepositionableJPanel {
        @NotNull
        private final Editor editor;
        @NotNull
        private final EditorLineStripeInlayRenderer renderer;
        private int pixelWidth;

        public PhantomInlayComponent(@NotNull Editor editor, @NotNull EditorLineStripeInlayRenderer renderer) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
            this.editor = editor;
            this.renderer = renderer;
            this.pixelWidth = HintRenderer.Companion.calcWidthInPixels(this.editor, this.renderer.getText(), this.renderer.getWidthAdjustment());
            this.reposition();
            this.setOpaque(false);
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final EditorLineStripeInlayRenderer getRenderer() {
            return this.renderer;
        }

        public final int getPixelWidth() {
            return this.pixelWidth;
        }

        public final void setPixelWidth(int n) {
            this.pixelWidth = n;
        }

        @Override
        public void reposition() {
            this.pixelWidth = HintRenderer.Companion.calcWidthInPixels(this.editor, this.renderer.getText(), this.renderer.getWidthAdjustment());
            int delta = this.renderer instanceof EditorLineStripeButtonRenderer ? 3 : -5;
            this.setMaximumSize(new Dimension(this.pixelWidth - delta, this.editor.getLineHeight()));
        }

        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            TextAttributes textAttributes = this.renderer.internalGetTextAttributes$intellij_platform_ide_codeinsight_inline(this.editor);
            if (textAttributes == null) {
                textAttributes = this.editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT);
            }
            TextAttributes attrs = textAttributes;
            Editor editor = this.editor;
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            EditorImpl editorImpl = (EditorImpl)editor;
            Rectangle rectangle = new Rectangle(0, this.getY(), this.pixelWidth, this.getHeight());
            String string = this.renderer.getText();
            Intrinsics.checkNotNull((Object)attrs);
            HintRenderer.Companion.paintHint(g, editorImpl, rectangle, string, attrs, attrs, this.renderer.getWidthAdjustment(), false);
        }
    }
}

