/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.render;

import com.intellij.codeInsight.inline.completion.render.InlineCompletionRenderTextBlock;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u0012\u001a\u00020\u0010*\u00020\nH\u0002J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionEditorTextUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getBlocksForRealText", "", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionRenderTextBlock;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/util/TextRange;", "isInline", "", "getTextAttributesOrDefault", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "getDefaultTextAttributes", "useCaretLineBackground", "intellij.platform.ide.codeinsight.inline"})
@SourceDebugExtension(value={"SMAP\nInlineCompletionEditorTextUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionEditorTextUtils.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionEditorTextUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,85:1\n1#2:86\n23#3:87\n*S KotlinDebug\n*F\n+ 1 InlineCompletionEditorTextUtils.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionEditorTextUtils\n*L\n14#1:87\n*E\n"})
public final class InlineCompletionEditorTextUtils {
    @NotNull
    public static final InlineCompletionEditorTextUtils INSTANCE;
    @NotNull
    private static final Logger LOG;

    private InlineCompletionEditorTextUtils() {
    }

    @NotNull
    public final List<InlineCompletionRenderTextBlock> getBlocksForRealText(@NotNull Editor editor, @NotNull TextRange range, boolean isInline) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (range.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(range.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator highlighterIterator2 = highlighterIterator;
        List blocks = new ArrayList();
        StringBuilder processedText = new StringBuilder();
        while (!highlighterIterator2.atEnd() && highlighterIterator2.getStart() < range.getEndOffset()) {
            TextRange iteratorRange = new TextRange(highlighterIterator2.getStart(), highlighterIterator2.getEnd());
            TextRange intersection = range.intersection(iteratorRange);
            if (!intersection.isEmpty()) {
                String text;
                Intrinsics.checkNotNullExpressionValue((Object)editor.getDocument().getText(intersection), (String)"getText(...)");
                TextAttributes attributes = this.getTextAttributesOrDefault(highlighterIterator2, editor);
                ((Collection)blocks).add(new InlineCompletionRenderTextBlock(text, attributes));
                processedText.append(text);
            }
            highlighterIterator2.advance();
        }
        String string = editor.getDocument().getText(range);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String rangeText = string;
        if (blocks.isEmpty()) {
            ((Collection)blocks).add(new InlineCompletionRenderTextBlock(rangeText, this.getDefaultTextAttributes(editor)));
        } else if (!Intrinsics.areEqual((Object)processedText.toString(), (Object)rangeText)) {
            LOG.error("Highlighting for inline completion is incorrectly computed. Expected: " + rangeText + ", actual: " + processedText);
        }
        if (this.useCaretLineBackground(editor, range, isInline)) {
            Color caretRowColor = editor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
            blocks.replaceAll(arg_0 -> InlineCompletionEditorTextUtils.getBlocksForRealText$lambda$0(caretRowColor, arg_0));
        }
        return blocks;
    }

    private final TextAttributes getTextAttributesOrDefault(HighlighterIterator $this$getTextAttributesOrDefault, Editor editor) {
        Object object;
        block3: {
            block2: {
                TextAttributes textAttributes;
                object = $this$getTextAttributesOrDefault.getTextAttributes();
                if (object == null) break block2;
                TextAttributes it = textAttributes = object;
                boolean bl = false;
                object = !it.isEmpty() ? textAttributes : null;
                if (object != null) break block3;
            }
            object = this.getDefaultTextAttributes(editor);
        }
        return object;
    }

    private final TextAttributes getDefaultTextAttributes(Editor $this$getDefaultTextAttributes) {
        TextAttributes textAttributes = $this$getDefaultTextAttributes.getColorsScheme().getAttributes(HighlighterColors.TEXT);
        if (textAttributes == null) {
            textAttributes = new TextAttributes();
        }
        return textAttributes;
    }

    private final boolean useCaretLineBackground(Editor editor, TextRange range, boolean isInline) {
        int rangeLine;
        if (!isInline) {
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        int caretLine = editor.offsetToVisualLine(caretOffset, true);
        return caretLine == (rangeLine = editor.offsetToVisualLine(range.getStartOffset(), true));
    }

    /*
     * WARNING - void declaration
     */
    private static final InlineCompletionRenderTextBlock getBlocksForRealText$lambda$0(Color $caretRowColor, InlineCompletionRenderTextBlock block) {
        void $this$getBlocksForRealText_u24lambda_u240_u240;
        TextAttributes textAttributes;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        TextAttributes textAttributes2 = textAttributes = block.getAttributes().clone();
        String string = null;
        InlineCompletionRenderTextBlock inlineCompletionRenderTextBlock = block;
        boolean bl = false;
        if ($this$getBlocksForRealText_u24lambda_u240_u240.getBackgroundColor() == null) {
            $this$getBlocksForRealText_u24lambda_u240_u240.setBackgroundColor($caretRowColor);
        }
        Unit unit = Unit.INSTANCE;
        TextAttributes textAttributes3 = textAttributes;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes3, (String)"apply(...)");
        return InlineCompletionRenderTextBlock.copy$default(inlineCompletionRenderTextBlock, string, textAttributes3, null, 5, null);
    }

    static {
        InlineCompletionEditorTextUtils $this$thisLogger$iv = INSTANCE = new InlineCompletionEditorTextUtils();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(InlineCompletionEditorTextUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

