/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.session;

import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.codeInsight.inline.completion.InlineCompletionProvider;
import com.intellij.codeInsight.inline.completion.InlineCompletionProviderID;
import com.intellij.codeInsight.inline.completion.InlineCompletionRequest;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionSkipTextElement;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionSession;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionSessionId;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionSessionIdKt;
import com.intellij.codeInsight.inline.completion.suggestion.InlineCompletionSuggestionUpdateManager;
import com.intellij.codeInsight.inline.completion.suggestion.InlineCompletionVariant;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH%J\b\u0010\r\u001a\u00020\tH\u0014J\b\u0010\u000e\u001a\u00020\tH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H$J*\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007J\b\u0010\u001a\u001a\u00020\tH\u0007J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u001e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010#\u001a\u00020\u001f*\u00020!H\u0002J\f\u0010$\u001a\u00020\u001f*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "currentSession", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSession;", "onUpdate", "", "session", "result", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult;", "onCreated", "onRemoved", "getSuggestionUpdater", "Lcom/intellij/codeInsight/inline/completion/suggestion/InlineCompletionSuggestionUpdateManager;", "provider", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionProvider;", "createSession", "request", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;", "disposable", "Lcom/intellij/openapi/Disposable;", "specificId", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionId;", "removeSession", "invalidate", "reason", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated$Reason;", "updateSession", "", "event", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEvent;", "suggestionUpdateManager", "mayMutateCaretPosition", "isEmpty", "UpdateSessionResult", "intellij.platform.ide.codeinsight.inline"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInlineCompletionSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionSessionManager.kt\ncom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1#2:178\n2792#3,3:179\n*S KotlinDebug\n*F\n+ 1 InlineCompletionSessionManager.kt\ncom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager\n*L\n159#1:179,3\n*E\n"})
public abstract class InlineCompletionSessionManager {
    @NotNull
    private final Editor editor;
    @Nullable
    private InlineCompletionSession currentSession;

    public InlineCompletionSessionManager(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @RequiresEdt
    protected abstract void onUpdate(@NotNull InlineCompletionSession var1, @NotNull UpdateSessionResult var2);

    protected void onCreated() {
    }

    protected void onRemoved() {
    }

    @NotNull
    protected abstract InlineCompletionSuggestionUpdateManager getSuggestionUpdater(@NotNull InlineCompletionProvider var1);

    @RequiresEdt
    @NotNull
    public final InlineCompletionSession createSession(@NotNull InlineCompletionProvider provider, @NotNull InlineCompletionRequest request2, @NotNull Disposable disposable, @Nullable InlineCompletionSessionId specificId) {
        InlineCompletionSession newSession;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ThreadingAssertions.assertEventDispatchThread();
        if (!(this.currentSession == null)) {
            boolean bl = false;
            String string = "Session already exists.";
            throw new IllegalStateException(string.toString());
        }
        this.currentSession = newSession = InlineCompletionSession.Companion.init$intellij_platform_ide_codeinsight_inline(this.editor, provider, request2, disposable);
        InlineCompletionSessionId inlineCompletionSessionId = specificId;
        InlineCompletionSessionId inlineCompletionSessionId2 = inlineCompletionSessionId != null ? InlineCompletionSessionIdKt.putId(newSession, inlineCompletionSessionId) : InlineCompletionSessionIdKt.putId(newSession);
        this.onCreated();
        return newSession;
    }

    @RequiresEdt
    public final void removeSession() {
        ThreadingAssertions.assertEventDispatchThread();
        if (!(this.currentSession != null)) {
            boolean bl = false;
            String string = "Session does not exist.";
            throw new IllegalStateException(string.toString());
        }
        InlineCompletionSession.Companion.remove$intellij_platform_ide_codeinsight_inline(this.editor);
        this.onRemoved();
        this.currentSession = null;
    }

    @RequiresEdt
    public final void invalidate(@NotNull UpdateSessionResult.Invalidated.Reason reason) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            InlineCompletionSession inlineCompletionSession = this.currentSession;
            if (inlineCompletionSession == null) break block0;
            InlineCompletionSession session = inlineCompletionSession;
            boolean bl = false;
            this.onUpdate(session, new UpdateSessionResult.Invalidated(reason));
        }
    }

    @RequiresEdt
    public final boolean updateSession(@NotNull InlineCompletionRequest request2) {
        Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
        InlineCompletionSession session = this.currentSession;
        if (session == null) {
            return false;
        }
        if (session.getProvider().restartOn(request2.getEvent())) {
            this.invalidate(session, request2.getEvent());
            return false;
        }
        UpdateSessionResult result2 = this.updateSession(session, request2);
        this.onUpdate(session, result2);
        return !(result2 instanceof UpdateSessionResult.Invalidated);
    }

    private final void invalidate(InlineCompletionSession session, InlineCompletionEvent event) {
        this.onUpdate(session, new UpdateSessionResult.Invalidated(new UpdateSessionResult.Invalidated.Reason.Event(event)));
    }

    private final UpdateSessionResult updateSession(InlineCompletionSession session, InlineCompletionRequest request2) {
        if (this.mayMutateCaretPosition(request2.getEvent())) {
            session.getContext().setExpectedStartOffset$intellij_platform_ide_codeinsight_inline(request2.getEndOffset());
        }
        InlineCompletionSuggestionUpdateManager updateManager = this.getSuggestionUpdater(session.getProvider());
        return this.updateSession(session, updateManager, request2);
    }

    private final UpdateSessionResult updateSession(InlineCompletionSession session, InlineCompletionSuggestionUpdateManager suggestionUpdateManager, InlineCompletionRequest request2) {
        InlineCompletionEvent event = request2.getEvent();
        if (event instanceof InlineCompletionEvent.WithSpecificProvider && !InlineCompletionProviderID.equals-impl0(session.getProvider().getId-S2YkoFA(), ((InlineCompletionEvent.WithSpecificProvider)event).getProviderId-S2YkoFA())) {
            return UpdateSessionResult.Succeeded.INSTANCE;
        }
        if (!session.isActive()) {
            UpdateSessionResult updateSessionResult;
            boolean bl = suggestionUpdateManager.updateWhileNoVariants(event);
            if (bl) {
                updateSessionResult = UpdateSessionResult.Succeeded.INSTANCE;
            } else if (!bl) {
                updateSessionResult = new UpdateSessionResult.Invalidated(new UpdateSessionResult.Invalidated.Reason.Event(event));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return updateSessionResult;
        }
        boolean success = session.update$intellij_platform_ide_codeinsight_inline(event, (Function1<? super InlineCompletionVariant.Snapshot, ? extends InlineCompletionSuggestionUpdateManager.UpdateResult>)((Function1)arg_0 -> InlineCompletionSessionManager.updateSession$lambda$0(suggestionUpdateManager, event, arg_0)));
        if (!success) {
            return new UpdateSessionResult.Invalidated(new UpdateSessionResult.Invalidated.Reason.Event(event));
        }
        if (!(!session.getContext().isDisposed())) {
            throw new IllegalStateException("Check failed.");
        }
        if (!this.isEmpty(session)) {
            return UpdateSessionResult.Succeeded.INSTANCE;
        }
        InlineCompletionSession.Snapshot snapshot = session.capture();
        if (snapshot == null) {
            return UpdateSessionResult.Emptied.INSTANCE;
        }
        InlineCompletionSession.Snapshot snapshot2 = snapshot;
        InlineCompletionVariant.Snapshot.State variantState = snapshot2.getActiveVariant().getState();
        return switch (WhenMappings.$EnumSwitchMapping$0[variantState.ordinal()]) {
            case 1 -> UpdateSessionResult.Emptied.INSTANCE;
            case 2 -> throw new IllegalStateException("Incorrect state: variant cannot be invalidated.".toString());
            default -> UpdateSessionResult.Succeeded.INSTANCE;
        };
    }

    private final boolean mayMutateCaretPosition(InlineCompletionEvent $this$mayMutateCaretPosition) {
        return !($this$mayMutateCaretPosition instanceof InlineCompletionEvent.InlineLookupEvent);
    }

    private final boolean isEmpty(InlineCompletionSession $this$isEmpty) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = $this$isEmpty.getContext().getState().getElements();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    InlineCompletionElement.Presentable it = (InlineCompletionElement.Presentable)element$iv;
                    boolean bl2 = false;
                    if (!(!(it.getElement() instanceof InlineCompletionSkipTextElement) && ((CharSequence)it.getElement().getText()).length() > 0)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final InlineCompletionSuggestionUpdateManager.UpdateResult updateSession$lambda$0(InlineCompletionSuggestionUpdateManager $suggestionUpdateManager, InlineCompletionEvent $event, InlineCompletionVariant.Snapshot variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return $suggestionUpdateManager.update($event, variant);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult;", "", "Succeeded", "Emptied", "Invalidated", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Emptied;", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated;", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Succeeded;", "intellij.platform.ide.codeinsight.inline"})
    @ApiStatus.Internal
    public static sealed interface UpdateSessionResult {

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Emptied;", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ide.codeinsight.inline"})
        public static final class Emptied
        implements UpdateSessionResult {
            @NotNull
            public static final Emptied INSTANCE = new Emptied();

            private Emptied() {
            }

            @NotNull
            public String toString() {
                return "Emptied";
            }

            public int hashCode() {
                return 1547559352;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Emptied)) {
                    return false;
                }
                Emptied cfr_ignored_0 = (Emptied)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated;", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult;", "reason", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated$Reason;", "<init>", "(Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated$Reason;)V", "getReason", "()Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated$Reason;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Reason", "intellij.platform.ide.codeinsight.inline"})
        public static final class Invalidated
        implements UpdateSessionResult {
            @NotNull
            private final Reason reason;

            public Invalidated(@NotNull Reason reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                this.reason = reason;
            }

            @NotNull
            public final Reason getReason() {
                return this.reason;
            }

            @NotNull
            public final Reason component1() {
                return this.reason;
            }

            @NotNull
            public final Invalidated copy(@NotNull Reason reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                return new Invalidated(reason);
            }

            public static /* synthetic */ Invalidated copy$default(Invalidated invalidated, Reason reason, int n, Object object) {
                if ((n & 1) != 0) {
                    reason = invalidated.reason;
                }
                return invalidated.copy(reason);
            }

            @NotNull
            public String toString() {
                return "Invalidated(reason=" + this.reason + ")";
            }

            public int hashCode() {
                return this.reason.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Invalidated)) {
                    return false;
                }
                Invalidated invalidated = (Invalidated)other;
                return Intrinsics.areEqual((Object)this.reason, (Object)invalidated.reason);
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated$Reason;", "", "Event", "UnclassifiedDocumentChange", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated$Reason$Event;", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated$Reason$UnclassifiedDocumentChange;", "intellij.platform.ide.codeinsight.inline"})
            public static sealed interface Reason {

                @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated$Reason$Event;", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated$Reason;", "event", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEvent;", "<init>", "(Lcom/intellij/codeInsight/inline/completion/InlineCompletionEvent;)V", "getEvent", "()Lcom/intellij/codeInsight/inline/completion/InlineCompletionEvent;", "intellij.platform.ide.codeinsight.inline"})
                public static final class Event
                implements Reason {
                    @NotNull
                    private final InlineCompletionEvent event;

                    public Event(@NotNull InlineCompletionEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        this.event = event;
                    }

                    @NotNull
                    public final InlineCompletionEvent getEvent() {
                        return this.event;
                    }
                }

                @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated$Reason$UnclassifiedDocumentChange;", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Invalidated$Reason;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ide.codeinsight.inline"})
                public static final class UnclassifiedDocumentChange
                implements Reason {
                    @NotNull
                    public static final UnclassifiedDocumentChange INSTANCE = new UnclassifiedDocumentChange();

                    private UnclassifiedDocumentChange() {
                    }

                    @NotNull
                    public String toString() {
                        return "UnclassifiedDocumentChange";
                    }

                    public int hashCode() {
                        return 400733976;
                    }

                    public boolean equals(@Nullable Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof UnclassifiedDocumentChange)) {
                            return false;
                        }
                        UnclassifiedDocumentChange cfr_ignored_0 = (UnclassifiedDocumentChange)other;
                        return true;
                    }
                }
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult$Succeeded;", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSessionManager$UpdateSessionResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ide.codeinsight.inline"})
        public static final class Succeeded
        implements UpdateSessionResult {
            @NotNull
            public static final Succeeded INSTANCE = new Succeeded();

            private Succeeded() {
            }

            @NotNull
            public String toString() {
                return "Succeeded";
            }

            public int hashCode() {
                return -769124739;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Succeeded)) {
                    return false;
                }
                Succeeded cfr_ignored_0 = (Succeeded)other;
                return true;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InlineCompletionVariant.Snapshot.State.values().length];
            try {
                nArray[InlineCompletionVariant.Snapshot.State.COMPUTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InlineCompletionVariant.Snapshot.State.INVALIDATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

