/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.session;

import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.codeInsight.inline.completion.InlineCompletionProvider;
import com.intellij.codeInsight.inline.completion.InlineCompletionRequest;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionContext;
import com.intellij.codeInsight.inline.completion.suggestion.InlineCompletionSuggestionUpdateManager;
import com.intellij.codeInsight.inline.completion.suggestion.InlineCompletionVariant;
import com.intellij.codeInsight.inline.completion.suggestion.InlineCompletionVariantsProvider;
import com.intellij.codeInsight.inline.edit.InlineEditRequestJob;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u0001:\u0002./B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u001aH\u0007J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0007J\b\u0010\u001f\u001a\u00020\u001eH\u0007J\b\u0010 \u001a\u00020\u001eH\u0016J\u0017\u0010!\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0001\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010$\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b%J)\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*H\u0001\u00a2\u0006\u0002\b-R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00060"}, d2={"Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSession;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "provider", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionProvider;", "request", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/inline/completion/InlineCompletionProvider;Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getProvider", "()Lcom/intellij/codeInsight/inline/completion/InlineCompletionProvider;", "getRequest", "()Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;", "job", "Lcom/intellij/codeInsight/inline/edit/InlineEditRequestJob;", "Lkotlinx/coroutines/Job;", "variantsProvider", "Lcom/intellij/codeInsight/inline/completion/suggestion/InlineCompletionVariantsProvider;", "context", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionContext;", "getContext", "()Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionContext;", "isActive", "", "capture", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSession$Snapshot;", "useNextVariant", "", "usePrevVariant", "dispose", "assignJob", "assignJob-7WBNr6U$intellij_platform_ide_codeinsight_inline", "(Lkotlinx/coroutines/Job;)V", "assignVariants", "assignVariants$intellij_platform_ide_codeinsight_inline", "update", "event", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEvent;", "updater", "Lkotlin/Function1;", "Lcom/intellij/codeInsight/inline/completion/suggestion/InlineCompletionVariant$Snapshot;", "Lcom/intellij/codeInsight/inline/completion/suggestion/InlineCompletionSuggestionUpdateManager$UpdateResult;", "update$intellij_platform_ide_codeinsight_inline", "Snapshot", "Companion", "intellij.platform.ide.codeinsight.inline"})
@SourceDebugExtension(value={"SMAP\nInlineCompletionSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionSession.kt\ncom/intellij/codeInsight/inline/completion/session/InlineCompletionSession\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,206:1\n23#2:207\n*S KotlinDebug\n*F\n+ 1 InlineCompletionSession.kt\ncom/intellij/codeInsight/inline/completion/session/InlineCompletionSession\n*L\n171#1:207\n*E\n"})
public final class InlineCompletionSession
implements Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Editor editor;
    @NotNull
    private final InlineCompletionProvider provider;
    @NotNull
    private final InlineCompletionRequest request;
    @Nullable
    private Job job;
    @Nullable
    private InlineCompletionVariantsProvider variantsProvider;
    @NotNull
    private final InlineCompletionContext context;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<InlineCompletionSession> INLINE_COMPLETION_SESSION;

    private InlineCompletionSession(Editor editor, InlineCompletionProvider provider, InlineCompletionRequest request2) {
        this.editor = editor;
        this.provider = provider;
        this.request = request2;
        Language language = this.request.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        this.context = new InlineCompletionContext(this.editor, language, this.request.getEndOffset());
        Disposer.register((Disposable)this, (Disposable)this.context);
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final InlineCompletionProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final InlineCompletionRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final InlineCompletionContext getContext() {
        return this.context;
    }

    @RequiresEdt
    public final boolean isActive() {
        return this.variantsProvider != null && !this.context.isDisposed();
    }

    @RequiresEdt
    @Nullable
    public final Snapshot capture() {
        ThreadingAssertions.assertEventDispatchThread();
        Object object = this.variantsProvider;
        if (object == null || (object = object.captureVariants()) == null) {
            return null;
        }
        Object variants = object;
        return new Snapshot((List<InlineCompletionVariant.Snapshot>)variants);
    }

    @RequiresEdt
    public final void useNextVariant() {
        block0: {
            ThreadingAssertions.assertEventDispatchThread();
            InlineCompletionVariantsProvider inlineCompletionVariantsProvider = this.variantsProvider;
            if (inlineCompletionVariantsProvider == null) break block0;
            inlineCompletionVariantsProvider.useNextVariant();
        }
    }

    @RequiresEdt
    public final void usePrevVariant() {
        block0: {
            ThreadingAssertions.assertEventDispatchThread();
            InlineCompletionVariantsProvider inlineCompletionVariantsProvider = this.variantsProvider;
            if (inlineCompletionVariantsProvider == null) break block0;
            inlineCompletionVariantsProvider.usePrevVariant();
        }
    }

    public void dispose() {
    }

    @RequiresEdt
    public final void assignJob-7WBNr6U$intellij_platform_ide_codeinsight_inline(@NotNull Job job2) {
        Intrinsics.checkNotNullParameter((Object)job2, (String)"$v$c$com-intellij-codeInsight-inline-edit-InlineEditRequestJob$-job$0");
        ThreadingAssertions.assertEventDispatchThread();
        if (!(this.job == null)) {
            boolean bl = false;
            String string = "Inline Completion Session job is already assigned.";
            throw new IllegalStateException(string.toString());
        }
        this.job = job2;
        Disposer.register((Disposable)this, (Disposable)InlineEditRequestJob.box-impl(job2));
    }

    @RequiresEdt
    public final void assignVariants$intellij_platform_ide_codeinsight_inline(@NotNull InlineCompletionVariantsProvider variantsProvider) {
        Intrinsics.checkNotNullParameter((Object)variantsProvider, (String)"variantsProvider");
        ThreadingAssertions.assertEventDispatchThread();
        if (!(this.variantsProvider == null)) {
            boolean bl = false;
            String string = "Inline Completion variants provider is already assigned.";
            throw new IllegalStateException(string.toString());
        }
        this.variantsProvider = variantsProvider;
        Disposer.register((Disposable)this, (Disposable)variantsProvider);
    }

    @RequiresEdt
    public final boolean update$intellij_platform_ide_codeinsight_inline(@NotNull InlineCompletionEvent event, @NotNull Function1<? super InlineCompletionVariant.Snapshot, ? extends InlineCompletionSuggestionUpdateManager.UpdateResult> updater) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        if (!this.isActive()) {
            throw new IllegalStateException("Check failed.");
        }
        InlineCompletionVariantsProvider inlineCompletionVariantsProvider = this.variantsProvider;
        if (inlineCompletionVariantsProvider == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return inlineCompletionVariantsProvider.update(event, updater);
    }

    public /* synthetic */ InlineCompletionSession(Editor editor, InlineCompletionProvider provider, InlineCompletionRequest request2, DefaultConstructorMarker $constructor_marker) {
        this(editor, provider, request2);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"inline.completion.session");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        INLINE_COMPLETION_SESSION = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ-\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSession$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "INLINE_COMPLETION_SESSION", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSession;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getOrNull", "editor", "Lcom/intellij/openapi/editor/Editor;", "init", "provider", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionProvider;", "request", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "init$intellij_platform_ide_codeinsight_inline", "remove", "", "remove$intellij_platform_ide_codeinsight_inline", "intellij.platform.ide.codeinsight.inline"})
    @SourceDebugExtension(value={"SMAP\nInlineCompletionSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionSession.kt\ncom/intellij/codeInsight/inline/completion/session/InlineCompletionSession$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final InlineCompletionSession getOrNull(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (InlineCompletionSession)editor.getUserData(INLINE_COMPLETION_SESSION);
        }

        @RequiresEdt
        @NotNull
        public final InlineCompletionSession init$intellij_platform_ide_codeinsight_inline(@NotNull Editor editor, @NotNull InlineCompletionProvider provider, @NotNull InlineCompletionRequest request2, @NotNull Disposable parentDisposable) {
            InlineCompletionSession inlineCompletionSession;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            InlineCompletionSession currentSession = this.getOrNull(editor);
            if (!(currentSession == null)) {
                boolean $i$a$-check-InlineCompletionSession$Companion$init$22 = false;
                String $i$a$-check-InlineCompletionSession$Companion$init$22 = "Inline completion session already exists.";
                throw new IllegalStateException($i$a$-check-InlineCompletionSession$Companion$init$22.toString());
            }
            InlineCompletionSession it = inlineCompletionSession = new InlineCompletionSession(editor, provider, request2, null);
            boolean bl = false;
            Disposer.register((Disposable)parentDisposable, (Disposable)it);
            editor.putUserData(INLINE_COMPLETION_SESSION, (Object)it);
            return inlineCompletionSession;
        }

        @RequiresEdt
        public final void remove$intellij_platform_ide_codeinsight_inline(@NotNull Editor editor) {
            block2: {
                InlineCompletionSession inlineCompletionSession;
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                InlineCompletionSession inlineCompletionSession2 = this.getOrNull(editor);
                if (inlineCompletionSession2 == null) break block2;
                InlineCompletionSession $this$remove_u24lambda_u240 = inlineCompletionSession = inlineCompletionSession2;
                boolean bl = false;
                if (!$this$remove_u24lambda_u240.getContext().isDisposed()) {
                    Disposer.dispose((Disposable)$this$remove_u24lambda_u240);
                    LOG.trace("[Inline Completion] Remove inline completion session");
                } else {
                    LOG.warn("[Inline Completion] Cannot dispose session because it's already disposed.");
                }
                editor.putUserData(INLINE_COMPLETION_SESSION, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSession$Snapshot;", "", "variants", "", "Lcom/intellij/codeInsight/inline/completion/suggestion/InlineCompletionVariant$Snapshot;", "<init>", "(Ljava/util/List;)V", "getVariants", "()Ljava/util/List;", "activeVariant", "getActiveVariant", "()Lcom/intellij/codeInsight/inline/completion/suggestion/InlineCompletionVariant$Snapshot;", "variantsNumber", "", "getVariantsNumber", "()I", "nonEmptyVariantsRange", "Lkotlin/ranges/IntRange;", "getNonEmptyVariantsRange", "()Lkotlin/ranges/IntRange;", "intellij.platform.ide.codeinsight.inline"})
    @SourceDebugExtension(value={"SMAP\nInlineCompletionSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionSession.kt\ncom/intellij/codeInsight/inline/completion/session/InlineCompletionSession$Snapshot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n230#2,2:207\n1788#2,4:209\n1788#2,4:213\n*S KotlinDebug\n*F\n+ 1 InlineCompletionSession.kt\ncom/intellij/codeInsight/inline/completion/session/InlineCompletionSession$Snapshot\n*L\n142#1:207,2\n160#1:209,4\n161#1:213,4\n*E\n"})
    public static final class Snapshot {
        @NotNull
        private final List<InlineCompletionVariant.Snapshot> variants;
        @NotNull
        private final InlineCompletionVariant.Snapshot activeVariant;
        @ApiStatus.Experimental
        @NotNull
        private final IntRange nonEmptyVariantsRange;

        /*
         * WARNING - void declaration
         */
        @ApiStatus.Internal
        public Snapshot(@NotNull List<InlineCompletionVariant.Snapshot> variants) {
            int n;
            int n2;
            void $this$nonEmptyVariantsRange_u24lambda_u240;
            Object element$iv2;
            Snapshot snapshot;
            block7: {
                void $this$first$iv;
                Intrinsics.checkNotNullParameter(variants, (String)"variants");
                this.variants = variants;
                Iterable iterable = this.variants;
                snapshot = this;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    InlineCompletionVariant.Snapshot it = (InlineCompletionVariant.Snapshot)element$iv2;
                    boolean bl = false;
                    if (!it.isActive()) continue;
                    break block7;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            snapshot.activeVariant = (InlineCompletionVariant.Snapshot)element$iv2;
            Snapshot $i$f$first = this;
            snapshot = this;
            boolean bl = false;
            Iterable $this$count$iv = $this$nonEmptyVariantsRange_u24lambda_u240.variants;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv3 : $this$count$iv) {
                    InlineCompletionVariant.Snapshot it = (InlineCompletionVariant.Snapshot)element$iv3;
                    boolean bl2 = false;
                    if (!(!it.isEmpty()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int forSure = n2;
            Iterable $this$count$iv2 = $this$nonEmptyVariantsRange_u24lambda_u240.variants;
            boolean $i$f$count2 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv4 : $this$count$iv2) {
                    InlineCompletionVariant.Snapshot it = (InlineCompletionVariant.Snapshot)element$iv4;
                    boolean bl3 = false;
                    if (!(!it.isEmpty() || it.getState() == InlineCompletionVariant.Snapshot.State.IN_PROGRESS || it.getState() == InlineCompletionVariant.Snapshot.State.UNTOUCHED) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int potential = n;
            snapshot.nonEmptyVariantsRange = new IntRange(forSure, potential);
        }

        @NotNull
        public final List<InlineCompletionVariant.Snapshot> getVariants() {
            return this.variants;
        }

        @NotNull
        public final InlineCompletionVariant.Snapshot getActiveVariant() {
            return this.activeVariant;
        }

        public final int getVariantsNumber() {
            return this.variants.size();
        }

        @NotNull
        public final IntRange getNonEmptyVariantsRange() {
            return this.nonEmptyVariantsRange;
        }
    }
}

