/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListener;
import com.intellij.ide.favoritesTreeView.FavoritesViewSettings;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="FavoritesManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
@Deprecated(forRemoval=true)
@ApiStatus.Obsolete
public final class FavoritesManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(FavoritesManager.class);
    private final Map<String, List<TreeItem<Pair<AbstractUrl, String>>>> myName2FavoritesRoots;
    private final List<String> myFavoritesRootsOrder;
    private final Project myProject;
    private final List<FavoritesListener> myListeners;
    private final FavoritesViewSettings myViewSettings;
    @NonNls
    private static final String CLASS_NAME = "klass";
    @NonNls
    private static final String FAVORITES_ROOT = "favorite_root";
    @NonNls
    private static final String ELEMENT_FAVORITES_LIST = "favorites_list";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @NonNls
    private static final String ATTRIBUTE_MODULE = "module";

    public static FavoritesManager getInstance(@NotNull Project project) {
        if (project == null) {
            FavoritesManager.$$$reportNull$$$0(0);
        }
        return (FavoritesManager)project.getService(FavoritesManager.class);
    }

    public FavoritesManager(@NotNull Project project) {
        if (project == null) {
            FavoritesManager.$$$reportNull$$$0(1);
        }
        this.myName2FavoritesRoots = new TreeMap<String, List<TreeItem<Pair<AbstractUrl, String>>>>();
        this.myFavoritesRootsOrder = new ArrayList<String>();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myViewSettings = new FavoritesViewSettings();
        this.myProject = project;
        FavoritesListProvider.EP_NAME.getPoint((AreaInstance)this.myProject).addChangeListener(() -> this.rootsChanged(), (Disposable)this.myProject);
    }

    private void rootsChanged() {
        for (FavoritesListener listener : this.myListeners) {
            listener.rootsChanged();
        }
    }

    private void listAdded(@NotNull String listName) {
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(2);
        }
        for (FavoritesListener listener : this.myListeners) {
            listener.listAdded(listName);
        }
    }

    public void addFavoritesListener(final FavoritesListener listener, @NotNull Disposable parent) {
        if (parent == null) {
            FavoritesManager.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener);
        listener.rootsChanged();
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                FavoritesManager.this.myListeners.remove(listener);
            }
        });
    }

    @NotNull
    public List<String> getAvailableFavoritesListNames() {
        return new ArrayList<String>(this.myFavoritesRootsOrder);
    }

    public synchronized void createNewList(@NotNull String listName) {
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(4);
        }
        this.myName2FavoritesRoots.put(listName, new ArrayList());
        this.myFavoritesRootsOrder.add(listName);
        this.listAdded(listName);
    }

    @Deprecated
    public synchronized void fireListeners(@NotNull String listName) {
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(5);
        }
        ((BookmarksListener)this.myProject.getMessageBus().syncPublisher(BookmarksListener.TOPIC)).structureChanged(null);
        this.rootsChanged();
    }

    @NotNull
    FavoritesViewSettings getViewSettings() {
        FavoritesViewSettings favoritesViewSettings = this.myViewSettings;
        if (favoritesViewSettings == null) {
            FavoritesManager.$$$reportNull$$$0(6);
        }
        return favoritesViewSettings;
    }

    @NotNull
    public List<TreeItem<Pair<AbstractUrl, String>>> getFavoritesListRootUrls(@NotNull String name) {
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> pairs;
        if (name == null) {
            FavoritesManager.$$$reportNull$$$0(7);
        }
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> arrayList = (pairs = this.myName2FavoritesRoots.get(name)) == null ? new ArrayList<TreeItem<Pair<AbstractUrl, String>>>() : pairs;
        if (arrayList == null) {
            FavoritesManager.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public synchronized boolean addRoots(@NotNull String name, Module moduleContext, @NotNull Object elements) {
        if (name == null) {
            FavoritesManager.$$$reportNull$$$0(9);
        }
        if (elements == null) {
            FavoritesManager.$$$reportNull$$$0(10);
        }
        return true;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            FavoritesManager.$$$reportNull$$$0(11);
        }
        this.myName2FavoritesRoots.clear();
        for (Element list : element.getChildren(ELEMENT_FAVORITES_LIST)) {
            String name = list.getAttributeValue(ATTRIBUTE_NAME);
            List<TreeItem<Pair<AbstractUrl, String>>> roots = FavoritesManager.readRoots(list, this.myProject);
            this.myName2FavoritesRoots.put(name, roots);
            this.myFavoritesRootsOrder.add(name);
        }
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void noStateLoaded() {
        LOG.info("no state loaded for old favorites");
    }

    private static List<TreeItem<Pair<AbstractUrl, String>>> readRoots(Element list, Project project) {
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> result = new ArrayList<TreeItem<Pair<AbstractUrl, String>>>();
        FavoritesManager.readFavoritesOneLevel(list, project, result);
        return result;
    }

    private static void readFavoritesOneLevel(Element list, Project project, Collection<? super TreeItem<Pair<AbstractUrl, String>>> result) {
        for (Element favorite : list.getChildren(FAVORITES_ROOT)) {
            String className = favorite.getAttributeValue(CLASS_NAME);
            AbstractUrl abstractUrl = FavoritesManager.readUrlFromElement(favorite, project);
            if (abstractUrl == null) continue;
            TreeItem treeItem = new TreeItem((Object)Pair.create((Object)abstractUrl, (Object)className));
            result.add((TreeItem<Pair<AbstractUrl, String>>)treeItem);
            FavoritesManager.readFavoritesOneLevel(favorite, project, treeItem.getChildren());
        }
    }

    @Nullable
    private static AbstractUrl readUrlFromElement(Element element, Project project) {
        String type = element.getAttributeValue(ATTRIBUTE_TYPE);
        String urlValue = element.getAttributeValue(ATTRIBUTE_URL);
        String moduleName = element.getAttributeValue(ATTRIBUTE_MODULE);
        for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])FavoriteNodeProvider.EP_NAME.getExtensions((AreaInstance)project)) {
            if (!nodeProvider.getFavoriteTypeId().equals(type)) continue;
            return new AbstractUrlFavoriteAdapter(urlValue, moduleName, nodeProvider);
        }
        for (AbstractUrl urlProvider : AbstractUrl.getAbstractUrlProviders()) {
            AbstractUrl url = urlProvider.createUrl(type, moduleName, urlValue);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public Element getState() {
        Element element = new Element("state");
        for (String name : this.myFavoritesRootsOrder) {
            Element list = new Element(ELEMENT_FAVORITES_LIST);
            list.setAttribute(ATTRIBUTE_NAME, name);
            FavoritesManager.writeRoots(list, (Collection<? extends TreeItem<Pair<AbstractUrl, String>>>)this.myName2FavoritesRoots.get(name));
            element.addContent(list);
        }
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        return element;
    }

    private static void writeRoots(Element element, Collection<? extends TreeItem<Pair<AbstractUrl, String>>> roots) {
        for (TreeItem<Pair<AbstractUrl, String>> treeItem : roots) {
            AbstractUrl url = (AbstractUrl)((Pair)treeItem.getData()).getFirst();
            if (url == null) continue;
            Element list = new Element(FAVORITES_ROOT);
            url.write(list);
            list.setAttribute(CLASS_NAME, (String)((Pair)treeItem.getData()).getSecond());
            element.addContent(list);
            List children = treeItem.getChildren();
            if (children.isEmpty()) continue;
            FavoritesManager.writeRoots(list, children);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/FavoritesManager";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoritesManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoritesListRootUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "listAdded";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFavoritesListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNewList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fireListeners";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFavoritesListRootUrls";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addRoots";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }
}

