/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPathBoundDescriptor;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/ide/impl/wsl/WslEelDescriptor;", "Lcom/intellij/platform/eel/EelPathBoundDescriptor;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "fsRoot", "", "<init>", "(Lcom/intellij/execution/wsl/WSLDistribution;Ljava/lang/String;)V", "(Lcom/intellij/execution/wsl/WSLDistribution;)V", "getDistribution", "()Lcom/intellij/execution/wsl/WSLDistribution;", "getFsRoot$intellij_platform_ide_impl_wsl", "()Ljava/lang/String;", "rootPath", "Ljava/nio/file/Path;", "getRootPath", "()Ljava/nio/file/Path;", "name", "Lorg/jetbrains/annotations/NonNls;", "getName", "osFamily", "Lcom/intellij/platform/eel/EelOsFamily;", "getOsFamily", "()Lcom/intellij/platform/eel/EelOsFamily;", "equals", "", "other", "", "hashCode", "", "intellij.platform.ide.impl.wsl"})
@SourceDebugExtension(value={"SMAP\nWslEelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslEelProvider.kt\ncom/intellij/platform/ide/impl/wsl/WslEelDescriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n1#2:279\n*E\n"})
public final class WslEelDescriptor
implements EelPathBoundDescriptor {
    @NotNull
    private final WSLDistribution distribution;
    @NotNull
    private final String fsRoot;
    @NotNull
    private final String name;
    @NotNull
    private final EelOsFamily osFamily;

    public WslEelDescriptor(@NotNull WSLDistribution distribution, @NotNull String fsRoot) {
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        Intrinsics.checkNotNullParameter((Object)fsRoot, (String)"fsRoot");
        this.distribution = distribution;
        this.fsRoot = fsRoot;
        this.name = "WSL: " + this.distribution.getPresentableName();
        this.osFamily = EelOsFamily.Posix;
    }

    @NotNull
    public final WSLDistribution getDistribution() {
        return this.distribution;
    }

    @NotNull
    public final String getFsRoot$intellij_platform_ide_impl_wsl() {
        return this.fsRoot;
    }

    public WslEelDescriptor(@NotNull WSLDistribution distribution) {
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        Path path = distribution.getUNCRootPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getUNCRootPath(...)");
        this(distribution, ((Object)path).toString());
    }

    @NotNull
    public Path getRootPath() {
        String p0 = this.fsRoot;
        boolean bl = false;
        Path path = Paths.get(p0, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public EelOsFamily getOsFamily() {
        return this.osFamily;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.platform.ide.impl.wsl.WslEelDescriptor");
        WslEelDescriptor cfr_ignored_0 = (WslEelDescriptor)object2;
        if (!Intrinsics.areEqual((Object)this.distribution, (Object)((WslEelDescriptor)other).distribution)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fsRoot, (Object)((WslEelDescriptor)other).fsRoot);
    }

    public int hashCode() {
        int result = this.distribution.hashCode();
        result = 31 * result + this.fsRoot.hashCode();
        return result;
    }
}

