// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

package com.intellij.ide.gdpr.ui.consents

import com.intellij.ide.gdpr.Consent
import com.intellij.ide.gdpr.DataCollectionAgreement
import com.intellij.openapi.util.NlsSafe
import com.intellij.openapi.util.text.StringUtil

internal class TraceDataCollectionConsentUI(
  private val consent: Consent,
) : ConsentUi {
  override fun getCheckBoxText(): @NlsSafe String = StringUtil.capitalize(consent.name)

  override fun getCheckBoxCommentText(): @NlsSafe String = consent.text

  override fun getForcedState(): ConsentForcedState? {
    val externalSettings = AiDataCollectionExternalSettings.findSettingsImplementedByAiAssistant()
    if (externalSettings != null && externalSettings.isForciblyDisabled()) {
      return ConsentForcedState.ExternallyDisabled(null)
    }
    val dataCollectionAgreement = DataCollectionAgreement.getInstance()
    val forcedState = when (dataCollectionAgreement) {
      DataCollectionAgreement.YES -> ConsentForcedState.AlwaysEnabled(null)
      DataCollectionAgreement.NO -> ConsentForcedState.ExternallyDisabled(null)
      DataCollectionAgreement.NOT_SET -> null
      else -> null
    }
    if (forcedState != null) {
      return forcedState
    }
    return null
  }
}