/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.util.Condition;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeColorDescriptionPanel
extends JPanel
implements OptionsPanelImpl.ColorDescriptionPanel {
    @NotNull
    protected final List<OptionsPanelImpl.ColorDescriptionPanel> myDescriptionPanels = new ArrayList<OptionsPanelImpl.ColorDescriptionPanel>();
    @NotNull
    protected final List<Condition<? super EditorSchemeAttributeDescriptor>> myConditions = new ArrayList<Condition<? super EditorSchemeAttributeDescriptor>>();
    @NotNull
    private final List<OptionsPanelImpl.ColorDescriptionPanel.Listener> myListeners = new ArrayList<OptionsPanelImpl.ColorDescriptionPanel.Listener>();
    private OptionsPanelImpl.ColorDescriptionPanel myActive;

    public void addDescriptionPanel(@NotNull OptionsPanelImpl.ColorDescriptionPanel descriptionPanel, @NotNull Condition<? super EditorSchemeAttributeDescriptor> condition) {
        if (descriptionPanel == null) {
            CompositeColorDescriptionPanel.$$$reportNull$$$0(0);
        }
        if (condition == null) {
            CompositeColorDescriptionPanel.$$$reportNull$$$0(1);
        }
        this.myDescriptionPanels.add(descriptionPanel);
        this.myConditions.add(condition);
        for (OptionsPanelImpl.ColorDescriptionPanel.Listener listener2 : this.myListeners) {
            descriptionPanel.addListener(listener2);
        }
        this.updatePreferredSize();
    }

    private void updatePreferredSize() {
        Dimension preferredSize = new Dimension();
        for (OptionsPanelImpl.ColorDescriptionPanel panel2 : this.myDescriptionPanels) {
            Dimension size2 = panel2.getPanel().getPreferredSize();
            preferredSize.setSize(Math.max(size2.getWidth(), preferredSize.getWidth()), Math.max(size2.getHeight(), preferredSize.getHeight()));
        }
        this.setPreferredSize(preferredSize);
    }

    @Override
    @NotNull
    public JComponent getPanel() {
        CompositeColorDescriptionPanel compositeColorDescriptionPanel = this;
        if (compositeColorDescriptionPanel == null) {
            CompositeColorDescriptionPanel.$$$reportNull$$$0(2);
        }
        return compositeColorDescriptionPanel;
    }

    @Override
    public void resetDefault() {
        if (this.myActive != null) {
            PaintLocker locker = new PaintLocker(this);
            try {
                this.setPreferredSize(this.getSize());
                this.remove(this.myActive.getPanel());
                this.myActive = null;
            }
            finally {
                locker.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(@NotNull EditorSchemeAttributeDescriptor descriptor) {
        JComponent newPanel;
        if (descriptor == null) {
            CompositeColorDescriptionPanel.$$$reportNull$$$0(3);
        }
        JComponent oldPanel = this.myActive == null ? null : this.myActive.getPanel();
        this.myActive = this.getPanelForDescriptor(descriptor);
        JComponent jComponent = newPanel = this.myActive == null ? null : this.myActive.getPanel();
        if (oldPanel != newPanel) {
            PaintLocker locker = new PaintLocker(this);
            try {
                if (oldPanel != null) {
                    this.remove(oldPanel);
                }
                if (newPanel != null) {
                    this.setPreferredSize(null);
                    this.add(newPanel);
                }
            }
            finally {
                locker.release();
            }
        }
        if (this.myActive != null) {
            this.myActive.reset(descriptor);
        }
    }

    @Nullable
    private OptionsPanelImpl.ColorDescriptionPanel getPanelForDescriptor(@NotNull EditorSchemeAttributeDescriptor descriptor) {
        if (descriptor == null) {
            CompositeColorDescriptionPanel.$$$reportNull$$$0(4);
        }
        for (int i2 = this.myConditions.size() - 1; i2 >= 0; --i2) {
            Condition<? super EditorSchemeAttributeDescriptor> condition = this.myConditions.get(i2);
            OptionsPanelImpl.ColorDescriptionPanel panel2 = this.myDescriptionPanels.get(i2);
            if (!condition.value((Object)descriptor)) continue;
            return panel2;
        }
        return null;
    }

    @Override
    public void apply(@NotNull EditorSchemeAttributeDescriptor descriptor, EditorColorsScheme scheme) {
        if (descriptor == null) {
            CompositeColorDescriptionPanel.$$$reportNull$$$0(5);
        }
        if (this.myActive != null) {
            this.myActive.apply(descriptor, scheme);
        }
    }

    @Override
    public void addListener(@NotNull OptionsPanelImpl.ColorDescriptionPanel.Listener listener2) {
        if (listener2 == null) {
            CompositeColorDescriptionPanel.$$$reportNull$$$0(6);
        }
        for (OptionsPanelImpl.ColorDescriptionPanel panel2 : this.myDescriptionPanels) {
            panel2.addListener(listener2);
        }
        this.myListeners.add(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/CompositeColorDescriptionPanel";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/CompositeColorDescriptionPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptionPanel";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPanelForDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class PaintLocker {
        private final Container myPaintHolder;
        private final boolean myPaintState;

        PaintLocker(@NotNull JComponent component2) {
            if (component2 == null) {
                PaintLocker.$$$reportNull$$$0(0);
            }
            this.myPaintHolder = component2.getParent();
            this.myPaintState = this.myPaintHolder.getIgnoreRepaint();
            this.myPaintHolder.setIgnoreRepaint(true);
        }

        public void release() {
            this.myPaintHolder.validate();
            this.myPaintHolder.setIgnoreRepaint(this.myPaintState);
            this.myPaintHolder.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/application/options/colors/CompositeColorDescriptionPanel$PaintLocker", "<init>"));
        }
    }
}

