/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.editor.fonts.AppEditorFontConfigurable;
import com.intellij.application.options.editor.fonts.AppEditorFontOptionsPanel;
import com.intellij.application.options.editor.fonts.AppFontConfigurable;
import com.intellij.application.options.editor.fonts.AppFontOptionsPanel;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppConsoleFontOptions;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.AppFontOptions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AppConsoleFontConfigurable
extends AppFontConfigurable {
    public static final String ID = "app.console.font";
    private ConsoleFontOptionsPanel myFontOptionsPanel;

    public String getDisplayName() {
        return IdeBundle.message((String)"configurable.console.font.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    protected AppFontOptions<?> getFontOptions() {
        AppConsoleFontOptions appConsoleFontOptions = AppConsoleFontOptions.getInstance();
        if (appConsoleFontOptions == null) {
            AppConsoleFontConfigurable.$$$reportNull$$$0(0);
        }
        return appConsoleFontOptions;
    }

    @Override
    @NotNull
    protected AppFontOptionsPanel createFontOptionsPanel(@NotNull EditorColorsScheme previewScheme) {
        if (previewScheme == null) {
            AppConsoleFontConfigurable.$$$reportNull$$$0(1);
        }
        ConsoleFontOptionsPanel consoleFontOptionsPanel = this.myFontOptionsPanel = new ConsoleFontOptionsPanel(previewScheme);
        if (consoleFontOptionsPanel == null) {
            AppConsoleFontConfigurable.$$$reportNull$$$0(2);
        }
        return consoleFontOptionsPanel;
    }

    @Override
    public boolean isModified() {
        boolean isUseEditorFont = AppConsoleFontOptions.getInstance().isUseEditorFont();
        return this.myFontOptionsPanel.myUseEditorFontBox.isSelected() ? !isUseEditorFont : isUseEditorFont || super.isModified();
    }

    @Override
    protected void applyFontPreferences() {
        boolean isUseEditorFont = this.myFontOptionsPanel.myUseEditorFontBox.isSelected();
        AppConsoleFontOptions.getInstance().setUseEditorFont(isUseEditorFont);
        if (!isUseEditorFont) {
            super.applyFontPreferences();
        }
    }

    @Override
    public void reset() {
        this.myFontOptionsPanel.myUseEditorFontBox.setSelected(AppConsoleFontOptions.getInstance().isUseEditorFont());
        super.reset();
    }

    void updateOnEditorFontChange(@NotNull FontPreferences fontPreferences) {
        if (fontPreferences == null) {
            AppConsoleFontConfigurable.$$$reportNull$$$0(3);
        }
        if (this.myFontOptionsPanel != null) {
            this.myFontOptionsPanel.updateOnEditorFontChange(fontPreferences);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/editor/fonts/AppConsoleFontConfigurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewScheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontOptions";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/editor/fonts/AppConsoleFontConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFontOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFontOptionsPanel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateOnEditorFontChange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }

    private static final class ConsoleFontOptionsPanel
    extends AppFontOptionsPanel {
        private JCheckBox myUseEditorFontBox;

        private ConsoleFontOptionsPanel(@NotNull EditorColorsScheme scheme) {
            if (scheme == null) {
                ConsoleFontOptionsPanel.$$$reportNull$$$0(0);
            }
            super(scheme);
        }

        @Override
        @NotNull
        protected JComponent createControls() {
            JPanel outerPanel = new JPanel(new BorderLayout());
            this.myUseEditorFontBox = new JCheckBox(IdeBundle.message((String)"configurable.console.font.use.editor.font", (Object[])new Object[0]));
            this.myUseEditorFontBox.setSelected(this.isReadOnly());
            this.myUseEditorFontBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (myUseEditorFontBox.isSelected()) {
                        this.getEditorFontPreferences().copyTo(this.getFontPreferences());
                    }
                    this.updateOnChangedFont();
                }
            });
            this.myUseEditorFontBox.setBorder((Border)JBUI.Borders.empty((int)10, (int)0));
            outerPanel.add((Component)this.myUseEditorFontBox, "North");
            JComponent innerControls = super.createControls();
            outerPanel.add((Component)innerControls, "Center");
            JPanel jPanel = outerPanel;
            if (jPanel == null) {
                ConsoleFontOptionsPanel.$$$reportNull$$$0(1);
            }
            return jPanel;
        }

        @Override
        protected boolean isReadOnly() {
            return this.myUseEditorFontBox.isSelected();
        }

        private void updateOnEditorFontChange(@NotNull FontPreferences fontPreferences) {
            if (fontPreferences == null) {
                ConsoleFontOptionsPanel.$$$reportNull$$$0(2);
            }
            if (this.myUseEditorFontBox.isSelected()) {
                fontPreferences.copyTo(this.getFontPreferences());
                this.updateOnChangedFont();
            }
        }

        @NotNull
        private FontPreferences getEditorFontPreferences() {
            AppEditorFontOptionsPanel panel2;
            AppEditorFontConfigurable configurable = (AppEditorFontConfigurable)AppFontConfigurable.findConfigurable(this, AppEditorFontConfigurable.class);
            if (configurable != null && (panel2 = configurable.getPanel()) != null) {
                FontPreferences fontPreferences = panel2.getFontPreferences();
                if (fontPreferences == null) {
                    ConsoleFontOptionsPanel.$$$reportNull$$$0(3);
                }
                return fontPreferences;
            }
            FontPreferences fontPreferences = AppEditorFontOptions.getInstance().getFontPreferences();
            if (fontPreferences == null) {
                ConsoleFontOptionsPanel.$$$reportNull$$$0(4);
            }
            return fontPreferences;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/editor/fonts/AppConsoleFontConfigurable$ConsoleFontOptionsPanel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fontPreferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/editor/fonts/AppConsoleFontConfigurable$ConsoleFontOptionsPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createControls";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorFontPreferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updateOnEditorFontChange";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Provider
    extends ConfigurableProvider {
        @Nullable
        public Configurable createConfigurable() {
            return new AppConsoleFontConfigurable();
        }

        public boolean canCreateConfigurable() {
            return AppFontOptions.APP_CONSOLE_FONT_ENABLED;
        }
    }
}

