/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.EdtLockLoadMonitorService;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ReadActionListener;
import com.intellij.openapi.application.WriteIntentReadActionListener;
import com.intellij.util.ui.EDT;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0013\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\u0014\u0010\u0016\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\u0014\u0010\u0017\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\u0014\u0010\u0018\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\u0014\u0010\u0019\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\f\u0010\u001a\u001a\u00020\u000e*\u00020\nH\u0002J\f\u0010\u001b\u001a\u00020\u000e*\u00020\nH\u0002J\f\u0010\u001c\u001a\u00020\u000e*\u00020\nH\u0002J\u0006\u0010\u001d\u001a\u00020\u001eR\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/diagnostic/EdtLockLoadListener;", "Lcom/intellij/openapi/application/ApplicationListener;", "Lcom/intellij/openapi/application/ReadActionListener;", "Lcom/intellij/openapi/application/WriteIntentReadActionListener;", "<init>", "()V", "epochStart", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "J", "writeLockDiagnosticData", "Lcom/intellij/diagnostic/EdtLockLoadListener$LockDiagnosticData;", "readLockDiagnosticData", "writeIntentReadLockDiagnosticData", "beforeWriteActionStart", "", "action", "", "writeActionStarted", "writeActionFinished", "beforeReadActionStart", "Ljava/lang/Class;", "readActionStarted", "readActionFinished", "beforeWriteIntentReadActionStart", "writeIntentReadActionStarted", "writeIntentReadActionFinished", "beforeLockAcquired", "lockAcquired", "lockReleased", "export", "Lcom/intellij/diagnostic/EdtLockLoadMonitorService$MeasurementData;", "LockDiagnosticData", "intellij.platform.ide.impl"})
public final class EdtLockLoadListener
implements ApplicationListener,
ReadActionListener,
WriteIntentReadActionListener {
    private final long epochStart = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
    @NotNull
    private final LockDiagnosticData writeLockDiagnosticData = new LockDiagnosticData(0, null, 0L, 0L, 15, null);
    @NotNull
    private final LockDiagnosticData readLockDiagnosticData = new LockDiagnosticData(0, null, 0L, 0L, 15, null);
    @NotNull
    private final LockDiagnosticData writeIntentReadLockDiagnosticData = new LockDiagnosticData(0, null, 0L, 0L, 15, null);

    public void beforeWriteActionStart(@NotNull Object action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        this.beforeLockAcquired(this.writeLockDiagnosticData);
    }

    public void writeActionStarted(@NotNull Object action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        this.lockAcquired(this.writeLockDiagnosticData);
    }

    public void writeActionFinished(@NotNull Object action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        this.lockReleased(this.writeLockDiagnosticData);
    }

    public void beforeReadActionStart(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        if (!EDT.isCurrentThreadEdt() || this.writeLockDiagnosticData.getLockAcquiredCounter() > 0 || this.writeIntentReadLockDiagnosticData.getLockAcquiredCounter() > 0) {
            return;
        }
        this.beforeLockAcquired(this.readLockDiagnosticData);
    }

    public void readActionStarted(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        if (!EDT.isCurrentThreadEdt() || this.writeLockDiagnosticData.getLockAcquiredCounter() > 0 || this.writeIntentReadLockDiagnosticData.getLockAcquiredCounter() > 0) {
            return;
        }
        this.lockAcquired(this.readLockDiagnosticData);
    }

    public void readActionFinished(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        if (!EDT.isCurrentThreadEdt() || this.writeLockDiagnosticData.getLockAcquiredCounter() > 0 || this.writeIntentReadLockDiagnosticData.getLockAcquiredCounter() > 0) {
            return;
        }
        this.lockReleased(this.readLockDiagnosticData);
    }

    public void beforeWriteIntentReadActionStart(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        if (!EDT.isCurrentThreadEdt() || this.writeLockDiagnosticData.getLockAcquiredCounter() > 0) {
            return;
        }
        this.beforeLockAcquired(this.writeIntentReadLockDiagnosticData);
    }

    public void writeIntentReadActionStarted(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        if (!EDT.isCurrentThreadEdt() || this.writeLockDiagnosticData.getLockAcquiredCounter() > 0) {
            return;
        }
        this.lockAcquired(this.writeIntentReadLockDiagnosticData);
    }

    public void writeIntentReadActionFinished(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        if (!EDT.isCurrentThreadEdt() || this.writeLockDiagnosticData.getLockAcquiredCounter() > 0) {
            return;
        }
        this.lockReleased(this.writeIntentReadLockDiagnosticData);
    }

    private final void beforeLockAcquired(LockDiagnosticData $this$beforeLockAcquired) {
        if ($this$beforeLockAcquired.getLockAcquiredCounter() == 0) {
            $this$beforeLockAcquired.setPreviousMark-rEXM0dE(TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()));
        }
    }

    private final void lockAcquired(LockDiagnosticData $this$lockAcquired) {
        if ($this$lockAcquired.getLockAcquiredCounter() == 0) {
            long now = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            TimeSource.Monotonic.ValueTimeMark intentToAcquire = $this$lockAcquired.getPreviousMark-LFT3Okc();
            if (intentToAcquire != null) {
                long timeToWaitForAcquisition = TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)now, (long)intentToAcquire.unbox-impl());
                $this$lockAcquired.setTotalAcquisitionIntentDuration-LRDsOJo(Duration.plus-LRDsOJo((long)$this$lockAcquired.getTotalAcquisitionIntentDuration-UwyO8pc(), (long)timeToWaitForAcquisition));
            }
            $this$lockAcquired.setPreviousMark-rEXM0dE(TimeSource.Monotonic.ValueTimeMark.box-impl((long)now));
        }
        $this$lockAcquired.setLockAcquiredCounter($this$lockAcquired.getLockAcquiredCounter() + 1);
    }

    private final void lockReleased(LockDiagnosticData $this$lockReleased) {
        $this$lockReleased.setLockAcquiredCounter($this$lockReleased.getLockAcquiredCounter() - 1);
        if ($this$lockReleased.getLockAcquiredCounter() == 0) {
            TimeSource.Monotonic.ValueTimeMark valueTimeMark = $this$lockReleased.getPreviousMark-LFT3Okc();
            if (valueTimeMark == null) {
                boolean bl = false;
                String string = "lockReleased() must be preceded by lockAcquired()";
                throw new IllegalArgumentException(string.toString());
            }
            long actionStart = valueTimeMark.unbox-impl();
            $this$lockReleased.setPreviousMark-rEXM0dE(null);
            long writeActionEnd = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            long difference = TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)writeActionEnd, (long)actionStart);
            $this$lockReleased.setTotalLockDuration-LRDsOJo(Duration.plus-LRDsOJo((long)$this$lockReleased.getTotalLockDuration-UwyO8pc(), (long)difference));
        }
    }

    @NotNull
    public final EdtLockLoadMonitorService.MeasurementData export() {
        if (!EDT.isCurrentThreadEdt()) {
            throw new IllegalStateException("Must be called on EDT; the values in this class are not thread-safe");
        }
        long epochDuration = TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto(), (long)this.epochStart);
        EdtLockLoadMonitorService.MeasurementData measurementData = new EdtLockLoadMonitorService.MeasurementData(epochDuration, this.writeLockDiagnosticData.getTotalAcquisitionIntentDuration-UwyO8pc(), this.writeLockDiagnosticData.getTotalLockDuration-UwyO8pc(), this.readLockDiagnosticData.getTotalAcquisitionIntentDuration-UwyO8pc(), this.readLockDiagnosticData.getTotalLockDuration-UwyO8pc(), this.writeIntentReadLockDiagnosticData.getTotalAcquisitionIntentDuration-UwyO8pc(), this.writeIntentReadLockDiagnosticData.getTotalLockDuration-UwyO8pc(), null);
        return measurementData;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u0014J\u0010\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b \u0010\u0014J:\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\"\u0010#J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006*"}, d2={"Lcom/intellij/diagnostic/EdtLockLoadListener$LockDiagnosticData;", "", "lockAcquiredCounter", "", "previousMark", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "totalLockDuration", "Lkotlin/time/Duration;", "totalAcquisitionIntentDuration", "<init>", "(ILkotlin/time/TimeSource$Monotonic$ValueTimeMark;JJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getLockAcquiredCounter", "()I", "setLockAcquiredCounter", "(I)V", "getPreviousMark-LFT3Okc", "()Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "setPreviousMark-rEXM0dE", "(Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;)V", "getTotalLockDuration-UwyO8pc", "()J", "setTotalLockDuration-LRDsOJo", "(J)V", "J", "getTotalAcquisitionIntentDuration-UwyO8pc", "setTotalAcquisitionIntentDuration-LRDsOJo", "component1", "component2", "component2-LFT3Okc", "component3", "component3-UwyO8pc", "component4", "component4-UwyO8pc", "copy", "copy-J2LNhJw", "(ILkotlin/time/TimeSource$Monotonic$ValueTimeMark;JJ)Lcom/intellij/diagnostic/EdtLockLoadListener$LockDiagnosticData;", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide.impl"})
    public static final class LockDiagnosticData {
        private int lockAcquiredCounter;
        @Nullable
        private TimeSource.Monotonic.ValueTimeMark previousMark;
        private long totalLockDuration;
        private long totalAcquisitionIntentDuration;

        private LockDiagnosticData(int lockAcquiredCounter, TimeSource.Monotonic.ValueTimeMark previousMark, long totalLockDuration, long totalAcquisitionIntentDuration) {
            this.lockAcquiredCounter = lockAcquiredCounter;
            this.previousMark = previousMark;
            this.totalLockDuration = totalLockDuration;
            this.totalAcquisitionIntentDuration = totalAcquisitionIntentDuration;
        }

        public /* synthetic */ LockDiagnosticData(int n, TimeSource.Monotonic.ValueTimeMark valueTimeMark, long l, long l2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                valueTimeMark = null;
            }
            if ((n2 & 4) != 0) {
                l = Duration.Companion.getZERO-UwyO8pc();
            }
            if ((n2 & 8) != 0) {
                l2 = Duration.Companion.getZERO-UwyO8pc();
            }
            this(n, valueTimeMark, l, l2, null);
        }

        public final int getLockAcquiredCounter() {
            return this.lockAcquiredCounter;
        }

        public final void setLockAcquiredCounter(int n) {
            this.lockAcquiredCounter = n;
        }

        @Nullable
        public final TimeSource.Monotonic.ValueTimeMark getPreviousMark-LFT3Okc() {
            return this.previousMark;
        }

        public final void setPreviousMark-rEXM0dE(@Nullable TimeSource.Monotonic.ValueTimeMark valueTimeMark) {
            this.previousMark = valueTimeMark;
        }

        public final long getTotalLockDuration-UwyO8pc() {
            return this.totalLockDuration;
        }

        public final void setTotalLockDuration-LRDsOJo(long l) {
            this.totalLockDuration = l;
        }

        public final long getTotalAcquisitionIntentDuration-UwyO8pc() {
            return this.totalAcquisitionIntentDuration;
        }

        public final void setTotalAcquisitionIntentDuration-LRDsOJo(long l) {
            this.totalAcquisitionIntentDuration = l;
        }

        public final int component1() {
            return this.lockAcquiredCounter;
        }

        @Nullable
        public final TimeSource.Monotonic.ValueTimeMark component2-LFT3Okc() {
            return this.previousMark;
        }

        public final long component3-UwyO8pc() {
            return this.totalLockDuration;
        }

        public final long component4-UwyO8pc() {
            return this.totalAcquisitionIntentDuration;
        }

        @NotNull
        public final LockDiagnosticData copy-J2LNhJw(int lockAcquiredCounter, @Nullable TimeSource.Monotonic.ValueTimeMark previousMark, long l, long l2) {
            return new LockDiagnosticData(lockAcquiredCounter, previousMark, l, l2, null);
        }

        public static /* synthetic */ LockDiagnosticData copy-J2LNhJw$default(LockDiagnosticData lockDiagnosticData, int n, TimeSource.Monotonic.ValueTimeMark valueTimeMark, long l, long l2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = lockDiagnosticData.lockAcquiredCounter;
            }
            if ((n2 & 2) != 0) {
                valueTimeMark = lockDiagnosticData.previousMark;
            }
            if ((n2 & 4) != 0) {
                l = lockDiagnosticData.totalLockDuration;
            }
            if ((n2 & 8) != 0) {
                l2 = lockDiagnosticData.totalAcquisitionIntentDuration;
            }
            return lockDiagnosticData.copy-J2LNhJw(n, valueTimeMark, l, l2);
        }

        @NotNull
        public String toString() {
            return "LockDiagnosticData(lockAcquiredCounter=" + this.lockAcquiredCounter + ", previousMark=" + this.previousMark + ", totalLockDuration=" + Duration.toString-impl((long)this.totalLockDuration) + ", totalAcquisitionIntentDuration=" + Duration.toString-impl((long)this.totalAcquisitionIntentDuration) + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.lockAcquiredCounter);
            result2 = result2 * 31 + (this.previousMark == null ? 0 : TimeSource.Monotonic.ValueTimeMark.hashCode-impl((long)this.previousMark.unbox-impl()));
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.totalLockDuration);
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.totalAcquisitionIntentDuration);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LockDiagnosticData)) {
                return false;
            }
            LockDiagnosticData lockDiagnosticData = (LockDiagnosticData)other;
            if (this.lockAcquiredCounter != lockDiagnosticData.lockAcquiredCounter) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.previousMark, (Object)lockDiagnosticData.previousMark)) {
                return false;
            }
            if (!Duration.equals-impl0((long)this.totalLockDuration, (long)lockDiagnosticData.totalLockDuration)) {
                return false;
            }
            return Duration.equals-impl0((long)this.totalAcquisitionIntentDuration, (long)lockDiagnosticData.totalAcquisitionIntentDuration);
        }

        public /* synthetic */ LockDiagnosticData(int lockAcquiredCounter, TimeSource.Monotonic.ValueTimeMark previousMark, long totalLockDuration, long totalAcquisitionIntentDuration, DefaultConstructorMarker $constructor_marker) {
            this(lockAcquiredCounter, previousMark, totalLockDuration, totalAcquisitionIntentDuration);
        }
    }
}

