/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.util;

import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.RecordType;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u0014*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\fJ&\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0007J\u0006\u0010\u001f\u001a\u00020\u0014J\b\u0010 \u001a\u00020\u0014H\u0002J\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007J\u001e\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005Jm\u0010&\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000-2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020-\u00a2\u0006\u0002\u00103J&\u00104\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u00105\u001a\u000206J&\u00107\u001a\u00020\u00142\u0006\u00108\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020;J.\u0010<\u001a\u00020\u00142\u0006\u00108\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u0002062\u0006\u0010@\u001a\u00020\u0005J\u0010\u0010A\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0018\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u0005H\u0002J\u0010\u0010F\u001a\u00020\u00142\u0006\u0010G\u001a\u00020HH\u0002J\u0016\u0010I\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u0007J\u0014\u0010K\u001a\u00020\u0014*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u001c\u0010L\u001a\u00020\u0014*\u00020\u00032\u0006\u0010M\u001a\u00020\u00072\u0006\u0010N\u001a\u00020>H\u0002J\u001e\u0010O\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00072\u0006\u0010P\u001a\u00020;J6\u0010Q\u001a\u00020\u00142\u0006\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020\u00072\u0006\u0010U\u001a\u00020\u00072\u0006\u0010V\u001a\u00020\u00052\u0006\u0010W\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/intellij/diagnostic/hprof/util/HprofWriter;", "Ljava/io/Closeable;", "dos", "Ljava/io/DataOutputStream;", "idSize", "", "timestamp", "", "<init>", "(Ljava/io/DataOutputStream;IJ)V", "stringToIdMap", "Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "", "idToStringMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "nextStringId", "subtagsBaos", "Ljava/io/ByteArrayOutputStream;", "subtagsStream", "close", "", "writeNullTerminatedString", "Ljava/io/DataOutput;", "s", "writeStringInUTF8", "id", "writeLoadClass", "serialNumber", "classObjectId", "stackTraceSerialNumber", "classNameId", "flushHeapObjects", "writeHeapDumpRecords", "writeRootUnknown", "writeRootJavaFrame", "objectId", "threadSerialNumber", "frameNumber", "writeClassDump", "superClassObjectId", "classLoaderObjectId", "signersObjectId", "protectionDomainObjectId", "instanceSize", "constantPool", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "(JIJJJJI[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "writeInstanceDump", "bytes", "", "writeObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "elementIds", "", "writePrimitiveArrayDump", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "elements", "elementsCount", "getOrCreateStringId", "writeRecordHeader", "recordType", "Lcom/intellij/diagnostic/hprof/parser/RecordType;", "length", "writeHeapDumpRecordHeader", "heapDumpRecordType", "Lcom/intellij/diagnostic/hprof/parser/HeapDumpRecordType;", "writeRootGlobalJNI", "jniGlobalRefId", "writeId", "writeValue", "value", "type", "writeStackTrace", "stackFrameIds", "writeStackFrame", "stackFrameId", "methodNameStringId", "methodSignatureStringId", "sourceFilenameStringId", "classSerialNumber", "lineNumber", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHprofWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HprofWriter.kt\ncom/intellij/diagnostic/hprof/util/HprofWriter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,293:1\n13833#2,2:294\n*S KotlinDebug\n*F\n+ 1 HprofWriter.kt\ncom/intellij/diagnostic/hprof/util/HprofWriter\n*L\n176#1:294,2\n*E\n"})
public final class HprofWriter
implements Closeable {
    @NotNull
    private final DataOutputStream dos;
    private final int idSize;
    @NotNull
    private final Object2LongOpenHashMap<String> stringToIdMap;
    @NotNull
    private final Long2ObjectOpenHashMap<String> idToStringMap;
    private long nextStringId;
    @NotNull
    private final ByteArrayOutputStream subtagsBaos;
    @NotNull
    private DataOutputStream subtagsStream;

    public HprofWriter(@NotNull DataOutputStream dos, int idSize, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)dos, (String)"dos");
        this.dos = dos;
        this.idSize = idSize;
        if (this.idSize != 4 && this.idSize != 8) {
            throw new IllegalArgumentException("idSize can only be 4 or 8");
        }
        this.writeNullTerminatedString(this.dos, "JAVA PROFILE 1.0.1");
        this.dos.writeInt(this.idSize);
        this.dos.writeLong(timestamp);
        this.stringToIdMap = new Object2LongOpenHashMap();
        this.idToStringMap = new Long2ObjectOpenHashMap();
        this.nextStringId = 1L;
        this.subtagsBaos = new ByteArrayOutputStream();
        this.subtagsStream = new DataOutputStream(this.subtagsBaos);
    }

    @Override
    public void close() {
        this.flushHeapObjects();
        this.dos.close();
    }

    private final void writeNullTerminatedString(DataOutput $this$writeNullTerminatedString, String s) {
        String string = s;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        $this$writeNullTerminatedString.write(byArray);
        $this$writeNullTerminatedString.write(0);
    }

    public final void writeStringInUTF8(long id2, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = s;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        this.writeRecordHeader(RecordType.StringInUTF8, bytes.length + this.idSize);
        this.writeId(this.dos, id2);
        this.dos.write(bytes);
    }

    public final void writeLoadClass(int serialNumber, long classObjectId, int stackTraceSerialNumber, long classNameId) {
        this.writeRecordHeader(RecordType.LoadClass, 8 + this.idSize * 2);
        this.dos.writeInt(serialNumber);
        this.writeId(this.dos, classObjectId);
        this.dos.writeInt(stackTraceSerialNumber);
        this.writeId(this.dos, classNameId);
    }

    public final void flushHeapObjects() {
        this.writeHeapDumpRecords();
    }

    private final void writeHeapDumpRecords() {
        if (this.subtagsBaos.size() > 0) {
            this.subtagsStream.close();
            this.writeRecordHeader(RecordType.HeapDump, this.subtagsBaos.size());
            this.subtagsBaos.writeTo(this.dos);
            this.subtagsBaos.reset();
            this.subtagsStream = new DataOutputStream(this.subtagsBaos);
            this.writeRecordHeader(RecordType.HeapDumpEnd, 0);
        }
    }

    public final void writeRootUnknown(long id2) {
        DataOutputStream $this$writeRootUnknown_u24lambda_u240 = this.subtagsStream;
        boolean bl = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.RootUnknown);
        this.writeId($this$writeRootUnknown_u24lambda_u240, id2);
    }

    public final void writeRootJavaFrame(long objectId, int threadSerialNumber, int frameNumber) {
        DataOutputStream $this$writeRootJavaFrame_u24lambda_u240 = this.subtagsStream;
        boolean bl = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.RootJavaFrame);
        this.writeId($this$writeRootJavaFrame_u24lambda_u240, objectId);
        $this$writeRootJavaFrame_u24lambda_u240.writeInt(threadSerialNumber);
        $this$writeRootJavaFrame_u24lambda_u240.writeInt(frameNumber);
    }

    public final void writeClassDump(long classObjectId, int stackTraceSerialNumber, long superClassObjectId, long classLoaderObjectId, long signersObjectId, long protectionDomainObjectId, int instanceSize, @NotNull ConstantPoolEntry[] constantPool, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        Intrinsics.checkNotNullParameter((Object)constantPool, (String)"constantPool");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        DataOutputStream $this$writeClassDump_u24lambda_u240 = this.subtagsStream;
        boolean bl = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.ClassDump);
        this.writeId($this$writeClassDump_u24lambda_u240, classObjectId);
        $this$writeClassDump_u24lambda_u240.writeInt(stackTraceSerialNumber);
        this.writeId($this$writeClassDump_u24lambda_u240, superClassObjectId);
        this.writeId($this$writeClassDump_u24lambda_u240, classLoaderObjectId);
        this.writeId($this$writeClassDump_u24lambda_u240, signersObjectId);
        this.writeId($this$writeClassDump_u24lambda_u240, protectionDomainObjectId);
        this.writeId($this$writeClassDump_u24lambda_u240, 0L);
        this.writeId($this$writeClassDump_u24lambda_u240, 0L);
        $this$writeClassDump_u24lambda_u240.writeInt(instanceSize);
        $this$writeClassDump_u24lambda_u240.writeShort(constantPool.length);
        for (ConstantPoolEntry constantPoolEntry : constantPool) {
            $this$writeClassDump_u24lambda_u240.writeShort(constantPoolEntry.getConstantPoolIndex());
            $this$writeClassDump_u24lambda_u240.writeByte(constantPoolEntry.getType().getTypeId());
            this.writeValue($this$writeClassDump_u24lambda_u240, constantPoolEntry.getValue(), constantPoolEntry.getType());
        }
        $this$writeClassDump_u24lambda_u240.writeShort(staticFields.length);
        for (StaticFieldEntry staticFieldEntry : staticFields) {
            this.writeId($this$writeClassDump_u24lambda_u240, staticFieldEntry.getFieldNameStringId());
            $this$writeClassDump_u24lambda_u240.writeByte(staticFieldEntry.getType().getTypeId());
            this.writeValue($this$writeClassDump_u24lambda_u240, staticFieldEntry.getValue(), staticFieldEntry.getType());
        }
        $this$writeClassDump_u24lambda_u240.writeShort(instanceFields.length);
        for (InstanceFieldEntry instanceFieldEntry : instanceFields) {
            this.writeId($this$writeClassDump_u24lambda_u240, instanceFieldEntry.getFieldNameStringId());
            $this$writeClassDump_u24lambda_u240.writeByte(instanceFieldEntry.getType().getTypeId());
        }
    }

    public final void writeInstanceDump(long objectId, int stackTraceSerialNumber, long classObjectId, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        DataOutputStream $this$writeInstanceDump_u24lambda_u240 = this.subtagsStream;
        boolean bl = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.InstanceDump);
        this.writeId($this$writeInstanceDump_u24lambda_u240, objectId);
        $this$writeInstanceDump_u24lambda_u240.writeInt(stackTraceSerialNumber);
        this.writeId($this$writeInstanceDump_u24lambda_u240, classObjectId);
        $this$writeInstanceDump_u24lambda_u240.writeInt(bytes.length);
        $this$writeInstanceDump_u24lambda_u240.write(bytes);
    }

    public final void writeObjectArrayDump(long arrayObjectId, int stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] elementIds) {
        Intrinsics.checkNotNullParameter((Object)elementIds, (String)"elementIds");
        DataOutputStream $this$writeObjectArrayDump_u24lambda_u240 = this.subtagsStream;
        boolean bl = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.ObjectArrayDump);
        this.writeId($this$writeObjectArrayDump_u24lambda_u240, arrayObjectId);
        $this$writeObjectArrayDump_u24lambda_u240.writeInt(stackTraceSerialNumber);
        $this$writeObjectArrayDump_u24lambda_u240.writeInt(elementIds.length);
        this.writeId($this$writeObjectArrayDump_u24lambda_u240, arrayClassObjectId);
        long[] $this$forEach$iv = elementIds;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            long element$iv;
            long id2 = element$iv = $this$forEach$iv[j];
            boolean bl2 = false;
            this.writeId($this$writeObjectArrayDump_u24lambda_u240, id2);
        }
    }

    public final void writePrimitiveArrayDump(long arrayObjectId, int stackTraceSerialNumber, @NotNull Type elementType, @NotNull byte[] elements, int elementsCount) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)elementType), (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        DataOutputStream $this$writePrimitiveArrayDump_u24lambda_u240 = this.subtagsStream;
        boolean bl2 = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.PrimitiveArrayDump);
        this.writeId($this$writePrimitiveArrayDump_u24lambda_u240, arrayObjectId);
        $this$writePrimitiveArrayDump_u24lambda_u240.writeInt(stackTraceSerialNumber);
        $this$writePrimitiveArrayDump_u24lambda_u240.writeInt(elementsCount);
        boolean bl3 = bl = elementType != Type.OBJECT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        $this$writePrimitiveArrayDump_u24lambda_u240.writeByte(elementType.getTypeId());
        boolean bl4 = bl = elements.length == elementsCount * elementType.getSize();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        $this$writePrimitiveArrayDump_u24lambda_u240.write(elements);
    }

    private final long getOrCreateStringId(String s) {
        long id2 = this.stringToIdMap.getLong((Object)s);
        if (id2 == 0L) {
            long l = this.nextStringId;
            this.nextStringId = l + 1L;
            long newId = l;
            this.writeStringInUTF8(newId, s);
            this.idToStringMap.put(newId, (Object)s);
            this.stringToIdMap.put((Object)s, newId);
            return newId;
        }
        return id2;
    }

    private final void writeRecordHeader(RecordType recordType, int length) {
        DataOutputStream $this$writeRecordHeader_u24lambda_u240 = this.dos;
        boolean bl = false;
        $this$writeRecordHeader_u24lambda_u240.writeByte(recordType.getValue());
        $this$writeRecordHeader_u24lambda_u240.writeInt(0);
        $this$writeRecordHeader_u24lambda_u240.writeInt(length);
    }

    private final void writeHeapDumpRecordHeader(HeapDumpRecordType heapDumpRecordType) {
        DataOutputStream $this$writeHeapDumpRecordHeader_u24lambda_u240 = this.subtagsStream;
        boolean bl = false;
        $this$writeHeapDumpRecordHeader_u24lambda_u240.writeByte(heapDumpRecordType.getValue());
    }

    public final void writeRootGlobalJNI(long objectId, long jniGlobalRefId) {
        DataOutputStream $this$writeRootGlobalJNI_u24lambda_u240 = this.subtagsStream;
        boolean bl = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.RootGlobalJNI);
        this.writeId($this$writeRootGlobalJNI_u24lambda_u240, objectId);
        this.writeId($this$writeRootGlobalJNI_u24lambda_u240, jniGlobalRefId);
    }

    private final void writeId(DataOutputStream $this$writeId, long id2) {
        switch (this.idSize) {
            case 4: {
                $this$writeId.writeInt((int)id2);
                break;
            }
            case 8: {
                $this$writeId.writeLong(id2);
                break;
            }
            default: {
                if (!_Assertions.ENABLED) break;
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }
    }

    private final void writeValue(DataOutputStream $this$writeValue, long value, Type type) {
        if (type == Type.OBJECT) {
            this.writeId($this$writeValue, value);
        } else {
            switch (type.getSize()) {
                case 1: {
                    $this$writeValue.writeByte((int)value);
                    break;
                }
                case 2: {
                    $this$writeValue.writeShort((int)value);
                    break;
                }
                case 4: {
                    $this$writeValue.writeInt((int)value);
                    break;
                }
                case 8: {
                    $this$writeValue.writeLong(value);
                    break;
                }
                default: {
                    if (!_Assertions.ENABLED) break;
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
        }
    }

    public final void writeStackTrace(int stackTraceSerialNumber, long threadSerialNumber, @NotNull long[] stackFrameIds) {
        Intrinsics.checkNotNullParameter((Object)stackFrameIds, (String)"stackFrameIds");
        DataOutputStream $this$writeStackTrace_u24lambda_u240 = this.dos;
        boolean bl = false;
        int length = 12 + this.idSize * stackFrameIds.length;
        this.writeRecordHeader(RecordType.StackTrace, length);
        $this$writeStackTrace_u24lambda_u240.writeInt(stackTraceSerialNumber);
        $this$writeStackTrace_u24lambda_u240.writeInt((int)threadSerialNumber);
        $this$writeStackTrace_u24lambda_u240.writeInt(stackFrameIds.length);
        for (long frameId : stackFrameIds) {
            this.writeId($this$writeStackTrace_u24lambda_u240, frameId);
        }
    }

    public final void writeStackFrame(long stackFrameId, long methodNameStringId, long methodSignatureStringId, long sourceFilenameStringId, int classSerialNumber, int lineNumber) {
        DataOutputStream $this$writeStackFrame_u24lambda_u240 = this.dos;
        boolean bl = false;
        int length = 4 * this.idSize + 8;
        this.writeRecordHeader(RecordType.StackFrame, length);
        this.writeId($this$writeStackFrame_u24lambda_u240, stackFrameId);
        this.writeId($this$writeStackFrame_u24lambda_u240, methodNameStringId);
        this.writeId($this$writeStackFrame_u24lambda_u240, methodSignatureStringId);
        this.writeId($this$writeStackFrame_u24lambda_u240, sourceFilenameStringId);
        $this$writeStackFrame_u24lambda_u240.writeInt(classSerialNumber);
        $this$writeStackFrame_u24lambda_u240.writeInt(lineNumber);
    }
}

