/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.externalDependencies.impl.ExternalDependenciesConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class CheckRequiredPluginsActivity
implements StartupActivity.RequiredForSmartMode {
    private static final Logger LOG = Logger.getInstance(CheckRequiredPluginsActivity.class);
    @NonNls
    private static final String NOTIFICATION_GROUP_ID = "Required Plugins";

    CheckRequiredPluginsActivity() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    public void runActivity(@NotNull Project project2) {
        if (project2 == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(0);
        }
        ExternalDependenciesManager.getInstance(project2);
    }

    private static List<DependencyOnPlugin> getRequiredPlugins(@NotNull ExternalDependenciesManager dependencyManager) {
        if (dependencyManager == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(1);
        }
        ArrayList<DependencyOnPlugin> dependencies = new ArrayList<DependencyOnPlugin>(dependencyManager.getDependencies(DependencyOnPlugin.class));
        if (!PlatformUtils.isPyCharm()) {
            return dependencies;
        }
        if (!PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID)) {
            return dependencies;
        }
        ArrayList<DependencyOnPlugin> result2 = new ArrayList<DependencyOnPlugin>();
        for (DependencyOnPlugin plugin : dependencies) {
            boolean canBeEnabled;
            String pluginId = plugin.getPluginId();
            IdeaPluginDescriptorImpl descriptor = PluginManagerCore.findPlugin((PluginId)PluginId.getId((String)pluginId));
            if (descriptor == null || !(canBeEnabled = !ContainerUtil.exists((Iterable)descriptor.getDependencies(), it -> it.getPluginId().equals((Object)PluginManagerCore.ULTIMATE_PLUGIN_ID)))) continue;
            result2.add(plugin);
        }
        return result2;
    }

    public static void runCheck(@NotNull Project project2, @NotNull ExternalDependenciesManager dependencyManager) {
        List<DependencyOnPlugin> dependencies;
        if (project2 == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(2);
        }
        if (dependencyManager == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(3);
        }
        if ((dependencies = CheckRequiredPluginsActivity.getRequiredPlugins(dependencyManager)).isEmpty()) {
            return;
        }
        String projectName = project2.getName();
        ArrayList<@Nls String> errorMessages = new ArrayList<String>();
        ArrayList<IdeaPluginDescriptor> disabled = new ArrayList<IdeaPluginDescriptor>();
        HashSet<PluginId> notInstalled = new HashSet<PluginId>();
        boolean hasVersionConflicts = false;
        ArrayList<IdeaPluginDescriptorImpl> pluginsToEnableWithoutRestart = new ArrayList<IdeaPluginDescriptorImpl>();
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        PluginEnabler pluginEnabler = PluginEnabler.getInstance();
        for (DependencyOnPlugin dependency : dependencies) {
            PluginId pluginId = PluginId.getId((String)dependency.getPluginId());
            IdeaPluginDescriptorImpl descriptor = PluginManagerCore.findPlugin((PluginId)pluginId);
            if (descriptor == null) {
                errorMessages.add(IdeBundle.message((String)"error.plugin.required.for.project.not.installed", (Object[])new Object[]{pluginId, projectName}));
                notInstalled.add(pluginId);
                continue;
            }
            String pluginName = descriptor.getName();
            if (pluginEnabler.isDisabled(pluginId)) {
                boolean canEnableWithoutRestart;
                boolean bl = canEnableWithoutRestart = Registry.is((String)"ide.plugins.load.automatically") && DynamicPlugins.allowLoadUnloadWithoutRestart(descriptor);
                if (canEnableWithoutRestart) {
                    pluginsToEnableWithoutRestart.add(descriptor);
                    continue;
                }
                errorMessages.add(IdeBundle.message((String)"error.plugin.required.for.project.disabled", (Object[])new Object[]{pluginName, projectName}));
                disabled.add((IdeaPluginDescriptor)descriptor);
                continue;
            }
            String minVersion = dependency.getMinVersion();
            String maxVersion = dependency.getMaxVersion();
            String pluginVersion = descriptor.getVersion();
            BuildNumber currentIdeVersion = applicationInfo.getBuild();
            if (descriptor.isBundled() && !descriptor.allowBundledUpdate() && currentIdeVersion.asStringWithoutProductCode().equals(pluginVersion)) {
                Object pluginFromString;
                Object object = pluginFromString = PluginManagerCore.CORE_ID.equals((Object)descriptor.getPluginId()) ? "" : "plugin '" + pluginName + "' from ";
                if (minVersion != null && !minVersion.isEmpty() && currentIdeVersion.compareTo(Objects.requireNonNull(BuildNumber.fromString((String)minVersion))) < 0) {
                    errorMessages.add(IdeBundle.message((String)"error.project.requires.newer.ide", (Object[])new Object[]{projectName, pluginFromString, minVersion, pluginVersion}));
                    hasVersionConflicts = true;
                }
                if (maxVersion == null || maxVersion.isEmpty() || currentIdeVersion.compareTo(Objects.requireNonNull(BuildNumber.fromString((String)maxVersion))) <= 0) continue;
                errorMessages.add(IdeBundle.message((String)"error.project.requires.older.ide", (Object[])new Object[]{projectName, pluginFromString, maxVersion, pluginVersion}));
                hasVersionConflicts = true;
                continue;
            }
            if (minVersion != null && VersionComparatorUtil.compare((String)pluginVersion, (String)minVersion) < 0) {
                errorMessages.add(IdeBundle.message((String)"error.project.requires.newer.plugin", (Object[])new Object[]{projectName, pluginName, minVersion, pluginVersion}));
                hasVersionConflicts = true;
            }
            if (maxVersion == null || VersionComparatorUtil.compare((String)pluginVersion, (String)maxVersion) <= 0) continue;
            errorMessages.add(IdeBundle.message((String)"error.project.requires.older.plugin", (Object[])new Object[]{projectName, pluginName, maxVersion, pluginVersion}));
            hasVersionConflicts = true;
        }
        if (!pluginsToEnableWithoutRestart.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> CheckRequiredPluginsActivity.enablePlugins(pluginsToEnableWithoutRestart, pluginEnabler));
        }
        if (errorMessages.isEmpty()) {
            return;
        }
        LOG.warn(StringUtil.join(errorMessages, (String)"\n"));
        String notificationMessage = hasVersionConflicts ? StringUtil.join(errorMessages, (String)"<br>") : CheckRequiredPluginsActivity.buildRequiredPluginsMessage(projectName, disabled, notInstalled);
        Notification notification2 = NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP_ID).createNotification(IdeBundle.message((String)"notification.title.required.plugins.not.loaded", (Object[])new Object[0]), notificationMessage, NotificationType.ERROR).setIcon(AllIcons.Ide.Notification.IdeUpdate);
        if (!disabled.isEmpty()) {
            notification2.addAction((AnAction)NotificationAction.create((String)(disabled.size() == 1 ? IdeBundle.message((String)"link.enable.required.plugin", (Object[])new Object[]{((IdeaPluginDescriptor)disabled.get(0)).getName()}) : IdeBundle.message((String)"link.enable.required.plugins", (Object[])new Object[0])), (event, n) -> {
                n.expire();
                if (!CheckRequiredPluginsActivity.enablePlugins(disabled, pluginEnabler)) {
                    PluginManagerMain.notifyPluginsUpdated(project2);
                }
            }));
        } else if (!notInstalled.isEmpty()) {
            notification2.addAction((AnAction)NotificationAction.create((String)IdeBundle.message((String)"link.install.required.plugins", (Object[])new Object[0]), (event, n) -> {
                HashSet<PluginId> pluginIds = new HashSet<PluginId>(notInstalled);
                pluginIds.addAll(notInstalled);
                for (IdeaPluginDescriptor descriptor : disabled) {
                    pluginIds.add(descriptor.getPluginId());
                }
                PluginsAdvertiser.installAndEnable(project2, pluginIds, true, true, () -> n.expire());
            }));
        }
        if (!notInstalled.isEmpty() || !disabled.isEmpty()) {
            notification2.addAction((AnAction)NotificationAction.createSimple((String)IdeBundle.message((String)"link.required.plugins.settings", (Object[])new Object[0]), () -> ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)new ExternalDependenciesConfigurable(project2))));
        }
        notification2.setSuggestionType(true).notify(project2);
    }

    @Nls
    @NotNull
    private static String buildRequiredPluginsMessage(@NotNull String projectName, List<IdeaPluginDescriptor> disabledPlugins, Set<PluginId> notInstalledPlugins) {
        if (projectName == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(4);
        }
        if (disabledPlugins.isEmpty()) {
            if (notInstalledPlugins.size() == 1) {
                PluginId pluginId = notInstalledPlugins.iterator().next();
                String string = IdeBundle.message((String)"error.plugin.required.for.project.not.installed", (Object[])new Object[]{pluginId, projectName});
                if (string == null) {
                    CheckRequiredPluginsActivity.$$$reportNull$$$0(5);
                }
                return string;
            }
            HtmlBuilder message = new HtmlBuilder();
            message.append(IdeBundle.message((String)"error.project.requires.plugins.not.installed", (Object[])new Object[]{projectName}));
            message.appendRaw("<ul>");
            for (PluginId pluginId : notInstalledPlugins) {
                message.appendRaw("<li>").append(pluginId.getIdString()).appendRaw("</li>");
            }
            message.appendRaw("</ul>");
            String string = message.toString();
            if (string == null) {
                CheckRequiredPluginsActivity.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (disabledPlugins.size() == 1 && notInstalledPlugins.isEmpty()) {
            IdeaPluginDescriptor plugin = disabledPlugins.get(0);
            String string = IdeBundle.message((String)"error.plugin.required.for.project.disabled", (Object[])new Object[]{plugin.getName(), projectName});
            if (string == null) {
                CheckRequiredPluginsActivity.$$$reportNull$$$0(7);
            }
            return string;
        }
        HtmlBuilder message = new HtmlBuilder();
        message.append(IdeBundle.message((String)"error.project.requires.plugins.not.enabled", (Object[])new Object[]{projectName}));
        message.appendRaw("<ul>");
        for (IdeaPluginDescriptor ideaPluginDescriptor : disabledPlugins) {
            message.appendRaw("<li>").append(ideaPluginDescriptor.getName()).appendRaw("</li>");
        }
        for (PluginId pluginId : notInstalledPlugins) {
            message.appendRaw("<li>").append(pluginId.getIdString()).appendRaw("</li>");
        }
        message.appendRaw("</ul>");
        String string = message.toString();
        if (string == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static boolean enablePlugins(@NotNull List<? extends IdeaPluginDescriptor> descriptors2, @NotNull PluginEnabler pluginEnabler) {
        if (descriptors2 == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(9);
        }
        if (pluginEnabler == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(10);
        }
        LOG.info("Required plugins to enable: [" + StringUtil.join(descriptors2, d -> d.getPluginId().getIdString(), (String)", ") + "]");
        return pluginEnabler.enable(descriptors2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/externalDependencies/impl/CheckRequiredPluginsActivity";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/externalDependencies/impl/CheckRequiredPluginsActivity";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRequiredPluginsMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredPlugins";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runCheck";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildRequiredPluginsMessage";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugins";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

