/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.WindowAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class MaximizeActiveDialogAction
extends WindowAction {
    private static final String NORMAL_BOUNDS = "NORMAL_BOUNDS";

    public void actionPerformed(@NotNull AnActionEvent e) {
        Component component2;
        Window window;
        if (e == null) {
            MaximizeActiveDialogAction.$$$reportNull$$$0(0);
        }
        if (!((window = ComponentUtil.getWindow((Component)(component2 = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)))) instanceof JDialog)) {
            return;
        }
        MaximizeActiveDialogAction.doMaximize((JDialog)window);
    }

    public static void doMaximize(JDialog dialog2) {
        if (MaximizeActiveDialogAction.canBeMaximized(dialog2)) {
            MaximizeActiveDialogAction.maximize(dialog2);
        } else if (MaximizeActiveDialogAction.canBeNormalized(dialog2)) {
            MaximizeActiveDialogAction.normalize(dialog2);
        }
    }

    public static boolean canBeMaximized(JDialog dialog2) {
        JRootPane rootPane;
        JRootPane jRootPane = rootPane = dialog2 != null && dialog2.isResizable() ? dialog2.getRootPane() : null;
        if (rootPane == null) {
            return false;
        }
        return !MaximizeActiveDialogAction.almostEquals(ScreenUtil.getScreenRectangle((Component)dialog2), dialog2.getBounds());
    }

    public static void maximize(JDialog dialog2) {
        if (!MaximizeActiveDialogAction.canBeMaximized(dialog2)) {
            return;
        }
        dialog2.getRootPane().putClientProperty(NORMAL_BOUNDS, dialog2.getBounds());
        dialog2.setBounds(ScreenUtil.getScreenRectangle((Component)dialog2));
    }

    public static boolean canBeNormalized(JDialog dialog2) {
        JRootPane rootPane;
        JRootPane jRootPane = rootPane = dialog2 != null && dialog2.isResizable() ? dialog2.getRootPane() : null;
        if (rootPane == null) {
            return false;
        }
        Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Component)dialog2);
        return MaximizeActiveDialogAction.almostEquals(dialog2.getBounds(), screenRectangle) && rootPane.getClientProperty(NORMAL_BOUNDS) instanceof Rectangle;
    }

    private static boolean almostEquals(@NotNull Rectangle r1, @NotNull Rectangle r2) {
        if (r1 == null) {
            MaximizeActiveDialogAction.$$$reportNull$$$0(1);
        }
        if (r2 == null) {
            MaximizeActiveDialogAction.$$$reportNull$$$0(2);
        }
        int tolerance = Registry.intValue((String)"ide.dialog.maximize.tolerance", (int)10);
        return Math.abs(r1.x - r2.x) <= tolerance && Math.abs(r1.y - r2.y) <= tolerance && Math.abs(r1.width - r2.width) <= tolerance && Math.abs(r1.height - r2.height) <= tolerance;
    }

    public static void normalize(JDialog dialog2) {
        if (!MaximizeActiveDialogAction.canBeNormalized(dialog2)) {
            return;
        }
        JRootPane rootPane = dialog2.getRootPane();
        Object value = rootPane.getClientProperty(NORMAL_BOUNDS);
        if (value instanceof Rectangle) {
            Rectangle bounds = (Rectangle)value;
            ScreenUtil.fitToScreen((Rectangle)bounds);
            dialog2.setBounds(bounds);
            rootPane.putClientProperty(NORMAL_BOUNDS, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/MaximizeActiveDialogAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "almostEquals";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

