/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.Switcher;
import com.intellij.ide.actions.SwitcherListItem;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0018\u00106\u001a\u0002002\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020!H\u0016J\u0012\u0010:\u001a\u0004\u0018\u00010\u00182\u0006\u0010;\u001a\u00020<H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\"R\u001a\u0010#\u001a\u00020$X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020$X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010&\"\u0004\b.\u0010(\u00a8\u0006="}, d2={"Lcom/intellij/ide/actions/SwitcherVirtualFile;", "Lcom/intellij/ide/actions/SwitcherListItem;", "Lcom/intellij/ui/BackgroundSupplier;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/fileEditor/impl/EditorWindow;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getWindow", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "icon$delegate", "Lkotlin/Lazy;", "backgroundColor", "Ljava/awt/Color;", "getBackgroundColor", "()Ljava/awt/Color;", "setBackgroundColor", "(Ljava/awt/Color;)V", "foregroundTextColor", "getForegroundTextColor", "setForegroundTextColor", "isProblemFile", "", "()Z", "mainText", "", "getMainText", "()Ljava/lang/String;", "setMainText", "(Ljava/lang/String;)V", "statusText", "getStatusText", "setStatusText", "pathText", "getPathText", "setPathText", "navigate", "", "switcher", "Lcom/intellij/ide/actions/Switcher$SwitcherPanel;", "mode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "close", "prepareMainRenderer", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "selected", "getElementBackground", "row", "", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSwitcherRendering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitcherRendering.kt\ncom/intellij/ide/actions/SwitcherVirtualFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1#2:252\n*E\n"})
public final class SwitcherVirtualFile
implements SwitcherListItem,
BackgroundSupplier {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @Nullable
    private final EditorWindow window;
    @NotNull
    private final Lazy icon$delegate;
    @Nullable
    private Color backgroundColor;
    @Nullable
    private Color foregroundTextColor;
    @NotNull
    private String mainText;
    @NotNull
    private String statusText;
    @NotNull
    private String pathText;

    public SwitcherVirtualFile(@NotNull Project project2, @NotNull VirtualFile file2, @Nullable EditorWindow window) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.project = project2;
        this.file = file2;
        this.window = window;
        this.icon$delegate = LazyKt.lazy(() -> SwitcherVirtualFile.icon_delegate$lambda$0(this));
        this.mainText = "";
        this.statusText = "";
        this.pathText = "";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    public final EditorWindow getWindow() {
        return this.window;
    }

    private final Icon getIcon() {
        Lazy lazy = this.icon$delegate;
        return (Icon)lazy.getValue();
    }

    @Nullable
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(@Nullable Color color) {
        this.backgroundColor = color;
    }

    @Nullable
    public final Color getForegroundTextColor() {
        return this.foregroundTextColor;
    }

    public final void setForegroundTextColor(@Nullable Color color) {
        this.foregroundTextColor = color;
    }

    public final boolean isProblemFile() {
        WolfTheProblemSolver wolfTheProblemSolver = WolfTheProblemSolver.getInstance((Project)this.project);
        return wolfTheProblemSolver != null ? wolfTheProblemSolver.isProblemFile(this.file) : false;
    }

    @Override
    @NotNull
    public String getMainText() {
        return this.mainText;
    }

    public void setMainText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mainText = string;
    }

    @Override
    @NotNull
    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.statusText = string;
    }

    @Override
    @NotNull
    public String getPathText() {
        return this.pathText;
    }

    public void setPathText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.pathText = string;
    }

    @Override
    public void navigate(@NotNull Switcher.SwitcherPanel switcher, @NotNull FileEditorManagerImpl.OpenMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)switcher), (String)"switcher");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
    }

    @Override
    public void close(@NotNull Switcher.SwitcherPanel switcher) {
        Intrinsics.checkNotNullParameter((Object)((Object)switcher), (String)"switcher");
    }

    @Override
    public void prepareMainRenderer(@NotNull SimpleColoredComponent component2, boolean selected) {
        block4: {
            int n;
            String it;
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            component2.setIconTextGap(JBUI.scale((int)4));
            component2.setIcon(Registry.Companion.is("ide.project.view.change.icon.on.selection", true) ? RenderingUtil.getIcon((Icon)this.getIcon(), (boolean)selected) : this.getIcon());
            Color foreground = selected ? null : this.foregroundTextColor;
            JBColor effectColor = this.isProblemFile() ? JBColor.red : null;
            int style = effectColor == null ? 0 : 8;
            component2.append(this.getMainText(), new SimpleTextAttributes(style, foreground, (Color)effectColor));
            Font font = component2.getFont();
            if (font == null) break block4;
            Font it2 = font;
            boolean bl = false;
            int mainTextWidth = UIUtil.computeStringWidth((JComponent)((JComponent)component2), (String)this.getMainText());
            String string = this.getShortcutText();
            if (string != null) {
                it = string;
                boolean bl2 = false;
                n = UIUtil.computeStringWidth((JComponent)((JComponent)component2), (String)it);
            } else {
                n = 0;
            }
            int shortcutTextWidth = n;
            int width = component2.getWidth() - mainTextWidth - shortcutTextWidth - component2.getIconTextGap() - component2.getIcon().getIconWidth() - component2.getInsets().left - component2.getInsets().right;
            if (width > 0) {
                String string2 = PaintUtil.cutContainerText((String)(" " + this.getPathText()), (int)width, (JComponent)((JComponent)component2));
                if (string2 != null) {
                    it = string2;
                    boolean bl3 = false;
                    component2.append(it, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        }
    }

    @Nullable
    public Color getElementBackground(int row2) {
        return this.backgroundColor;
    }

    private static final Icon icon_delegate$lambda$0(SwitcherVirtualFile this$0) {
        return IconUtil.getIcon((VirtualFile)this$0.file, (int)2, (Project)this$0.project);
    }
}

