/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ToolwindowFusEventFields;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowViewModeAction
extends DumbAwareToggleAction
implements FusAwareAction,
ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    protected final ViewMode myMode;

    protected ToolWindowViewModeAction(@NotNull ViewMode mode) {
        if (mode == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(0);
        }
        this.myMode = mode;
        Presentation presentation2 = this.getTemplatePresentation();
        presentation2.setText(ActionsBundle.actionText((String)this.myMode.myActionID));
        presentation2.setDescription(ActionsBundle.actionDescription((String)this.myMode.myActionID));
        presentation2.setKeepPopupOnPerform(KeepPopupOnPerform.Never);
    }

    @Nullable
    protected ToolWindowManager getToolWindowManager(AnActionEvent e) {
        Project project2 = e.getProject();
        return project2 == null || project2.isDisposed() ? null : ToolWindowManager.getInstance((Project)project2);
    }

    @Nullable
    protected ToolWindow getToolWindow(AnActionEvent e) {
        ToolWindowManager manager2 = this.getToolWindowManager(e);
        if (manager2 == null) {
            return null;
        }
        ToolWindow window = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
        if (window != null) {
            return window;
        }
        String id2 = manager2.getActiveToolWindowId();
        return id2 == null ? null : manager2.getToolWindow(id2);
    }

    public final boolean isSelected(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(1);
        }
        if ((project2 = e.getProject()) == null || project2.isDisposed()) {
            return false;
        }
        ToolWindow window = this.getToolWindow(e);
        return window != null && this.isSelected(window);
    }

    protected boolean isSelected(@NotNull ToolWindow window) {
        if (window == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(2);
        }
        return this.myMode.isApplied(window);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        ToolWindow window;
        if (e == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(3);
        }
        if ((window = this.getToolWindow(e)) == null) {
            return;
        }
        if (!this.myMode.isApplied(window)) {
            this.myMode.applyTo(window);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(4);
        }
        super.update(e);
        e.getPresentation().setEnabledAndVisible(this.getToolWindow(e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(5);
        }
        return actionUpdateThread;
    }

    @Override
    @NotNull
    public List<EventPair<?>> getAdditionalUsageData(@NotNull AnActionEvent event) {
        ToolWindow toolWindow2;
        if (event == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(6);
        }
        if ((toolWindow2 = this.getToolWindow(event)) != null) {
            List<EventPair<?>> list2 = Collections.singletonList(ToolwindowFusEventFields.TOOLWINDOW.with((Object)toolWindow2.getId()));
            if (list2 == null) {
                ToolWindowViewModeAction.$$$reportNull$$$0(7);
            }
            return list2;
        }
        List<EventPair<?>> list3 = Collections.emptyList();
        if (list3 == null) {
            ToolWindowViewModeAction.$$$reportNull$$$0(8);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ToolWindowViewModeAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ToolWindowViewModeAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalUsageData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static enum ViewMode {
        DockPinned("DockPinnedMode"),
        DockUnpinned("DockUnpinnedMode"),
        Undock("UndockMode"),
        Float("FloatMode"),
        Window("WindowMode");

        private final String myActionID;

        private ViewMode(String actionID) {
            this.myActionID = actionID;
        }

        public String getActionID() {
            return this.myActionID;
        }

        boolean isApplied(@NotNull ToolWindow window) {
            if (window == null) {
                ViewMode.$$$reportNull$$$0(0);
            }
            ToolWindowType type = window.getType();
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (type == ToolWindowType.DOCKED && !window.isAutoHide()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (type == ToolWindowType.DOCKED && window.isAutoHide()) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (type == ToolWindowType.SLIDING) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (type == ToolWindowType.FLOATING) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> type == ToolWindowType.WINDOWED;
            };
        }

        public static ViewMode fromWindowInfo(@NotNull WindowInfo info) {
            if (info == null) {
                ViewMode.$$$reportNull$$$0(1);
            }
            return switch (info.getType()) {
                default -> throw new MatchException(null, null);
                case ToolWindowType.DOCKED -> {
                    if (info.isAutoHide()) {
                        yield DockUnpinned;
                    }
                    yield DockPinned;
                }
                case ToolWindowType.FLOATING -> Float;
                case ToolWindowType.SLIDING -> Undock;
                case ToolWindowType.WINDOWED -> Window;
            };
        }

        void applyTo(@NotNull ToolWindow window) {
            if (window == null) {
                ViewMode.$$$reportNull$$$0(2);
            }
            switch (this.ordinal()) {
                case 0: 
                case 1: {
                    window.setType(ToolWindowType.DOCKED, null);
                    break;
                }
                case 2: {
                    window.setType(ToolWindowType.SLIDING, null);
                    break;
                }
                case 3: {
                    window.setType(ToolWindowType.FLOATING, null);
                    break;
                }
                case 4: {
                    window.setType(ToolWindowType.WINDOWED, null);
                }
            }
            window.setAutoHide(this == DockUnpinned || this == Undock);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/ToolWindowViewModeAction$ViewMode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplied";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromWindowInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Group
    extends DefaultActionGroup {
        private boolean isInitialized = false;

        public boolean isDumbAware() {
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                Group.$$$reportNull$$$0(0);
            }
            if (!this.isInitialized) {
                ActionManager actionManager = ActionManager.getInstance();
                for (ViewMode viewMode : ViewMode.values()) {
                    ToolWindowViewModeAction action2 = new ToolWindowViewModeAction(viewMode);
                    AnAction template = actionManager.getAction(viewMode.getActionID());
                    if (template != null) {
                        action2.copyShortcutFrom(template);
                    }
                    this.add((AnAction)action2);
                }
                this.isInitialized = true;
            }
            super.update(e);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                Group.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/ToolWindowViewModeAction$Group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/ToolWindowViewModeAction$Group";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

