/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.ide.browsers.BrowserStarter;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.LaunchBrowserBeforeRunTask;
import com.intellij.ide.browsers.LaunchBrowserBeforeRunTaskProviderKt;
import com.intellij.ide.browsers.LaunchBrowserBeforeRunTaskState;
import com.intellij.ide.browsers.StartBrowserPanel;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J(\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/browsers/LaunchBrowserBeforeRunTaskProvider;", "Lcom/intellij/execution/BeforeRunTaskProvider;", "Lcom/intellij/ide/browsers/LaunchBrowserBeforeRunTask;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getName", "", "Lorg/jetbrains/annotations/Nls;", "getId", "Lcom/intellij/openapi/util/Key;", "getIcon", "Ljavax/swing/Icon;", "isConfigurable", "", "createTask", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "configureTask", "Lorg/jetbrains/concurrency/Promise;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "task", "executeTask", "configuration", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "intellij.platform.ide.impl"})
public final class LaunchBrowserBeforeRunTaskProvider
extends BeforeRunTaskProvider<LaunchBrowserBeforeRunTask>
implements DumbAware {
    @NotNull
    public String getName() {
        String string = IdeBundle.message((String)"task.browser.launch", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Key<LaunchBrowserBeforeRunTask> getId() {
        return LaunchBrowserBeforeRunTaskProviderKt.access$getID$p();
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = AllIcons.Nodes.PpWeb;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PpWeb");
        return icon2;
    }

    public boolean isConfigurable() {
        return true;
    }

    @NotNull
    public LaunchBrowserBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        return new LaunchBrowserBeforeRunTask();
    }

    @NotNull
    public Promise<Boolean> configureTask(@NotNull DataContext context, @NotNull RunConfiguration runConfiguration, @NotNull LaunchBrowserBeforeRunTask task) {
        long modificationCount;
        LaunchBrowserBeforeRunTaskState state2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
            Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
            state2 = task.getState();
            modificationCount = state2.getModificationCount();
            BrowserSelector browserSelector = new BrowserSelector();
            JComponent browserComboBox = browserSelector.getMainComponent();
            WebBrowser webBrowser = state2.getBrowser();
            if (webBrowser != null) {
                WebBrowser it = webBrowser;
                boolean bl = false;
                browserSelector.setSelected(it);
            }
            TextFieldWithBrowseButton url = new TextFieldWithBrowseButton();
            String string = state2.getUrl();
            if (string != null) {
                String it = string;
                boolean bl = false;
                url.setText(it);
            }
            StartBrowserPanel.setupUrlField(url, runConfiguration.getProject());
            Ref.ObjectRef startJavaScriptDebuggerCheckBox = new Ref.ObjectRef();
            DialogPanel panel2 = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> LaunchBrowserBeforeRunTaskProvider.configureTask$lambda$2(browserComboBox, startJavaScriptDebuggerCheckBox, state2, url, arg_0)));
            String string2 = IdeBundle.message((String)"task.browser.launch", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            ComponentsKt.dialog$default(string2, (JComponent)panel2, true, (JComponent)url, false, null, null, null, null, null, null, 2032, null).show();
            state2.setBrowser(browserSelector.getSelected());
            state2.setUrl(url.getText());
            JCheckBox jCheckBox = (JCheckBox)startJavaScriptDebuggerCheckBox.element;
            if (jCheckBox == null) break block2;
            JCheckBox it = jCheckBox;
            boolean bl = false;
            state2.setWithDebugger(it.isSelected());
        }
        return Promises.resolvedPromise((Object)(modificationCount != state2.getModificationCount() ? 1 : 0));
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull LaunchBrowserBeforeRunTask task) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        Disposer.register((Disposable)((Disposable)env.getProject()), (Disposable)disposable2);
        long executionId = env.getExecutionId();
        env.getProject().getMessageBus().connect(disposable2).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(disposable2, executionId, task, configuration){
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ long $executionId;
            final /* synthetic */ LaunchBrowserBeforeRunTask $task;
            final /* synthetic */ RunConfiguration $configuration;
            {
                this.$disposable = $disposable;
                this.$executionId = $executionId;
                this.$task = $task;
                this.$configuration = $configuration;
            }

            public void processNotStarted(String executorId, ExecutionEnvironment env) {
                Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                Disposer.dispose((Disposable)this.$disposable);
            }

            public void processStarted(String executorId, ExecutionEnvironment env, ProcessHandler handler) {
                Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                if (env.getExecutionId() != this.$executionId) {
                    return;
                }
                Disposer.dispose((Disposable)this.$disposable);
                StartBrowserSettings settings = new StartBrowserSettings();
                settings.setBrowser(this.$task.getState().getBrowser());
                settings.setStartJavaScriptDebugger(this.$task.getState().getWithDebugger());
                settings.setUrl(this.$task.getState().getUrl());
                settings.setSelected(true);
                new BrowserStarter(this.$configuration, settings, handler).start();
            }
        });
        return true;
    }

    private static final Unit configureTask$lambda$2(JComponent $browserComboBox, Ref.ObjectRef $startJavaScriptDebuggerCheckBox, LaunchBrowserBeforeRunTaskState $state, TextFieldWithBrowseButton $url, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = IdeBundle.message((String)"task.browser.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, (Function1<? super Row, Unit>)((Function1)arg_0 -> LaunchBrowserBeforeRunTaskProvider.configureTask$lambda$2$0($browserComboBox, $startJavaScriptDebuggerCheckBox, $state, arg_0)));
        String string2 = IdeBundle.message((String)"task.browser.url", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, (Function1<? super Row, Unit>)((Function1)arg_0 -> LaunchBrowserBeforeRunTaskProvider.configureTask$lambda$2$1($url, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit configureTask$lambda$2$0(JComponent $browserComboBox, Ref.ObjectRef $startJavaScriptDebuggerCheckBox, LaunchBrowserBeforeRunTaskState $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Intrinsics.checkNotNull((Object)$browserComboBox);
        $this$row.cell($browserComboBox).resizableColumn().align(AlignX.FILL.INSTANCE);
        if (JavaScriptDebuggerStarter.Util.hasStarters()) {
            String string = IdeBundle.message((String)"start.browser.with.js.debugger", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $startJavaScriptDebuggerCheckBox.element = ButtonKt.selected($this$row.checkBox(string), $state.getWithDebugger()).getComponent();
        }
        return Unit.INSTANCE;
    }

    private static final Unit configureTask$lambda$2$1(TextFieldWithBrowseButton $url, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldWithBrowseButtonKt.columns($this$row.cell((JComponent)$url).align(AlignX.FILL.INSTANCE), 25);
        return Unit.INSTANCE;
    }
}

