/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.ConsentSettingsUi;
import com.intellij.ide.gdpr.ui.consents.ConsentForcedState;
import com.intellij.ide.gdpr.ui.consents.ConsentGroup;
import com.intellij.ide.gdpr.ui.consents.ConsentGroupUi;
import com.intellij.ide.gdpr.ui.consents.ConsentUi;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u001a,\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0001\u001a.\u0010\u000b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\t0\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u001a0\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u001a0\u0010\u0013\u001a\u00020\u000f*\u00020\u00102\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u0016\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\t*\u00020\u00102\u0006\u0010\u0019\u001a\u00020\rH\u0002\u001a\"\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\nH\u0002\u001a\u0019\u0010\u001f\u001a\t\u0018\u00010 \u00a2\u0006\u0002\b!2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u001a\u0019\u0010\"\u001a\u00020\u000f*\u00020\u00102\u000b\u0010#\u001a\u00070 \u00a2\u0006\u0002\b!H\u0002\u001a\u001a\u0010$\u001a\u00070 \u00a2\u0006\u0002\b!2\u000b\u0010%\u001a\u00070 \u00a2\u0006\u0002\b!H\u0002\u00a8\u0006&"}, d2={"createNoOptionsConsentSettings", "Lcom/intellij/openapi/ui/DialogPanel;", "preferencesMode", "", "createConsentSettings", "consentMapping", "", "Lcom/intellij/ide/gdpr/ConsentSettingsUi$ConsentStateSupplier;", "consents", "", "Lcom/intellij/ide/gdpr/Consent;", "partitionConsentsByGroupId", "Lkotlin/Pair;", "Lcom/intellij/ide/gdpr/ui/consents/ConsentGroup;", "addSingleConsents", "", "Lcom/intellij/ui/dsl/builder/Panel;", "singleConsents", "addCheckBox", "addGroupConsents", "consentsGroups", "addBorder", "createConsentElement", "consent", "createGroupConsentsElement", "consentGroup", "createConsentStateSupplier", "forcedState", "Lcom/intellij/ide/gdpr/ui/consents/ConsentForcedState;", "cb", "Lcom/intellij/ui/components/JBCheckBox;", "getWarning", "", "Lcom/intellij/openapi/util/NlsSafe;", "addWarningRow", "warning", "processCheckboxComment", "text", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nConsentSettingsBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsentSettingsBody.kt\ncom/intellij/ide/gdpr/ConsentSettingsBodyKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n136#2,9:208\n216#2:217\n217#2:225\n145#2:226\n774#3:218\n865#3,2:219\n827#3:221\n855#3,2:222\n1869#3,2:227\n1869#3,2:229\n1#4:224\n*S KotlinDebug\n*F\n+ 1 ConsentSettingsBody.kt\ncom/intellij/ide/gdpr/ConsentSettingsBodyKt\n*L\n57#1:208,9\n57#1:217\n57#1:225\n57#1:226\n58#1:218\n58#1:219,2\n61#1:221\n61#1:222,2\n73#1:227,2\n84#1:229,2\n57#1:224\n*E\n"})
public final class ConsentSettingsBodyKt {
    @ApiStatus.Internal
    @NotNull
    public static final DialogPanel createNoOptionsConsentSettings(boolean preferencesMode) {
        DialogPanel dialogPanel;
        DialogPanel $this$createNoOptionsConsentSettings_u24lambda_u241 = dialogPanel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)ConsentSettingsBodyKt::createNoOptionsConsentSettings$lambda$0));
        boolean bl = false;
        ConsentSettingsBodyKt.addBorder($this$createNoOptionsConsentSettings_u24lambda_u241, preferencesMode);
        return dialogPanel;
    }

    @ApiStatus.Internal
    @NotNull
    public static final DialogPanel createConsentSettings(@NotNull Collection<ConsentSettingsUi.ConsentStateSupplier> consentMapping, boolean preferencesMode, @NotNull List<Consent> consents) {
        DialogPanel dialogPanel;
        Intrinsics.checkNotNullParameter(consentMapping, (String)"consentMapping");
        Intrinsics.checkNotNullParameter(consents, (String)"consents");
        boolean addCheckBox = preferencesMode || consents.size() > 1;
        DialogPanel $this$createConsentSettings_u24lambda_u241 = dialogPanel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> ConsentSettingsBodyKt.createConsentSettings$lambda$0(consents, consentMapping, addCheckBox, preferencesMode, arg_0)));
        boolean bl = false;
        $this$createConsentSettings_u24lambda_u241.setBackground(preferencesMode ? UIUtil.getPanelBackground() : UIUtil.getEditorPaneBackground());
        ConsentSettingsBodyKt.addBorder($this$createConsentSettings_u24lambda_u241, preferencesMode);
        return dialogPanel;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<List<Consent>, List<ConsentGroup>> partitionConsentsByGroupId(@NotNull List<Consent> consents) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(consents, (String)"consents");
        Ref.ObjectRef ungroupedConsents = new Ref.ObjectRef();
        ungroupedConsents.element = CollectionsKt.toList((Iterable)consents);
        Map<String, Function1<Consent, Boolean>> $this$mapNotNull$iv = ConsentGroup.Companion.getCONSENT_GROUP_MAPPING();
        boolean $i$f$mapNotNull = false;
        Map<String, Function1<Consent, Boolean>> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ConsentGroup consentGroup;
            void $this$filterTo$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String groupId = (String)entry.getKey();
            Function1 predicate = (Function1)entry.getValue();
            Iterable $this$filter$iv = (Iterable)ungroupedConsents.element;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Consent it = (Consent)element$iv$iv2;
                boolean bl3 = false;
                if (!((Boolean)predicate.invoke((Object)it)).booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List matchingConsents = (List)destination$iv$iv2;
            if (matchingConsents.isEmpty()) {
                consentGroup = null;
            } else {
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                $this$filter$iv = (Iterable)ungroupedConsents.element;
                Ref.ObjectRef objectRef = ungroupedConsents;
                boolean $i$f$filterNot = false;
                $this$filterTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
                    if (((Boolean)predicate.invoke(element$iv$iv2)).booleanValue()) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                objectRef.element = (List)destination$iv$iv2;
                consentGroup = new ConsentGroup(groupId, matchingConsents);
            }
            if (consentGroup == null) continue;
            ConsentGroup it$iv$iv = consentGroup;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List consentGroups = (List)destination$iv$iv;
        return TuplesKt.to((Object)ungroupedConsents.element, (Object)consentGroups);
    }

    private static final void addSingleConsents(Panel $this$addSingleConsents, Collection<ConsentSettingsUi.ConsentStateSupplier> consentMapping, List<Consent> singleConsents, boolean addCheckBox) {
        Iterable $this$forEach$iv = singleConsents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Consent consent = (Consent)element$iv;
            boolean bl = false;
            ConsentSettingsUi.ConsentStateSupplier supplier = ConsentSettingsBodyKt.createConsentElement($this$addSingleConsents, consent, addCheckBox);
            consentMapping.add(supplier);
        }
    }

    private static final void addGroupConsents(Panel $this$addGroupConsents, Collection<ConsentSettingsUi.ConsentStateSupplier> consentMapping, List<ConsentGroup> consentsGroups, boolean addCheckBox) {
        Iterable $this$forEach$iv = consentsGroups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsentGroup consentGroup = (ConsentGroup)element$iv;
            boolean bl = false;
            if (consentGroup.getConsents().size() > 1) {
                List<ConsentSettingsUi.ConsentStateSupplier> suppliers = ConsentSettingsBodyKt.createGroupConsentsElement($this$addGroupConsents, consentGroup);
                consentMapping.addAll((Collection<ConsentSettingsUi.ConsentStateSupplier>)suppliers);
                continue;
            }
            ConsentSettingsBodyKt.addSingleConsents($this$addGroupConsents, consentMapping, consentGroup.getConsents(), addCheckBox);
        }
    }

    private static final void addBorder(DialogPanel $this$addBorder, boolean preferencesMode) {
        if (!preferencesMode) {
            $this$addBorder.setBorder(JBUI.Borders.empty((int)10));
        }
    }

    private static final ConsentSettingsUi.ConsentStateSupplier createConsentElement(Panel $this$createConsentElement, Consent consent, boolean addCheckBox) {
        ConsentSettingsUi.ConsentStateSupplier consentStateSupplier;
        Row row2;
        ConsentUi consentUi = ConsentSettingsUi.getConsentUi(consent);
        Intrinsics.checkNotNullExpressionValue((Object)consentUi, (String)"getConsentUi(...)");
        ConsentUi consentUi2 = consentUi;
        ConsentForcedState forcedState = consentUi2.getForcedState();
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        if (addCheckBox) {
            row2 = Panel.row$default($this$createConsentElement, null, arg_0 -> ConsentSettingsBodyKt.createConsentElement$lambda$0(consentUi2, consent, result2, forcedState, arg_0), 1, null);
        } else {
            result2.element = new ConsentSettingsUi.ConsentStateSupplier(consent, ConsentSettingsBodyKt::createConsentElement$lambda$1);
            row2 = Panel.row$default($this$createConsentElement, null, arg_0 -> ConsentSettingsBodyKt.createConsentElement$lambda$2(consent, arg_0), 1, null);
        }
        Row row3 = row2;
        String warning = ConsentSettingsBodyKt.getWarning(forcedState);
        if (warning == null) {
            row3.bottomGap(BottomGap.SMALL);
        } else {
            ConsentSettingsBodyKt.addWarningRow($this$createConsentElement, warning);
        }
        if (result2.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            consentStateSupplier = null;
        } else {
            consentStateSupplier = (ConsentSettingsUi.ConsentStateSupplier)result2.element;
        }
        return consentStateSupplier;
    }

    private static final List<ConsentSettingsUi.ConsentStateSupplier> createGroupConsentsElement(Panel $this$createGroupConsentsElement, ConsentGroup consentGroup) {
        List results;
        block2: {
            ConsentGroupUi consentGroupUI = ConsentSettingsUi.getConsentGroupUi(consentGroup);
            if (consentGroupUI == null) {
                return CollectionsKt.emptyList();
            }
            results = new ArrayList();
            Panel.row$default($this$createGroupConsentsElement, null, arg_0 -> ConsentSettingsBodyKt.createGroupConsentsElement$lambda$0(consentGroupUI, arg_0), 1, null).bottomGap(BottomGap.SMALL);
            for (Pair pair : CollectionsKt.zip((Iterable)consentGroupUI.getConsentUis(), (Iterable)consentGroup.getConsents())) {
                ConsentUi consentUI = (ConsentUi)pair.component1();
                Consent consent = (Consent)pair.component2();
                ConsentForcedState forcedState = consentUI.getForcedState();
                $this$createGroupConsentsElement.indent((Function1<? super Panel, Unit>)((Function1)arg_0 -> ConsentSettingsBodyKt.createGroupConsentsElement$lambda$1(consentUI, consent, results, forcedState, arg_0)));
            }
            String string = consentGroupUI.getForcedStateDescription();
            if (string == null) break block2;
            String description = string;
            boolean bl = false;
            $this$createGroupConsentsElement.indent((Function1<? super Panel, Unit>)((Function1)arg_0 -> ConsentSettingsBodyKt.createGroupConsentsElement$lambda$2$0(description, arg_0)));
        }
        return results;
    }

    private static final ConsentSettingsUi.ConsentStateSupplier createConsentStateSupplier(ConsentForcedState forcedState, JBCheckBox cb, Consent consent) {
        ConsentSettingsUi.ConsentStateSupplier consentStateSupplier;
        ConsentForcedState consentForcedState = forcedState;
        if (consentForcedState instanceof ConsentForcedState.ExternallyDisabled) {
            cb.setEnabled(false);
            cb.setSelected(false);
            consentStateSupplier = new ConsentSettingsUi.ConsentStateSupplier(consent, () -> ConsentSettingsBodyKt.createConsentStateSupplier$lambda$0(consent));
        } else if (consentForcedState instanceof ConsentForcedState.AlwaysEnabled) {
            cb.setEnabled(false);
            cb.setSelected(true);
            consentStateSupplier = new ConsentSettingsUi.ConsentStateSupplier(consent, () -> ConsentSettingsBodyKt.createConsentStateSupplier$lambda$1(consent));
        } else {
            consentStateSupplier = new ConsentSettingsUi.ConsentStateSupplier(consent, () -> ConsentSettingsBodyKt.createConsentStateSupplier$lambda$2(cb));
        }
        return consentStateSupplier;
    }

    private static final String getWarning(ConsentForcedState forcedState) {
        ConsentForcedState consentForcedState = forcedState;
        return consentForcedState instanceof ConsentForcedState.ExternallyDisabled ? ((ConsentForcedState.ExternallyDisabled)forcedState).getDescription() : (consentForcedState instanceof ConsentForcedState.AlwaysEnabled ? ((ConsentForcedState.AlwaysEnabled)forcedState).getDescription() : null);
    }

    private static final void addWarningRow(Panel $this$addWarningRow, String warning) {
        Panel.row$default($this$addWarningRow, null, arg_0 -> ConsentSettingsBodyKt.addWarningRow$lambda$0(warning, arg_0), 1, null).bottomGap(BottomGap.SMALL);
    }

    private static final String processCheckboxComment(String text2) {
        Object object = new String[]{"\n"};
        List paragraphs = StringsKt.split$default((CharSequence)text2, (String[])object, (boolean)false, (int)0, (int)6, null);
        if (paragraphs.size() <= 1) {
            return text2;
        }
        object = "<p style=\"margin-top:" + ConsentSettingsUi.getParagraphSpace() + "px;\">";
        return CollectionsKt.joinToString$default((Iterable)paragraphs, (CharSequence)((CharSequence)object), (CharSequence)"<p>", null, (int)0, null, null, (int)60, null);
    }

    private static final Unit createNoOptionsConsentSettings$lambda$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, ConsentSettingsBodyKt::createNoOptionsConsentSettings$lambda$0$0, 1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createNoOptionsConsentSettings$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"gdpr.label.there.are.no.data.sharing.options.available", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).align(Align.CENTER);
        return Unit.INSTANCE;
    }

    private static final Unit createConsentSettings$lambda$0(List $consents, Collection $consentMapping, boolean $addCheckBox, boolean $preferencesMode, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Pair<List<Consent>, List<ConsentGroup>> pair = ConsentSettingsBodyKt.partitionConsentsByGroupId($consents);
        List singleConsents = (List)pair.component1();
        List consentsWithGroup = (List)pair.component2();
        ConsentSettingsBodyKt.addGroupConsents($this$panel, $consentMapping, consentsWithGroup, $addCheckBox);
        ConsentSettingsBodyKt.addSingleConsents($this$panel, $consentMapping, singleConsents, $addCheckBox);
        if (!ConsentOptions.getInstance().isEAP()) {
            Panel.row$default($this$panel, null, ConsentSettingsBodyKt::createConsentSettings$lambda$0$0, 1, null);
        }
        if (!$preferencesMode) {
            Panel.row$default($this$panel, null, ConsentSettingsBodyKt::createConsentSettings$lambda$0$1, 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createConsentSettings$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{ApplicationInfoImpl.getShadowInstance().getShortCompanyName()};
        String string = IdeBundle.message((String)"gdpr.hint.text.apply.to.all.installed.products", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default($this$row, string, 0, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createConsentSettings$lambda$0$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{ShowSettingsUtil.getSettingsMenuName()};
        String string = IdeBundle.message((String)"gdpr.hint.text.you.can.always.change.this.behavior", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default($this$row, string, 0, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createConsentElement$lambda$0(ConsentUi $consentUi, Consent $consent, Ref.ObjectRef $result, ConsentForcedState $forcedState, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBCheckBox cb = (JBCheckBox)ButtonKt.selected(Cell.comment$default($this$row.checkBox($consentUi.getCheckBoxText()), ConsentSettingsBodyKt.processCheckboxComment($consentUi.getCheckBoxCommentText()), 0, null, 6, null), $consent.isAccepted()).getComponent();
        $result.element = ConsentSettingsBodyKt.createConsentStateSupplier($forcedState, cb, $consent);
        return Unit.INSTANCE;
    }

    private static final Boolean createConsentElement$lambda$1() {
        return true;
    }

    private static final Unit createConsentElement$lambda$2(Consent $consent, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JEditorPane jEditorPane = ConsentSettingsUi.createSingleConsent($consent);
        Intrinsics.checkNotNullExpressionValue((Object)jEditorPane, (String)"createSingleConsent(...)");
        $this$row.cell((JComponent)jEditorPane).align(AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createGroupConsentsElement$lambda$0(ConsentGroupUi $consentGroupUI, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default($this$row, ConsentSettingsBodyKt.processCheckboxComment($consentGroupUI.getCommentText()), 70, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit createGroupConsentsElement$lambda$1(ConsentUi $consentUI, Consent $consent, List $results, ConsentForcedState $forcedState, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default($this$indent, null, arg_0 -> ConsentSettingsBodyKt.createGroupConsentsElement$lambda$1$0($consentUI, $consent, $results, $forcedState, arg_0), 1, null).bottomGap(BottomGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit createGroupConsentsElement$lambda$1$0(ConsentUi $consentUI, Consent $consent, List $results, ConsentForcedState $forcedState, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBCheckBox cb = (JBCheckBox)ButtonKt.selected(Cell.comment$default($this$row.checkBox($consentUI.getCheckBoxText()), ConsentSettingsBodyKt.processCheckboxComment($consentUI.getCheckBoxCommentText()), 0, null, 6, null), $consent.isAccepted()).getComponent();
        $results.add(ConsentSettingsBodyKt.createConsentStateSupplier($forcedState, cb, $consent));
        return Unit.INSTANCE;
    }

    private static final Unit createGroupConsentsElement$lambda$2$0(String $description, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        ConsentSettingsBodyKt.addWarningRow($this$indent, $description);
        return Unit.INSTANCE;
    }

    private static final Boolean createConsentStateSupplier$lambda$0(Consent $consent) {
        return $consent.isAccepted();
    }

    private static final Boolean createConsentStateSupplier$lambda$1(Consent $consent) {
        return $consent.isAccepted();
    }

    private static final Boolean createConsentStateSupplier$lambda$2(JBCheckBox $cb) {
        return $cb.isSelected();
    }

    private static final Unit addWarningRow$lambda$0(String $warning, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon2 = AllIcons.General.Warning;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Warning");
        $this$row.icon(icon2).gap(RightGap.SMALL).align(AlignY.TOP.INSTANCE);
        Row.comment$default($this$row, $warning, 70, null, 4, null);
        return Unit.INSTANCE;
    }
}

