/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr.ui.consents;

import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/gdpr/ui/consents/ConsentGroup;", "", "id", "", "consents", "", "Lcom/intellij/ide/gdpr/Consent;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getId", "()Ljava/lang/String;", "getConsents", "()Ljava/util/List;", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nConsentGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsentGroup.kt\ncom/intellij/ide/gdpr/ui/consents/ConsentGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,24:1\n1068#2:25\n*S KotlinDebug\n*F\n+ 1 ConsentGroup.kt\ncom/intellij/ide/gdpr/ui/consents/ConsentGroup\n*L\n11#1:25\n*E\n"})
public final class ConsentGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final List<Consent> consents;
    @NotNull
    public static final String DATA_COLLECTION_GROUP_ID = "data.collection";
    @NotNull
    private static final Map<String, Function1<Consent, Boolean>> CONSENT_GROUP_MAPPING = MapsKt.mapOf((Pair)TuplesKt.to((Object)"data.collection", ConsentGroup::CONSENT_GROUP_MAPPING$lambda$0));

    public ConsentGroup(@NotNull String id2, @NotNull List<Consent> consents) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter(consents, (String)"consents");
        this.id = id2;
        Iterable $this$sortedByDescending$iv = consents;
        boolean $i$f$sortedByDescending = false;
        this.consents = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Consent it = (Consent)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (Consent)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
            }
        });
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final List<Consent> getConsents() {
        return this.consents;
    }

    private static final boolean CONSENT_GROUP_MAPPING$lambda$0(Consent consent) {
        Intrinsics.checkNotNullParameter((Object)consent, (String)"consent");
        return ConsentOptions.condUsageStatsConsent().test(consent) || ConsentOptions.condTraceDataCollectionComConsent().test(consent) || ConsentOptions.condTraceDataCollectionNonComConsent().test(consent);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/gdpr/ui/consents/ConsentGroup$Companion;", "", "<init>", "()V", "DATA_COLLECTION_GROUP_ID", "", "CONSENT_GROUP_MAPPING", "", "Lkotlin/Function1;", "Lcom/intellij/ide/gdpr/Consent;", "", "getCONSENT_GROUP_MAPPING", "()Ljava/util/Map;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Function1<Consent, Boolean>> getCONSENT_GROUP_MAPPING() {
            return CONSENT_GROUP_MAPPING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

