/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.DynamicPaidPluginsServiceKt;
import com.intellij.ide.plugins.DynamicPluginEnabler;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.DynamicPluginsUsagesCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.IntellijInternalApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u0014\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u000b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u001e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002JC\u0010\u0012\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\u000f\b\u0002\u0010\u0017\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b\u0019H\u0002J*\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u001b*\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/plugins/DynamicPaidPluginsService;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "loadPaidPluginsWhenProjectIsOpened", "", "loadPaidPlugins", "project", "Lcom/intellij/openapi/project/Project;", "doLoadPaidPlugins", "notifyNotLoadedWithoutRestart", "pluginEnabler", "Lcom/intellij/ide/plugins/PluginEnabler;", "plugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "enablePlugins", "descriptors", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "restart", "", "progressTitle", "", "Lorg/jetbrains/annotations/Nls;", "splitPlugins", "Lkotlin/Pair;", "LoadPaidPluginsProjectActivity", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDynamicPaidPluginsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicPaidPluginsService.kt\ncom/intellij/ide/plugins/DynamicPaidPluginsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,214:1\n774#2:215\n865#2,2:216\n3301#2,4:218\n1740#2,3:222\n3305#2,6:225\n1563#2:231\n1634#2,3:232\n1563#2:235\n1634#2,3:236\n3301#2,10:243\n95#3:239\n135#3,3:240\n13#4:253\n*S KotlinDebug\n*F\n+ 1 DynamicPaidPluginsService.kt\ncom/intellij/ide/plugins/DynamicPaidPluginsService\n*L\n85#1:215\n85#1:216,2\n118#1:218,4\n119#1:222,3\n118#1:225,6\n123#1:231\n123#1:232,3\n128#1:235\n128#1:236,3\n187#1:243,10\n154#1:239\n154#1:240,3\n49#1:253\n*E\n"})
public final class DynamicPaidPluginsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final AtomicBoolean shouldLoadOnProjectOpening;

    public DynamicPaidPluginsService(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
    }

    @ApiStatus.Internal
    public final void loadPaidPluginsWhenProjectIsOpened() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Project project2 = (Project)ArraysKt.firstOrNull((Object[])projectArray);
        if (project2 != null) {
            this.loadPaidPlugins(project2);
        } else {
            logger.debug("No open projects found. Scheduling paid plugins loading on project opening.");
            shouldLoadOnProjectOpening.set(true);
        }
    }

    @JvmOverloads
    public final void loadPaidPlugins(@Nullable Project project2) {
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.nonModal();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"nonModal(...)");
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project2, null){
            int label;
            final /* synthetic */ DynamicPaidPluginsService this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        DynamicPaidPluginsService.access$getLogger$cp().debug("loadPaidPlugins called");
                        DynamicPaidPluginsService.access$doLoadPaidPlugins(this.this$0, this.$project);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static /* synthetic */ void loadPaidPlugins$default(DynamicPaidPluginsService dynamicPaidPluginsService, Project project2, int n, Object object) {
        if ((n & 1) != 0) {
            project2 = null;
        }
        dynamicPaidPluginsService.loadPaidPlugins(project2);
    }

    /*
     * WARNING - void declaration
     */
    private final void doLoadPaidPlugins(Project project2) {
        void $this$filterTo$iv$iv;
        if (PluginEnabler.getInstance().isDisabled(PluginManagerCore.ULTIMATE_PLUGIN_ID)) {
            logger.info("Ultimate plugin is disabled. Paid plugins will not be enabled.");
            return;
        }
        Set disabledPlugins = DisabledPluginsState.Companion.getDisabledIds();
        PluginSet pluginSet = PluginManagerCore.getPluginSet();
        Map pluginIdMap = PluginManagerCore.INSTANCE.buildPluginIdMap();
        Map contentModuleIdMap = pluginSet.buildContentModuleIdMap();
        Set loadedPlugins = CollectionsKt.toSet((Iterable)pluginSet.enabledPlugins);
        Iterable $this$filter$iv = pluginSet.allPlugins;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PluginMainDescriptor it = (PluginMainDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(!disabledPlugins.contains(it.getPluginId()) && !loadedPlugins.contains(it) && PluginManagerCoreKt.pluginRequiresUltimatePlugin((PluginId)it.getPluginId(), (Map)pluginIdMap, (Map)contentModuleIdMap) && !DynamicPaidPluginsServiceKt.access$pluginRequiresDisabledPlugin(it.getPluginId(), pluginIdMap, contentModuleIdMap, disabledPlugins) && PluginManagerCore.isCompatible((IdeaPluginDescriptor)((IdeaPluginDescriptor)it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List pluginsToEnable = (List)destination$iv$iv;
        if (pluginsToEnable.isEmpty()) {
            logger.debug("No plugins found to be enabled.");
            return;
        }
        Pair<List<IdeaPluginDescriptorImpl>, List<IdeaPluginDescriptorImpl>> pair = this.splitPlugins(pluginsToEnable);
        List loadablePlugins = (List)pair.component1();
        List requireRestartPlugins = (List)pair.component2();
        PluginEnabler pluginEnabler = PluginEnabler.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)pluginEnabler, (String)"getInstance(...)");
        PluginEnabler pluginEnabler2 = pluginEnabler;
        if (!((Collection)loadablePlugins).isEmpty()) {
            this.enablePlugins(pluginEnabler2, loadablePlugins, false, project2, IdeBundle.message((String)"progress.title.loading.paid.plugins", (Object[])new Object[0]));
        } else {
            logger.debug("No plugins loadable without restart plugins found to be enabled.");
        }
        if (!((Collection)requireRestartPlugins).isEmpty()) {
            this.notifyNotLoadedWithoutRestart(pluginEnabler2, requireRestartPlugins);
        } else {
            logger.debug("No plugins that require restart found to be enabled.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void notifyNotLoadedWithoutRestart(PluginEnabler pluginEnabler, List<? extends IdeaPluginDescriptorImpl> plugins2) {
        Object object;
        Iterable $this$partition$iv = plugins2;
        boolean $i$f$partition = false;
        Iterable first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            boolean bl;
            block8: {
                IdeaPluginDescriptorImpl plugin = (IdeaPluginDescriptorImpl)element$iv;
                boolean bl2 = false;
                Iterable $this$all$iv = plugin.getDependencies();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        PluginDependency it = (PluginDependency)element$iv2;
                        boolean bl3 = false;
                        if (PluginManagerCore.isPluginInstalled((PluginId)it.getPluginId()) || it.isOptional()) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            boolean bl4 = bl ? ((ArrayList)first$iv).add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List loadableAfterRestart = (List)pair.component1();
        List missingDependencies = (List)pair.component2();
        if (!((Collection)missingDependencies).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            first$iv = missingDependencies;
            object = logger;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IdeaPluginDescriptorImpl $i$f$all = (IdeaPluginDescriptorImpl)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPluginId());
            }
            object.info("Plugins cannot be loaded even with restart because of missing dependencies: " + (List)destination$iv$iv);
        }
        if (!((Collection)loadableAfterRestart).isEmpty()) {
            void $this$mapTo$iv$iv;
            String string = IdeBundle.message((String)"notification.title.paid.plugins.not.loaded", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String notificationTitle = string;
            Iterable $this$map$iv = loadableAfterRestart;
            boolean $i$f$map = false;
            Iterable $i$f$mapTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object element$iv2;
                element$iv2 = (IdeaPluginDescriptorImpl)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getName());
            }
            List pluginNames = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            String notificationContent = IdeBundle.message((String)"notification.content.paid.plugins.not.loaded", (Object[])new Object[0]) + CollectionsKt.joinToString$default((Iterable)pluginNames, (CharSequence)"<br>", null, null, (int)0, null, null, (int)62, null);
            String string2 = IdeBundle.message((String)"notification.action.load.paid.plugins.and.restart", (Object[])new Object[0]);
            NotificationGroupManager.getInstance().getNotificationGroup("Paid Plugins").createNotification(notificationTitle, notificationContent, NotificationType.INFORMATION).addAction((AnAction)new NotificationAction(this, pluginEnabler, loadableAfterRestart, string2){
                final /* synthetic */ DynamicPaidPluginsService this$0;
                final /* synthetic */ PluginEnabler $pluginEnabler;
                final /* synthetic */ List<IdeaPluginDescriptorImpl> $loadableAfterRestart;
                {
                    this.this$0 = $receiver;
                    this.$pluginEnabler = $pluginEnabler;
                    this.$loadableAfterRestart = $loadableAfterRestart;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e, Notification notification2) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                    DynamicPaidPluginsService.enablePlugins$default(this.this$0, this.$pluginEnabler, this.$loadableAfterRestart, true, null, null, 24, null);
                }
            }).notify(null);
        }
    }

    private final void enablePlugins(PluginEnabler pluginEnabler, List<? extends IdeaPluginDescriptor> descriptors2, boolean restart, Project project2, String progressTitle) {
        logger.info("Plugins to enable: [" + CollectionsKt.joinToString$default((Iterable)descriptors2, (CharSequence)", ", null, null, (int)0, null, DynamicPaidPluginsService::enablePlugins$lambda$0, (int)30, null) + "]");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        Boolean result$iv$iv = pluginEnabler instanceof DynamicPluginEnabler ? ((DynamicPluginEnabler)pluginEnabler).enable((Collection<? extends IdeaPluginDescriptor>)descriptors2, progressTitle, project2) : pluginEnabler.enable((Collection)descriptors2);
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        boolean result2 = (Boolean)timedValue.component1();
        long elapsedTime = timedValue.component2-UwyO8pc();
        int pluginsCount = descriptors2.size();
        DynamicPluginsUsagesCollector.INSTANCE.logPaidPluginsLoaded-KLykuaI$intellij_platform_ide_impl(elapsedTime, pluginsCount, restart);
        logger.info("Loaded " + pluginsCount + " plugins in " + Duration.getInWholeMilliseconds-impl((long)elapsedTime) + " ms. Enabled: " + result2 + ". Restart requested: " + restart);
        if (restart) {
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }

    static /* synthetic */ void enablePlugins$default(DynamicPaidPluginsService dynamicPaidPluginsService, PluginEnabler pluginEnabler, List list2, boolean bl, Project project2, String string, int n, Object object) {
        if ((n & 8) != 0) {
            project2 = null;
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        dynamicPaidPluginsService.enablePlugins(pluginEnabler, list2, bl, project2, string);
    }

    private final Pair<List<IdeaPluginDescriptorImpl>, List<IdeaPluginDescriptorImpl>> splitPlugins(List<? extends IdeaPluginDescriptorImpl> $this$splitPlugins) {
        return DynamicPaidPluginsService.splitPlugins$doSplit($this$splitPlugins, CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    @JvmOverloads
    public final void loadPaidPlugins() {
        DynamicPaidPluginsService.loadPaidPlugins$default(this, null, 1, null);
    }

    private static final CharSequence enablePlugins$lambda$0(IdeaPluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPluginId().getIdString();
    }

    private static final Pair<List<IdeaPluginDescriptorImpl>, List<IdeaPluginDescriptorImpl>> splitPlugins$doSplit(List<? extends IdeaPluginDescriptorImpl> pluginsToLoad, List<? extends IdeaPluginDescriptorImpl> loadablePlugins, List<? extends IdeaPluginDescriptorImpl> requireRestartPlugins) {
        while (!pluginsToLoad.isEmpty()) {
            Iterable $this$partition$iv = pluginsToLoad;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                IdeaPluginDescriptorImpl it = (IdeaPluginDescriptorImpl)element$iv;
                boolean bl = false;
                boolean bl2 = DynamicPlugins.allowLoadUnloadWithoutRestart$default(it, null, pluginsToLoad, 2, null) ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List loadable = (List)pair.component1();
            List requireRestart = (List)pair.component2();
            if (requireRestart.isEmpty()) {
                return TuplesKt.to((Object)CollectionsKt.plus((Collection)loadablePlugins, (Iterable)loadable), requireRestartPlugins);
            }
            List<? extends IdeaPluginDescriptorImpl> list2 = loadablePlugins;
            List list3 = CollectionsKt.plus((Collection)requireRestartPlugins, (Iterable)requireRestart);
            pluginsToLoad = loadable;
            loadablePlugins = list2;
            requireRestartPlugins = list3;
        }
        return TuplesKt.to(loadablePlugins, requireRestartPlugins);
    }

    @JvmStatic
    @NotNull
    public static final DynamicPaidPluginsService getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$doLoadPaidPlugins(DynamicPaidPluginsService $this, Project project2) {
        $this.doLoadPaidPlugins(project2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DynamicPaidPluginsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DynamicPaidPluginsService.logger = logger;
        shouldLoadOnProjectOpening = new AtomicBoolean(false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/plugins/DynamicPaidPluginsService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ide/plugins/DynamicPaidPluginsService;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "shouldLoadOnProjectOpening", "Ljava/util/concurrent/atomic/AtomicBoolean;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nDynamicPaidPluginsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicPaidPluginsService.kt\ncom/intellij/ide/plugins/DynamicPaidPluginsService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,214:1\n42#2,3:215\n*S KotlinDebug\n*F\n+ 1 DynamicPaidPluginsService.kt\ncom/intellij/ide/plugins/DynamicPaidPluginsService$Companion\n*L\n47#1:215,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DynamicPaidPluginsService getInstance() {
            boolean $i$f$service = false;
            Class<DynamicPaidPluginsService> serviceClass$iv = DynamicPaidPluginsService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (DynamicPaidPluginsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/plugins/DynamicPaidPluginsService$LoadPaidPluginsProjectActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
    public static final class LoadPaidPluginsProjectActivity
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
            if (shouldLoadOnProjectOpening.compareAndSet(true, false)) {
                Companion.getInstance().loadPaidPlugins(project2);
            }
            return Unit.INSTANCE;
        }
    }
}

