/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.core.CoreBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginUtilsKt;
import com.intellij.ide.plugins.ThirdPartyPluginsWithoutConsentFile;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.marketplace.statistics.enums.DialogAcceptanceResultEnum;
import com.intellij.idea.AppMode;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerFacade;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginManagerMain {
    private PluginManagerMain() {
    }

    @Deprecated(since="2020.2", forRemoval=true)
    public static boolean downloadPlugins(@NotNull List<PluginNode> plugins2, @NotNull List<? extends IdeaPluginDescriptor> customPlugins2, @Nullable Runnable onSuccess, @NotNull PluginEnabler pluginEnabler, @Nullable Runnable cleanup) throws IOException {
        if (plugins2 == null) {
            PluginManagerMain.$$$reportNull$$$0(0);
        }
        if (customPlugins2 == null) {
            PluginManagerMain.$$$reportNull$$$0(1);
        }
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(2);
        }
        List filteredCustomPlugins = ContainerUtil.filterIsInstance(customPlugins2, PluginNode.class);
        return PluginManagerMain.downloadPluginsAndCleanup(plugins2, filteredCustomPlugins, onSuccess, pluginEnabler, ModalityState.any(), cleanup);
    }

    public static boolean downloadPluginsAndCleanup(@NotNull List<PluginNode> plugins2, @NotNull Collection<PluginNode> customPlugins2, @Nullable Runnable onSuccess, @NotNull com.intellij.ide.plugins.PluginEnabler pluginEnabler, @NotNull ModalityState modalityState, @Nullable Runnable cleanup) throws IOException {
        if (plugins2 == null) {
            PluginManagerMain.$$$reportNull$$$0(3);
        }
        if (customPlugins2 == null) {
            PluginManagerMain.$$$reportNull$$$0(4);
        }
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(5);
        }
        if (modalityState == null) {
            PluginManagerMain.$$$reportNull$$$0(6);
        }
        return PluginManagerMain.downloadPlugins(plugins2, customPlugins2, false, onSuccess, pluginEnabler, modalityState, cleanup != null ? __ -> cleanup.run() : null);
    }

    public static boolean downloadPlugins(@NotNull List<PluginNode> plugins2, @NotNull Collection<PluginNode> customPlugins2, boolean allowInstallWithoutRestart, @Nullable Runnable onSuccess, @NotNull com.intellij.ide.plugins.PluginEnabler pluginEnabler, @NotNull ModalityState modalityState, @Nullable Consumer<Boolean> function) throws IOException {
        if (plugins2 == null) {
            PluginManagerMain.$$$reportNull$$$0(7);
        }
        if (customPlugins2 == null) {
            PluginManagerMain.$$$reportNull$$$0(8);
        }
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(9);
        }
        if (modalityState == null) {
            PluginManagerMain.$$$reportNull$$$0(10);
        }
        return PluginManagerMain.downloadPluginsImpl(plugins2, customPlugins2, allowInstallWithoutRestart, onSuccess, pluginEnabler, function, modalityState, true);
    }

    public static boolean downloadPluginsModal(@NotNull List<PluginNode> plugins2, @NotNull Collection<PluginNode> customPlugins2, boolean allowInstallWithoutRestart, @Nullable Runnable onSuccess, @NotNull com.intellij.ide.plugins.PluginEnabler pluginEnabler, @NotNull ModalityState modalityState, @Nullable Consumer<Boolean> function) throws IOException {
        if (plugins2 == null) {
            PluginManagerMain.$$$reportNull$$$0(11);
        }
        if (customPlugins2 == null) {
            PluginManagerMain.$$$reportNull$$$0(12);
        }
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(13);
        }
        if (modalityState == null) {
            PluginManagerMain.$$$reportNull$$$0(14);
        }
        return PluginManagerMain.downloadPluginsImpl(plugins2, customPlugins2, allowInstallWithoutRestart, onSuccess, pluginEnabler, function, modalityState, false);
    }

    private static boolean downloadPluginsImpl(List<PluginNode> plugins2, Collection<PluginNode> customPlugins2, boolean allowInstallWithoutRestart, @Nullable Runnable onSuccess, com.intellij.ide.plugins.PluginEnabler pluginEnabler, @Nullable Consumer<Boolean> function, ModalityState modalityState, boolean inBackground) throws IOException {
        try {
            boolean[] result2 = new boolean[1];
            Consumer<ProgressIndicator> downloading = indicator2 -> {
                try {
                    boolean success2;
                    PluginInstallOperation operation2 = new PluginInstallOperation(plugins2, customPlugins2, pluginEnabler, (ProgressIndicator)indicator2);
                    operation2.setAllowInstallWithoutRestart(allowInstallWithoutRestart);
                    operation2.run();
                    result2[0] = success2 = operation2.isSuccess();
                    if (success2) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (allowInstallWithoutRestart) {
                                for (PendingDynamicPluginInstall install2 : operation2.getPendingDynamicPluginInstalls()) {
                                    result2[0] = result2[0] & PluginInstaller.installAndLoadDynamicPlugin(install2.getFile(), install2.getPluginDescriptor());
                                }
                            }
                            if (onSuccess != null) {
                                onSuccess.run();
                            }
                        }, modalityState);
                    }
                }
                finally {
                    if (function != null) {
                        ApplicationManager.getApplication().invokeLater(() -> function.accept(result2[0]), ModalityState.any());
                    }
                }
            };
            ProgressManager.getInstance().run(PluginManagerMain.createTask(downloading, inBackground));
            return result2[0];
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    private static Task createTask(final Consumer<ProgressIndicator> f, boolean inBackground) {
        if (inBackground) {
            return new Task.Backgroundable(null, IdeBundle.message((String)"progress.download.plugins", (Object[])new Object[0]), true, PluginManagerUISettings.getInstance()){

                public void run(@NotNull ProgressIndicator indicator2) {
                    if (indicator2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    f.accept(indicator2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginManagerMain$1", "run"));
                }
            };
        }
        return new Task.Modal(null, IdeBundle.message((String)"progress.download.plugins", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                f.accept(indicator2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginManagerMain$2", "run"));
            }
        };
    }

    public static boolean suggestToEnableInstalledDependantPlugins(@NotNull com.intellij.ide.plugins.PluginEnabler pluginEnabler, @NotNull List<? extends IdeaPluginDescriptor> list2) {
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(15);
        }
        if (list2 == null) {
            PluginManagerMain.$$$reportNull$$$0(16);
        }
        return PluginManagerMain.suggestToEnableInstalledDependantPlugins(pluginEnabler, list2, null);
    }

    public static boolean suggestToEnableInstalledDependantPlugins(@NotNull com.intellij.ide.plugins.PluginEnabler pluginEnabler, @NotNull List<? extends IdeaPluginDescriptor> list2, @Nullable Boolean isUpdate) {
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(17);
        }
        if (list2 == null) {
            PluginManagerMain.$$$reportNull$$$0(18);
        }
        Set<IdeaPluginDescriptor> disabled = PluginManagerMain.getDisabledPlugins(pluginEnabler, list2, isUpdate);
        Set<IdeaPluginDescriptor> disabledDependants = PluginManagerMain.getDisabledDependants(pluginEnabler, list2);
        boolean result2 = PluginManagerMain.askToEnableDependencies(list2.size(), ContainerUtil.map(disabled, it -> it.getName()), ContainerUtil.map(disabledDependants, it -> it.getName()));
        PluginManagerMain.enablePlugins(result2, disabled, disabledDependants, pluginEnabler);
        return result2;
    }

    public static Set<IdeaPluginDescriptor> getDisabledPlugins(@NotNull com.intellij.ide.plugins.PluginEnabler pluginEnabler, @NotNull List<? extends IdeaPluginDescriptor> list2, @Nullable Boolean isUpdate) {
        if (list2 == null) {
            PluginManagerMain.$$$reportNull$$$0(19);
        }
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(20);
        }
        HashSet<IdeaPluginDescriptor> disabled = new HashSet<IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : list2) {
            PluginId pluginId = ideaPluginDescriptor.getPluginId();
            if (!pluginEnabler.isDisabled(pluginId) || isUpdate != null && !isUpdate.booleanValue()) continue;
            disabled.add(ideaPluginDescriptor);
        }
        return disabled;
    }

    public static Set<IdeaPluginDescriptor> getDisabledDependants(@NotNull com.intellij.ide.plugins.PluginEnabler pluginEnabler, @NotNull List<? extends IdeaPluginDescriptor> list2) {
        if (list2 == null) {
            PluginManagerMain.$$$reportNull$$$0(21);
        }
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(22);
        }
        HashSet<IdeaPluginDescriptor> disabledDependants = new HashSet<IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : list2) {
            for (IdeaPluginDependency dependency : ideaPluginDescriptor.getDependencies()) {
                IdeaPluginDescriptor descriptor;
                PluginId dependantId;
                if (dependency.isOptional() || PluginManagerCore.looksLikePlatformPluginAlias((PluginId)(dependantId = dependency.getPluginId())) && PluginManagerCore.findPluginByPlatformAlias((PluginId)dependantId) == null || (descriptor = PluginManagerCore.getPlugin((PluginId)dependantId)) == null || !pluginEnabler.isDisabled(dependantId)) continue;
                disabledDependants.add(descriptor);
            }
        }
        return disabledDependants;
    }

    public static boolean askToEnableDependencies(int pluginsToInstallCount, List<String> disabled, List<String> disabledDependants) {
        if (!disabled.isEmpty() || !disabledDependants.isEmpty()) {
            boolean result2;
            Object message = "";
            if (disabled.size() == 1) {
                message = (String)message + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part1", (Object[])new Object[]{disabled.iterator().next()});
            } else if (!disabled.isEmpty()) {
                message = (String)message + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part2", (Object[])new Object[]{StringUtil.join(disabled, name2 -> name2, (String)", ")});
            }
            if (!disabledDependants.isEmpty()) {
                message = (String)message + "<br>";
                message = (String)message + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part3", (Object[])new Object[]{pluginsToInstallCount});
                message = (String)message + " ";
                message = disabledDependants.size() == 1 ? (String)message + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part4", (Object[])new Object[]{disabledDependants.iterator().next()}) : (String)message + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part5", (Object[])new Object[]{StringUtil.join(disabledDependants, name2 -> name2, (String)", ")});
            }
            message = (String)message + " ";
            message = (String)message + IdeBundle.message((String)(disabled.isEmpty() ? "plugin.manager.main.suggest.to.enable.message.part6" : "plugin.manager.main.suggest.to.enable.message.part7"), (Object[])new Object[0]);
            if (!disabled.isEmpty() && !disabledDependants.isEmpty()) {
                int code;
                Integer codeHeadless = PluginUtilsKt.getEnableDisabledPluginsDependentConfirmationData();
                int n = code = codeHeadless != null ? codeHeadless.intValue() : ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)IdeBundle.message((String)"dialog.title.dependent.plugins.found", (Object[])new Object[0]), (String)XmlStringUtil.wrapInHtml((CharSequence)message)).yesText(IdeBundle.message((String)"button.enable.all", (Object[])new Object[0]))).noText(IdeBundle.message((String)"button.enable.updated.plugins", (Object[])new Object[]{disabled.size()}))).guessWindowAndAsk();
                if (code == 2) {
                    return false;
                }
                result2 = code == 0;
            } else {
                message = (String)message + "<br>";
                message = !disabled.isEmpty() ? (String)message + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part8", (Object[])new Object[]{disabled.size()}) : (String)message + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part9", (Object[])new Object[]{disabledDependants.size()});
                message = (String)message + "?";
                Integer codeHeadless = PluginUtilsKt.getEnableDisabledPluginsDependentConfirmationData();
                boolean bl = result2 = codeHeadless != null ? codeHeadless.equals(0) : MessageDialogBuilder.yesNo((String)IdeBundle.message((String)"dialog.title.dependent.plugins.found", (Object[])new Object[0]), (String)XmlStringUtil.wrapInHtml((CharSequence)message)).guessWindowAndAsk();
                if (!result2) {
                    return false;
                }
            }
            return result2;
        }
        return false;
    }

    public static void enablePlugins(boolean dialogResult, Set<IdeaPluginDescriptor> disabled, Set<IdeaPluginDescriptor> disabledDependants, com.intellij.ide.plugins.PluginEnabler pluginEnabler) {
        if (dialogResult) {
            disabled.addAll(disabledDependants);
            pluginEnabler.enable(disabled);
        } else if (!disabled.isEmpty()) {
            pluginEnabler.enable(disabled);
        }
    }

    @ApiStatus.Internal
    public static void onEvent(String description) {
        switch (description) {
            case "disable": {
                PluginManagerCore.onEnable((boolean)false);
                break;
            }
            case "enable": {
                if (!PluginManagerCore.onEnable((boolean)true)) break;
                PluginManagerMain.notifyPluginsUpdated(null);
                break;
            }
            case "edit": {
                IdeFrame frame = WindowManagerEx.getInstanceEx().findFrameFor(null);
                PluginManagerConfigurable.showPluginConfigurable(frame != null ? frame.getComponent() : null, null, List.of());
            }
        }
    }

    public static void notifyPluginsUpdated(@Nullable Project project2) {
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        String title2 = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        String action2 = IdeBundle.message((String)"ide.restart.required.notification", (Object[])new Object[]{app.isRestartCapable() ? 1 : 0});
        ((UpdateCheckerFacade)ApplicationManager.getApplication().getService(UpdateCheckerFacade.class)).getNotificationGroupForPluginUpdateResults().createNotification(title2, NotificationType.INFORMATION).setDisplayId("plugins.updated.suggest.restart").addAction((AnAction)new NotificationAction(action2){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (notification2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (PluginManagerConfigurable.showRestartDialog() == 0) {
                    notification2.expire();
                    ApplicationManagerEx.getApplicationEx().restart(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/plugins/PluginManagerMain$3";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project2);
    }

    public static boolean checkThirdPartyPluginsAllowed(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2) {
        String noText;
        String yesText;
        List aliens;
        if (descriptors2 == null) {
            PluginManagerMain.$$$reportNull$$$0(23);
        }
        if ((aliens = ContainerUtil.filter(descriptors2, descriptor -> !descriptor.isBundled() && !PluginManagerCore.isVendorTrusted((PluginDescriptor)descriptor))).isEmpty()) {
            return true;
        }
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        if (updateSettings.isThirdPartyPluginsAllowed()) {
            PluginManagerUsageCollector.thirdPartyAcceptanceCheck(DialogAcceptanceResultEnum.AUTO_ACCEPTED);
            return true;
        }
        if (AppMode.isHeadless()) {
            ThirdPartyPluginsWithoutConsentFile.appendAliens((Collection)ContainerUtil.map((Collection)aliens, PluginDescriptor::getPluginId));
            return true;
        }
        String title2 = CoreBundle.message((String)"third.party.plugins.privacy.note.title", (Object[])new Object[0]);
        String pluginList = aliens.stream().map(descriptor -> "&nbsp;&nbsp;&nbsp;" + PluginManagerCore.getPluginNameAndVendor((IdeaPluginDescriptor)descriptor)).collect(Collectors.joining("<br>"));
        String message = CoreBundle.message((String)"third.party.plugins.privacy.note.text", (Object[])new Object[]{pluginList, ApplicationInfoImpl.getShadowInstance().getShortCompanyName()});
        if (Messages.showYesNoDialog((String)message, (String)title2, (String)(yesText = CoreBundle.message((String)"third.party.plugins.privacy.note.accept", (Object[])new Object[0])), (String)(noText = CommonBundle.getCancelButtonText()), (Icon)Messages.getWarningIcon()) == 0) {
            updateSettings.setThirdPartyPluginsAllowed(true);
            PluginManagerUsageCollector.thirdPartyAcceptanceCheck(DialogAcceptanceResultEnum.ACCEPTED);
            return true;
        }
        PluginManagerUsageCollector.thirdPartyAcceptanceCheck(DialogAcceptanceResultEnum.DECLINED);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customPlugins";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerMain";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadPlugins";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadPluginsAndCleanup";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadPluginsModal";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestToEnableInstalledDependantPlugins";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getDisabledPlugins";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "getDisabledDependants";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "checkThirdPartyPluginsAllowed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Deprecated(forRemoval=true)
    public static final class MyHyperlinkListener
    extends HyperlinkAdapter {
        protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
            if (e == null) {
                MyHyperlinkListener.$$$reportNull$$$0(0);
            }
            JEditorPane pane2 = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLDocument doc = (HTMLDocument)pane2.getDocument();
                doc.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
            } else {
                URL url = e.getURL();
                if (url != null) {
                    BrowserUtil.browse((URL)url);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerMain$MyHyperlinkListener", "hyperlinkActivated"));
        }
    }

    @Deprecated(forRemoval=true)
    public static interface PluginEnabler
    extends com.intellij.ide.plugins.PluginEnabler {
        default public boolean isDisabled(@NotNull PluginId pluginId) {
            if (pluginId == null) {
                PluginEnabler.$$$reportNull$$$0(0);
            }
            return HEADLESS.isDisabled(pluginId);
        }

        default public boolean enableById(@NotNull Set<PluginId> pluginIds) {
            if (pluginIds == null) {
                PluginEnabler.$$$reportNull$$$0(1);
            }
            return HEADLESS.enableById(pluginIds);
        }

        default public boolean enable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2) {
            if (descriptors2 == null) {
                PluginEnabler.$$$reportNull$$$0(2);
            }
            return HEADLESS.enable(descriptors2);
        }

        default public boolean disableById(@NotNull Set<PluginId> pluginIds) {
            if (pluginIds == null) {
                PluginEnabler.$$$reportNull$$$0(3);
            }
            return HEADLESS.disableById(pluginIds);
        }

        default public boolean disable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2) {
            if (descriptors2 == null) {
                PluginEnabler.$$$reportNull$$$0(4);
            }
            return HEADLESS.disable(descriptors2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginId";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginIds";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerMain$PluginEnabler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDisabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "enableById";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "enable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "disableById";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "disable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static final class HEADLESS
        implements PluginEnabler {
        }
    }
}

