/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.LinkPanel;
import com.intellij.ide.plugins.PluginNodeVendorDetails;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.ListLayout;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@IntellijInternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/plugins/newui/VendorInfoPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "name", "Lcom/intellij/ide/plugins/LinkPanel;", "verifiedIcon", "Lcom/intellij/ui/ContextHelpLabel;", "Lorg/jetbrains/annotations/NotNull;", "traderStatus", "Lcom/intellij/ui/components/JBLabel;", "traderIcon", "nonTraderIcon", "show", "", "node", "Lcom/intellij/ide/plugins/newui/PluginUiModel;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class VendorInfoPanel
extends JPanel {
    @NotNull
    private final LinkPanel name = new LinkPanel(this, false, false, null, null);
    @NotNull
    private final ContextHelpLabel verifiedIcon;
    @NotNull
    private final JBLabel traderStatus;
    @NotNull
    private final ContextHelpLabel traderIcon;
    @NotNull
    private final ContextHelpLabel nonTraderIcon;

    public VendorInfoPanel() {
        super((LayoutManager)ListLayout.Companion.horizontal$default((ListLayout.Companion)ListLayout.Companion, (int)JBUI.scale((int)5), null, null, (int)6, null));
        ContextHelpLabel contextHelpLabel = ContextHelpLabel.create((String)IdeBundle.message((String)"plugin.verified.organization", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)contextHelpLabel, (String)"create(...)");
        this.verifiedIcon = contextHelpLabel;
        this.traderStatus = new JBLabel();
        ContextHelpLabel contextHelpLabel2 = ContextHelpLabel.create((String)IdeBundle.message((String)"plugin.vendor.trader.status", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)contextHelpLabel2, (String)"create(...)");
        this.traderIcon = contextHelpLabel2;
        ContextHelpLabel contextHelpLabel3 = ContextHelpLabel.create((String)IdeBundle.message((String)"plugin.vendor.non.trader.status", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)contextHelpLabel3, (String)"create(...)");
        this.nonTraderIcon = contextHelpLabel3;
        this.verifiedIcon.setIcon(AllIcons.Debugger.ThreadStates.Idle);
        this.traderStatus.setForeground(ListPluginComponent.GRAY_COLOR);
        this.traderStatus.setBorder((Border)JBUI.Borders.emptyLeft((int)15));
        this.setOpaque(false);
        this.add((Component)this.verifiedIcon);
        this.add((Component)this.traderStatus);
        this.add((Component)this.traderIcon);
        this.add((Component)this.nonTraderIcon);
    }

    public final void show(@NotNull PluginUiModel node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PluginNodeVendorDetails vendorDetails = node.getVendorDetails();
        if (vendorDetails == null) {
            this.name.hide();
            this.setVisible(false);
            this.traderIcon.setVisible(false);
            this.nonTraderIcon.setVisible(false);
            this.verifiedIcon.setVisible(false);
            return;
        }
        if (vendorDetails.getUrl() != null) {
            Object[] objectArray = new Object[]{""};
            this.name.showWithBrowseUrl(IdeBundle.message((String)"plugin.vendor.info.label", (Object[])objectArray), vendorDetails.getName(), false, () -> VendorInfoPanel.show$lambda$0(vendorDetails));
        } else {
            Object[] objectArray = new Object[]{vendorDetails.getName()};
            this.name.show(IdeBundle.message((String)"plugin.vendor.info.label", (Object[])objectArray), null);
        }
        this.verifiedIcon.setVisible(vendorDetails.isVerified());
        this.traderStatus.setText(IdeBundle.message((String)(vendorDetails.isTrader() ? "plugin.vendor.trader.label" : "plugin.vendor.non.trader.label"), (Object[])new Object[0]));
        this.traderIcon.setVisible(vendorDetails.isTrader());
        this.nonTraderIcon.setVisible(!vendorDetails.isTrader());
        this.setVisible(true);
    }

    private static final String show$lambda$0(PluginNodeVendorDetails $vendorDetails) {
        return $vendorDetails.getUrl();
    }
}

