/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.WindowRoundedCornersManager;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public final class IdeaPopupMenuUI
extends BasicPopupMenuUI {
    public static final JBValue CORNER_RADIUS = new JBValue.UIInteger("PopupMenu.borderCornerRadius", 8);

    public static ComponentUI createUI(JComponent c) {
        return new IdeaPopupMenuUI();
    }

    public static boolean isUnderPopup(Component component2) {
        if (component2 instanceof JBPopupMenu) {
            JBPopupMenu menu = (JBPopupMenu)component2;
            Component invoker = menu.getInvoker();
            if (invoker instanceof ActionMenu) {
                ActionMenu actionMenu = (ActionMenu)((Object)invoker);
                return !actionMenu.isMainMenuPlace();
            }
            return true;
        }
        return false;
    }

    public static boolean isUnderMainMenu(Component component2) {
        JBPopupMenu menu;
        Component invoker;
        if (component2 instanceof JBPopupMenu && (invoker = (menu = (JBPopupMenu)component2).getInvoker()) instanceof ActionMenu) {
            ActionMenu actionMenu = (ActionMenu)((Object)invoker);
            return actionMenu.isMainMenuPlace();
        }
        return false;
    }

    public static boolean isPartOfPopupMenu(Component c) {
        if (c == null) {
            return false;
        }
        if (c instanceof JPopupMenu) {
            return IdeaPopupMenuUI.isUnderPopup(c);
        }
        return IdeaPopupMenuUI.isPartOfPopupMenu(c.getParent());
    }

    public static boolean isMenuBarItem(Component c) {
        return c.getParent() instanceof JMenuBar;
    }

    @Override
    public boolean isPopupTrigger(MouseEvent event) {
        return event.isPopupTrigger();
    }

    @Override
    public void paint(Graphics g, JComponent jcomponent) {
        Rectangle bounds = this.popupMenu.getBounds();
        g.setColor(this.popupMenu.getBackground());
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        if (!IdeaPopupMenuUI.isUnderPopup(jcomponent) || IdeaPopupMenuUI.isRoundBorder() || SystemInfoRt.isWindows) {
            return;
        }
        g.setColor((Color)JBColor.namedColor((String)"Menu.borderColor", (Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51)));
        g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public static boolean isRoundBorder() {
        return WindowRoundedCornersManager.isAvailable();
    }

    public static boolean hideEmptyIcon(Component c) {
        if (!IdeaPopupMenuUI.isPartOfPopupMenu(c)) {
            return false;
        }
        Container parent = c.getParent();
        if (parent instanceof JPopupMenu) {
            int count = parent.getComponentCount();
            for (int i2 = 0; i2 < count; ++i2) {
                Icon icon2;
                Component item = parent.getComponent(i2);
                if (!(item instanceof JMenuItem)) continue;
                JMenuItem menuItem = (JMenuItem)item;
                Icon icon3 = icon2 = menuItem.isEnabled() ? menuItem.getIcon() : menuItem.getDisabledIcon();
                if (icon2 == null) continue;
                return false;
            }
        }
        return true;
    }
}

