/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.PluginBundledTemplate;
import com.intellij.internal.statistic.collectors.fus.fileTypes.BundledFileTemplateValidationRule;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileExtensionValidationRule;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileNamePatternCustomValidationRule;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeSchemaValidator;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageCounterCollectorKt;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageSchemaDescriptor;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageSchemaDescriptorEP;
import com.intellij.internal.statistic.collectors.fus.fileTypes.ProjectState;
import com.intellij.internal.statistic.collectors.fus.fileTypes.ProjectStateObserver;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IncompleteDependenciesService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J1\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\u001c\"\u0006\u0012\u0002\b\u00030\nH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007J\u001a\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0007J\u0018\u0010+\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007J \u0010+\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0007J8\u0010.\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u000205J\u001a\u00106\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u000308072\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u00109\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J(\u0010:\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010;\u001a\u00020\rH\u0002J*\u0010<\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u000308072\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010;\u001a\u00020\rH\u0002J$\u0010=\u001a\u00020%2\u0012\u0010>\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u0003080?2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010@\u001a\u00020%H\u0002J\u001a\u0010A\u001a\u0004\u0018\u00010\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "FILE_EDITOR", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "SCHEMA", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "", "IS_WRITABLE", "", "IS_PREVIEW_TAB", "INCOMPLETE_DEPENDENCIES_MODE", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/openapi/project/IncompleteDependenciesService$DependenciesState;", "FILE_EXTENSION", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "FILE_NAME_PATTERN", "FILE_TEMPLATE_NAME", "FILE_NAME_PATTERN_FIELD", "FILE_TEMPLATE_FIELD", "registerFileTypeEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "eventId", "extraFields", "", "(Ljava/lang/String;[Lcom/intellij/internal/statistic/eventLog/events/EventField;)Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "SELECT", "EDIT", "OPEN", "CLOSE", "CREATE_BY_NEW_FILE", "CREATE_WITH_FILE_TEMPLATE", "triggerEdit", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "triggerSelect", "logCreated", "fileTemplate", "Lcom/intellij/ide/fileTemplates/FileTemplate;", "logOpened", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "timeToShow", "", "durationMs", "composite", "Lcom/intellij/openapi/fileEditor/FileEditorComposite;", "getProjectState", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "triggerClosed", "log", "withWritable", "buildCommonEventPairs", "addFileNamePattern", "data", "", "logEmptyFile", "findSchema", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFileTypeUsageCounterCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileTypeUsageCounterCollector.kt\ncom/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,294:1\n11561#2:295\n11896#2,3:296\n30#3,2:299\n30#3,2:303\n295#4,2:301\n*S KotlinDebug\n*F\n+ 1 FileTypeUsageCounterCollector.kt\ncom/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector\n*L\n129#1:295\n129#1:296,3\n171#1:299,2\n89#1:303,2\n215#1:301,2\n*E\n"})
public final class FileTypeUsageCounterCollector
extends CounterUsagesCollector {
    @NotNull
    public static final FileTypeUsageCounterCollector INSTANCE = new FileTypeUsageCounterCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("file.types.usage", 75, null, 4, null);
    @NotNull
    private static final ClassEventField FILE_EDITOR = EventFields.Class((String)"file_editor");
    @NotNull
    private static final EventField<String> SCHEMA = (EventField)EventFields.StringValidatedByCustomRule((String)"schema", FileTypeSchemaValidator.class);
    @NotNull
    private static final EventField<Boolean> IS_WRITABLE = (EventField)EventFields.Boolean((String)"is_writable");
    @NotNull
    private static final EventField<Boolean> IS_PREVIEW_TAB = (EventField)EventFields.Boolean((String)"is_preview_tab");
    @NotNull
    private static final EnumEventField<IncompleteDependenciesService.DependenciesState> INCOMPLETE_DEPENDENCIES_MODE = EventFields.Enum$default((String)"incomplete_dependencies_mode", IncompleteDependenciesService.DependenciesState.class, null, (int)4, null);
    @NotNull
    private static final StringEventField FILE_EXTENSION = EventFields.StringValidatedByCustomRule((String)"file_extension", FileExtensionValidationRule.class);
    @NotNull
    public static final String FILE_NAME_PATTERN = "file_name_pattern";
    @NotNull
    public static final String FILE_TEMPLATE_NAME = "file_template_name";
    @NotNull
    private static final EventField<String> FILE_NAME_PATTERN_FIELD = (EventField)EventFields.StringValidatedByCustomRule((String)"file_name_pattern", FileNamePatternCustomValidationRule.class);
    @NotNull
    private static final EventField<String> FILE_TEMPLATE_FIELD = (EventField)EventFields.StringValidatedByCustomRule((String)"file_template_name", BundledFileTemplateValidationRule.class);
    @NotNull
    private static final VarargEventId SELECT = INSTANCE.registerFileTypeEvent("select", new EventField[0]);
    @NotNull
    private static final VarargEventId EDIT;
    @NotNull
    private static final VarargEventId OPEN;
    @NotNull
    private static final VarargEventId CLOSE;
    @NotNull
    private static final VarargEventId CREATE_BY_NEW_FILE;
    @NotNull
    private static final VarargEventId CREATE_WITH_FILE_TEMPLATE;

    private FileTypeUsageCounterCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    private final VarargEventId registerFileTypeEvent(String eventId, EventField<?> ... extraFields) {
        Object[] objectArray = new EventField[]{EventFields.PluginInfoFromInstance, EventFields.FileType, EventFields.AnonymizedPath, SCHEMA, FILE_EXTENSION};
        Object[] baseFields = objectArray;
        objectArray = (EventField[])ArrayUtil.mergeArrays((Object[])baseFields, (Object[])extraFields);
        return GROUP.registerVarargEvent(eventId, (EventField[])Arrays.copyOf(objectArray, objectArray.length));
    }

    @JvmStatic
    @RequiresEdt
    public static final void triggerEdit(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List projectState = (List)ReadAction.compute(() -> FileTypeUsageCounterCollector.triggerEdit$lambda$0(project2));
        EDIT.log(project2, arg_0 -> FileTypeUsageCounterCollector.triggerEdit$lambda$1(project2, file2, projectState, arg_0));
    }

    @RequiresEdt
    public final void triggerSelect(@NotNull Project project2, @Nullable VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (file2 != null) {
            this.log(SELECT, project2, file2, false);
        } else {
            this.logEmptyFile();
        }
    }

    @JvmStatic
    public static final void logCreated(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        INSTANCE.log(CREATE_BY_NEW_FILE, project2, file2, false);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void logCreated(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull FileTemplate fileTemplate) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileTemplate, (String)"fileTemplate");
        CREATE_WITH_FILE_TEMPLATE.log(project2, arg_0 -> FileTypeUsageCounterCollector.logCreated$lambda$0(project2, file2, fileTemplate, arg_0));
        if (fileTemplate instanceof PluginBundledTemplate && !Boolean.getBoolean("ide.skip.plugin.templates.registered.check")) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FileTemplate[] fileTemplateArray = FileTemplateManager.getDefaultInstance().getInternalTemplates();
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplateArray, (String)"getInternalTemplates(...)");
            Object[] objectArray = fileTemplateArray;
            boolean $i$f$map = false;
            void var6_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void t;
                FileTemplate fileTemplate2 = (FileTemplate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(t.getName());
            }
            Set internalTemplates = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            FileTypeUsageCounterCollectorKt.access$getLOG$p().assertTrue(internalTemplates.contains(fileTemplate.getName()), (Object)("Unknown bundled file template: " + fileTemplate + ", register it in plugin.xml via <internalFileTemplate name=\"" + fileTemplate.getName() + "\"/> tag"));
        }
    }

    public final void logOpened(@NotNull Project project2, @NotNull VirtualFile file2, @Nullable FileEditor fileEditor, long timeToShow, long durationMs, @NotNull FileEditorComposite composite2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)composite2, (String)"composite");
        List<EventPair<?>> projectState = this.getProjectState(project2);
        if (fileEditor != null) {
            Object[] objectArray = new EventPair[]{FILE_EDITOR.with(fileEditor.getClass()), IS_PREVIEW_TAB.with((Object)composite2.isPreview())};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List fileEditorPairs = list2;
        OPEN.log(project2, arg_0 -> FileTypeUsageCounterCollector.logOpened$lambda$0(project2, file2, fileEditorPairs, timeToShow, durationMs, projectState, arg_0));
    }

    private final List<EventPair<?>> getProjectState(Project project2) {
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ProjectStateObserver> serviceClass$iv = ProjectStateObserver.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ProjectState state2 = ((ProjectStateObserver)object).getState();
        Object[] objectArray = new EventPair[]{EventFields.Dumb.with((Object)state2.isDumb()), INCOMPLETE_DEPENDENCIES_MODE.with((Object)state2.getDependenciesState())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public final void triggerClosed(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.log(CLOSE, project2, file2, true);
    }

    private final void log(VarargEventId eventId, Project project2, VirtualFile file2, boolean withWritable) {
        eventId.log(project2, arg_0 -> FileTypeUsageCounterCollector.log$lambda$0(project2, file2, withWritable, arg_0));
    }

    private final List<EventPair<?>> buildCommonEventPairs(Project project2, VirtualFile file2, boolean withWritable) {
        FileType fileType2 = file2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
        FileType fileType3 = fileType2;
        Object[] objectArray = new EventPair[]{EventFields.PluginInfoFromInstance.with((Object)fileType3), EventFields.FileType.with((Object)fileType3), EventFields.AnonymizedPath.with((Object)file2.getPath()), SCHEMA.with((Object)FileTypeUsageCounterCollector.findSchema(project2, file2)), FILE_EXTENSION.with((Object)file2.getExtension())};
        List data2 = CollectionsKt.listOf((Object[])objectArray);
        if (!withWritable) {
            return data2;
        }
        return CollectionsKt.plus((Collection)data2, (Object)IS_WRITABLE.with((Object)file2.isWritable()));
    }

    /*
     * WARNING - void declaration
     */
    private final void addFileNamePattern(List<? super EventPair<?>> data2, VirtualFile file2) {
        block3: {
            Object v2;
            block2: {
                void $this$firstOrNull$iv;
                FileType fileType2 = file2.getFileType();
                Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
                FileType fileType3 = fileType2;
                FileTypeManager fileTypeManager = FileTypeManager.getInstance();
                if (!(fileTypeManager instanceof FileTypeManagerImpl)) {
                    return;
                }
                List<FileNameMatcher> list2 = ((FileTypeManagerImpl)fileTypeManager).getStandardMatchers(fileType3);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getStandardMatchers(...)");
                List<FileNameMatcher> fileNameMatchers = list2;
                Iterable iterable = fileNameMatchers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FileNameMatcher it = (FileNameMatcher)element$iv;
                    boolean bl = false;
                    if (!it.acceptsCharSequence((CharSequence)file2.getName())) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            FileNameMatcher fileNameMatcher = v2;
            if (fileNameMatcher == null) break block3;
            FileNameMatcher it = fileNameMatcher;
            boolean bl = false;
            data2.add(FILE_NAME_PATTERN_FIELD.with((Object)it.getPresentableString()));
        }
    }

    private final void logEmptyFile() {
        EventPair[] eventPairArray = new EventPair[]{EventFields.AnonymizedPath.with(null)};
        SELECT.log(eventPairArray);
    }

    @JvmStatic
    @Nullable
    public static final String findSchema(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        for (FileTypeUsageSchemaDescriptorEP ext : FileTypeSchemaValidator.EP.getExtensionList()) {
            Object object = ext.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance(...)");
            FileTypeUsageSchemaDescriptor instance = (FileTypeUsageSchemaDescriptor)object;
            if (ext.schema == null) {
                Logger.getInstance(FileTypeUsageCounterCollector.class).warn("Extension " + ext.implementationClass + " should define a 'schema' attribute");
                continue;
            }
            if (!instance.describes(project2, file2)) continue;
            return PluginInfoDetectorKt.getPluginInfo(instance.getClass()).isSafeToReport() ? ext.schema : "third.party";
        }
        return null;
    }

    private static final List triggerEdit$lambda$0(Project $project) {
        Object[] objectArray = new EventPair[2];
        objectArray[0] = EventFields.Dumb.with((Object)DumbService.Companion.isDumb($project));
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<IncompleteDependenciesService> serviceClass$iv = IncompleteDependenciesService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        objectArray[1] = INCOMPLETE_DEPENDENCIES_MODE.with((Object)((IncompleteDependenciesService)object).getState());
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final void triggerEdit$lambda$1(Project $project, VirtualFile $file, List $projectState, List pairs) {
        Intrinsics.checkNotNullParameter((Object)pairs, (String)"pairs");
        pairs.addAll((Collection)INSTANCE.buildCommonEventPairs($project, $file, false));
        INSTANCE.addFileNamePattern(pairs, $file);
        Intrinsics.checkNotNull((Object)$projectState);
        pairs.addAll($projectState);
    }

    private static final void logCreated$lambda$0(Project $project, VirtualFile $file, FileTemplate $fileTemplate, List pairs) {
        Intrinsics.checkNotNullParameter((Object)pairs, (String)"pairs");
        pairs.addAll((Collection)INSTANCE.buildCommonEventPairs($project, $file, false));
        pairs.add(FILE_TEMPLATE_FIELD.with((Object)$fileTemplate.getName()));
        if ($fileTemplate instanceof PluginBundledTemplate) {
            PluginDescriptor pluginDescriptor = ((PluginBundledTemplate)$fileTemplate).getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"getPluginDescriptor(...)");
            PluginDescriptor pluginDescriptor2 = pluginDescriptor;
            pairs.add(EventFields.PluginInfo.with((Object)PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor2)));
        }
    }

    private static final void logOpened$lambda$0(Project $project, VirtualFile $file, List $fileEditorPairs, long $timeToShow, long $durationMs, List $projectState, List pairs) {
        Intrinsics.checkNotNullParameter((Object)pairs, (String)"pairs");
        pairs.addAll((Collection)INSTANCE.buildCommonEventPairs($project, $file, true));
        pairs.addAll($fileEditorPairs);
        pairs.add(EventFields.TimeToShowMs.with((Object)$timeToShow));
        if ($durationMs != -1L) {
            pairs.add(EventFields.DurationMs.with((Object)$durationMs));
        }
        INSTANCE.addFileNamePattern(pairs, $file);
        pairs.addAll($projectState);
    }

    private static final void log$lambda$0(Project $project, VirtualFile $file, boolean $withWritable, List pairs) {
        Intrinsics.checkNotNullParameter((Object)pairs, (String)"pairs");
        pairs.addAll((Collection)INSTANCE.buildCommonEventPairs($project, $file, $withWritable));
    }

    static {
        EventField[] eventFieldArray = new EventField[]{FILE_NAME_PATTERN_FIELD, EventFields.Dumb, INCOMPLETE_DEPENDENCIES_MODE};
        EDIT = INSTANCE.registerFileTypeEvent("edit", eventFieldArray);
        eventFieldArray = new EventField[]{FILE_EDITOR, EventFields.TimeToShowMs, EventFields.DurationMs, IS_WRITABLE, IS_PREVIEW_TAB, FILE_NAME_PATTERN_FIELD, EventFields.Dumb, INCOMPLETE_DEPENDENCIES_MODE};
        OPEN = INSTANCE.registerFileTypeEvent("open", eventFieldArray);
        eventFieldArray = new EventField[]{IS_WRITABLE};
        CLOSE = INSTANCE.registerFileTypeEvent("close", eventFieldArray);
        CREATE_BY_NEW_FILE = INSTANCE.registerFileTypeEvent("create_by_new_file", new EventField[0]);
        eventFieldArray = new EventField[]{FILE_TEMPLATE_FIELD, EventFields.PluginInfo};
        CREATE_WITH_FILE_TEMPLATE = INSTANCE.registerFileTypeEvent("create_with_template", eventFieldArray);
    }
}

